/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.BookmarkDate;
import net.yacy.data.BookmarkHelper;
import net.yacy.data.ListManager;
import net.yacy.kelondro.blob.MapHeap;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.RowHandleSet;

public class BookmarksDB {
    private static final int SORT_SIZE = 2;
    private static final int SHOW_ALL = -1;
    private final MapHeap bookmarks;
    private final ConcurrentHashMap<String, Tag> tags;
    private final BookmarkDate dates;
    private static final TagComparator tagComparator = new TagComparator();
    private static final TagSizeComparator tagSizeComparator = new TagSizeComparator();

    public BookmarksDB(File bookmarksFile, File datesFile) throws IOException {
        bookmarksFile.getParentFile().mkdirs();
        this.bookmarks = new MapHeap(bookmarksFile, 12, NaturalOrder.naturalOrder, 65536, 1000, ' ');
        this.tags = new ConcurrentHashMap();
        ConcurrentLog.info("BOOKMARKS", "started init of tags from bookmarks.db...");
        bookmarkIterator it = new bookmarkIterator(true);
        while (it.hasNext()) {
            Bookmark bookmark;
            try {
                bookmark = (Bookmark)it.next();
            }
            catch (Throwable e) {
                continue;
            }
            if (bookmark == null) continue;
            String[] tagArray = CommonPattern.COMMA.split(BookmarkHelper.cleanTagsString(bookmark.getTagsString() + bookmark.getFoldersString()));
            Tag tag = null;
            for (String element : tagArray) {
                tag = this.getTag(BookmarkHelper.tagHash(element));
                if (tag == null) {
                    tag = new Tag(element);
                }
                tag.addUrl(bookmark.getUrlHash());
                this.putTag(tag);
            }
        }
        ConcurrentLog.info("BOOKMARKS", "finished init " + this.tags.size() + " tags using your " + this.bookmarks.size() + " bookmarks.");
        boolean datesExisted = datesFile.exists();
        this.dates = new BookmarkDate(datesFile);
        if (!datesExisted) {
            this.dates.init(new bookmarkIterator(true));
        }
    }

    public synchronized void close() {
        this.bookmarks.close();
        this.tags.clear();
        this.dates.close();
    }

    public Bookmark createorgetBookmark(String url, String user) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        try {
            DigestURL durl = new DigestURL((String)(url.indexOf("://") < 0 ? "http://" + url : url));
            Bookmark bk = this.getBookmark(ASCII.String(durl.hash()));
            if (bk == null) {
                bk = new Bookmark(url);
            }
            bk.setOwner(user);
            return bk.getUrlHash() == null || bk.toMap() == null ? null : bk;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public int bookmarksSize() {
        return this.bookmarks.size();
    }

    public void saveBookmark(Bookmark bookmark) {
        try {
            this.bookmarks.insert(ASCII.getBytes(bookmark.getUrlHash()), bookmark.entry);
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }

    public Bookmark getBookmark(String urlHash) {
        try {
            Map<String, String> map = this.bookmarks.get(ASCII.getBytes(urlHash));
            if (map == null) {
                ConcurrentLog.info("BOOKMARKS", "cannot get bookmark for url hash " + urlHash);
                return null;
            }
            return new Bookmark(map);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean removeBookmark(String urlHash) {
        Bookmark bookmark = this.getBookmark(urlHash);
        if (bookmark == null) {
            return false;
        }
        Set<String> tagSet = bookmark.getTags();
        Tag tag = null;
        Iterator<String> it = tagSet.iterator();
        while (it.hasNext()) {
            tag = this.getTag(BookmarkHelper.tagHash(it.next()));
            if (tag == null) continue;
            tag.delete(urlHash);
            this.putTag(tag);
        }
        Bookmark b = this.getBookmark(urlHash);
        try {
            if (b != null) {
                this.bookmarks.delete(ASCII.getBytes(urlHash));
            }
        }
        catch (IOException e) {
            b = null;
        }
        return b != null;
    }

    public Iterator<String> getBookmarksIterator(boolean priv) {
        bookmarkIterator it;
        TreeSet<String> set = new TreeSet<String>(new bookmarkComparator(true));
        try {
            it = new bookmarkIterator(true);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return set.iterator();
        }
        while (it.hasNext()) {
            Bookmark bm = (Bookmark)it.next();
            if (!priv && !bm.getPublic()) continue;
            set.add(bm.getUrlHash());
        }
        return set.iterator();
    }

    public Iterator<Bookmark> getBookmarksIterator() {
        try {
            return new bookmarkIterator(true);
        }
        catch (IOException ex) {
            ConcurrentLog.logException(ex);
            return null;
        }
    }

    public Iterator<String> getBookmarksIterator(String tagName, boolean priv) {
        RowHandleSet hashes;
        TreeSet<String> set = new TreeSet<String>(new bookmarkComparator(true));
        String tagHash = BookmarkHelper.tagHash(tagName);
        Tag tag = this.getTag(tagHash);
        RowHandleSet rowHandleSet = hashes = tag == null ? new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 10) : tag.getUrlHashes();
        if (priv) {
            for (byte[] hash : hashes) {
                set.add(ASCII.String(hash));
            }
        } else {
            for (byte[] hash : hashes) {
                Bookmark bm = this.getBookmark(ASCII.String(hash));
                if (bm == null || !bm.getPublic()) continue;
                set.add(bm.getUrlHash());
            }
        }
        return set.iterator();
    }

    public int tagsSize() {
        return this.tags.size();
    }

    private Tag getTag(String hash) {
        return this.tags.get(hash);
    }

    private void putTag(Tag tag) {
        if (tag == null) {
            return;
        }
        if (tag.isEmpty()) {
            this.tags.remove(tag.getTagHash());
        } else {
            this.tags.put(tag.getTagHash(), tag);
        }
    }

    private void removeTag(String hash) {
        this.tags.remove(hash);
    }

    public Iterator<Tag> getTagIterator(boolean priv) {
        return this.getTagIterator(priv, 1);
    }

    private Iterator<Tag> getTagIterator(boolean priv, int c) {
        TreeSet<Tag> set = new TreeSet<Tag>((Comparator<Tag>)((Object)(c == 2 ? tagSizeComparator : tagComparator)));
        for (Tag tag : this.tags.values()) {
            if (tag == null || !priv && !tag.hasPublicItems()) continue;
            set.add(tag);
        }
        return set.iterator();
    }

    public Iterator<Tag> getTagIterator(boolean priv, int comp, int max) {
        if (max == -1) {
            return this.getTagIterator(priv, comp);
        }
        Iterator<Tag> it = this.getTagIterator(priv, 2);
        TreeSet<Tag> set = new TreeSet<Tag>((Comparator<Tag>)((Object)(comp == 2 ? tagSizeComparator : tagComparator)));
        for (int count = 0; it.hasNext() && count <= max; ++count) {
            set.add(it.next());
        }
        return set.iterator();
    }

    private Iterator<Tag> getTagIterator(String tagName, boolean priv, int comp) {
        TreeSet<Tag> set = new TreeSet<Tag>((Comparator<Tag>)((Object)(comp == 2 ? tagSizeComparator : tagComparator)));
        Iterator<String> it = null;
        Iterator<String> bit = this.getBookmarksIterator(tagName, priv);
        while (bit.hasNext()) {
            Bookmark bm = this.getBookmark(bit.next());
            if (bm == null) continue;
            Set<String> tagSet = bm.getTags();
            it = tagSet.iterator();
            while (it.hasNext()) {
                Tag tag = this.getTag(BookmarkHelper.tagHash(it.next()));
                if (!priv && !tag.hasPublicItems() || tag == null) continue;
                set.add(tag);
            }
        }
        return set.iterator();
    }

    public Iterator<Tag> getTagIterator(String tagName, boolean priv, int comp, int max) {
        if (max == -1) {
            return this.getTagIterator(priv, comp);
        }
        Iterator<Tag> it = this.getTagIterator(tagName, priv, 2);
        TreeSet<Tag> set = new TreeSet<Tag>((Comparator<Tag>)((Object)(comp == 2 ? tagSizeComparator : tagComparator)));
        for (int count = 0; it.hasNext() && count <= max; ++count) {
            set.add(it.next());
        }
        return set.iterator();
    }

    public boolean renameTag(String oldName, String newName) {
        Tag oldTag = this.getTag(BookmarkHelper.tagHash(oldName));
        if (oldTag != null) {
            RowHandleSet urlHashes = oldTag.getUrlHashes();
            this.removeTag(BookmarkHelper.tagHash(oldName));
            Set<Object> tagSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            for (byte[] urlHash : urlHashes) {
                Bookmark bookmark = this.getBookmark(ASCII.String(urlHash));
                if (bookmark == null) continue;
                tagSet = bookmark.getTags();
                tagSet.remove(oldName);
                bookmark.setTags(tagSet, true);
                if (!"".equals(newName)) {
                    bookmark.addTag(newName);
                }
                this.saveBookmark(bookmark);
            }
            return true;
        }
        return false;
    }

    public void addTag(String selectTag, String newTag) {
        for (byte[] urlHash : this.getTag(BookmarkHelper.tagHash(selectTag)).getUrlHashes()) {
            Bookmark bookmark = this.getBookmark(ASCII.String(urlHash));
            if (bookmark == null) continue;
            bookmark.addTag(newTag);
            this.saveBookmark(bookmark);
        }
    }

    public BookmarkDate.Entry getDate(String date) {
        return this.dates.getDate(date);
    }

    private class bookmarkIterator
    implements Iterator<Bookmark> {
        Iterator<byte[]> bookmarkIter;

        private bookmarkIterator(boolean up) throws IOException {
            this.bookmarkIter = BookmarksDB.this.bookmarks.keys(up, false);
        }

        @Override
        public boolean hasNext() {
            return this.bookmarkIter.hasNext();
        }

        @Override
        public Bookmark next() {
            return BookmarksDB.this.getBookmark(UTF8.String(this.bookmarkIter.next()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Bookmark {
        private static final String BOOKMARK_URL = "bookmarkUrl";
        public static final String BOOKMARK_TITLE = "bookmarkTitle";
        public static final String BOOKMARK_DESCRIPTION = "bookmarkDesc";
        private static final String BOOKMARK_TAGS = "bookmarkTags";
        private static final String BOOKMARK_PUBLIC = "bookmarkPublic";
        private static final String BOOKMARK_TIMESTAMP = "bookmarkTimestamp";
        private static final String BOOKMARK_OWNER = "bookmarkOwner";
        private static final String BOOKMARK_IS_FEED = "bookmarkIsFeed";
        public static final String BOOKMARK_QUERY = "bookmarkQuery";
        private final String urlHash;
        private Set<String> tagNames;
        private long timestamp;
        private final Map<String, String> entry;

        public Bookmark(DigestURL url) {
            this.entry = new HashMap<String, String>();
            this.urlHash = ASCII.String(url.hash());
            this.entry.put(BOOKMARK_URL, url.toNormalform(false));
            this.tagNames = new HashSet<String>();
            this.timestamp = System.currentTimeMillis();
            Bookmark oldBm = BookmarksDB.this.getBookmark(this.urlHash);
            if (oldBm != null && oldBm.entry.containsKey(BOOKMARK_TIMESTAMP)) {
                this.entry.put(BOOKMARK_TIMESTAMP, oldBm.entry.get(BOOKMARK_TIMESTAMP));
            } else {
                this.entry.put(BOOKMARK_TIMESTAMP, String.valueOf(System.currentTimeMillis()));
            }
            BookmarkDate.Entry bmDate = BookmarksDB.this.dates.getDate(this.entry.get(BOOKMARK_TIMESTAMP));
            bmDate.add(this.urlHash);
            bmDate.setDatesTable();
            BookmarksDB.this.removeBookmark(this.urlHash);
        }

        public Bookmark(String url) throws MalformedURLException {
            this(new DigestURL((String)(url.indexOf("://") < 0 ? "http://" + url : url)));
        }

        private Bookmark(Map<String, String> map) throws MalformedURLException {
            this.entry = map;
            this.urlHash = ASCII.String(new DigestURL(map.get(BOOKMARK_URL)).hash());
            this.tagNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (map.containsKey(BOOKMARK_TAGS)) {
                this.tagNames.addAll(ListManager.string2set(map.get(BOOKMARK_TAGS)));
            }
            this.loadTimestamp();
        }

        private Map<String, String> toMap() {
            this.entry.put(BOOKMARK_TAGS, ListManager.collection2string(this.tagNames));
            this.entry.put(BOOKMARK_TIMESTAMP, String.valueOf(this.timestamp));
            return this.entry;
        }

        private void loadTimestamp() {
            if (this.entry.containsKey(BOOKMARK_TIMESTAMP)) {
                this.timestamp = Long.parseLong(this.entry.get(BOOKMARK_TIMESTAMP));
            }
        }

        public String getUrlHash() {
            return this.urlHash;
        }

        public String getUrl() {
            return this.entry.get(BOOKMARK_URL);
        }

        public Set<String> getTags() {
            return this.tagNames;
        }

        public String getTagsString() {
            String[] s = CommonPattern.COMMA.split(ListManager.collection2string(this.getTags()));
            StringBuilder stringBuilder = new StringBuilder();
            int currentTag = 1;
            int tagCount = s.length;
            for (String element : s) {
                if (element.startsWith("/")) continue;
                stringBuilder.append(element);
                if (++currentTag >= tagCount) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }

        public String getTagsJsonList() {
            String[] s = CommonPattern.COMMA.split(ListManager.collection2string(this.getTags()));
            StringBuilder stringBuilder = new StringBuilder();
            int currentTag = 1;
            int tagCount = s.length;
            stringBuilder.append("[");
            for (String element : s) {
                if (element.startsWith("/")) continue;
                stringBuilder.append("\"");
                stringBuilder.append(element);
                stringBuilder.append("\"");
                if (++currentTag >= tagCount) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public String getFoldersString() {
            String[] s = CommonPattern.COMMA.split(ListManager.collection2string(this.getTags()));
            StringBuilder stringBuilder = new StringBuilder();
            int currentTag = 1;
            int tagCount = s.length;
            for (String element : s) {
                if (!element.startsWith("/")) continue;
                stringBuilder.append(element);
                if (++currentTag >= tagCount) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }

        public String getFolderJsonList() {
            String[] s = CommonPattern.COMMA.split(ListManager.collection2string(this.getTags()));
            StringBuilder stringBuilder = new StringBuilder();
            int currentTag = 1;
            int tagCount = s.length;
            stringBuilder.append("[");
            for (String element : s) {
                if (element.startsWith("/")) continue;
                stringBuilder.append("\"");
                stringBuilder.append(element);
                stringBuilder.append("\"");
                if (++currentTag >= tagCount) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public String getDescription() {
            if (this.entry.containsKey(BOOKMARK_DESCRIPTION)) {
                return this.entry.get(BOOKMARK_DESCRIPTION);
            }
            return "";
        }

        public String getTitle() {
            if (this.entry.containsKey(BOOKMARK_TITLE)) {
                return this.entry.get(BOOKMARK_TITLE);
            }
            return this.entry.get(BOOKMARK_URL);
        }

        public String getOwner() {
            if (this.entry.containsKey(BOOKMARK_OWNER)) {
                return this.entry.get(BOOKMARK_OWNER);
            }
            return null;
        }

        public void setOwner(String owner) {
            this.entry.put(BOOKMARK_OWNER, owner);
        }

        public boolean getPublic() {
            if (this.entry.containsKey(BOOKMARK_PUBLIC)) {
                return "public".equals(this.entry.get(BOOKMARK_PUBLIC));
            }
            return false;
        }

        public boolean getFeed() {
            if (this.entry.containsKey(BOOKMARK_IS_FEED)) {
                return "true".equals(this.entry.get(BOOKMARK_IS_FEED));
            }
            return false;
        }

        public String getQuery() {
            if (this.entry.containsKey(BOOKMARK_QUERY)) {
                return this.entry.get(BOOKMARK_QUERY);
            }
            return null;
        }

        public void setPublic(boolean isPublic) {
            if (isPublic) {
                this.entry.put(BOOKMARK_PUBLIC, "public");
            } else {
                this.entry.put(BOOKMARK_PUBLIC, "private");
            }
        }

        public void setFeed(boolean isFeed) {
            if (isFeed) {
                this.entry.put(BOOKMARK_IS_FEED, "true");
            } else {
                this.entry.put(BOOKMARK_IS_FEED, "false");
            }
        }

        public void setProperty(String name, String value) {
            this.entry.put(name, value);
        }

        public void addTag(String tagName) {
            this.tagNames.add(tagName);
            this.setTags(this.tagNames);
            BookmarksDB.this.saveBookmark(this);
        }

        public void setTags(Set<String> tags2) {
            this.setTags(tags2, true);
        }

        public void setTags(Set<String> tags2, boolean local) {
            this.tagNames = tags2;
            for (String tagName : this.tagNames) {
                Tag tag = BookmarksDB.this.getTag(BookmarkHelper.tagHash(tagName));
                if (tag == null) {
                    tag = new Tag(tagName);
                }
                tag.addUrl(this.getUrlHash());
                if (!local) continue;
                BookmarksDB.this.putTag(tag);
            }
            this.toMap();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public void setTimeStamp(long ts) {
            this.timestamp = ts;
            this.entry.put(BOOKMARK_TIMESTAMP, String.valueOf(this.timestamp));
        }
    }

    public class Tag {
        private final String tagHash;
        private final String tagName;
        private RowHandleSet urlHashes;

        private Tag(String name) {
            this.tagHash = BookmarkHelper.tagHash(name);
            this.tagName = name;
            this.urlHashes = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 10);
        }

        public String getTagName() {
            return this.getFriendlyName().toLowerCase();
        }

        private String getTagHash() {
            return this.tagHash;
        }

        public String getFriendlyName() {
            return this.tagName;
        }

        private RowHandleSet getUrlHashes() {
            return this.urlHashes;
        }

        private boolean hasPublicItems() {
            return BookmarksDB.this.getBookmarksIterator(this.getTagName(), false).hasNext();
        }

        private void addUrl(String urlHash) {
            try {
                this.urlHashes.put(ASCII.getBytes(urlHash));
            }
            catch (SpaceExceededException spaceExceededException) {
                // empty catch block
            }
        }

        private void delete(String urlHash) {
            this.urlHashes.remove(ASCII.getBytes(urlHash));
        }

        public int size() {
            return this.urlHashes.size();
        }

        private boolean isEmpty() {
            return this.urlHashes.isEmpty();
        }
    }

    private class bookmarkComparator
    implements Comparator<String> {
        private final boolean newestFirst;

        private bookmarkComparator(boolean newestFirst) {
            this.newestFirst = newestFirst;
        }

        @Override
        public int compare(String obj1, String obj2) {
            Bookmark bm1 = BookmarksDB.this.getBookmark(obj1);
            Bookmark bm2 = BookmarksDB.this.getBookmark(obj2);
            if (bm1 == null || bm2 == null) {
                return 0;
            }
            if (this.newestFirst) {
                if (bm2.getTimeStamp() - bm1.getTimeStamp() > 0L) {
                    return 1;
                }
                return -1;
            }
            if (bm1.getTimeStamp() - bm2.getTimeStamp() > 0L) {
                return 1;
            }
            return -1;
        }
    }

    private static class TagSizeComparator
    implements Comparator<Tag>,
    Serializable {
        private static final long serialVersionUID = 4149185397646373251L;

        private TagSizeComparator() {
        }

        @Override
        public int compare(Tag obj1, Tag obj2) {
            if (obj1.size() < obj2.size()) {
                return 1;
            }
            if (obj1.getTagName().equals(obj2.getTagName())) {
                return 0;
            }
            return -1;
        }
    }

    private static class TagComparator
    implements Comparator<Tag>,
    Serializable {
        private static final long serialVersionUID = 3105057490088903930L;

        private TagComparator() {
        }

        @Override
        public int compare(Tag obj1, Tag obj2) {
            return obj1.getTagName().compareTo(obj2.getTagName());
        }
    }
}

