/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.data;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.crawler.Balancer;
import net.yacy.crawler.CrawlSwitchboard;
import net.yacy.crawler.HostBalancer;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.MemoryControl;

public class NoticedURL {
    private Balancer coreStack;
    private Balancer limitStack;
    private Balancer remoteStack;
    private Balancer noloadStack;
    private final File cachePath;

    protected NoticedURL(File cachePath, int onDemandLimit, boolean exceed134217727) {
        ConcurrentLog.info("NoticedURL", "START CREATING STACKS at " + cachePath.toString());
        ConcurrentLog.info("NoticedURL", "opening CrawlerCoreStacks..");
        this.cachePath = cachePath;
        this.coreStack = new HostBalancer(new File(cachePath, "CrawlerCoreStacks"), onDemandLimit, exceed134217727);
        ConcurrentLog.info("NoticedURL", "opening CrawlerLimitStacks..");
        this.limitStack = new HostBalancer(new File(cachePath, "CrawlerLimitStacks"), onDemandLimit, exceed134217727);
        this.remoteStack = null;
        ConcurrentLog.info("NoticedURL", "opening CrawlerNoLoadStacks..");
        this.noloadStack = new HostBalancer(new File(cachePath, "CrawlerNoLoadStacks"), onDemandLimit, exceed134217727);
        ConcurrentLog.info("NoticedURL", "FINISHED CREATING STACKS at " + cachePath.toString());
    }

    protected void initRemoteStack() {
        if (this.remoteStack == null && !MemoryControl.shortStatus()) {
            ConcurrentLog.info("NoticedURL", "opening CrawlerRemoteStacks..");
            this.remoteStack = new HostBalancer(new File(this.cachePath, "CrawlerRemoteStacks"), this.coreStack.getOnDemandLimit(), this.coreStack.getExceed134217727());
        }
    }

    public void clear() {
        ConcurrentLog.info("NoticedURL", "CLEARING ALL STACKS");
        if (this.coreStack != null) {
            this.coreStack.clear();
        }
        if (this.limitStack != null) {
            this.limitStack.clear();
        }
        if (this.remoteStack != null) {
            this.remoteStack.clear();
        }
        if (this.noloadStack != null) {
            this.noloadStack.clear();
        }
    }

    protected void close() {
        ConcurrentLog.info("NoticedURL", "CLOSING ALL STACKS");
        if (this.coreStack != null) {
            this.coreStack.close();
            this.coreStack = null;
        }
        if (this.limitStack != null) {
            this.limitStack.close();
            this.limitStack = null;
        }
        if (this.remoteStack != null) {
            this.remoteStack.close();
            this.remoteStack = null;
        }
        if (this.noloadStack != null) {
            this.noloadStack.close();
            this.noloadStack = null;
        }
    }

    public int size() {
        return (this.coreStack == null ? 0 : this.coreStack.size()) + (this.limitStack == null ? 0 : this.limitStack.size()) + (this.remoteStack == null ? 0 : this.remoteStack.size());
    }

    public boolean isEmptyLocal() {
        if (this.coreStack == null) {
            return true;
        }
        if (!this.coreStack.isEmpty()) {
            return false;
        }
        if (!this.limitStack.isEmpty()) {
            return false;
        }
        return this.noloadStack.isEmpty();
    }

    public boolean isEmpty() {
        if (!this.isEmptyLocal()) {
            return false;
        }
        return this.remoteStack == null || this.remoteStack.isEmpty();
    }

    public boolean isEmpty(StackType stackType) {
        switch (stackType.ordinal()) {
            case 3: {
                return this.noloadStack == null ? true : this.noloadStack.isEmpty();
            }
            case 0: {
                return this.coreStack == null ? true : this.coreStack.isEmpty();
            }
            case 1: {
                return this.limitStack == null ? true : this.limitStack.isEmpty();
            }
            case 2: {
                return this.remoteStack == null ? true : this.remoteStack.isEmpty();
            }
        }
        return true;
    }

    public int stackSize(StackType stackType) {
        switch (stackType.ordinal()) {
            case 3: {
                return this.noloadStack == null ? 0 : this.noloadStack.size();
            }
            case 0: {
                return this.coreStack == null ? 0 : this.coreStack.size();
            }
            case 1: {
                return this.limitStack == null ? 0 : this.limitStack.size();
            }
            case 2: {
                return this.remoteStack == null ? 0 : this.remoteStack.size();
            }
        }
        return -1;
    }

    protected boolean existsInStack(byte[] urlhashb) {
        return this.coreStack.has(urlhashb) || this.limitStack.has(urlhashb) || this.remoteStack != null && this.remoteStack.has(urlhashb) || this.noloadStack.has(urlhashb);
    }

    public String push(StackType stackType, Request entry2, CrawlProfile profile2, RobotsTxt robots2) {
        try {
            switch (stackType.ordinal()) {
                case 0: {
                    return this.coreStack.push(entry2, profile2, robots2);
                }
                case 1: {
                    return this.limitStack.push(entry2, profile2, robots2);
                }
                case 2: {
                    if (this.remoteStack == null) {
                        this.initRemoteStack();
                    }
                    return this.remoteStack != null ? this.remoteStack.push(entry2, profile2, robots2) : "remote crawler stack deactivated";
                }
                case 3: {
                    return this.noloadStack.push(entry2, profile2, robots2);
                }
            }
            return "stack type unknown";
        }
        catch (Exception er) {
            ConcurrentLog.logException(er);
            return "error pushing onto the crawl stack: " + er.getMessage();
        }
    }

    protected Request get(byte[] urlhash) {
        Request entry2 = null;
        try {
            entry2 = this.noloadStack.get(urlhash);
            if (entry2 != null) {
                return entry2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            entry2 = this.coreStack.get(urlhash);
            if (entry2 != null) {
                return entry2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            entry2 = this.limitStack.get(urlhash);
            if (entry2 != null) {
                return entry2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.remoteStack != null && (entry2 = this.remoteStack.get(urlhash)) != null) {
                return entry2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean removeByURLHash(byte[] urlhashBytes) {
        try {
            RowHandleSet urlHashes = new RowHandleSet(12, (ByteOrder)Base64Order.enhancedCoder, 1);
            urlHashes.put(urlhashBytes);
            boolean ret = false;
            try {
                ret |= this.noloadStack.remove(urlHashes) > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ret |= this.coreStack.remove(urlHashes) > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ret |= this.limitStack.remove(urlHashes) > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ret |= this.remoteStack != null && this.remoteStack.remove(urlHashes) > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ret;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return false;
        }
    }

    public int removeByProfileHandle(String handle, long timeout) throws SpaceExceededException {
        int removed = 0;
        try {
            removed += this.noloadStack.removeAllByProfileHandle(handle, timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            removed += this.coreStack.removeAllByProfileHandle(handle, timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            removed += this.limitStack.removeAllByProfileHandle(handle, timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.remoteStack != null) {
            try {
                removed += this.remoteStack.removeAllByProfileHandle(handle, timeout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return removed;
    }

    public int removeByHostHash(Set<String> hosthashes) {
        int removed = 0;
        removed += this.noloadStack.removeAllByHostHashes(hosthashes);
        removed += this.coreStack.removeAllByHostHashes(hosthashes);
        removed += this.limitStack.removeAllByHostHashes(hosthashes);
        if (this.remoteStack != null) {
            removed += this.remoteStack.removeAllByHostHashes(hosthashes);
        }
        return removed;
    }

    public Map<String, Integer[]> getDomainStackHosts(StackType stackType, RobotsTxt robots2) {
        switch (stackType.ordinal()) {
            case 0: {
                return this.coreStack.getDomainStackHosts(robots2);
            }
            case 1: {
                return this.limitStack.getDomainStackHosts(robots2);
            }
            case 2: {
                return this.remoteStack != null ? this.remoteStack.getDomainStackHosts(robots2) : null;
            }
            case 3: {
                return this.noloadStack.getDomainStackHosts(robots2);
            }
        }
        return null;
    }

    public List<Request> getDomainStackReferences(StackType stackType, String host, int maxcount, long maxtime) {
        switch (stackType.ordinal()) {
            case 0: {
                return this.coreStack.getDomainStackReferences(host, maxcount, maxtime);
            }
            case 1: {
                return this.limitStack.getDomainStackReferences(host, maxcount, maxtime);
            }
            case 2: {
                return this.remoteStack != null ? this.remoteStack.getDomainStackReferences(host, maxcount, maxtime) : Collections.emptyList();
            }
            case 3: {
                return this.noloadStack.getDomainStackReferences(host, maxcount, maxtime);
            }
        }
        return Collections.emptyList();
    }

    public Request pop(StackType stackType, boolean delay, CrawlSwitchboard cs, RobotsTxt robots2) throws IOException {
        switch (stackType.ordinal()) {
            case 0: {
                return NoticedURL.pop(this.coreStack, delay, cs, robots2);
            }
            case 1: {
                return NoticedURL.pop(this.limitStack, delay, cs, robots2);
            }
            case 2: {
                return this.remoteStack != null ? NoticedURL.pop(this.remoteStack, delay, cs, robots2) : null;
            }
            case 3: {
                return NoticedURL.pop(this.noloadStack, false, cs, robots2);
            }
        }
        return null;
    }

    protected void shift(StackType fromStack, StackType toStack, CrawlSwitchboard cs, RobotsTxt robots2) {
        try {
            String warning;
            Request entry2 = this.pop(fromStack, false, cs, robots2);
            if (entry2 != null && (warning = this.push(toStack, entry2, null, robots2)) != null) {
                ConcurrentLog.warn("NoticedURL", "shift from " + String.valueOf((Object)fromStack) + " to " + String.valueOf((Object)toStack) + ": " + warning);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    public void clear(StackType stackType) {
        ConcurrentLog.info("NoticedURL", "CLEARING STACK " + String.valueOf((Object)stackType));
        switch (stackType.ordinal()) {
            case 0: {
                this.coreStack.clear();
                break;
            }
            case 1: {
                this.limitStack.clear();
                break;
            }
            case 2: {
                if (this.remoteStack == null) break;
                this.remoteStack.clear();
                break;
            }
            case 3: {
                this.noloadStack.clear();
                break;
            }
            default: {
                return;
            }
        }
    }

    private static Request pop(Balancer balancer, boolean delay, CrawlSwitchboard cs, RobotsTxt robots2) throws IOException {
        int errors = 0;
        while (!balancer.isEmpty()) {
            Request entry2 = balancer.pop(delay, cs, robots2);
            if (entry2 != null) {
                return entry2;
            }
            int s = balancer.size();
            if (s == 0) {
                return null;
            }
            entry2 = balancer.pop(delay, cs, robots2);
            if (entry2 != null) {
                return entry2;
            }
            if (s > balancer.size() || ++errors < 100) continue;
            int aftersize = balancer.size();
            balancer.clear();
            ConcurrentLog.warn("BALANCER", "balancer cannot shrink (bevore pop = " + s + ", after pop = " + aftersize + "); reset of balancer");
            return null;
        }
        return null;
    }

    public Iterator<Request> iterator(StackType stackType) {
        try {
            switch (stackType.ordinal()) {
                case 0: {
                    return this.coreStack.iterator();
                }
                case 1: {
                    return this.limitStack.iterator();
                }
                case 2: {
                    return this.remoteStack != null ? this.remoteStack.iterator() : null;
                }
                case 3: {
                    return this.noloadStack.iterator();
                }
            }
            return null;
        }
        catch (IOException e) {
            return new HashSet().iterator();
        }
    }

    public static enum StackType {
        LOCAL,
        GLOBAL,
        REMOTE,
        NOLOAD;

    }
}

