/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.yacy.cora.document.encoding.UTF8;

public final class ChunkedBytes
extends OutputStream
implements Comparable<Object>,
Closeable,
Cloneable {
    public static final int CHUNK_SIZE = 0x4000000;
    private final List<Segment> segments;
    private long size;
    private final List<FileChannel> fileChannels = new ArrayList<FileChannel>();

    public ChunkedBytes() {
        this.segments = new ArrayList<Segment>();
        this.size = 0L;
    }

    public ChunkedBytes(InputStream in) throws IOException {
        this();
        this.writeFrom(in);
    }

    public ChunkedBytes(byte[] initialData) {
        this();
        this.append(initialData, 0, initialData.length);
    }

    public ChunkedBytes(String initialData) {
        this();
        this.append(UTF8.getBytes(initialData));
    }

    private ChunkedBytes(List<Segment> segments, long size) {
        this.segments = new ArrayList<Segment>(segments);
        this.size = size;
    }

    public long size() {
        return this.size;
    }

    public void writeFrom(InputStream in) throws IOException {
        int r;
        byte[] tmp = new byte[65536];
        while ((r = in.read(tmp)) != -1) {
            if (r == 0) continue;
            this.append(tmp, 0, r);
        }
    }

    public void append(byte[] src, int off, int len) {
        while (len > 0) {
            int space = this.spaceInTailHeapChunk();
            if (space == 0) {
                this.newTailHeapChunk(len);
                space = this.spaceInTailHeapChunk();
            }
            Segment tail = this.segments.get(this.segments.size() - 1);
            int take = Math.min(len, space);
            int written = tail.chunk.write(tail.length, src, off, take);
            if (written <= 0) break;
            this.growTailLength(tail, written);
            off += written;
            len -= written;
            this.size += (long)written;
        }
    }

    public void append(byte[] src) {
        this.append(src, 0, src.length);
    }

    public void append(String src, int off, int len) {
        this.append(src.substring(off, off + len));
    }

    public void append(String src) {
        this.append(UTF8.getBytes(src));
    }

    public void appendFile(Path path) {
        this.appendFile(path, false);
    }

    public void appendFile(Path path, boolean writable) {
        AbstractInterruptibleChannel ch = null;
        try {
            int len;
            OpenOption[] openOptionArray;
            if (writable) {
                OpenOption[] openOptionArray2 = new OpenOption[2];
                openOptionArray2[0] = StandardOpenOption.READ;
                openOptionArray = openOptionArray2;
                openOptionArray2[1] = StandardOpenOption.WRITE;
            } else {
                OpenOption[] openOptionArray3 = new OpenOption[1];
                openOptionArray = openOptionArray3;
                openOptionArray3[0] = StandardOpenOption.READ;
            }
            ch = FileChannel.open(path, openOptionArray);
            long fileSize = ((FileChannel)ch).size();
            for (long pos = 0L; pos < fileSize; pos += (long)len) {
                len = (int)Math.min(0x4000000L, fileSize - pos);
                this.segments.add(new Segment(new FileChunk((FileChannel)ch, pos, len, writable), this.size, len));
                this.size += (long)len;
            }
            this.fileChannels.add((FileChannel)ch);
            ch = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ch != null) {
                try {
                    ch.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int read(long pos, byte[] dst, int off, int len) {
        if (pos < 0L) {
            throw new IllegalArgumentException("pos < 0");
        }
        if (pos >= this.size) {
            return -1;
        }
        long remaining = Math.min((long)len, this.size - pos);
        int done = 0;
        int idx2 = this.findSegment(pos);
        long p = pos;
        while (remaining > 0L && idx2 < this.segments.size()) {
            Segment s = this.segments.get(idx2);
            long rel = p - s.start;
            int take = (int)Math.min(remaining, (long)s.length - rel);
            int n = s.chunk.read(rel, dst, off + done, take);
            if (n <= 0) break;
            done += n;
            p += (long)n;
            remaining -= (long)n;
            if (rel + (long)n < (long)s.length) continue;
            ++idx2;
        }
        return done == 0 ? -1 : done;
    }

    public int write(long pos, byte[] src, int off, int len) {
        if (pos < 0L) {
            throw new IllegalArgumentException("pos < 0");
        }
        if (pos >= this.size) {
            return -1;
        }
        long remaining = Math.min((long)len, this.size - pos);
        int done = 0;
        int idx2 = this.findSegment(pos);
        long p = pos;
        while (remaining > 0L && idx2 < this.segments.size()) {
            Segment s = this.segments.get(idx2);
            long rel = p - s.start;
            int take = (int)Math.min(remaining, (long)s.length - rel);
            int n = s.chunk.write(rel, src, off + done, take);
            if (n <= 0) break;
            done += n;
            p += (long)n;
            remaining -= (long)n;
            if (rel + (long)n < (long)s.length) continue;
            ++idx2;
        }
        return done == 0 ? -1 : done;
    }

    public InputStream openStream() {
        return new InputStream(){
            long pos = 0L;

            @Override
            public int read() throws IOException {
                byte[] one = new byte[1];
                int n = this.read(one, 0, 1);
                return n < 0 ? -1 : one[0] & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int n = ChunkedBytes.this.read(this.pos, b, off, len);
                if (n > 0) {
                    this.pos += (long)n;
                }
                return n;
            }

            @Override
            public long skip(long n) {
                long k = Math.min(n, ChunkedBytes.this.size - this.pos);
                this.pos += k;
                return k;
            }

            @Override
            public int available() {
                long rem = ChunkedBytes.this.size - this.pos;
                return rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rem;
            }
        };
    }

    public void writeTo(OutputStream out) {
        byte[] tmp = new byte[262144];
        try {
            int n;
            for (long p = 0L; p < this.size && (n = this.read(p, tmp, 0, tmp.length)) >= 0; p += (long)n) {
                out.write(tmp, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        if (this.size > Integer.MAX_VALUE) {
            throw new RuntimeException("Size > Integer.MAX_VALUE");
        }
        final byte[] all2 = new byte[(int)this.size];
        this.writeTo(new ByteArrayOutputStream(){
            int offset = 0;

            @Override
            public void write(byte[] b, int off, int len) {
                System.arraycopy(b, off, all2, this.offset, len);
                this.offset += len;
            }
        });
        return all2;
    }

    @Override
    public synchronized void write(int b) {
        byte[] one = new byte[]{(byte)b};
        this.append(one, 0, 1);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        this.append(b, off, len);
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        Exception first = null;
        for (Segment s : this.segments) {
            try {
                s.close();
            }
            catch (Exception e) {
                if (first != null) continue;
                first = e;
            }
        }
        for (FileChannel ch : this.fileChannels) {
            try {
                ch.close();
            }
            catch (Exception e) {
                if (first != null) continue;
                first = e;
            }
        }
        if (first != null) {
            throw new RuntimeException(first.getMessage());
        }
    }

    public String toString() {
        return UTF8.String(this.toByteArray());
    }

    public byte get(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("pos < 0");
        }
        if (pos >= this.size) {
            throw new RuntimeException("pos >= size");
        }
        int idx2 = this.findSegment(pos);
        Segment s = this.segments.get(idx2);
        long rel = pos - s.start;
        return s.chunk.get(rel);
    }

    public Object clone() {
        ArrayList<Segment> list2 = new ArrayList<Segment>(this.segments.size());
        for (Segment s : this.segments) {
            list2.add((Segment)s.clone());
        }
        ChunkedBytes cb = new ChunkedBytes(list2, this.size);
        return cb;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ChunkedBytes) {
            ChunkedBytes cb = (ChunkedBytes)o;
            if (this.size != cb.size) {
                return false;
            }
            for (long i = 0L; i < this.size; ++i) {
                if (this.get(i) == cb.get(i)) continue;
                return false;
            }
            return true;
        }
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (this.size != (long)b.length) {
                return false;
            }
            for (int i = 0; i < b.length; ++i) {
                if (this.get(i) == b[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof String) {
            return this.equals(UTF8.getBytes((String)o));
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof ChunkedBytes) {
            ChunkedBytes cb = (ChunkedBytes)o;
            int minLen = (int)Math.min(this.size, cb.size);
            for (int i = 0; i < minLen; ++i) {
                int diff = (this.get(i) & 0xFF) - (cb.get(i) & 0xFF);
                if (diff == 0) continue;
                return diff;
            }
            return Long.compare(this.size, cb.size);
        }
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            int minLen = (int)Math.min(this.size, (long)b.length);
            for (int i = 0; i < minLen; ++i) {
                int diff = (this.get(i) & 0xFF) - (b[i] & 0xFF);
                if (diff == 0) continue;
                return diff;
            }
            return Long.compare(this.size, b.length);
        }
        if (o instanceof String) {
            return this.compareTo(UTF8.getBytes((String)o));
        }
        throw new IllegalArgumentException("Cannot compare to " + (o == null ? "null" : o.getClass().getName()));
    }

    private int findSegment(long pos) {
        int lo = 0;
        int hi = this.segments.size() - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            Segment s = this.segments.get(mid);
            if (pos < s.start) {
                hi = mid - 1;
                continue;
            }
            if (pos >= s.start + (long)s.length) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return Math.max(0, Math.min(lo, this.segments.size() - 1));
    }

    private int spaceInTailHeapChunk() {
        if (this.segments.isEmpty()) {
            return 0;
        }
        Segment tail = this.segments.get(this.segments.size() - 1);
        if (!(tail.chunk instanceof HeapChunk)) {
            return 0;
        }
        return tail.length < tail.chunk.length() ? tail.chunk.length() - tail.length : 0;
    }

    private void newTailHeapChunk(int minCapacity) {
        int cap = Math.min(0x4000000, minCapacity);
        this.segments.add(new Segment(new HeapChunk(cap), this.size, 0));
    }

    private void growTailLength(Segment tail, int inc) {
        int idx2 = this.segments.size() - 1;
        this.segments.set(idx2, new Segment(tail.chunk, tail.start, tail.length + inc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ChunkedBytes cb;
        OutputStream fout;
        System.out.println("ChunkedBytes test starting. CHUNK_SIZE=64 MiB");
        long seed = 1592642302L;
        long bigLen = 369111097L;
        int ioBuf = 0x100000;
        long[] samples = new long[]{0L, 0x3FFFFFFL, 0x4000000L, 0x4000001L, 0xBFFFFFFL, 0xC000000L, 0x14000011L, 369111096L};
        try (ChunkedBytes cb2 = new ChunkedBytes();){
            int n;
            System.out.println("[A] Heap-only append of random 369111097 bytes (>5 chunks) via OutputStream");
            byte[] expectedSample = new byte[samples.length];
            byte[] buf = new byte[0x100000];
            Random rnd = new Random(1592642302L);
            MessageDigest mdIn = MessageDigest.getInstance("SHA-256");
            int si = 0;
            for (long pos = 0L; pos < 369111097L; pos += (long)n) {
                n = (int)Math.min((long)buf.length, 369111097L - pos);
                rnd.nextBytes(buf);
                mdIn.update(buf, 0, n);
                cb2.write(buf, 0, n);
                while (si < samples.length && samples[si] >= pos && samples[si] < pos + (long)n) {
                    expectedSample[si] = buf[(int)(samples[si] - pos)];
                    ++si;
                }
            }
            byte[] digestOriginal = mdIn.digest();
            System.out.println("  Original SHA-256: " + ChunkedBytes.toHex(digestOriginal));
            ChunkedBytes.assertEquals(369111097L, cb2.size(), "[A] size");
            byte[] digestCb = ChunkedBytes.sha256Of(cb2.openStream(), 0x100000);
            System.out.println("  CB stream SHA-256: " + ChunkedBytes.toHex(digestCb));
            ChunkedBytes.assertArrayEquals(digestOriginal, digestCb, "[A] digest equality");
            for (int i = 0; i < samples.length; ++i) {
                byte b = ChunkedBytes.readByteAt(cb2, samples[i]);
                if (b != expectedSample[i]) {
                    throw new AssertionError((Object)("[A] sample mismatch at " + samples[i]));
                }
            }
            System.out.println("  Sample point checks: OK");
            long crossStart = 0x3FFFFFEL;
            byte[] got = new byte[5];
            int n2 = cb2.read(0x3FFFFFEL, got, 0, got.length);
            ChunkedBytes.assertEquals(5, n2, "[A] cross-boundary read length");
            byte[] expect = ChunkedBytes.regenRange(1592642302L, 369111097L, 0x3FFFFFEL, 5, 0x100000);
            ChunkedBytes.assertArrayEquals(expect, got, "[A] cross-boundary bytes");
            byte[] patch = new byte[]{99, 98, 97, 0, 1, 2, 3};
            long patchPos = 0x8000007L;
            int wrote = cb2.write(0x8000007L, patch, 0, patch.length);
            ChunkedBytes.assertEquals(patch.length, wrote, "[A] write length");
            byte[] check = new byte[patch.length];
            int rn = cb2.read(0x8000007L, check, 0, check.length);
            ChunkedBytes.assertEquals(patch.length, rn, "[A] reread length");
            ChunkedBytes.assertArrayEquals(patch, check, "[A] write verification");
            try (InputStream in = cb2.openStream();){
                long skipped = in.skip(0x8000007L);
                ChunkedBytes.assertEquals(0x8000007L, skipped, "[A] skip");
                int avail = in.available();
                if (avail <= 0) {
                    throw new AssertionError((Object)"[A] available should be > 0 after skip");
                }
                byte[] tmp = in.readNBytes(32);
                if (tmp.length == 0) {
                    throw new AssertionError((Object)"[A] read after skip failed");
                }
                while (in.read(tmp) >= 0) {
                }
                if (in.read() != -1) {
                    throw new AssertionError((Object)"[A] EOF expected");
                }
            }
            byte[] digestAfter = ChunkedBytes.sha256Of(cb2.openStream(), 0x100000);
            MessageDigest mdSink = MessageDigest.getInstance("SHA-256");
            cb2.writeTo(new DigestOutputStream(new NullOutputStream(), mdSink));
            byte[] digestWriteTo = mdSink.digest();
            ChunkedBytes.assertArrayEquals(digestAfter, digestWriteTo, "[A] writeTo digest (post-mutation)");
            try (ChunkedBytes small = new ChunkedBytes();){
                byte[] sm = new byte[15000];
                new Random(123L).nextBytes(sm);
                small.write(sm);
                byte[] smOut = small.toByteArray();
                ChunkedBytes.assertArrayEquals(sm, smOut, "[A] toByteArray");
            }
            System.out.println("[A] Heap-only tests: OK");
        }
        Path tmpFile = Files.createTempFile("cb-ro-", ".bin", new FileAttribute[0]);
        try {
            byte[] fileDigest;
            long fileLen = 201338937L;
            System.out.println("[B] Create temp file (read-only mapping) len=201338937");
            fout = Files.newOutputStream(tmpFile, new OpenOption[0]);
            try {
                fileDigest = ChunkedBytes.writeRandomToStream(fout, 1592642303L, 201338937L, 0x100000);
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
            System.out.println("  File SHA-256: " + ChunkedBytes.toHex(fileDigest));
            cb = new ChunkedBytes();
            try {
                cb.appendFile(tmpFile);
                ChunkedBytes.assertEquals(201338937L, cb.size(), "[B] size");
                byte[] cbDigest = ChunkedBytes.sha256Of(cb.openStream(), 0x100000);
                System.out.println("  CB map SHA-256: " + ChunkedBytes.toHex(cbDigest));
                ChunkedBytes.assertArrayEquals(fileDigest, cbDigest, "[B] digest equality");
                long pos = 0x3FFFFFDL;
                byte[] got = new byte[9];
                int m = cb.read(0x3FFFFFDL, got, 0, got.length);
                ChunkedBytes.assertEquals(9, m, "[B] boundary read length");
                byte[] exp = ChunkedBytes.regenRange(1592642303L, 201338937L, 0x3FFFFFDL, 9, 0x100000);
                ChunkedBytes.assertArrayEquals(exp, got, "[B] boundary bytes");
            }
            finally {
                cb.close();
            }
            System.out.println("[B] Read-only mapping tests: OK");
        }
        finally {
            try {
                Files.deleteIfExists(tmpFile);
            }
            catch (Exception fileLen) {}
        }
        Path tmpRW = Files.createTempFile("cb-rw-", ".bin", new FileAttribute[0]);
        try {
            long fileLen = 134218505L;
            System.out.println("[C] Create temp file (writable mapping) len=134218505");
            fout = Files.newOutputStream(tmpRW, new OpenOption[0]);
            try {
                ChunkedBytes.writeRandomToStream(fout, 1592642304L, 134218505L, 0x100000);
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
            cb = new ChunkedBytes();
            try {
                cb.appendFile(tmpRW, true);
                long[] offs = new long[]{0L, 0x4000000L, 134218500L};
                byte[][] patches = new byte[][]{{7, 6, 5, 4, 3}, {1, 2, 3, 4}, {-1, -2, -3, -4, -5}};
                for (int i = 0; i < offs.length; ++i) {
                    int w = cb.write(offs[i], patches[i], 0, patches[i].length);
                    ChunkedBytes.assertEquals(patches[i].length, w, "[C] write length " + i);
                    byte[] chk = new byte[patches[i].length];
                    int r = cb.read(offs[i], chk, 0, chk.length);
                    ChunkedBytes.assertEquals(chk.length, r, "[C] reread len " + i);
                    ChunkedBytes.assertArrayEquals(patches[i], chk, "[C] content verify " + i);
                }
            }
            finally {
                cb.close();
            }
            try (FileChannel ch = FileChannel.open(tmpRW, StandardOpenOption.READ);){
                byte[] p0 = new byte[5];
                ChunkedBytes.readFully(ch, 0L, p0);
                ChunkedBytes.assertArrayEquals(new byte[]{7, 6, 5, 4, 3}, p0, "[C] disk verify 0");
                byte[] p1 = new byte[4];
                ChunkedBytes.readFully(ch, 0x4000000L, p1);
                ChunkedBytes.assertArrayEquals(new byte[]{1, 2, 3, 4}, p1, "[C] disk verify 1");
                byte[] p2 = new byte[5];
                ChunkedBytes.readFully(ch, 134218500L, p2);
                ChunkedBytes.assertArrayEquals(new byte[]{-1, -2, -3, -4, -5}, p2, "[C] disk verify 2");
            }
            System.out.println("[C] Writable mapping tests: OK");
        }
        finally {
            try {
                Files.deleteIfExists(tmpRW);
            }
            catch (Exception fileLen) {}
        }
        System.out.println("[D] Mixed sources (heap + file + single-byte writes)");
        Path tmpMix = Files.createTempFile("cb-mix-", ".bin", new FileAttribute[0]);
        long mixLen = 67109197L;
        try (OutputStream fout2 = Files.newOutputStream(tmpMix, new OpenOption[0]);){
            ChunkedBytes.writeRandomToStream(fout2, 1592642305L, 67109197L, 0x100000);
        }
        try (ChunkedBytes cb3 = new ChunkedBytes();){
            byte[] prefix = new byte[5000];
            new Random(42L).nextBytes(prefix);
            cb3.write(prefix);
            cb3.appendFile(tmpMix);
            for (int i = 0; i < 1000; ++i) {
                cb3.write(i & 0xFF);
            }
            long expectedSize = (long)prefix.length + Files.size(tmpMix) + 1000L;
            ChunkedBytes.assertEquals(expectedSize, cb3.size(), "[D] size");
            byte[] got = new byte[prefix.length];
            int r = cb3.read(0L, got, 0, got.length);
            ChunkedBytes.assertEquals(prefix.length, r, "[D] prefix read len");
            ChunkedBytes.assertArrayEquals(prefix, got, "[D] prefix bytes");
            byte[] fileSliceExpected = ChunkedBytes.regenRange(1592642305L, Files.size(tmpMix), 123L, 256, 0x100000);
            byte[] fileSliceGot = new byte[256];
            int r2 = cb3.read(prefix.length + 123, fileSliceGot, 0, fileSliceGot.length);
            ChunkedBytes.assertEquals(256, r2, "[D] file slice len");
            ChunkedBytes.assertArrayEquals(fileSliceExpected, fileSliceGot, "[D] file slice bytes");
            byte[] tail = new byte[10];
            int r3 = cb3.read(expectedSize - 10L, tail, 0, 10);
            ChunkedBytes.assertEquals(10, r3, "[D] tail len");
            for (int i = 0; i < 10; ++i) {
                byte exp = (byte)(990 + i & 0xFF);
                if (tail[i] != exp) {
                    throw new AssertionError((Object)("[D] tail byte mismatch at i=" + i));
                }
            }
            CountingOutputStream cos = new CountingOutputStream();
            cb3.writeTo(cos);
            ChunkedBytes.assertEquals(expectedSize, cos.count, "[D] writeTo count");
        }
        finally {
            try {
                Files.deleteIfExists(tmpMix);
            }
            catch (Exception exception) {}
        }
        System.out.println("[D] Mixed sources tests: OK");
        System.out.println("All tests PASSED.");
    }

    private static void assertEquals(long exp, long got, String where) {
        if (exp != got) {
            throw new AssertionError((Object)(where + ": expected " + exp + " but got " + got));
        }
    }

    private static void assertEquals(int exp, int got, String where) {
        if (exp != got) {
            throw new AssertionError((Object)(where + ": expected " + exp + " but got " + got));
        }
    }

    private static void assertArrayEquals(byte[] exp, byte[] got, String where) {
        if (!Arrays.equals(exp, got)) {
            throw new AssertionError((Object)(where + ": arrays differ"));
        }
    }

    private static String toHex(byte[] d) {
        StringBuilder sb = new StringBuilder(d.length * 2);
        for (byte b : d) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] sha256Of(InputStream in, int bufSize) throws Exception {
        int n;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buf = new byte[bufSize];
        while ((n = in.read(buf)) >= 0) {
            md.update(buf, 0, n);
        }
        return md.digest();
    }

    private static byte readByteAt(ChunkedBytes cb, long pos) throws IOException {
        byte[] one = new byte[1];
        int n = cb.read(pos, one, 0, 1);
        if (n != 1) {
            throw new IOException("Unable to read at pos=" + pos);
        }
        return one[0];
    }

    private static byte[] regenRange(long seed, long totalLen, long start, int len, int bufSize) throws IOException {
        if (start + (long)len > totalLen) {
            throw new IOException("range exceeds totalLen");
        }
        Random rnd = new Random(seed);
        byte[] buf = new byte[bufSize];
        long pos = 0L;
        byte[] out = new byte[len];
        int outPos = 0;
        while (pos < totalLen && outPos < len) {
            int n = (int)Math.min((long)buf.length, totalLen - pos);
            rnd.nextBytes(buf);
            long end = pos + (long)n;
            if (start < end && start + (long)len > pos) {
                long s = Math.max(start, pos);
                long e = Math.min(start + (long)len, end);
                int copy = (int)(e - s);
                System.arraycopy(buf, (int)(s - pos), out, outPos, copy);
                outPos += copy;
            }
            pos = end;
        }
        return out;
    }

    private static byte[] writeRandomToStream(OutputStream out, long seed, long length, int bufSize) throws Exception {
        int n;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        Random rnd = new Random(seed);
        byte[] buf = new byte[bufSize];
        for (long pos = 0L; pos < length; pos += (long)n) {
            n = (int)Math.min((long)buf.length, length - pos);
            rnd.nextBytes(buf);
            out.write(buf, 0, n);
            md.update(buf, 0, n);
        }
        out.flush();
        return md.digest();
    }

    private static void readFully(FileChannel ch, long pos, byte[] dst) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(dst);
        while (bb.hasRemaining()) {
            int n = ch.read(bb, pos);
            if (n < 0) {
                throw new EOFException();
            }
            pos += (long)n;
        }
    }

    private static final class Segment
    implements Closeable,
    Cloneable {
        final Chunk chunk;
        final long start;
        final int length;

        Segment(Chunk chunk, long start, int length) {
            this.chunk = chunk;
            this.start = start;
            this.length = length;
        }

        public Object clone() {
            return new Segment((Chunk)this.chunk.clone(), this.start, this.length);
        }

        @Override
        public void close() throws IOException {
            this.chunk.close();
        }
    }

    private static interface Chunk
    extends Closeable,
    Cloneable {
        public int read(long var1, byte[] var3, int var4, int var5);

        public int write(long var1, byte[] var3, int var4, int var5);

        public byte get(long var1);

        public void set(long var1, byte var3);

        public int length();

        public Object clone();

        @Override
        default public void close() {
        }
    }

    private static final class FileChunk
    implements Chunk,
    Cloneable {
        final FileChannel ch;
        final long fileOffset;
        final int len;
        final boolean writable;
        private volatile MappedByteBuffer mm;

        FileChunk(FileChannel ch, long fileOffset, int len, boolean writable) {
            this.ch = ch;
            this.fileOffset = fileOffset;
            this.len = len;
            this.writable = writable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MappedByteBuffer map() {
            MappedByteBuffer local = this.mm;
            if (local == null) {
                FileChunk fileChunk = this;
                synchronized (fileChunk) {
                    local = this.mm;
                    if (local == null) {
                        FileChannel.MapMode mapMode = this.writable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
                        try {
                            this.mm = local = this.ch.map(mapMode, this.fileOffset, this.len);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return local;
        }

        @Override
        public int read(long p, byte[] dst, int off, int len) {
            if (p >= (long)this.len) {
                return -1;
            }
            int take = Math.min(len, this.len - (int)p);
            MappedByteBuffer dup = this.map().duplicate();
            ((ByteBuffer)dup).position((int)p).limit((int)p + take);
            dup.get(dst, off, take);
            return take;
        }

        @Override
        public int write(long p, byte[] src, int off, int len) {
            if (!this.writable) {
                throw new RuntimeException("FileChunk is read-only");
            }
            if (p >= (long)this.len) {
                return -1;
            }
            int take = Math.min(len, this.len - (int)p);
            MappedByteBuffer dup = this.map().duplicate();
            ((ByteBuffer)dup).position((int)p).limit((int)p + take);
            dup.put(src, off, take);
            return take;
        }

        @Override
        public byte get(long p) {
            return this.map().get((int)p);
        }

        @Override
        public void set(long p, byte b) {
            if (!this.writable) {
                throw new RuntimeException("FileChunk is read-only");
            }
            this.map().put((int)p, b);
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public Object clone() {
            return new FileChunk(this.ch, this.fileOffset, this.len, this.writable);
        }

        @Override
        public void close() {
            MappedByteBuffer local = this.mm;
            if (local != null) {
                try {
                    Unmapper.unmap(local);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static final class HeapChunk
    implements Chunk,
    Cloneable {
        final byte[] buf;

        HeapChunk(int cap) {
            assert (cap > 0 && cap <= 0x4000000) : "Invalid HeapChunk capacity: " + cap;
            this.buf = new byte[cap];
        }

        @Override
        public int read(long p, byte[] dst, int off, int len) {
            int pos = (int)p;
            int n = Math.min(len, this.buf.length - pos);
            if (n <= 0) {
                return -1;
            }
            System.arraycopy(this.buf, pos, dst, off, n);
            return n;
        }

        @Override
        public int write(long p, byte[] src, int off, int len) {
            int pos = (int)p;
            int n = Math.min(len, this.buf.length - pos);
            if (n <= 0) {
                return -1;
            }
            System.arraycopy(src, off, this.buf, pos, n);
            return n;
        }

        @Override
        public byte get(long p) {
            return this.buf[(int)p];
        }

        @Override
        public void set(long p, byte b) {
            this.buf[(int)p] = b;
        }

        @Override
        public int length() {
            return this.buf.length;
        }

        @Override
        public Object clone() {
            HeapChunk hc = new HeapChunk(this.buf.length);
            System.arraycopy(this.buf, 0, hc.buf, 0, this.buf.length);
            return hc;
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }

    private static final class CountingOutputStream
    extends OutputStream {
        long count = 0L;

        private CountingOutputStream() {
        }

        @Override
        public void write(int b) {
            ++this.count;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.count += (long)len;
        }
    }

    private static final class Unmapper {
        private Unmapper() {
        }

        static void unmap(MappedByteBuffer bb) throws Exception {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                Object unsafe = theUnsafe.get(null);
                unsafeClass.getMethod("invokeCleaner", MappedByteBuffer.class).invoke(unsafe, bb);
                return;
            }
            catch (Throwable unsafeClass) {
                Class<?> directBuffer = Class.forName("sun.nio.ch.DirectBuffer");
                Object db = directBuffer.cast(bb);
                Object cleaner = directBuffer.getMethod("cleaner", new Class[0]).invoke(db, new Object[0]);
                if (cleaner != null) {
                    cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                }
                return;
            }
        }
    }
}

