/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.geo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.geo.Locations;

public class OverarchingLocation
implements Locations {
    public static int MINIMUM_NAME_LENGTH = 4;
    private final Map<String, Locations> services = new HashMap<String, Locations>();

    public void activateLocation(String nickname, Locations service) {
        this.services.put(nickname, service);
    }

    public void deactivateLocalization(String nickname) {
        this.services.remove(nickname);
    }

    @Override
    public int size() {
        int locations = 0;
        for (Locations service : this.services.values()) {
            locations += service.size();
        }
        return locations;
    }

    @Override
    public boolean isEmpty() {
        for (Locations service : this.services.values()) {
            if (service.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TreeSet<GeoLocation> find(String anyname, boolean locationexact) {
        TreeSet<GeoLocation> locations = new TreeSet<GeoLocation>();
        for (Locations service : this.services.values()) {
            locations.addAll(service.find(anyname, locationexact));
        }
        return locations;
    }

    @Override
    public Set<String> locationNames() {
        HashSet<String> locations = new HashSet<String>();
        for (Locations service : this.services.values()) {
            locations.addAll(service.locationNames());
        }
        return locations;
    }

    @Override
    public Set<String> recommend(String s) {
        HashSet<String> recommendations = new HashSet<String>();
        if (s.isEmpty()) {
            return recommendations;
        }
        for (Locations service : this.services.values()) {
            recommendations.addAll(service.recommend(s));
        }
        return recommendations;
    }

    @Override
    public Set<StringBuilder> recommend(StringBuilder s) {
        HashSet<StringBuilder> recommendations = new HashSet<StringBuilder>();
        if (s.length() == 0) {
            return recommendations;
        }
        for (Locations service : this.services.values()) {
            recommendations.addAll(service.recommend(s));
        }
        return recommendations;
    }

    @Override
    public String nickname() {
        return "oa";
    }

    @Override
    public int hashCode() {
        return this.nickname().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Locations)) {
            return false;
        }
        return this.nickname().equals(((Locations)other).nickname());
    }
}

