/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.yacy;

public enum CacheStrategy {
    NOCACHE(0),
    IFFRESH(1),
    IFEXIST(2),
    CACHEONLY(3),
    NIFTY(4);

    public int code;

    private CacheStrategy(int code) {
        this.code = code;
    }

    public String toString() {
        return Integer.toString(this.code);
    }

    public static CacheStrategy decode(int code) {
        for (CacheStrategy strategy : CacheStrategy.values()) {
            if (strategy.code != code) continue;
            return strategy;
        }
        return NOCACHE;
    }

    public static CacheStrategy parse(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.equals("nocache")) {
            return NOCACHE;
        }
        if (name.equals("iffresh")) {
            return IFFRESH;
        }
        if (name.equals("ifexist")) {
            return IFEXIST;
        }
        if (name.equals("cacheonly")) {
            return CACHEONLY;
        }
        if (name.equals("nifty")) {
            return NIFTY;
        }
        if (name.equals("true")) {
            return IFEXIST;
        }
        if (name.equals("false")) {
            return null;
        }
        return null;
    }

    public String toName() {
        return this.name().toLowerCase();
    }

    public boolean isAllowedToFetchOnline() {
        return this.code < 3;
    }

    public boolean mustBeOffline() {
        return this.code == 3;
    }
}

