/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import net.yacy.cora.lod.vocabulary.DublinCore;
import net.yacy.cora.util.CommonPattern;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;

public class HTMLResponseWriter
implements QueryResponseWriter,
SolrjResponseWriter {
    public static final Pattern dqp = Pattern.compile("\"");

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "text/html";
    }

    public void init(NamedList n) {
    }

    private void writeJSLicence(Writer writer) throws IOException {
        writer.write("<script>");
        writer.write("/*");
        writer.write("@licstart  The following is the entire license notice for the");
        writer.write("JavaScript code in this page.");
        writer.write("");
        writer.write("Copyright (C) 2013-2015 by Michael Peter Christen and reger");
        writer.write("");
        writer.write("The JavaScript code in this page is free software: you can redistribute it and/or");
        writer.write("modify it under the terms of the GNU General Public License");
        writer.write("as published by the Free Software Foundation; either version 2");
        writer.write("of the License, or (at your option) any later version.");
        writer.write("");
        writer.write("This program is distributed in the hope that it will be useful,");
        writer.write("but WITHOUT ANY WARRANTY; without even the implied warranty of");
        writer.write("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        writer.write("GNU General Public License for more details.");
        writer.write("");
        writer.write("You should have received a copy of the GNU General Public License");
        writer.write("along with this program; if not, write to the Free Software");
        writer.write("Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.");
        writer.write("");
        writer.write("@licend  The above is the entire license notice");
        writer.write("for the JavaScript code in this page.");
        writer.write("*/");
        writer.write("</script>");
    }

    private void writeApiLink(Writer writer, SolrParams solrParams, String coreName) throws IOException {
        NamedList paramsList = solrParams.toNamedList();
        paramsList.remove("wt");
        String xmlquery = dqp.matcher("select?" + SolrParams.toSolrParams((NamedList)paramsList).toString() + "&core=" + coreName).replaceAll("%22");
        writer.write("<div id=\"api\"><a href=\"" + xmlquery + "\"><img src=\"../env/grafics/api.png\" width=\"60\" height=\"40\" alt=\"API\" /></a>\n");
        writer.write("<span>This search result can also be retrieved as XML. Click the API icon to see this page as XML.</span></div>\n");
    }

    private void writeResponseHeader(Writer writer, SolrQueryRequest request, NamedList<Object> responseHeader) throws IOException {
        if (responseHeader != null && request.getParams() == null || !request.getParams().getBool("omitHeader", false)) {
            writer.write("<form name=\"responseHeaders\" method=\"get\" action=\"select\" enctype=\"multipart/form-data\" accept-charset=\"UTF-8\" class=\"form-horizontal\">\n");
            writer.write("<fieldset>\n");
            writer.write("<h1>Response header</h1>\n");
            this.writeNamedList(writer, responseHeader, 0);
            writer.write("<div class=\"col-sm-offset-2\">");
            writer.write("<input class=\"btn btn-primary\" type=\"submit\">");
            writer.write("</div>");
            writer.write("</fieldset>\n");
            writer.write("</form>\n");
        }
    }

    private void writeNamedList(Writer writer, NamedList<?> list2, int nestingLevel) throws IOException {
        if (list2 != null && list2.size() > 0) {
            writer.write("<dl>\n");
            for (Map.Entry entry2 : list2) {
                String key = (String)entry2.getKey();
                Object value = entry2.getValue();
                writer.write("<dt>");
                writer.write(key);
                writer.write("</dt>\n<dd>");
                if (value instanceof NamedList) {
                    if (nestingLevel < 5) {
                        if ("params".equals(key) && nestingLevel == 0) {
                            this.writeEditableNamedList(writer, (NamedList)value, nestingLevel + 1);
                        } else {
                            this.writeNamedList(writer, (NamedList)value, nestingLevel + 1);
                        }
                    }
                } else if (value instanceof Iterable) {
                    this.writeIterable(writer, key, (Iterable)value);
                } else if (value instanceof Object[]) {
                    this.writeIterable(writer, key, Arrays.asList((Object[])value));
                } else {
                    writer.write(CharacterCoding.unicode2html(String.valueOf(value), true));
                }
                writer.write("</dd>\n");
            }
            writer.write("</dl>\n");
        }
    }

    private void writeEditableNamedList(Writer writer, NamedList<?> list2, int nestingLevel) throws IOException {
        if (list2 != null && list2.size() > 0) {
            writer.write("<fieldset>\n");
            for (Map.Entry entry2 : list2) {
                String key = (String)entry2.getKey();
                Object value = entry2.getValue();
                if (value instanceof NamedList) {
                    if (nestingLevel >= 5) continue;
                    this.writeEditableNamedList(writer, (NamedList)value, nestingLevel + 1);
                    continue;
                }
                if (value instanceof Iterable) {
                    this.writeEditableIterable(writer, key, (Iterable)value);
                    continue;
                }
                if (value instanceof Object[]) {
                    this.writeEditableIterable(writer, key, Arrays.asList((Object[])value));
                    continue;
                }
                this.writeEditableValue(writer, key, key, key, value);
            }
            writer.write("</fieldset>\n");
        }
    }

    private void writeEditableValue(Writer writer, String inputLabel, String inputId, String inputName, Object value) throws IOException {
        writer.write("<div class=\"form-group\">\n");
        writer.write("<label for=\"" + inputId + "\" class=\"col-sm-2 control-label\">");
        writer.write(inputLabel);
        writer.write("</label>\n");
        writer.write("<div class=\"col-sm-10\">\n");
        writer.write("<input type=\"text\" class=\"form-control\" id=\"" + inputId + "\" name=\"" + inputName + "\" value=\"");
        writer.write(CharacterCoding.unicode2html(String.valueOf(value), true));
        writer.write("\"/>\n");
        writer.write("</div></div>\n");
    }

    private void writeIterable(Writer writer, String key, Iterable<?> values) throws IOException {
        int count = 0;
        for (Object value : values) {
            writer.write("<dt>");
            writer.write(key);
            writer.write("_");
            writer.write(Integer.toString(count));
            writer.write("</dt>\n<dd>");
            writer.write(CharacterCoding.unicode2html(String.valueOf(value), true));
            ++count;
            writer.write("</dd>\n");
        }
    }

    private void writeEditableIterable(Writer writer, String key, Iterable<?> values) throws IOException {
        int count = 0;
        for (Object value : values) {
            this.writeEditableValue(writer, key + "_" + Integer.toString(count), key + "_" + Integer.toString(count), key, value);
            ++count;
        }
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        this.writeHtmlHead(writer, request);
        String coreName = request.getCore().getName();
        Object responseObj = rsp.getResponse();
        if (responseObj instanceof SolrDocumentList) {
            SolrDocumentList docList = (SolrDocumentList)responseObj;
            this.writeSolrDocumentList(writer, request, (NamedList<Object>)rsp.getResponseHeader(), coreName, docList);
        } else if (responseObj instanceof ResultContext) {
            DocList documents = ((ResultContext)responseObj).getDocList();
            String rootPath = this.getRootPath(request);
            int sz = documents.size();
            if (sz > 0) {
                SolrIndexSearcher searcher = request.getSearcher();
                DocIterator iterator = documents.iterator();
                IndexSchema schema2 = request.getSchema();
                int id = iterator.nextDoc();
                Document doc = searcher.doc(id);
                LinkedHashMap<String, String> tdoc = HTMLResponseWriter.translateDoc(schema2, doc, rsp.getReturnFields());
                String title = doc.get(CollectionSchema.title.getSolrFieldName());
                this.writeTitle(writer, coreName, sz, title);
                this.writeResponseHeader(writer, request, (NamedList<Object>)rsp.getResponseHeader());
                this.writeApiLink(writer, request.getOriginalParams(), coreName);
                HTMLResponseWriter.writeDoc(writer, tdoc, coreName, rsp.getReturnFields(), rootPath);
                while (iterator.hasNext()) {
                    id = iterator.nextDoc();
                    doc = searcher.doc(id);
                    tdoc = HTMLResponseWriter.translateDoc(schema2, doc, rsp.getReturnFields());
                    HTMLResponseWriter.writeDoc(writer, tdoc, coreName, rsp.getReturnFields(), rootPath);
                }
            } else {
                writer.write("<title>No Document Found</title>\n</head><body>\n");
                this.writeResponseHeader(writer, request, (NamedList<Object>)rsp.getResponseHeader());
                writer.write("<div class='alert alert-info'>No documents found</div>\n");
            }
        } else {
            writer.write("<title>Unable to process Solr response</title>\n</head><body>\n");
            this.writeResponseHeader(writer, request, (NamedList<Object>)rsp.getResponseHeader());
            writer.write("<div class='alert alert-info'>Unknown Solr response format</div>\n");
        }
        writer.write("</body></html>\n");
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, String coreName, QueryResponse rsp) throws IOException {
        this.writeHtmlHead(writer, request);
        SolrDocumentList docsList = rsp.getResults();
        NamedList responseHeader = rsp.getHeader();
        this.writeSolrDocumentList(writer, request, (NamedList<Object>)responseHeader, coreName, docsList);
        writer.write("</body></html>\n");
    }

    private void writeSolrDocumentList(Writer writer, SolrQueryRequest request, NamedList<Object> responseHeader, String coreName, SolrDocumentList docList) throws IOException {
        int sz = docList.size();
        String rootPath = this.getRootPath(request);
        if (sz > 0) {
            Iterator iterator = docList.iterator();
            SolrDocument doc = (SolrDocument)iterator.next();
            SolrReturnFields fieldsToReturn = request != null ? new SolrReturnFields(request) : new SolrReturnFields();
            Object titleValue = doc.getFirstValue(CollectionSchema.title.getSolrFieldName());
            String firstDocTitle = HTMLResponseWriter.formatValue(titleValue);
            this.writeTitle(writer, coreName, sz, firstDocTitle);
            this.writeResponseHeader(writer, request, responseHeader);
            this.writeApiLink(writer, request.getOriginalParams(), coreName);
            HTMLResponseWriter.writeDoc(writer, HTMLResponseWriter.translateDoc(doc, (ReturnFields)fieldsToReturn), coreName, (ReturnFields)fieldsToReturn, rootPath);
            while (iterator.hasNext()) {
                doc = (SolrDocument)iterator.next();
                HTMLResponseWriter.writeDoc(writer, HTMLResponseWriter.translateDoc(doc, (ReturnFields)fieldsToReturn), coreName, (ReturnFields)fieldsToReturn, rootPath);
            }
        } else {
            writer.write("<title>No Document Found</title>\n</head><body>\n");
            writer.write("<div class='alert alert-info'>No documents found</div>\n");
        }
    }

    private void writeTitle(Writer writer, String coreName, int responseSize, String firstDocTitle) throws IOException {
        if ("collection1".equals(coreName)) {
            if (responseSize == 1) {
                writer.write("<title>");
                writer.write(firstDocTitle == null ? "" : firstDocTitle);
                writer.write("</title>\n</head><body>\n");
            } else {
                writer.write("<title>Documents List</title>\n</head><body>\n");
            }
        } else if ("webgraph".equals(coreName)) {
            writer.write("<title>Links list</title>\n</head><body>\n");
        } else {
            writer.write("<title>Solr documents List</title>\n</head><body>\n");
        }
    }

    private void writeHtmlHead(Writer writer, SolrQueryRequest request) throws IOException {
        String rootPath = this.getRootPath(request);
        writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
        writer.write("<html xmlns=\"http://www.w3.org/1999/xhtml\"\n");
        writer.write("      xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        writer.write("      xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n");
        writer.write("      xmlns:foaf=\"http://xmlns.com/foaf/0.1/\">\n");
        writer.write("<head profile=\"http://www.w3.org/2003/g/data-view\">\n");
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n");
        this.writeJSLicence(writer);
        writer.write("<!-- Bootstrap core CSS -->\n");
        writer.write("<link href=\"" + rootPath + "env/bootstrap/css/bootstrap.min.css\" rel=\"stylesheet\">\n");
        writer.write("<link href=\"" + rootPath + "env/bootstrap/css/bootstrap-switch.min.css\" rel=\"stylesheet\">\n");
        writer.write("<!-- Custom styles for this template, i.e. navigation (move this to base.css) -->\n");
        writer.write("<link href=\"" + rootPath + "env/bootstrap-base.css\" rel=\"stylesheet\">\n");
        writer.write("<!-- old css styles -->\n");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"" + rootPath + "env/base.css\" />\n");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + rootPath + "env/style.css\" />\n");
        writer.write("<!--[if lt IE 6]>\n");
        writer.write(" <link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + rootPath + "env/oldie.css\" />\n");
        writer.write("<![endif]-->\n");
        writer.write("<!--[if lte IE 6.0]>\n");
        writer.write(" <link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + rootPath + "env/ie6.css\" />\n");
        writer.write("<![endif]-->\n");
        writer.write("<!--[if lte IE 7.0]>\n");
        writer.write(" <link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + rootPath + "env/ie7.css\" />\n");
        writer.write("<![endif]-->\n");
        writer.write("<!-- (C), Architecture: Michael Peter Christen; Contact: mc <at> yacy.net -->\n");
    }

    private String getRootPath(SolrQueryRequest request) {
        String[] pathParts;
        String servletRequestUri;
        Object requestUriObj;
        String rootPath = "/";
        Map context = request.getContext();
        if (context != null && (requestUriObj = context.get("requestURI")) instanceof String && (servletRequestUri = (String)requestUriObj).startsWith("/") && (pathParts = CommonPattern.SLASH.split(servletRequestUri = servletRequestUri.substring(1))).length > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < pathParts.length; ++i) {
                sb.append("../");
            }
            rootPath = sb.toString();
        }
        return rootPath;
    }

    private static final void writeDoc(Writer writer, LinkedHashMap<String, String> tdoc, String coreName, ReturnFields returnFields, String rootPath) throws IOException {
        String title;
        if ("collection1".equals(coreName)) {
            title = tdoc.get(CollectionSchema.title.getSolrFieldName());
            if (title == null) {
                title = "";
            }
        } else {
            title = "";
        }
        writer.write("<form name=\"yacydoc" + title + "\" method=\"post\" action=\"#\" enctype=\"multipart/form-data\" accept-charset=\"UTF-8\">\n");
        writer.write("<fieldset>\n");
        if ("collection1".equals(coreName)) {
            String sku = tdoc.get(CollectionSchema.sku.getSolrFieldName());
            if (sku != null) {
                String jsc = "javascript:w = window.open('" + rootPath + "QuickCrawlLink_p.html?indexText=on&indexMedia=on&crawlingQ=on&followFrames=on&obeyHtmlRobotsNoindex=on&obeyHtmlRobotsNofollow=off&xdstopw=on&title=" + URLEncoder.encode(title, StandardCharsets.UTF_8.name()) + "&url='+escape('" + sku + "'),'_blank','height=250,width=600,resizable=yes,scrollbar=no,directory=no,menubar=no,location=no');w.focus();";
                writer.write("<div class='btn btn-default btn-sm' style='float:right' onclick=\"" + jsc + "\">re-crawl url</div>\n");
            }
            writer.write("<h1 property=\"" + DublinCore.Title.getURIref() + "\">" + title + "</h1>\n");
        }
        writer.write("<dl>\n");
        Map fieldRenamings = returnFields == null ? Collections.emptyMap() : returnFields.getFieldRenames();
        for (Map.Entry<String, String> entry2 : tdoc.entrySet()) {
            if (returnFields != null && !returnFields.wantsField(entry2.getKey())) continue;
            writer.write("<dt>");
            writer.write(fieldRenamings.getOrDefault(entry2.getKey(), entry2.getKey()));
            writer.write("</dt><dd>");
            if (entry2.getKey().equals("sku")) {
                writer.write("<a href=\"" + entry2.getValue() + "\">" + entry2.getValue() + "</a>");
            } else {
                XML.escapeAttributeValue((String)entry2.getValue(), (Writer)writer);
            }
            writer.write("</dd>\n");
        }
        writer.write("</dl>\n");
        writer.write("</fieldset>\n");
        writer.write("</form>\n");
    }

    private static final LinkedHashMap<String, String> translateDoc(IndexSchema schema2, Document doc, ReturnFields returnFields) {
        List fields = doc.getFields();
        int sz = fields.size();
        int fidx1 = 0;
        int fidx2 = 0;
        LinkedHashMap<String, String> kv = new LinkedHashMap<String, String>();
        while (fidx1 < sz) {
            IndexableField value = (IndexableField)fields.get(fidx1);
            String fieldName = value.name();
            for (fidx2 = fidx1 + 1; fidx2 < sz && fieldName.equals(((IndexableField)fields.get(fidx2)).name()); ++fidx2) {
            }
            if (returnFields == null || returnFields.wantsField(fieldName)) {
                SchemaField sf = schema2.getFieldOrNull(fieldName);
                if (sf == null) {
                    sf = new SchemaField(fieldName, (FieldType)new TextField());
                }
                FieldType type = sf.getType();
                if (fidx1 + 1 == fidx2) {
                    if (sf.multiValued()) {
                        String sv = value.stringValue();
                        kv.put(fieldName, HTMLResponseWriter.field2string(type, sv));
                    } else {
                        kv.put(fieldName, HTMLResponseWriter.field2string(type, value.stringValue()));
                    }
                } else {
                    int c = 0;
                    for (int i = fidx1; i < fidx2; ++i) {
                        String sv = ((IndexableField)fields.get(i)).stringValue();
                        kv.put(fieldName + "_" + c++, HTMLResponseWriter.field2string(type, sv));
                    }
                }
            }
            fidx1 = fidx2;
        }
        return kv;
    }

    public static final LinkedHashMap<String, String> translateDoc(SolrDocument doc, ReturnFields returnFields) {
        LinkedHashMap<String, String> kv = new LinkedHashMap<String, String>();
        for (Map.Entry entry2 : doc) {
            String fieldName = (String)entry2.getKey();
            if (returnFields != null && !returnFields.wantsField(fieldName)) continue;
            Object value = entry2.getValue();
            if (value instanceof Collection) {
                Object singleValue;
                Collection values = (Collection)value;
                if (values.size() > 1) {
                    int c = 0;
                    for (Object singleValue2 : values) {
                        if (singleValue2 == null) continue;
                        kv.put(fieldName + "_" + c++, HTMLResponseWriter.formatValue(singleValue2));
                    }
                    continue;
                }
                if (values.size() != 1 || (singleValue = values.iterator().next()) == null) continue;
                kv.put(fieldName, HTMLResponseWriter.formatValue(singleValue));
                continue;
            }
            if (value == null) continue;
            kv.put(fieldName, HTMLResponseWriter.formatValue(value));
        }
        return kv;
    }

    public static final LinkedHashMap<String, String> translateDoc(IndexSchema schema2, Document doc) {
        return HTMLResponseWriter.translateDoc(schema2, doc, null);
    }

    private static String formatValue(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toInstant().toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private static String field2string(FieldType type, String value) {
        String typeName = type.getTypeName();
        if (SolrType.bool.printName().equals(typeName)) {
            return "F".equals(value) ? "false" : "true";
        }
        if (SolrType.date.printName().equals(typeName)) {
            return new Date(Long.parseLong(value)).toInstant().toString();
        }
        return value;
    }
}

