/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.schema.CollectionSchema;

public class Ranking {
    private static float quantRate = 0.5f;
    private static int minTokenLen = 3;
    private Map<SchemaDeclaration, Float> fieldBoosts = new LinkedHashMap<SchemaDeclaration, Float>();
    private String name = "";
    private String filterQuery = "";
    private String boostQuery = "";
    private String boostFunction = "";
    private String queryFields = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void putFieldBoost(SchemaDeclaration schema2, float boost) {
        this.fieldBoosts.put(schema2, Float.valueOf(boost));
    }

    public Float getFieldBoost(SchemaDeclaration schema2) {
        return this.fieldBoosts.get(schema2);
    }

    public Set<Map.Entry<SchemaDeclaration, Float>> getBoostMap() {
        return this.fieldBoosts.entrySet();
    }

    public String getQueryFields() {
        if (this.queryFields != null) {
            return this.queryFields;
        }
        StringBuilder qf = new StringBuilder(80);
        for (Map.Entry<SchemaDeclaration, Float> entry2 : this.fieldBoosts.entrySet()) {
            SchemaDeclaration field = entry2.getKey();
            if (field.getType() == SolrType.num_integer || field.getType() == SolrType.num_long || field.getType() == SolrType.num_float || field.getType() == SolrType.num_double || field.getType() == SolrType.bool) continue;
            qf.append(field.getSolrFieldName());
            Float boost = entry2.getValue();
            if (boost != null) {
                qf.append('^').append(boost.toString()).append(' ');
                continue;
            }
            qf.append(' ');
        }
        if (!this.fieldBoosts.containsKey(CollectionSchema.title)) {
            qf.append(CollectionSchema.title.getSolrFieldName()).append(' ');
        }
        if (!this.fieldBoosts.containsKey(CollectionSchema.text_t)) {
            qf.append(CollectionSchema.text_t.getSolrFieldName()).append(' ');
        }
        if (!this.fieldBoosts.containsKey(CollectionSchema.description_txt)) {
            qf.append(CollectionSchema.description_txt.getSolrFieldName()).append(' ');
        }
        if (!this.fieldBoosts.containsKey(CollectionSchema.keywords)) {
            qf.append(CollectionSchema.keywords.getSolrFieldName());
        }
        this.queryFields = qf.toString().trim();
        return this.queryFields;
    }

    public void updateBoosts(String boostDef) {
        if (boostDef == null || boostDef.length() == 0) {
            return;
        }
        String[] bf = CommonPattern.COMMA.split(boostDef);
        this.queryFields = null;
        this.fieldBoosts.clear();
        for (String boost : bf) {
            int p = boost.indexOf(94);
            if (p < 0) continue;
            String boostkey = boost.substring(0, p);
            try {
                CollectionSchema field = CollectionSchema.valueOf(boostkey);
                Float factor = Float.valueOf(Float.parseFloat(boost.substring(p + 1)));
                this.fieldBoosts.put(field, factor);
            }
            catch (IllegalArgumentException e) {
                ConcurrentLog.warn("Ranking", "unknwon boost key '" + boostkey + "'");
            }
        }
    }

    public void setFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
    }

    public String getFilterQuery() {
        return this.filterQuery;
    }

    public void setBoostQuery(String boostQuery) {
        this.boostQuery = boostQuery;
    }

    public String getBoostQuery() {
        return this.boostQuery;
    }

    public void setBoostFunction(String boostFunction) {
        this.boostFunction = boostFunction;
    }

    public String getBoostFunction() {
        return this.boostFunction;
    }

    public static void setQuantRate(float newquantRate) {
        quantRate = newquantRate;
    }

    public static void setMinTokenLen(int newminTokenLen) {
        minTokenLen = newminTokenLen;
    }

    public static float getQuantRate() {
        return quantRate;
    }

    public static int getMinTokenLen() {
        return minTokenLen;
    }
}

