/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.StringBuilderComparator;

public class WordCache {
    private static final ConcurrentLog log = new ConcurrentLog(WordCache.class.getName());
    private static final int commonWordsMaxSize = 20000;
    private static final int commonWordsMinLength = 5;
    private static OrderedScoreMap<StringBuilder> commonWords = new OrderedScoreMap<StringBuilder>(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
    private final File dictionaryPath;
    final Map<String, Dictionary> dictionaries;

    public Map<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    public WordCache(File dictionaryPath) {
        this.dictionaryPath = dictionaryPath;
        this.dictionaries = new ConcurrentHashMap<String, Dictionary>();
        this.reload();
    }

    public static void learn(StringBuilder word) {
        if (word == null) {
            return;
        }
        if (word.length() < 5) {
            return;
        }
        commonWords.inc(word);
        if (!commonWords.sizeSmaller(20000)) {
            commonWords.shrinkToMaxSize(10000);
        }
    }

    public static void learn(Collection<String> wordset) {
        for (String s : wordset) {
            WordCache.learn(new StringBuilder(s));
        }
    }

    public void reload() {
        String[] files;
        if (this.dictionaryPath == null || !this.dictionaryPath.exists()) {
            return;
        }
        for (String f : files = this.dictionaryPath.list()) {
            if (!f.endsWith(".words")) continue;
            try {
                Dictionary dict = new Dictionary(new File(this.dictionaryPath, f));
                this.dictionaries.put(f.substring(0, f.length() - 6), dict);
            }
            catch (IOException e) {
                log.warn(e);
            }
        }
    }

    private static StringBuilder reverse(StringBuilder s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            sb.append(s.charAt(i));
        }
        return sb;
    }

    public Set<StringBuilder> recommend(StringBuilder string) {
        HashSet<StringBuilder> ret = new HashSet<StringBuilder>();
        for (Dictionary dict : this.dictionaries.values()) {
            ret.addAll(dict.recommend(string));
        }
        SortedMap<StringBuilder, AtomicInteger> u = commonWords.tailMap(string);
        try {
            Map.Entry<StringBuilder, AtomicInteger> v;
            StringBuilder vv;
            Iterator<Map.Entry<StringBuilder, AtomicInteger>> iterator = u.entrySet().iterator();
            while (iterator.hasNext() && StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(vv = (v = iterator.next()).getKey(), string) && vv.length() > string.length()) {
                ret.add(vv);
            }
        }
        catch (ConcurrentModificationException e) {
            ConcurrentLog.logException(e);
        }
        return ret;
    }

    public boolean contains(StringBuilder s) {
        for (Dictionary dict : this.dictionaries.values()) {
            if (!dict.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(StringBuilder string) {
        for (Dictionary dict : this.dictionaries.values()) {
            if (!dict.supports(string)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        for (Dictionary dict : this.dictionaries.values()) {
            size += dict.size();
        }
        return size;
    }

    public static int sizeCommonWords() {
        return commonWords.size();
    }

    public static void clearCommonWords() {
        commonWords.clear();
    }

    public boolean isRelevant(int minimumWords) {
        for (Dictionary dict : this.dictionaries.values()) {
            if (!dict.isRelevant(minimumWords)) continue;
            return true;
        }
        return false;
    }

    public static class Dictionary {
        private final TreeSet<StringBuilder> dict = new TreeSet<StringBuilder>(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
        private final TreeSet<StringBuilder> tcid = new TreeSet<StringBuilder>(StringBuilderComparator.CASE_INSENSITIVE_ORDER);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dictionary(File file) throws IOException {
            InputStream is = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String l;
                while ((l = reader.readLine()) != null) {
                    if (l.isEmpty() || l.charAt(0) == '#' || (l = l.trim().toLowerCase()).length() < 4) continue;
                    StringBuilder sb = new StringBuilder(l);
                    this.dict.add(sb);
                    this.tcid.add(WordCache.reverse(sb));
                }
            }
        }

        public Set<StringBuilder> recommend(StringBuilder string) {
            StringBuilder r;
            HashSet<StringBuilder> ret = new HashSet<StringBuilder>();
            SortedSet<StringBuilder> t = this.dict.tailSet(string);
            Iterator iterator = t.iterator();
            while (iterator.hasNext() && StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(r = (StringBuilder)iterator.next(), string) && r.length() > string.length()) {
                ret.add(r);
            }
            string = WordCache.reverse(string);
            t = this.tcid.tailSet(string);
            iterator = t.iterator();
            while (iterator.hasNext() && StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(r = (StringBuilder)iterator.next(), string) && r.length() > string.length()) {
                ret.add(WordCache.reverse(r));
            }
            return ret;
        }

        public boolean contains(StringBuilder s) {
            return this.dict.contains(s);
        }

        public boolean supports(StringBuilder string) {
            StringBuilder r;
            SortedSet<StringBuilder> t = this.dict.tailSet(string);
            Iterator iterator = t.iterator();
            if (iterator.hasNext() && StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(string, r = (StringBuilder)iterator.next())) {
                return true;
            }
            t = this.tcid.tailSet(string = WordCache.reverse(string));
            iterator = t.iterator();
            return iterator.hasNext() && StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(string, r = (StringBuilder)iterator.next());
        }

        public int size() {
            return this.dict.size();
        }

        public boolean isRelevant(int minimumWords) {
            return this.dict.size() >= minimumWords;
        }

        public Set<StringBuilder> getWords() {
            return this.dict;
        }
    }
}

