/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Tensor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.yacy.ai.llama3.Model.GGMLType;
import net.yacy.ai.llama3.Tensor.FloatTensor;

public final class BF16FloatTensor
extends FloatTensor {
    final int size;
    final ByteBuffer buffer;

    public BF16FloatTensor(int size, ByteBuffer buffer) {
        if (buffer.remaining() < size * 2) {
            throw new IllegalArgumentException("Buffer too small");
        }
        this.size = size;
        this.buffer = buffer.duplicate().order(ByteOrder.nativeOrder());
    }

    public BF16FloatTensor(float[] values) {
        this.size = values.length;
        this.buffer = ByteBuffer.allocateDirect(this.size * 2).order(ByteOrder.nativeOrder());
        for (int i = 0; i < this.size; ++i) {
            this.setFloat(i, values[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public GGMLType type() {
        return GGMLType.BF16;
    }

    @Override
    public final void setFloat(int index2, float value) {
        assert (0 <= index2 && index2 < this.size);
        int hBits = Float.floatToIntBits(value) >>> 16;
        this.buffer.putShort(index2 * 2, (short)hBits);
    }

    @Override
    public final float getFloat(int index2) {
        assert (0 <= index2 && index2 < this.size);
        return Float.intBitsToFloat(this.buffer.getShort(index2 * 2) << 16);
    }
}

