/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Vocabulary {
    private final String[] tokens;
    private final float[] scores;
    private final Map<String, Integer> tokenToIndex;

    public Vocabulary(String[] tokens, float[] scores, Map<String, Integer> tokenToIndex) {
        this.tokens = tokens == null ? null : Arrays.copyOf(tokens, tokens.length);
        this.scores = scores == null ? null : Arrays.copyOf(scores, scores.length);
        this.tokenToIndex = tokenToIndex == null ? null : new HashMap<String, Integer>(tokenToIndex);
    }

    public Vocabulary(String[] vocabulary, float[] scores) {
        this(vocabulary, scores, IntStream.range(0, vocabulary.length).boxed().collect(Collectors.toMap(i -> vocabulary[i], i -> i)));
    }

    public String[] tokens() {
        return Arrays.copyOf(this.tokens, this.tokens.length);
    }

    public String get(int tokenIndex) {
        return this.tokens[tokenIndex];
    }

    public OptionalInt getIndex(String token) {
        Integer value = this.tokenToIndex.get(token);
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    public int size() {
        return this.tokens.length;
    }
}

