/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMemoryBackend;

public class RrdMemoryBackendFactory
extends RrdBackendFactory {
    protected final Map<String, RrdMemoryBackend> backends = new ConcurrentHashMap<String, RrdMemoryBackend>();

    @Override
    protected RrdBackend open(String id, boolean readOnly) throws IOException {
        RrdMemoryBackend backend;
        if (this.backends.containsKey(id)) {
            backend = this.backends.get(id);
        } else {
            backend = new RrdMemoryBackend(id);
            this.backends.put(id, backend);
        }
        return backend;
    }

    @Override
    protected boolean exists(String id) {
        return this.backends.containsKey(id);
    }

    @Override
    protected boolean shouldValidateHeader(String path) throws IOException {
        return false;
    }

    public boolean delete(String id) {
        if (this.backends.containsKey(id)) {
            this.backends.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "MEMORY";
    }
}

