/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.StringValue;
import org.apache.solr.schema.FieldType;

class StringFieldWriter
extends FieldWriter {
    protected String field;
    private FieldType fieldType;
    private BytesRef lastRef;
    private int lastOrd = -1;
    private IntObjectHashMap<SortedDocValues> docValuesCache = new IntObjectHashMap();
    protected CharsRefBuilder cref = new CharsRefBuilder();
    final ByteArrayUtf8CharSequence utf8 = new ByteArrayUtf8CharSequence(new byte[0], 0, 0){

        public String toString() {
            String str = this.utf16;
            if (str != null) {
                return str;
            }
            StringFieldWriter.this.fieldType.indexedToReadable(new BytesRef(this.buf, this.offset, this.length), StringFieldWriter.this.cref);
            this.utf16 = str = StringFieldWriter.this.cref.toString();
            return str;
        }
    };

    public StringFieldWriter(String field, FieldType fieldType) {
        this.field = field;
        this.fieldType = fieldType;
    }

    @Override
    public boolean write(SortDoc sortDoc, LeafReaderContext readerContext, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        StringValue stringValue = (StringValue)sortDoc.getSortValue(this.field);
        BytesRef ref = null;
        if (stringValue != null) {
            if (stringValue.currentOrd == -1) {
                return false;
            }
            if (this.lastOrd == stringValue.currentOrd) {
                ref = this.lastRef;
            }
            this.lastOrd = stringValue.currentOrd;
        }
        if (ref == null) {
            SortedDocValues sortedDocValues;
            int readerOrd = readerContext.ord;
            SortedDocValues vals = null;
            if (this.docValuesCache.containsKey(readerOrd) && (sortedDocValues = (SortedDocValues)this.docValuesCache.get(readerOrd)).docID() < sortDoc.docId) {
                vals = sortedDocValues;
            }
            if (vals == null) {
                vals = DocValues.getSorted((LeafReader)readerContext.reader(), (String)this.field);
                this.docValuesCache.put(readerOrd, (Object)vals);
            }
            if (vals.advance(sortDoc.docId) != sortDoc.docId) {
                return false;
            }
            int ord = vals.ordValue();
            ref = vals.lookupOrd(ord);
            if (stringValue != null) {
                this.lastRef = ref.clone();
            }
        }
        this.writeBytes(ew, ref, this.fieldType);
        return true;
    }

    protected void writeBytes(MapWriter.EntryWriter ew, BytesRef ref, FieldType fieldType) throws IOException {
        if (ew instanceof JavaBinCodec.BinEntryWriter) {
            ew.put((CharSequence)this.field, (CharSequence)this.utf8.reset(ref.bytes, ref.offset, ref.length, null));
        } else {
            fieldType.indexedToReadable(ref, this.cref);
            ew.put((CharSequence)this.field, (CharSequence)this.cref.toString());
        }
    }
}

