/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class JDBCStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private static final HashSet<String> directSupportedTypes = new HashSet();
    private String driverClassName;
    private String connectionUrl;
    private String sqlQuery;
    private StreamComparator definedSort;
    private int fetchSize;
    private Connection connection;
    private Properties connectionProperties;
    private Statement statement;
    private ResultSetValueSelector[] valueSelectors;
    protected ResultSet resultSet;
    protected transient StreamContext streamContext;
    protected String sep = Character.toString('\u001f');

    public JDBCStream(String connectionUrl, String sqlQuery, StreamComparator definedSort) throws IOException {
        this(connectionUrl, sqlQuery, definedSort, null, null);
    }

    public JDBCStream(String connectionUrl, String sqlQuery, StreamComparator definedSort, Properties connectionProperties, String driverClassName) throws IOException {
        this.init(connectionUrl, sqlQuery, definedSort, connectionProperties, driverClassName, 5000);
    }

    public JDBCStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter connectionUrlExpression = factory.getNamedOperand(expression, "connection");
        StreamExpressionNamedParameter sqlQueryExpression = factory.getNamedOperand(expression, "sql");
        StreamExpressionNamedParameter definedSortExpression = factory.getNamedOperand(expression, "sort");
        StreamExpressionNamedParameter driverClassNameExpression = factory.getNamedOperand(expression, "driver");
        StreamExpressionNamedParameter fetchSizeExpression = factory.getNamedOperand(expression, "fetchSize");
        if (expression.getParameters().size() != namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        Properties connectionProperties = new Properties();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("driver") || namedParam.getName().equals("connection") || namedParam.getName().equals("sql") || namedParam.getName().equals("sort")) continue;
            connectionProperties.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        int fetchSize = 5000;
        if (null != fetchSizeExpression && fetchSizeExpression.getParameter() instanceof StreamExpressionValue) {
            String fetchSizeString = ((StreamExpressionValue)fetchSizeExpression.getParameter()).getValue();
            fetchSize = Integer.parseInt(fetchSizeString);
        }
        String connectionUrl = null;
        if (null != connectionUrlExpression && connectionUrlExpression.getParameter() instanceof StreamExpressionValue) {
            connectionUrl = ((StreamExpressionValue)connectionUrlExpression.getParameter()).getValue();
        }
        if (null == connectionUrl) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - connection not found", connectionUrlExpression));
        }
        String sqlQuery = null;
        if (null != sqlQueryExpression && sqlQueryExpression.getParameter() instanceof StreamExpressionValue) {
            sqlQuery = ((StreamExpressionValue)sqlQueryExpression.getParameter()).getValue();
        }
        if (null == sqlQuery) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - sql not found", sqlQueryExpression));
        }
        StreamComparator definedSort = null;
        if (null != definedSortExpression && definedSortExpression.getParameter() instanceof StreamExpressionValue) {
            definedSort = factory.constructComparator(((StreamExpressionValue)definedSortExpression.getParameter()).getValue(), FieldComparator.class);
        }
        if (null == definedSort) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - sort not found", definedSortExpression));
        }
        String driverClass = null;
        if (null != driverClassNameExpression && driverClassNameExpression.getParameter() instanceof StreamExpressionValue) {
            driverClass = ((StreamExpressionValue)driverClassNameExpression.getParameter()).getValue();
        }
        this.init(connectionUrl, sqlQuery, definedSort, connectionProperties, driverClass, fetchSize);
    }

    private void init(String connectionUrl, String sqlQuery, StreamComparator definedSort, Properties connectionProperties, String driverClassName, int fetchSize) {
        this.connectionUrl = connectionUrl;
        this.sqlQuery = sqlQuery;
        this.definedSort = definedSort;
        this.connectionProperties = connectionProperties;
        this.driverClassName = driverClassName;
        this.fetchSize = fetchSize;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    protected Driver getDriver() throws IOException {
        try {
            if (null != this.driverClassName) {
                Class.forName(this.driverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to load JDBC driver for '%s'", this.driverClassName), e);
        }
        try {
            Driver driver = DriverManager.getDriver(this.connectionUrl);
            if (null == driver) {
                throw new SQLException("DriverManager.getDriver(url) returned null");
            }
            return driver;
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to determine JDBC driver from connection url '%s'. Usually this means the driver is not loaded - you can have JDBCStream try to load it by providing the 'driverClassName' value", this.connectionUrl), e);
        }
    }

    @Override
    public void open() throws IOException {
        try {
            this.connection = this.getDriver().connect(this.connectionUrl, this.connectionProperties);
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to open JDBC connection to '%s'", this.connectionUrl), e);
        }
        try {
            this.statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to create a statement from JDBC connection '%s'", this.connectionUrl), e);
        }
        try {
            this.resultSet = this.statement.executeQuery(this.sqlQuery);
            this.resultSet.setFetchSize(this.fetchSize);
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to execute sqlQuery '%s' against JDBC connection '%s'.%nCaused by: %s", this.sqlQuery, this.connectionUrl, e.getMessage()), e);
        }
        try {
            this.valueSelectors = this.constructValueSelectors(this.resultSet.getMetaData());
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to generate value selectors for sqlQuery '%s' against JDBC connection '%s'", this.sqlQuery, this.connectionUrl), e);
        }
    }

    private ResultSetValueSelector[] constructValueSelectors(ResultSetMetaData metadata) throws SQLException {
        ResultSetValueSelector[] valueSelectors = new ResultSetValueSelector[metadata.getColumnCount()];
        for (int columnIdx = 0; columnIdx < metadata.getColumnCount(); ++columnIdx) {
            ResultSetValueSelector valueSelector = this.determineValueSelector(columnIdx, metadata);
            if (valueSelector == null) {
                int columnNumber = columnIdx + 1;
                String columnName = metadata.getColumnLabel(columnNumber);
                String className = metadata.getColumnClassName(columnNumber);
                String typeName = metadata.getColumnTypeName(columnNumber);
                throw new SQLException(String.format(Locale.ROOT, "Unable to determine the valueSelector for column '%s' (col #%d) of java class '%s' and type '%s'", columnName, columnNumber, className, typeName));
            }
            valueSelectors[columnIdx] = valueSelector;
        }
        return valueSelectors;
    }

    protected ResultSetValueSelector determineValueSelector(int columnIdx, ResultSetMetaData metadata) throws SQLException {
        final int columnNumber = columnIdx + 1;
        final String columnName = metadata.getColumnLabel(columnNumber);
        int jdbcType = metadata.getColumnType(columnNumber);
        String className = metadata.getColumnClassName(columnNumber);
        ResultSetValueSelector valueSelector = null;
        if (directSupportedTypes.contains(className)) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    String s;
                    Object obj = resultSet.getObject(columnNumber);
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    if (obj instanceof String && (s = (String)obj).indexOf(JDBCStream.this.sep) > -1) {
                        s = s.substring(1);
                        return s.split(JDBCStream.this.sep);
                    }
                    return obj;
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (Short.class.getName().equals(className)) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Short obj = resultSet.getShort(columnNumber);
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    return obj.longValue();
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (Integer.class.getName().equals(className)) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Integer obj = resultSet.getInt(columnNumber);
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    return obj.longValue();
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (Float.class.getName().equals(className)) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Float obj = Float.valueOf(resultSet.getFloat(columnNumber));
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    return obj.doubleValue();
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (jdbcType == 91) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Date sqlDate = resultSet.getDate(columnNumber);
                    return resultSet.wasNull() ? null : sqlDate.toString();
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (jdbcType == 92) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Time sqlTime = resultSet.getTime(columnNumber);
                    return resultSet.wasNull() ? null : sqlTime.toString();
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (jdbcType == 93) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Timestamp sqlTimestamp = resultSet.getTimestamp(columnNumber);
                    return resultSet.wasNull() ? null : sqlTimestamp.toInstant().toString();
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else if (Object.class.getName().equals(className)) {
            valueSelector = new ResultSetValueSelector(){

                @Override
                public Object selectValue(ResultSet resultSet) throws SQLException {
                    Object obj = resultSet.getObject(columnNumber);
                    return resultSet.wasNull() ? null : obj;
                }

                @Override
                public String getColumnName() {
                    return columnName;
                }
            };
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(className, false, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int scale = metadata.getScale(columnNumber);
            if (Number.class.isAssignableFrom(clazz)) {
                valueSelector = scale > 0 ? new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        BigDecimal bd = resultSet.getBigDecimal(columnNumber);
                        return resultSet.wasNull() ? null : Double.valueOf(bd.doubleValue());
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                } : new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        BigDecimal bd = resultSet.getBigDecimal(columnNumber);
                        return resultSet.wasNull() ? null : Long.valueOf(bd.longValue());
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                };
            } else if (Clob.class.isAssignableFrom(clazz)) {
                valueSelector = new ResultSetValueSelector(){

                    @Override
                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        int lengthInt;
                        Clob c = resultSet.getClob(columnNumber);
                        if (resultSet.wasNull()) {
                            return null;
                        }
                        long length = c.length();
                        if (length != (long)(lengthInt = (int)length)) {
                            throw new SQLException(String.format(Locale.ROOT, "Encountered a clob of length #%l in column '%s' (col #%d).  Max supported length is #%i.", length, columnName, columnNumber, Integer.MAX_VALUE));
                        }
                        return c.getSubString(1L, lengthInt);
                    }

                    @Override
                    public String getColumnName() {
                        return columnName;
                    }
                };
            }
        }
        return valueSelector;
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.resultSet) {
                this.resultSet.close();
            }
            if (null != this.statement && !this.statement.isClosed()) {
                this.statement.close();
            }
            if (null != this.connection && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException("Failed to properly close JDBCStream", e);
        }
    }

    @Override
    public Tuple read() throws IOException {
        try {
            Tuple tuple = new Tuple();
            if (this.resultSet.next()) {
                for (ResultSetValueSelector selector : this.valueSelectors) {
                    tuple.put(selector.getColumnName(), selector.selectValue(this.resultSet));
                }
            } else {
                tuple.put("EOF", true);
            }
            return tuple;
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "Failed to read next record with error '%s'", e.getMessage()), e);
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionNamedParameter("connection", this.connectionUrl));
        expression.addParameter(new StreamExpressionNamedParameter("sql", this.sqlQuery));
        expression.addParameter(new StreamExpressionNamedParameter("fetchSize", Integer.toString(this.fetchSize)));
        expression.addParameter(new StreamExpressionNamedParameter("sort", this.definedSort.toExpression(factory)));
        if (null != this.driverClassName) {
            expression.addParameter(new StreamExpressionNamedParameter("driver", this.driverClassName));
        }
        if (null != this.connectionProperties) {
            for (String propertyName : this.connectionProperties.stringPropertyNames()) {
                expression.addParameter(new StreamExpressionNamedParameter(propertyName, this.connectionProperties.getProperty(propertyName)));
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        StreamExpression expression = (StreamExpression)this.toExpression(factory);
        explanation.setExpression(expression.toString());
        String driverClassName = this.driverClassName;
        if (null == driverClassName) {
            try {
                driverClassName = DriverManager.getDriver(this.connectionUrl).getClass().getName();
            }
            catch (Exception e) {
                driverClassName = String.format(Locale.ROOT, "Failed to find driver for connectionUrl='%s'", this.connectionUrl);
            }
        }
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName("jdbc-source");
        child.setImplementingClass(driverClassName);
        child.setExpressionType("datastore");
        child.setExpression(this.sqlQuery);
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.definedSort;
    }

    static {
        directSupportedTypes.add(String.class.getName());
        directSupportedTypes.add(Double.class.getName());
        directSupportedTypes.add(Long.class.getName());
        directSupportedTypes.add(Boolean.class.getName());
    }

    public static interface ResultSetValueSelector {
        public String getColumnName();

        public Object selectValue(ResultSet var1) throws SQLException;
    }
}

