/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.logging.LoggerInfo;
import org.apache.solr.logging.jul.JulWatcher;
import org.apache.solr.logging.log4j2.Log4j2Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class LogWatcher<E> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected CircularList<E> history;
    protected long last = -1L;

    public abstract String getName();

    public abstract List<String> getAllLevels();

    public abstract void setLogLevel(String var1, String var2);

    public abstract Collection<LoggerInfo> getAllLoggers();

    public abstract void setThreshold(String var1);

    public abstract String getThreshold();

    public void add(E event, long timstamp) {
        this.history.add(event);
        this.last = timstamp;
    }

    public long getLastEvent() {
        return this.last;
    }

    public int getHistorySize() {
        return this.history == null ? -1 : this.history.getBufferSize();
    }

    public SolrDocumentList getHistory(long since, AtomicBoolean found) {
        if (this.history == null) {
            return null;
        }
        SolrDocumentList docs = new SolrDocumentList();
        for (E e : this.history) {
            long ts = this.getTimestamp(e);
            if (ts == since && found != null) {
                found.set(true);
            }
            if (ts <= since) continue;
            docs.add((Object)this.toSolrDocument(e));
        }
        docs.setNumFound((long)docs.size());
        return docs;
    }

    public abstract long getTimestamp(E var1);

    public abstract SolrDocument toSolrDocument(E var1);

    public abstract void registerListener(ListenerConfig var1);

    public void reset() {
        this.history.clear();
        this.last = -1L;
    }

    public static LogWatcher<?> newRegisteredLogWatcher(LogWatcherConfig config, SolrResourceLoader loader) {
        if (!config.isEnabled()) {
            log.debug("A LogWatcher is not enabled");
            return null;
        }
        LogWatcher<?> logWatcher = LogWatcher.createWatcher(config, loader);
        if (logWatcher != null && config.getWatcherSize() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Registering Log Listener [{}]", (Object)logWatcher.getName());
            }
            logWatcher.registerListener(config.asListenerConfig());
        }
        return logWatcher;
    }

    private static LogWatcher<?> createWatcher(LogWatcherConfig config, SolrResourceLoader loader) {
        String slf4jImpl;
        String fname = config.getLoggingClass();
        try {
            slf4jImpl = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
            log.debug("SLF4J impl is {}", (Object)slf4jImpl);
            if (fname == null) {
                if ("org.apache.logging.slf4j.Log4jLoggerFactory".equals(slf4jImpl)) {
                    fname = "Log4j2";
                } else if (slf4jImpl.indexOf("JDK") > 0) {
                    fname = "JUL";
                }
            }
        }
        catch (Throwable e) {
            log.warn("Unable to read SLF4J version.  LogWatcher will be disabled: ", e);
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            return null;
        }
        if (fname == null) {
            log.debug("No LogWatcher configured");
            return null;
        }
        if ("JUL".equalsIgnoreCase(fname)) {
            return new JulWatcher(slf4jImpl);
        }
        if ("Log4j2".equals(fname)) {
            return new Log4j2Watcher();
        }
        try {
            return loader != null ? loader.newInstance(fname, LogWatcher.class) : null;
        }
        catch (Throwable e) {
            log.warn("Unable to load LogWatcher {}: {}", (Object)fname, (Object)e);
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            return null;
        }
    }
}

