/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.ForceLeaderPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}/shards/{shard}", "/collections/{collection}/shards/{shard}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class ForceLeaderAPI {
    private static final String V2_FORCE_LEADER_CMD = "force-leader";
    private final CollectionsHandler collectionsHandler;

    public ForceLeaderAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="force-leader")
    public void forceLeader(PayloadObj<ForceLeaderPayload> obj) throws Exception {
        HashMap addedV1Params = Maps.newHashMap();
        Map<String, String> pathParams = obj.getRequest().getPathTemplateValues();
        addedV1Params.put("action", CollectionParams.CollectionAction.FORCELEADER.toLower());
        addedV1Params.put("collection", pathParams.get("collection"));
        addedV1Params.put("shard", pathParams.get("shard"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), addedV1Params), obj.getResponse());
    }
}

