/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.CreateShardPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}/shards", "/collections/{collection}/shards"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class CreateShardAPI {
    private static final String V2_CREATE_CMD = "create";
    private final CollectionsHandler collectionsHandler;

    public CreateShardAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="create")
    public void createShard(PayloadObj<CreateShardPayload> obj) throws Exception {
        CreateShardPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CollectionParams.CollectionAction.CREATESHARD.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        if (v2Body.nodeSet != null) {
            v1Params.put("createNodeSet", this.buildV1CreateNodeSetValue(v2Body.nodeSet));
        }
        if (MapUtils.isNotEmpty((Map)v2Body.coreProperties)) {
            V2ApiUtils.flattenMapWithPrefix(v2Body.coreProperties, v1Params, "property.");
        }
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    private String buildV1CreateNodeSetValue(List<String> nodeSet) {
        if (nodeSet.size() > 0) {
            return String.join((CharSequence)",", nodeSet);
        }
        return "EMPTY";
    }
}

