/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.util.StrUtils;

public class NodeRoles {
    public static final String NODE_ROLES_PROP = "solr.node.roles";
    public static final String DEFAULT_ROLES_STRING = "data:on,overseer:allowed";
    private Map<Role, String> nodeRoles;
    public static final String MODE_ON = "on";
    public static final String MODE_OFF = "off";
    public static final String MODE_ALLOWED = "allowed";
    public static final String MODE_PREFERRED = "preferred";
    public static final String MODE_DISALLOWED = "disallowed";

    public NodeRoles(String rolesString) {
        EnumMap<Role, String> roles = new EnumMap<Role, String>(Role.class);
        if (StringUtils.isEmpty((String)rolesString)) {
            rolesString = DEFAULT_ROLES_STRING;
        }
        List rolesList = StrUtils.splitSmart((String)rolesString, (char)',');
        for (String s : rolesList) {
            List roleMode = StrUtils.splitSmart((String)s, (char)':');
            Role r = Role.getRole((String)roleMode.get(0));
            String m = (String)roleMode.get(1);
            if (r.supportedModes().contains(m)) {
                roles.put(r, m);
                continue;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown role mode '" + (String)roleMode.get(1) + "' for role '" + r + "'");
        }
        for (Role r : Role.values()) {
            if (roles.containsKey((Object)r)) continue;
            roles.put(r, r.modeWhenRoleIsAbsent());
        }
        this.nodeRoles = Collections.unmodifiableMap(roles);
    }

    public Map<Role, String> getRoles() {
        return this.nodeRoles;
    }

    public String getRoleMode(Role role) {
        return this.nodeRoles.get((Object)role);
    }

    public boolean isOverseerAllowedOrPreferred() {
        String roleMode = this.nodeRoles.get((Object)Role.OVERSEER);
        return MODE_ALLOWED.equals(roleMode) || MODE_PREFERRED.equals(roleMode);
    }

    public static String getZNodeForRole(Role role) {
        return "/node_roles/" + role.roleName;
    }

    public static String getZNodeForRoleMode(Role role, String mode) {
        return "/node_roles/" + role.roleName + "/" + mode;
    }

    public static enum Role {
        DATA("data"){

            @Override
            public Set<String> supportedModes() {
                return Set.of(NodeRoles.MODE_ON, NodeRoles.MODE_OFF);
            }

            @Override
            public String modeWhenRoleIsAbsent() {
                return NodeRoles.MODE_OFF;
            }
        }
        ,
        OVERSEER("overseer"){

            @Override
            public Set<String> supportedModes() {
                return Set.of(NodeRoles.MODE_ALLOWED, NodeRoles.MODE_PREFERRED, NodeRoles.MODE_DISALLOWED);
            }

            @Override
            public String modeWhenRoleIsAbsent() {
                return NodeRoles.MODE_DISALLOWED;
            }
        };

        public final String roleName;

        private Role(String name) {
            this.roleName = name;
        }

        public static Role getRole(String value) {
            for (Role role : Role.values()) {
                if (!value.equals(role.roleName)) continue;
                return role;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown role: " + value);
        }

        public abstract Set<String> supportedModes();

        public abstract String modeWhenRoleIsAbsent();

        public String toString() {
            return this.roleName;
        }
    }
}

