/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockTree {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Node root = new Node(null, CollectionParams.LockLevel.CLUSTER, null);
    static final OverseerMessageHandler.Lock FREELOCK = () -> {};

    public Session getSession() {
        return new Session();
    }

    private class Node {
        final String name;
        final Node mom;
        final CollectionParams.LockLevel level;
        HashMap<String, Node> children = new HashMap();
        LockImpl myLock;

        Node(String name, CollectionParams.LockLevel level, Node mom) {
            this.name = name;
            this.level = level;
            this.mom = mom;
        }

        boolean isLocked() {
            if (this.myLock != null) {
                return true;
            }
            for (Node node : this.children.values()) {
                if (!node.isLocked()) continue;
                return true;
            }
            return false;
        }

        void unlock(LockImpl lockObject) {
            if (this.myLock == lockObject) {
                this.myLock = null;
            } else {
                log.info("Unlocked multiple times : {}", (Object)lockObject);
            }
        }

        OverseerMessageHandler.Lock lock(CollectionParams.LockLevel lockLevel, List<String> path) {
            if (this.myLock != null) {
                return null;
            }
            if (lockLevel == this.level) {
                if (this.isLocked()) {
                    return null;
                }
                this.myLock = new LockImpl(this);
                return this.myLock;
            }
            String childName = path.get(this.level.getHeight());
            Node child = this.children.get(childName);
            if (child == null) {
                child = new Node(childName, this.level.getChild(), this);
                this.children.put(childName, child);
            }
            return child.lock(lockLevel, path);
        }

        LinkedList<String> constructPath(LinkedList<String> collect) {
            if (this.name != null) {
                collect.addFirst(this.name);
            }
            if (this.mom != null) {
                this.mom.constructPath(collect);
            }
            return collect;
        }
    }

    private static class SessionNode {
        final CollectionParams.LockLevel level;
        Map<String, SessionNode> kids;
        boolean busy = false;

        SessionNode(CollectionParams.LockLevel level) {
            this.level = level;
        }

        void markBusy(CollectionParams.LockLevel lockLevel, List<String> path) {
            if (this.level == lockLevel) {
                this.busy = true;
            } else {
                SessionNode child;
                String s = path.get(this.level.getHeight());
                if (this.kids == null) {
                    this.kids = new HashMap<String, SessionNode>();
                }
                if ((child = this.kids.get(s)) == null) {
                    child = new SessionNode(this.level.getChild());
                    this.kids.put(s, child);
                }
                child.markBusy(lockLevel, path);
            }
        }

        boolean isBusy(CollectionParams.LockLevel lockLevel, List<String> path) {
            if (lockLevel.isHigherOrEqual(this.level)) {
                if (this.busy) {
                    return true;
                }
                String s = path.get(this.level.getHeight());
                if (this.kids == null || this.kids.get(s) == null) {
                    return false;
                }
                return this.kids.get(s).isBusy(lockLevel, path);
            }
            return false;
        }
    }

    public class Session {
        private SessionNode root = new SessionNode(CollectionParams.LockLevel.CLUSTER);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OverseerMessageHandler.Lock lock(CollectionParams.CollectionAction action, List<String> path) {
            if (action.lockLevel == CollectionParams.LockLevel.NONE) {
                return FREELOCK;
            }
            LockTree lockTree = LockTree.this;
            synchronized (lockTree) {
                if (this.root.isBusy(action.lockLevel, path)) {
                    return null;
                }
                OverseerMessageHandler.Lock lockObject = LockTree.this.root.lock(action.lockLevel, path);
                if (lockObject == null) {
                    this.root.markBusy(action.lockLevel, path);
                }
                return lockObject;
            }
        }
    }

    private class LockImpl
    implements OverseerMessageHandler.Lock {
        final Node node;

        LockImpl(Node node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            LockTree lockTree = LockTree.this;
            synchronized (lockTree) {
                this.node.unlock(this);
            }
        }

        public String toString() {
            return StrUtils.join(this.node.constructPath(new LinkedList<String>()), (char)'/');
        }
    }
}

