/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeSet;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.visualization.CircleTool;
import net.yacy.visualization.PrintTool;

public class RasterPlotter {
    public static final ConcurrentLog log = new ConcurrentLog("RasterPlotter");
    public static final double PI180 = Math.PI / 180;
    public static final double PI4 = 0.7853981633974483;
    public static final double PI2 = 1.5707963267948966;
    public static final double PI32 = 4.71238898038469;
    public static final double TL = Math.sqrt(3.0) / 2.0;
    public static final long RED = 0xFF0000L;
    public static final long GREEN = 65280L;
    public static final long BLUE = 255L;
    public static final long GREY = 0x888888L;
    protected final int width;
    protected final int height;
    private final int[] cc = new int[3];
    private BufferedImage image;
    private WritableRaster grid;
    private int defaultColR;
    private int defaultColG;
    private int defaultColB;
    private final long backgroundCol;
    private DrawMode defaultMode;
    private byte[] frame;
    private static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    private static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    private static final byte[] IEND = new byte[]{73, 69, 78, 68};

    public RasterPlotter(int width, int height, DrawMode drawMode, String backgroundColor) {
        this(width, height, drawMode, Long.parseLong(backgroundColor, 16));
    }

    public RasterPlotter(int width, int height, DrawMode drawMode, long backgroundColor) {
        this.width = width;
        this.height = height;
        this.backgroundCol = backgroundColor;
        this.defaultColR = 255;
        this.defaultColG = 255;
        this.defaultColB = 255;
        this.defaultMode = drawMode;
        try {
            this.frame = new byte[width * height * 3];
            DataBufferByte videoBuffer = new DataBufferByte(this.frame, this.frame.length);
            ComponentSampleModel sampleModel = new ComponentSampleModel(0, width, height, 3, width * 3, new int[]{0, 1, 2});
            this.grid = Raster.createWritableRaster(sampleModel, videoBuffer, null);
            ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, 0);
            this.image = new BufferedImage(colorModel, this.grid, false, null);
        }
        catch (OutOfMemoryError e) {
            this.frame = null;
            try {
                this.image = new BufferedImage(width, height, 13);
            }
            catch (OutOfMemoryError ee) {
                try {
                    this.image = new BufferedImage(width, height, 12);
                }
                catch (OutOfMemoryError eee) {
                    this.image = new BufferedImage(1, 1, 12);
                }
            }
            this.grid = this.image.getRaster();
        }
        this.clear();
    }

    public final void clear() {
        int bgR = (int)(this.backgroundCol >> 16);
        int bgG = (int)(this.backgroundCol >> 8 & 0xFFL);
        int bgB = (int)(this.backgroundCol & 0xFFL);
        if (this.frame == null) {
            Graphics2D gr = this.image.createGraphics();
            Color c = new Color(bgR, bgG, bgB);
            gr.setBackground(c);
            gr.clearRect(0, 0, this.width, this.height);
            gr.setColor(c);
            gr.fillRect(0, 0, this.width, this.height);
        } else {
            int p = 0;
            for (int i = 0; i < this.width; ++i) {
                this.frame[p++] = (byte)bgR;
                this.frame[p++] = (byte)bgG;
                this.frame[p++] = (byte)bgB;
            }
            int rw = this.width * 3;
            for (int i = 1; i < this.height; ++i) {
                System.arraycopy(this.frame, 0, this.frame, i * rw, rw);
            }
        }
    }

    public void setDrawMode(DrawMode drawMode) {
        this.defaultMode = drawMode;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static boolean darkColor(String s) {
        return RasterPlotter.darkColor(Long.parseLong(s, 16));
    }

    public static boolean darkColor(long c) {
        int r = (int)(c >> 16);
        int g = (int)(c >> 8 & 0xFFL);
        int b = (int)(c & 0xFFL);
        return r + g + b < 384;
    }

    public int[] getPixel(int x, int y) {
        return this.getPixel(x, y, new int[3]);
    }

    public int[] getPixel(int x, int y, int[] c) {
        if (this.frame == null) {
            return this.grid.getPixel(x, y, c);
        }
        int cell = (this.width * y + x) * 3;
        c[0] = this.frame[cell++] & 0xFF;
        c[1] = this.frame[cell++] & 0xFF;
        c[2] = this.frame[cell++] & 0xFF;
        return c;
    }

    public void setPixel(int x, int y, int[] c) {
        if (this.frame == null) {
            this.grid.setPixel(x, y, c);
            return;
        }
        int cell = (this.width * y + x) * 3;
        this.frame[cell++] = (byte)c[0];
        this.frame[cell++] = (byte)c[1];
        this.frame[cell++] = (byte)c[2];
    }

    public void setColor(long c) {
        if (this.defaultMode == DrawMode.MODE_SUB) {
            int r = (int)(c >> 16);
            int g = (int)(c >> 8 & 0xFFL);
            int b = (int)(c & 0xFFL);
            this.defaultColR = g + b >>> 1;
            this.defaultColG = r + b >>> 1;
            this.defaultColB = r + g >>> 1;
        } else {
            this.defaultColR = (int)(c >> 16);
            this.defaultColG = (int)(c >> 8 & 0xFFL);
            this.defaultColB = (int)(c & 0xFFL);
        }
    }

    public void plot(int x, int y) {
        this.plot(x, y, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void plot(int x, int y, int intensity) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        try {
            if (this.defaultMode == DrawMode.MODE_REPLACE) {
                if (intensity == 100) {
                    int[] nArray = this.cc;
                    synchronized (this.cc) {
                        this.cc[0] = this.defaultColR;
                        this.cc[1] = this.defaultColG;
                        this.cc[2] = this.defaultColB;
                        this.setPixel(x, y, this.cc);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                }
                int[] nArray = this.cc;
                synchronized (this.cc) {
                    int[] c = this.getPixel(x, y, this.cc);
                    c[0] = (intensity * this.defaultColR + (100 - intensity) * c[0]) / 100;
                    c[1] = (intensity * this.defaultColG + (100 - intensity) * c[1]) / 100;
                    c[2] = (intensity * this.defaultColB + (100 - intensity) * c[2]) / 100;
                    this.setPixel(x, y, c);
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return;
                }
            }
            if (this.defaultMode == DrawMode.MODE_ADD) {
                int[] nArray = this.cc;
                synchronized (this.cc) {
                    int[] c = null;
                    try {
                        c = this.getPixel(x, y, this.cc);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return;
                    }
                    if (intensity == 100) {
                        c[0] = (0xFF & c[0]) + this.defaultColR;
                        if (this.cc[0] > 255) {
                            this.cc[0] = 255;
                        }
                        c[1] = (0xFF & c[1]) + this.defaultColG;
                        if (this.cc[1] > 255) {
                            this.cc[1] = 255;
                        }
                        c[2] = (0xFF & c[2]) + this.defaultColB;
                        if (this.cc[2] > 255) {
                            this.cc[2] = 255;
                        }
                    } else {
                        c[0] = (0xFF & c[0]) + intensity * this.defaultColR / 100;
                        if (this.cc[0] > 255) {
                            this.cc[0] = 255;
                        }
                        c[1] = (0xFF & c[1]) + intensity * this.defaultColG / 100;
                        if (this.cc[1] > 255) {
                            this.cc[1] = 255;
                        }
                        c[2] = (0xFF & c[2]) + intensity * this.defaultColB / 100;
                        if (this.cc[2] > 255) {
                            this.cc[2] = 255;
                        }
                    }
                    this.setPixel(x, y, c);
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return;
                }
            }
            if (this.defaultMode != DrawMode.MODE_SUB) return;
            int[] nArray = this.cc;
            synchronized (this.cc) {
                int[] c = null;
                try {
                    c = this.getPixel(x, y, this.cc);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // ** MonitorExit[var4_7] (shouldn't be in output)
                    return;
                }
                if (intensity == 100) {
                    c[0] = (0xFF & c[0]) - this.defaultColR;
                    if (this.cc[0] < 0) {
                        this.cc[0] = 0;
                    }
                    c[1] = (0xFF & c[1]) - this.defaultColG;
                    if (this.cc[1] < 0) {
                        this.cc[1] = 0;
                    }
                    c[2] = (0xFF & c[2]) - this.defaultColB;
                    if (this.cc[2] < 0) {
                        this.cc[2] = 0;
                    }
                } else {
                    c[0] = (0xFF & c[0]) - intensity * this.defaultColR / 100;
                    if (this.cc[0] < 0) {
                        this.cc[0] = 0;
                    }
                    c[1] = (0xFF & c[1]) - intensity * this.defaultColG / 100;
                    if (this.cc[1] < 0) {
                        this.cc[1] = 0;
                    }
                    c[2] = (0xFF & c[2]) - intensity * this.defaultColB / 100;
                    if (this.cc[2] < 0) {
                        this.cc[2] = 0;
                    }
                }
                this.setPixel(x, y, c);
                // ** MonitorExit[var4_7] (shouldn't be in output)
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.warn(e.getMessage() + ": x = " + x + ", y = " + y);
        }
    }

    public void line(int Ax, int Ay, int Bx, int By, int intensity) {
        this.line(Ax, Ay, Bx, By, null, intensity, null, -1, -1, -1, -1, false);
    }

    public void line(int Ax, int Ay, int Bx, int By, Long colorLine, int intensityLine, Long colorDot, int intensityDot, int dotDist, int dotPos, int dotRadius, boolean dotFilled) {
        int dY;
        int dX;
        int Xincr = Ax > Bx ? -1 : 1;
        int Yincr = Ay > By ? -1 : 1;
        int dotc = 0;
        if (dX >= dY) {
            int dPr = dY << 1;
            int dPru = dPr - (dX << 1);
            int P2 = dPr - dX;
            for (dX = Math.abs(Bx - Ax); dX >= 0; --dX) {
                if (colorLine != null) {
                    this.setColor(colorLine);
                }
                this.plot(Ax, Ay, intensityLine);
                if (dotc == dotPos) {
                    if (colorDot != null) {
                        this.setColor(colorDot);
                    }
                    if (dotRadius == 0) {
                        this.plot(Ax, Ay, intensityDot);
                    } else if (dotRadius > 0) {
                        this.dot(Ax, Ay, dotRadius, dotFilled, intensityDot);
                    }
                }
                if (++dotc == dotDist) {
                    dotc = 0;
                }
                if (P2 > 0) {
                    Ax += Xincr;
                    Ay += Yincr;
                    P2 += dPru;
                    continue;
                }
                Ax += Xincr;
                P2 += dPr;
            }
        } else {
            int dPr = dX << 1;
            int dPru = dPr - (dY << 1);
            int P3 = dPr - dY;
            for (dY = Math.abs(By - Ay); dY >= 0; --dY) {
                if (colorLine != null) {
                    this.setColor(colorLine);
                }
                this.plot(Ax, Ay, intensityLine);
                if (dotc == dotPos) {
                    if (colorDot != null) {
                        this.setColor(colorDot);
                    }
                    if (dotRadius == 0) {
                        this.plot(Ax, Ay, intensityDot);
                    } else if (dotRadius > 0) {
                        this.dot(Ax, Ay, dotRadius, dotFilled, intensityDot);
                    }
                }
                if (++dotc == dotDist) {
                    dotc = 0;
                }
                if (P3 > 0) {
                    Ax += Xincr;
                    Ay += Yincr;
                    P3 += dPru;
                    continue;
                }
                Ay += Yincr;
                P3 += dPr;
            }
        }
    }

    public void lineDot(int x0, int y0, int x1, int y1, int radius, int padding, long lineColor, long dotColor) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double angle = Math.atan2(dy, dx);
        double d = Math.sqrt(dx * dx + dy * dy);
        double ddotcenter = d - (double)radius - (double)padding;
        double ddotborder = ddotcenter - (double)radius;
        double xn = Math.cos(angle);
        double yn = Math.sin(angle);
        int x2 = x0 + (int)(ddotcenter * xn);
        int y2 = y0 + (int)(ddotcenter * yn);
        int x3 = x0 + (int)(ddotborder * xn);
        int y3 = y0 + (int)(ddotborder * yn);
        this.setColor(lineColor);
        this.line(x0, y0, x3, y3, 100);
        this.setColor(dotColor);
        this.dot(x2, y2, radius, true, 100);
    }

    public void lineArrow(int x0, int y0, int x1, int y1, int sidelength, int padding, long lineColor, long arrowColor) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double angle = Math.atan2(dy, dx);
        double d = Math.sqrt(dx * dx + dy * dy);
        double arrowtip = d - (double)padding;
        double arrowlength = TL * (double)sidelength;
        double arrowbase = arrowtip - arrowlength;
        double xn = Math.cos(angle);
        double yn = Math.sin(angle);
        int xt = x0 + (int)(arrowtip * xn);
        int yt = y0 + (int)(arrowtip * yn);
        double xb = (double)x0 + arrowbase * xn;
        double yb = (double)y0 + arrowbase * yn;
        double sl2 = (double)sidelength / 2.0;
        double xk = sl2 * Math.cos(angle + 1.5707963267948966);
        double yk = sl2 * Math.sin(angle + 1.5707963267948966);
        int x2 = (int)(xb + xk);
        int y2 = (int)(yb + yk);
        int x3 = (int)(xb - xk);
        int y3 = (int)(yb - yk);
        this.setColor(lineColor);
        this.line(x0, y0, (int)xb, (int)yb, 100);
        this.setColor(arrowColor);
        this.line(x2, y2, x3, y3, 100);
        this.line(x2, y2, xt, yt, 100);
        this.line(x3, y3, xt, yt, 100);
    }

    public void dot(int x, int y, int radius, boolean filled, int intensity) {
        if (filled) {
            for (int r = radius; r >= 0; --r) {
                CircleTool.circle(this, x, y, r, intensity);
            }
        } else {
            CircleTool.circle(this, x, y, radius, intensity);
        }
    }

    public void arc(int x, int y, int innerRadius, int outerRadius, int intensity) {
        for (int r = innerRadius; r <= outerRadius; ++r) {
            CircleTool.circle(this, x, y, r, intensity);
        }
    }

    public void arc(int x, int y, int innerRadius, int outerRadius, int fromArc, int toArc) {
        for (int r = innerRadius; r <= outerRadius; ++r) {
            CircleTool.circle(this, x, y, r, fromArc, toArc);
        }
    }

    public void arcLine(int cx, int cy, int innerRadius, int outerRadius, double angle, boolean in, Long colorLine, Long colorDot, int dotDist, int dotPos, int dotRadius, boolean dotFilled) {
        double a = Math.PI / 180 * angle;
        double cosa = Math.cos(a);
        double sina = Math.sin(a);
        int xi = cx + (int)((double)innerRadius * cosa);
        int yi = cy - (int)((double)innerRadius * sina);
        int xo = cx + (int)((double)outerRadius * cosa);
        int yo = cy - (int)((double)outerRadius * sina);
        if (in) {
            this.line(xo, yo, xi, yi, colorLine, 100, colorDot, 100, dotDist, dotPos, dotRadius, dotFilled);
        } else {
            this.line(xi, yi, xo, yo, colorLine, 100, colorDot, 100, dotDist, dotPos, dotRadius, dotFilled);
        }
    }

    public void arcDot(int cx, int cy, int arcRadius, double angle, int dotRadius) {
        double a = Math.PI / 180 * angle;
        int x = cx + (int)((double)arcRadius * Math.cos(a));
        int y = cy - (int)((double)arcRadius * Math.sin(a));
        this.dot(x, y, dotRadius, true, 100);
    }

    public void arcConnect(int cx, int cy, int arcRadius, double angle1, double angle2, boolean in, Long colorLine, int intensityLine, Long colorDot, int intensityDot, int dotDist, int dotPos, int dotRadius, boolean dotFilled, String message2, Long colorMessage, int intensityMessage) {
        double a1 = Math.PI / 180 * angle1;
        double a2 = Math.PI / 180 * angle2;
        int x1 = cx + (int)((double)arcRadius * Math.cos(a1));
        int y1 = cy - (int)((double)arcRadius * Math.sin(a1));
        int x2 = cx + (int)((double)arcRadius * Math.cos(a2));
        int y2 = cy - (int)((double)arcRadius * Math.sin(a2));
        if (in) {
            this.line(x1, y1, x2, y2, colorLine, intensityLine, colorDot, intensityDot, dotDist, dotPos, dotRadius, dotFilled);
        } else {
            this.line(x2, y2, x1, y1, colorLine, intensityLine, colorDot, intensityDot, dotDist, dotPos, dotRadius, dotFilled);
        }
        if (message2 != null && message2.length() > 0) {
            this.setColor(colorMessage);
            int xm = (x1 + 5 * x2) / 6;
            int ym = (y1 + 5 * y2) / 6;
            ym = ym < cy ? (ym += 6) : (ym -= 6);
            xm = xm < cx ? (xm += 6) : (xm -= 6);
            if (xm > cx) {
                xm -= 6 * message2.length();
            }
            PrintTool.print(this, xm, ym, 0, message2.toUpperCase(), -1, intensityMessage);
        }
    }

    public void arcArc(int cx, int cy, int arcRadius, double angle, int innerRadius, int outerRadius, int intensity) {
        double a = Math.PI / 180 * angle;
        int x = cx + (int)((double)arcRadius * Math.cos(a));
        int y = cy - (int)((double)arcRadius * Math.sin(a));
        this.arc(x, y, innerRadius, outerRadius, intensity);
    }

    public void arcArc(int cx, int cy, int arcRadius, double angle, int innerRadius, int outerRadius, int fromArc, int toArc) {
        double a = Math.PI / 180 * angle;
        int x = cx + (int)((double)arcRadius * Math.cos(a));
        int y = cy - (int)((double)arcRadius * Math.sin(a));
        this.arc(x, y, innerRadius, outerRadius, fromArc, toArc);
    }

    public void insertBitmap(BufferedImage bitmap, int x, int y) {
        this.insertBitmap(bitmap, x, y, -1);
    }

    public void insertBitmap(BufferedImage bitmap, int x, int y, FilterMode filter) {
        this.insertBitmap(bitmap, x, y, -1, filter);
    }

    public void insertBitmap(BufferedImage bitmap, int x, int y, int xx, int yy) {
        this.insertBitmap(bitmap, x, y, bitmap.getRGB(xx, yy));
    }

    public void insertBitmap(BufferedImage bitmap, int x, int y, int xx, int yy, FilterMode filter) {
        this.insertBitmap(bitmap, x, y, bitmap.getRGB(xx, yy), filter);
    }

    public void insertBitmap(BufferedImage bitmap, int x, int y, int transRGB) {
        int heightSrc = bitmap.getHeight();
        int widthSrc = bitmap.getWidth();
        int heightTgt = this.height;
        int widthTgt = this.width;
        for (int i = 0; i < heightSrc; ++i) {
            for (int j = 0; j < widthSrc; ++j) {
                int rgb;
                if (j + x < 0 || i + y < 0 || i + y >= heightTgt || j + x >= widthTgt || (rgb = bitmap.getRGB(j, i)) == transRGB) continue;
                this.image.setRGB(j + x, i + y, rgb);
            }
        }
    }

    public void insertBitmap(BufferedImage bitmap, int x, int y, int transRGB, FilterMode filter) {
        this.insertBitmap(bitmap, x, y, transRGB);
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        if (filter == FilterMode.FILTER_ANTIALIASING) {
            int transX = -1;
            int transY = -1;
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            int j = 0;
            boolean found = false;
            for (int i = 0; i < bitmapWidth && i + x < imageWidth && !found; ++i) {
                while (j < bitmapHeight && j + y < imageHeight && !found) {
                    if (bitmap.getRGB(i, j) == transRGB) {
                        transX = i;
                        transY = j;
                        found = true;
                    }
                    ++j;
                }
            }
            if (transX != -1) {
                this.filter(x - 1, y - 1, x + bitmapWidth, y + bitmapHeight, filter, this.image.getRGB(transX + x, transY + y));
            }
        } else {
            this.filter(x - 1, y - 1, x + bitmapWidth, y + bitmapHeight, filter, -1);
        }
    }

    public void antialiasing(int ulx, int uly, int lrx, int lry, int bgcolor) {
        this.filter(ulx, uly, lrx, lry, FilterMode.FILTER_ANTIALIASING, bgcolor);
    }

    public void blur(int ulx, int uly, int lrx, int lry) {
        this.filter(ulx, uly, lrx, lry, FilterMode.FILTER_BLUR, -1);
    }

    public void invert(int ulx, int uly, int lrx, int lry) {
        this.filter(ulx, uly, lrx, lry, FilterMode.FILTER_INVERT, -1);
    }

    private void filter(int ulx, int uly, int lrx, int lry, FilterMode filter, int bgcolor) {
        int lox = Math.min(Math.max(Math.min(ulx, lrx), 0), this.width - 1);
        int loy = Math.min(Math.max(Math.min(uly, lry), 0), this.height - 1);
        int rux = Math.min(Math.max(Math.max(ulx, lrx), 0), this.width - 1);
        int ruy = Math.min(Math.max(Math.max(uly, lry), 0), this.height - 1);
        int numberOfNeighbours = 0;
        int rgbR = 0;
        int rgbG = 0;
        int rgbB = 0;
        int rgb = 0;
        int width2 = rux - lox + 1;
        int height2 = ruy - loy + 1;
        boolean border = false;
        BufferedImage image2 = new BufferedImage(width2, height2, 1);
        for (int i = lox; i < rux + 1; ++i) {
            for (int j = loy; j < ruy + 1; ++j) {
                numberOfNeighbours = 0;
                rgbR = 0;
                rgbG = 0;
                rgbB = 0;
                if (filter == FilterMode.FILTER_ANTIALIASING || filter == FilterMode.FILTER_BLUR) {
                    if (i > lox) {
                        rgb = this.image.getRGB(i - 1, j);
                        border = rgb == bgcolor;
                        rgbR += rgb >> 16 & 0xFF;
                        rgbG += rgb >> 8 & 0xFF;
                        rgbB += rgb & 0xFF;
                        ++numberOfNeighbours;
                    }
                    if (j > loy) {
                        rgb = this.image.getRGB(i, j - 1);
                        border = border || rgb == bgcolor;
                        rgbR += rgb >> 16 & 0xFF;
                        rgbG += rgb >> 8 & 0xFF;
                        rgbB += rgb & 0xFF;
                        ++numberOfNeighbours;
                    }
                    if (i < this.width - 1) {
                        rgb = this.image.getRGB(i + 1, j);
                        border = border || rgb == bgcolor;
                        rgbR += rgb >> 16 & 0xFF;
                        rgbG += rgb >> 8 & 0xFF;
                        rgbB += rgb & 0xFF;
                        ++numberOfNeighbours;
                    }
                    if (i < this.height - 1) {
                        rgb = this.image.getRGB(i, j + 1);
                        border = border || rgb == bgcolor;
                        rgbR += rgb >> 16 & 0xFF;
                        rgbG += rgb >> 8 & 0xFF;
                        rgbB += rgb & 0xFF;
                        ++numberOfNeighbours;
                    }
                }
                rgb = this.image.getRGB(i, j);
                if (filter == FilterMode.FILTER_ANTIALIASING && border || filter == FilterMode.FILTER_BLUR) {
                    rgbR += rgb >> 16 & 0xFF;
                    rgbG += rgb >> 8 & 0xFF;
                    rgbB += rgb & 0xFF;
                    ++numberOfNeighbours;
                    border = false;
                } else if (filter == FilterMode.FILTER_ANTIALIASING) {
                    rgbR = rgb >> 16 & 0xFF;
                    rgbG = rgb >> 8 & 0xFF;
                    rgbB = rgb & 0xFF;
                    numberOfNeighbours = 1;
                } else if (filter == FilterMode.FILTER_INVERT) {
                    rgbR = (rgb ^= 0xFFFFFF) >> 16 & 0xFF;
                    rgbG = rgb >> 8 & 0xFF;
                    rgbB = rgb & 0xFF;
                    numberOfNeighbours = 1;
                }
                rgb = (rgbR /= numberOfNeighbours) << 16 | (rgbG /= numberOfNeighbours) << 8 | (rgbB /= numberOfNeighbours);
                image2.setRGB(i - lox, j - loy, rgb);
            }
        }
        this.insertBitmap(image2, lox, loy);
    }

    public static void demoPaint(RasterPlotter m) {
        m.setColor(0x888888L);
        m.line(0, 70, 100, 70, 100);
        PrintTool.print(m, 0, 65, 0, "Grey", -1, 100);
        m.line(65, 0, 65, 300, 100);
        m.setColor(0xFF0000L);
        m.line(0, 90, 100, 90, 100);
        PrintTool.print(m, 0, 85, 0, "Red", -1, 100);
        m.line(70, 0, 70, 300, 100);
        m.setColor(65280L);
        m.line(0, 110, 100, 110, 100);
        PrintTool.print(m, 0, 105, 0, "Green", -1, 100);
        m.line(75, 0, 75, 300, 100);
        m.setColor(255L);
        m.line(0, 130, 100, 130, 100);
        PrintTool.print(m, 0, 125, 0, "Blue", -1, 100);
        m.line(80, 0, 80, 300, 100);
    }

    public BufferedImage toIndexed() {
        TreeSet<Integer> colors = new TreeSet<Integer>();
        int[] c = new int[3];
        for (int y = this.getHeight() - 1; y >= 0; --y) {
            for (int x = this.getWidth() - 1; x >= 0; --x) {
                c = this.getPixel(x, y, c);
                colors.add(c[0] << 16 | c[1] << 8 | c[2]);
            }
        }
        int[] cmap = new int[colors.size()];
        int i = 0;
        for (Integer cc : colors) {
            cmap[i++] = cc;
            if (i <= 255) continue;
            break;
        }
        int bitCount = 1;
        while (colors.size() - 1 >> bitCount != 0) {
            bitCount *= 2;
        }
        IndexColorModel cm = new IndexColorModel(bitCount, colors.size(), cmap, 0, 0, null);
        BufferedImage dest = new BufferedImage(this.getWidth(), this.getHeight(), cm.getPixelSize() < 8 ? 12 : 13, cm);
        dest.createGraphics().drawImage((Image)this.getImage(), 0, 0, null);
        return dest;
    }

    public static BufferedImage convertToIndexed(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13);
        dest.createGraphics().drawImage((Image)src, 0, 0, null);
        return dest;
    }

    public static ByteBuffer exportImage(BufferedImage image, String targetExt) {
        ByteBuffer baos = new ByteBuffer();
        ImageIO.setUseCache(false);
        try {
            ImageIO.write((RenderedImage)image, targetExt, baos);
            return baos;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public ByteBuffer exportPng() {
        try {
            byte[] pngbytes = this.pngEncode(9);
            if (pngbytes == null) {
                return null;
            }
            ByteBuffer baos = new ByteBuffer(pngbytes.length);
            baos.write(pngbytes);
            baos.flush();
            baos.close();
            return baos;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public void save(File file, String type) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            ImageIO.write((RenderedImage)this.image, type, fos);
        }
    }

    public void show() {
        JLabel label = new JLabel(new ImageIcon(this.image));
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(label);
        f.pack();
        f.setVisible(true);
    }

    public final byte[] pngEncode(int compressionLevel) throws IOException {
        if (this.frame == null) {
            return RasterPlotter.exportImage(this.getImage(), "png").getBytes();
        }
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        Deflater scrunch = new Deflater(compressionLevel);
        ByteBuffer outBytes = new ByteBuffer(409600);
        BufferedOutputStream compBytes = new BufferedOutputStream(new DeflaterOutputStream(outBytes, scrunch, 2048, false), 16384);
        int i = 0;
        for (int row = 0; row < height; ++row) {
            ((OutputStream)compBytes).write(0);
            ((OutputStream)compBytes).write(this.frame, i, 3 * width);
            i += 3 * width;
        }
        ((OutputStream)compBytes).close();
        scrunch.finish();
        int nCompressed = outBytes.length();
        byte[] png = new byte[nCompressed + 57];
        int next = RasterPlotter.writeBytes(png, new byte[]{-119, 80, 78, 71, 13, 10, 26, 10}, 0);
        int startPos = next = RasterPlotter.writeInt4(png, 13, next);
        next = RasterPlotter.writeBytes(png, IHDR, next);
        next = RasterPlotter.writeInt4(png, width, next);
        next = RasterPlotter.writeInt4(png, height, next);
        next = RasterPlotter.writeBytes(png, new byte[]{8, 2, 0, 0, 0}, next);
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(png, startPos, next - startPos);
        next = RasterPlotter.writeInt4(png, (int)crc.getValue(), next);
        crc.reset();
        next = RasterPlotter.writeInt4(png, nCompressed, next);
        next = RasterPlotter.writeBytes(png, IDAT, next);
        crc.update(IDAT);
        outBytes.copyTo(png, next);
        outBytes.close();
        outBytes = null;
        crc.update(png, next, nCompressed);
        next += nCompressed;
        next = RasterPlotter.writeInt4(png, (int)crc.getValue(), next);
        next = RasterPlotter.writeInt4(png, 0, next);
        next = RasterPlotter.writeBytes(png, IEND, next);
        crc.reset();
        crc.update(IEND);
        next = RasterPlotter.writeInt4(png, (int)crc.getValue(), next);
        return png;
    }

    private static final int writeInt4(byte[] target, int n, int pos) {
        target[pos++] = (byte)(n >> 24 & 0xFF);
        target[pos++] = (byte)(n >> 16 & 0xFF);
        target[pos++] = (byte)(n >> 8 & 0xFF);
        target[pos++] = (byte)(n & 0xFF);
        return pos;
    }

    private static final int writeBytes(byte[] target, byte[] data, int pos) {
        System.arraycopy(data, 0, target, pos, data.length);
        return pos + data.length;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        RasterPlotter m = new RasterPlotter(200, 300, DrawMode.MODE_SUB, "FFFFFF");
        RasterPlotter.demoPaint(m);
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "testimage.png");
        try (FileOutputStream fos = new FileOutputStream(file);){
            System.out.println("Writing file " + file);
            ImageIO.write((RenderedImage)m.getImage(), "png", fos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConcurrentLog.shutdown();
    }

    public static enum DrawMode {
        MODE_REPLACE,
        MODE_ADD,
        MODE_SUB;

    }

    public static enum FilterMode {
        FILTER_ANTIALIASING,
        FILTER_BLUR,
        FILTER_INVERT;

    }
}

