/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.Translator;
import net.yacy.utils.translation.TranslatorUtil;

public class TranslateAllToOneLanguage
extends TranslatorUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File sourceDir = TranslateAllToOneLanguage.getSourceDir(args, 0);
        File destDir = TranslateAllToOneLanguage.getDestDir(args);
        File translationFile = TranslateAllToOneLanguage.getTranslationFile(args, 2);
        String extensions = TranslateAllToOneLanguage.getExtensions(args, 3);
        ConcurrentLog.info("TranslateAllToOneLanguage", "Translating " + extensions + " files from " + sourceDir + " to " + destDir + " using " + translationFile);
        try {
            new Translator().translateFilesRecursive(sourceDir, destDir, translationFile, extensions, "locale");
        }
        finally {
            ConcurrentLog.shutdown();
        }
    }

    protected static File getDestDir(String[] args) {
        File destDir;
        if (args.length > 1) {
            destDir = new File(args[1]);
        } else {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                throw new IllegalArgumentException("No destination dir specified, and default not found");
            }
            destDir = new File(tmpDir + File.separator + TranslateAllToOneLanguage.class.getCanonicalName());
        }
        return destDir;
    }
}

