/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import java.util.ArrayList;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.Translator;
import net.yacy.utils.translation.ExtensionsFileFilter;
import net.yacy.utils.translation.TranslatorUtil;

public class TranslateAll
extends TranslatorUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File sourceDir = TranslateAll.getSourceDir(args, 0);
        File destDir = TranslateAll.getDestDir(args);
        File localesDir = TranslateAll.getLocalesDir(args, 2);
        String extensions = TranslateAll.getExtensions(args, 3);
        try {
            ArrayList<String> exts = new ArrayList<String>();
            exts.add(".lng");
            ExtensionsFileFilter localesFilter = new ExtensionsFileFilter(exts);
            File[] translationFiles = localesDir.listFiles(localesFilter);
            if (translationFiles == null || translationFiles.length == 0) {
                ConcurrentLog.info("TranslateAll", "No translation file found in " + localesDir);
            } else {
                ConcurrentLog.info("TranslateAll", "Translating " + extensions + " files from " + sourceDir + " to " + destDir + " using all locale files in " + localesDir);
                for (File translationFile : translationFiles) {
                    String localeCode = translationFile.getName().substring(0, translationFile.getName().length() - ((String)exts.get(0)).length());
                    File localeDestDir = new File(destDir, localeCode);
                    localeDestDir.mkdirs();
                    new Translator().translateFilesRecursive(sourceDir, localeDestDir, translationFile, extensions, "locale");
                }
            }
        }
        finally {
            ConcurrentLog.shutdown();
        }
    }

    protected static File getDestDir(String[] args) {
        File destDir;
        if (args.length > 1) {
            destDir = new File(args[1]);
        } else {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                throw new IllegalArgumentException("No destination dir specified, and default not found");
            }
            destDir = new File(tmpDir + File.separator + TranslateAll.class.getCanonicalName());
        }
        return destDir;
    }

    protected static File getLocalesDir(String[] args, int argIndex) {
        File localesDir;
        if (args.length > argIndex && argIndex >= 0) {
            localesDir = new File(args[argIndex]);
        } else {
            String workingDir = System.getProperty("user.dir");
            if (workingDir == null) {
                throw new IllegalArgumentException("No translation files directory specified, and default not found");
            }
            localesDir = new File(workingDir, "locales");
            if (!localesDir.exists() && !localesDir.isDirectory()) {
                throw new IllegalArgumentException("No translation files directory specified, and default not found : " + localesDir.getPath());
            }
        }
        return localesDir;
    }
}

