/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server.http;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.retrieval.Request;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.TextParser;
import net.yacy.kelondro.io.ByteCountOutputStream;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.http.ChunkedOutputStream;
import net.yacy.server.http.HTTPDemon;
import net.yacy.server.http.MultiOutputStream;
import net.yacy.server.http.ProxyLogFormatter;
import net.yacy.server.serverObjects;

public final class HTTPDProxyHandler {
    private static final String yacyProxyUserAgent = "yacyproxy (" + ClientIdentification.yacySystem + ") http://yacy.net/bot.html";
    private static Switchboard sb = null;
    private static final HashSet<String> yellowList;
    private static int timeout;
    private static Process redirectorProcess;
    private static boolean redirectorEnabled;
    private static PrintWriter redirectorWriter;
    private static BufferedReader redirectorReader;
    private static final ConcurrentLog log;
    public static final ConcurrentLog proxyLog;
    private static final StringBuilder logMessage;
    private static final StringBuilder userAgentStr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleOutgoingCookies(RequestHeader requestHeader, String targethost, String clienthost) {
        if (sb.getConfigBool("proxy.monitorCookies", false) && requestHeader.containsKey("Cookie")) {
            Object[] entry2 = new Object[]{new Date(), clienthost, requestHeader.getCookies()};
            Map<String, Object[]> map = HTTPDProxyHandler.sb.outgoingCookies;
            synchronized (map) {
                HTTPDProxyHandler.sb.outgoingCookies.put(targethost, entry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleIncomingCookies(ResponseHeader respondHeader, String serverhost, String targetclient) {
        if (sb.getConfigBool("proxy.monitorCookies", false) && respondHeader.containsKey("Set-Cookie")) {
            Object[] entry2 = new Object[]{new Date(), targetclient, respondHeader.getMultiple("Set-Cookie")};
            Map<String, Object[]> map = HTTPDProxyHandler.sb.incomingCookies;
            synchronized (map) {
                HTTPDProxyHandler.sb.incomingCookies.put(serverhost, entry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void doGet(HashMap<String, Object> conProp, RequestHeader requestHeader, OutputStream respond, ClientIdentification.Agent agent) {
        block52: {
            BufferedOutputStream countedRespond;
            block51: {
                DigestURL url;
                String ip;
                int reqID;
                block50: {
                    countedRespond = null;
                    reqID = requestHeader.hashCode();
                    Date requestDate = new Date();
                    conProp.put("REQUEST_START", requestDate.getTime());
                    HTTPDProxyHandler.sb.proxyLastAccess = System.currentTimeMillis();
                    countedRespond = new ByteCountOutputStream(respond, "PROXY");
                    ip = (String)conProp.get("CLIENTIP");
                    url = (DigestURL)conProp.get("URL");
                    if (log.isFine()) {
                        log.fine(reqID + " GET " + url.toString());
                    }
                    if (log.isFinest()) {
                        log.finest(reqID + "    header: " + requestHeader);
                    }
                    if (redirectorEnabled) {
                        Process process = redirectorProcess;
                        synchronized (process) {
                            redirectorWriter.println(url.toNormalform(true));
                            redirectorWriter.flush();
                        }
                        String newUrl = redirectorReader.readLine();
                        if (!newUrl.equals("")) {
                            try {
                                url = new DigestURL(newUrl);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        if (log.isFinest()) {
                            log.finest(reqID + "    using redirector to " + url);
                        }
                        conProp.put("URL", url);
                    }
                    if (!Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.PROXY, url)) break block50;
                    log.info("AGIS blocking of host '" + url.getHost() + "'");
                    HTTPDemon.sendRespondError(conProp, (OutputStream)countedRespond, 4, 403, null, "URL '" + url.getHost() + "' blocked by yacy proxy (blacklisted)", null);
                    try {
                        if (countedRespond != null) {
                            countedRespond.flush();
                        } else if (respond != null) {
                            respond.flush();
                        }
                    }
                    catch (Exception newUrl) {
                        // empty catch block
                    }
                    if (countedRespond != null) {
                        ((ByteCountOutputStream)countedRespond).finish();
                    }
                    conProp.put("REQUEST_END", System.currentTimeMillis());
                    conProp.put("PROXY_REQUEST_SIZE", countedRespond != null ? Long.toString(((ByteCountOutputStream)countedRespond).getCount()) : Long.valueOf(-1L));
                    HTTPDProxyHandler.logProxyAccess(conProp);
                    return;
                }
                HTTPDProxyHandler.handleOutgoingCookies(requestHeader, url.getHost(), ip);
                HTTPDProxyHandler.prepareRequestHeader(conProp, requestHeader, url.getHost().toLowerCase(Locale.ROOT));
                ResponseHeader cachedResponseHeader = Cache.getResponseHeader(url.hash());
                if (cachedResponseHeader == null) {
                    if (log.isFinest()) {
                        log.finest(reqID + " page not in cache: fulfill request from web");
                    }
                    HTTPDProxyHandler.fulfillRequestFromWeb(conProp, url, requestHeader, cachedResponseHeader, countedRespond, agent);
                    break block51;
                }
                Request request = new Request(null, url, requestHeader.referer() == null ? null : requestHeader.referer().hash(), "", cachedResponseHeader.lastModified(), HTTPDProxyHandler.sb.crawler.defaultProxyProfile.handle(), 0, HTTPDProxyHandler.sb.crawler.defaultProxyProfile.timezoneOffset());
                Response response = new Response(request, requestHeader, cachedResponseHeader, HTTPDProxyHandler.sb.crawler.defaultProxyProfile, true, null);
                byte[] cacheContent = Cache.getContent(url.hash());
                if (cacheContent != null && response.isFreshForProxy()) {
                    if (log.isFinest()) {
                        log.finest(reqID + " fulfill request from cache");
                    }
                    HTTPDProxyHandler.fulfillRequestFromCache(conProp, url, requestHeader, cachedResponseHeader, cacheContent, countedRespond);
                    break block51;
                }
                if (log.isFinest()) {
                    log.finest(reqID + " fulfill request from web");
                }
                HTTPDProxyHandler.fulfillRequestFromWeb(conProp, url, requestHeader, cachedResponseHeader, countedRespond, agent);
            }
            try {
                if (countedRespond != null) {
                    countedRespond.flush();
                } else if (respond != null) {
                    respond.flush();
                }
            }
            catch (Exception reqID) {
                // empty catch block
            }
            if (countedRespond != null) {
                ((ByteCountOutputStream)countedRespond).finish();
            }
            conProp.put("REQUEST_END", System.currentTimeMillis());
            conProp.put("PROXY_REQUEST_SIZE", countedRespond != null ? Long.toString(((ByteCountOutputStream)countedRespond).getCount()) : Long.valueOf(-1L));
            HTTPDProxyHandler.logProxyAccess(conProp);
            break block52;
            catch (Exception e) {
                try {
                    try {
                        String exTxt = e.getMessage();
                        if (exTxt != null && exTxt.startsWith("Socket closed")) {
                            HTTPDProxyHandler.forceConnectionClose(conProp);
                        } else if (!conProp.containsKey("PROXY_RESPOND_HEADER")) {
                            String errorMsg = "Unexpected Error. " + e.getClass().getName() + ": " + e.getMessage();
                            HTTPDemon.sendRespondError(conProp, (OutputStream)countedRespond, 4, 501, null, errorMsg, (Throwable)e);
                            log.severe(errorMsg);
                        } else {
                            HTTPDProxyHandler.forceConnectionClose(conProp);
                        }
                    }
                    catch (Exception ee) {
                        HTTPDProxyHandler.forceConnectionClose(conProp);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (countedRespond != null) {
                            countedRespond.flush();
                        } else if (respond != null) {
                            respond.flush();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (countedRespond != null) {
                        ((ByteCountOutputStream)countedRespond).finish();
                    }
                    conProp.put("REQUEST_END", System.currentTimeMillis());
                    conProp.put("PROXY_REQUEST_SIZE", countedRespond != null ? Long.toString(((ByteCountOutputStream)countedRespond).getCount()) : Long.valueOf(-1L));
                    HTTPDProxyHandler.logProxyAccess(conProp);
                    throw throwable;
                }
                try {
                    if (countedRespond != null) {
                        countedRespond.flush();
                    } else if (respond != null) {
                        respond.flush();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (countedRespond != null) {
                    ((ByteCountOutputStream)countedRespond).finish();
                }
                conProp.put("REQUEST_END", System.currentTimeMillis());
                conProp.put("PROXY_REQUEST_SIZE", countedRespond != null ? Long.toString(((ByteCountOutputStream)countedRespond).getCount()) : Long.valueOf(-1L));
                HTTPDProxyHandler.logProxyAccess(conProp);
            }
        }
    }

    private static void fulfillRequestFromWeb(HashMap<String, Object> conProp, DigestURL url, RequestHeader requestHeader, ResponseHeader cachedResponseHeader, OutputStream respond, ClientIdentification.Agent agent) {
        block30: {
            try {
                String remotePath;
                int reqID = requestHeader.hashCode();
                String host = url.getHost();
                String path = url.getPath();
                String args = url.getSearchpart();
                String ip = (String)conProp.get("CLIENTIP");
                String httpVer = (String)conProp.get("HTTP");
                HttpServletRequest clientservletrequest = (HttpServletRequest)conProp.get("CLIENT_HTTPSERVLETREQUEST");
                String clienthttpVer = clientservletrequest != null ? clientservletrequest.getProtocol() : null;
                int port = url.getPort();
                String yAddress = HTTPDProxyHandler.resolveYacyDomains(host);
                String string = remotePath = args == null ? path : path + "?" + args;
                if (yAddress != null && remotePath.startsWith("/env") && yAddress.indexOf(47) != -1) {
                    yAddress = yAddress.substring(0, yAddress.indexOf(47));
                }
                HTTPDProxyHandler.modifyProxyHeaders(requestHeader, httpVer);
                String connectHost = HTTPDProxyHandler.hostPart(host, port, yAddress);
                String getUrl = url.getProtocol() + "://" + connectHost + remotePath;
                requestHeader.remove("Host");
                try (HTTPClient client = new HTTPClient(agent, timeout);){
                    int statusCode;
                    ResponseHeader responseHeader;
                    client.setHeader(requestHeader.entrySet());
                    client.setRedirecting(false);
                    client.GET(getUrl, false);
                    if (log.isFinest()) {
                        log.finest(reqID + "    response status: " + client.getHttpResponse().getStatusLine());
                    }
                    if ((responseHeader = new ResponseHeader(statusCode = client.getHttpResponse().getStatusLine().getStatusCode(), client.getHttpResponse().getAllHeaders())).isEmpty()) {
                        throw new Exception(client.getHttpResponse().getStatusLine().toString());
                    }
                    ChunkedOutputStream chunkedOut = HTTPDProxyHandler.setTransferEncoding(conProp, responseHeader, statusCode, respond);
                    long sizeBeforeDelete = -1L;
                    if (cachedResponseHeader != null) {
                        byte[] b;
                        ResponseHeader rh = Cache.getResponseHeader(url.hash());
                        if (rh != null && (sizeBeforeDelete = (long)rh.getContentLength()) == 0L && (b = Cache.getContent(url.hash())) != null) {
                            sizeBeforeDelete = b.length;
                        }
                        Cache.delete(url.hash());
                        conProp.put("PROXY_RESPOND_CODE", "TCP_REFRESH_MISS");
                    }
                    Request request = new Request(null, url, requestHeader.referer() == null ? null : requestHeader.referer().hash(), "", responseHeader.lastModified(), HTTPDProxyHandler.sb.crawler.defaultProxyProfile.handle(), 0, HTTPDProxyHandler.sb.crawler.defaultProxyProfile.timezoneOffset());
                    HTTPDProxyHandler.handleIncomingCookies(responseHeader, host, ip);
                    HTTPDProxyHandler.prepareResponseHeader(responseHeader, client.getHttpResponse().getProtocolVersion().toString());
                    if (chunkedOut != null) {
                        responseHeader.put("Transfer-Encoding", "chunked");
                    }
                    if (log.isFinest()) {
                        log.finest(reqID + "    sending response header: " + responseHeader);
                    }
                    HTTPDemon.sendRespondHeader(conProp, respond, clienthttpVer, statusCode, client.getHttpResponse().getStatusLine().toString(), responseHeader);
                    if (!HTTPDProxyHandler.hasBody(client.getHttpResponse().getStatusLine().getStatusCode())) break block30;
                    OutputStream outStream = chunkedOut != null ? chunkedOut : respond;
                    Response response = new Response(request, requestHeader, responseHeader, HTTPDProxyHandler.sb.crawler.defaultProxyProfile, true, null);
                    String storeError = response.shallStoreCacheForProxy();
                    boolean storeHTCache = response.profile().storeHTCache();
                    String supportError = TextParser.supports(response.url(), response.getMimeType());
                    if (storeError == null && (storeHTCache || supportError != null)) {
                        int l = responseHeader.size();
                        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(l < 32 ? 32 : l);
                        MultiOutputStream toClientAndMemory = new MultiOutputStream(new OutputStream[]{outStream, byteStream});
                        client.writeTo(toClientAndMemory);
                        byte[] cacheArray = byteStream.size() > 0 ? byteStream.toByteArray() : null;
                        if (log.isFine()) {
                            log.fine(reqID + " writeContent of " + url + " produced cacheArray = " + (String)(cacheArray == null ? "null" : "size=" + cacheArray.length));
                        }
                        if (sizeBeforeDelete == -1L) {
                            response.setContent(cacheArray);
                            try {
                                Cache.store(response.url(), response.getResponseHeader(), cacheArray);
                                sb.toIndexer(response);
                            }
                            catch (IOException e) {
                                log.warn("cannot write " + response.url() + " to Cache (1): " + e.getMessage(), e);
                            }
                            conProp.put("PROXY_RESPOND_CODE", "TCP_MISS");
                        } else if (cacheArray != null && sizeBeforeDelete == (long)cacheArray.length) {
                            cacheArray = null;
                            conProp.put("PROXY_RESPOND_CODE", "TCP_REF_FAIL_HIT");
                        } else {
                            response.setContent(cacheArray);
                            try {
                                Cache.store(response.url(), response.getResponseHeader(), cacheArray);
                                sb.toIndexer(response);
                            }
                            catch (IOException e) {
                                log.warn("cannot write " + response.url() + " to Cache (2): " + e.getMessage(), e);
                            }
                            conProp.put("PROXY_RESPOND_CODE", "TCP_REFRESH_MISS");
                        }
                    } else {
                        if (log.isFine()) {
                            log.fine(reqID + " " + url.toNormalform(false) + " not cached. StoreError=" + (storeError == null ? "None" : storeError) + " StoreHTCache=" + storeHTCache + " SupportError=" + supportError);
                        }
                        if (statusCode == 200) {
                            client.writeTo(outStream);
                        }
                        conProp.put("PROXY_RESPOND_CODE", "TCP_MISS");
                    }
                    outStream.close();
                    if (chunkedOut != null) {
                        chunkedOut.finish();
                        chunkedOut.flush();
                    }
                }
                catch (SocketException se) {
                    HTTPDProxyHandler.handleProxyException(se, conProp, respond, url);
                }
            }
            catch (Exception e) {
                HTTPDProxyHandler.handleProxyException(e, conProp, respond, url);
            }
        }
    }

    private static boolean hasBody(int statusCode) {
        return (statusCode < 100 || statusCode >= 200) && statusCode != 204 && statusCode != 304;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fulfillRequestFromCache(HashMap<String, Object> conProp, DigestURL url, RequestHeader requestHeader, ResponseHeader cachedResponseHeader, byte[] cacheEntry, OutputStream respond) throws IOException {
        String httpVer = (String)conProp.get("HTTP");
        HttpServletRequest clientservletrequest = (HttpServletRequest)conProp.get("CLIENT_HTTPSERVLETREQUEST");
        String clienthttpVer = clientservletrequest != null ? clientservletrequest.getProtocol() : null;
        try {
            HTTPDProxyHandler.prepareResponseHeader(cachedResponseHeader, httpVer);
            cachedResponseHeader.put("Date", HeaderFramework.formatRFC1123(new Date()));
            if (requestHeader.containsKey("If-Modified-Since")) {
                log.info("CACHE HIT/304 " + url.toNormalform(false));
                conProp.put("PROXY_RESPOND_CODE", "TCP_REFRESH_HIT");
                cachedResponseHeader.put("Content-Length", Integer.toString(0));
                HTTPDemon.sendRespondHeader(conProp, respond, clienthttpVer, 304, null, cachedResponseHeader);
            } else {
                log.info("CACHE HIT/203 " + url.toNormalform(false));
                conProp.put("PROXY_RESPOND_CODE", "TCP_HIT");
                cachedResponseHeader.put("Content-Length", Long.toString(cacheEntry.length));
                HTTPDemon.sendRespondHeader(conProp, respond, clienthttpVer, 203, null, cachedResponseHeader);
                FileUtils.copy(cacheEntry, respond);
            }
        }
        catch (Exception e) {
            if (conProp.containsKey("PROXY_RESPOND_HEADER")) {
                log.warn("Error while trying to send cached message body.");
                conProp.put("PERSISTENT", "close");
            } else {
                HTTPDemon.sendRespondError(conProp, respond, 4, 503, "socket error: " + e.getMessage(), "socket error: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                respond.flush();
                respond.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String resolveYacyDomains(String host) {
        return HTTPDProxyHandler.sb.peers == null ? null : HTTPDProxyHandler.sb.peers.resolve(host);
    }

    private static String hostPart(String host, int port, String yAddress) {
        String connectHost = yAddress == null ? host + ":" + port : yAddress;
        return connectHost;
    }

    private static void prepareRequestHeader(HashMap<String, Object> conProp, RequestHeader requestHeader, String hostlow) {
        if (yellowList != null && !yellowList.contains(HTTPDProxyHandler.domain(hostlow))) {
            requestHeader.put("User-Agent", HTTPDProxyHandler.generateUserAgent(requestHeader));
        }
        if (requestHeader.get("Accept-Encoding", "").indexOf("gzip", 0) != -1) {
            requestHeader.put("Accept-Encoding", "gzip");
        } else {
            requestHeader.put("Accept-Encoding", "");
        }
        HTTPDProxyHandler.addXForwardedForHeader(conProp, requestHeader);
    }

    private static String domain(String host) {
        String domain = host;
        int pos = domain.lastIndexOf(46);
        if (pos >= 0 && (pos = (domain = domain.substring(0, pos)).lastIndexOf(46)) >= 0) {
            domain = domain.substring(pos + 1);
        }
        return domain;
    }

    private static ChunkedOutputStream setTransferEncoding(HashMap<String, Object> conProp, ResponseHeader responseHeader, int statusCode, OutputStream respond) {
        String httpVer = (String)conProp.get("HTTP");
        ChunkedOutputStream chunkedOut = null;
        if (responseHeader.gzip() || responseHeader.getContentLength() < 0) {
            if (statusCode == 204 || statusCode == 304) {
                responseHeader.put("Content-Length", "0");
            } else {
                if (httpVer.equals("HTTP/0.9") || httpVer.equals("HTTP/1.0")) {
                    HTTPDProxyHandler.forceConnectionClose(conProp);
                } else {
                    chunkedOut = new ChunkedOutputStream(respond);
                }
                responseHeader.remove("Content-Length");
            }
        }
        return chunkedOut;
    }

    private static void prepareResponseHeader(ResponseHeader responseHeader, String httpVer) {
        HTTPDProxyHandler.modifyProxyHeaders(responseHeader, httpVer);
        HTTPDProxyHandler.correctContentEncoding(responseHeader);
    }

    private static void correctContentEncoding(ResponseHeader responseHeader) {
        if (responseHeader.gzip()) {
            responseHeader.remove("Content-Encoding");
            responseHeader.remove("Content-Length");
        }
    }

    private static void addXForwardedForHeader(HashMap<String, Object> conProp, RequestHeader requestHeader) {
        if (sb.getConfigBool("proxy.sendXForwardedForHeader", true)) {
            requestHeader.put("X-Forwarded-For", (String)conProp.get("CLIENTIP"));
        }
    }

    public static void modifyProxyHeaders(HeaderFramework requestHeader, String httpVer) {
        HTTPDProxyHandler.removeHopByHopHeaders(requestHeader);
        HTTPDProxyHandler.setViaHeader(requestHeader, httpVer);
    }

    private static void removeHopByHopHeaders(HeaderFramework headers) {
        headers.remove("Connection");
        headers.remove("Keep-Alive");
        headers.remove("Upgrade");
        headers.remove("TE");
        headers.remove("Proxy-Connection");
        headers.remove("Proxy-Authenticate");
        headers.remove("Proxy-Authorization");
        headers.remove("X-Cache");
        headers.remove("X-Cache-Lookup");
        headers.remove("Transfer-Encoding");
    }

    private static void setViaHeader(HeaderFramework header, String httpVer) {
        String myAddress;
        if (!sb.getConfigBool("proxy.sendViaHeader", true)) {
            return;
        }
        String string = myAddress = HTTPDProxyHandler.sb.peers == null ? null : HTTPDProxyHandler.sb.peers.myAlternativeAddress();
        if (myAddress != null) {
            StringBuilder viaValue = new StringBuilder(80);
            if (header.containsKey("Via")) {
                viaValue.append((String)header.get("Via"));
            }
            if (viaValue.length() > 0) {
                viaValue.append(", ");
            }
            viaValue.append(httpVer).append(" ").append(myAddress).append(" ").append("(YaCy ").append(yacyBuildProperties.getVersion()).append(")");
            header.put("Via", viaValue.toString());
        }
    }

    private static void handleProxyException(Exception e, HashMap<String, Object> conProp, OutputStream respond, DigestURL url) {
        try {
            int httpStatusCode = 404;
            String httpStatusText = null;
            Object errorMessage = null;
            Exception errorExc = null;
            boolean unknownError = false;
            boolean detailedErrorMsg = false;
            String detailedErrorMsgFile = null;
            serverObjects detailedErrorMsgMap = null;
            if (e instanceof ConnectException) {
                httpStatusCode = 403;
                httpStatusText = "Connection refused";
                errorMessage = "Connection refused by destination host";
            } else if (e instanceof BindException) {
                errorMessage = "Unable to establish a connection to the destination host";
            } else if (e instanceof NoRouteToHostException) {
                errorMessage = "No route to destination host";
            } else if (e instanceof UnknownHostException) {
                try {
                    detailedErrorMsgMap = HTTPDProxyHandler.unknownHostHandling(conProp);
                    httpStatusText = "Unknown Host";
                    detailedErrorMsg = true;
                    detailedErrorMsgFile = "proxymsg/unknownHost.inc";
                }
                catch (Exception e1) {
                    errorMessage = "IP address of the destination host could not be determined";
                }
            } else if (e instanceof SocketTimeoutException) {
                errorMessage = "Unable to establish a connection to the destination host. Connect timed out.";
            } else {
                String exceptionMsg = e.getMessage();
                if (exceptionMsg != null && exceptionMsg.indexOf("Corrupt GZIP trailer", 0) >= 0) {
                    if (log.isFine()) {
                        log.fine("ignoring bad gzip trail for URL " + url + " (" + e.getMessage() + ")");
                    }
                    HTTPDProxyHandler.forceConnectionClose(conProp);
                } else if (exceptionMsg != null && exceptionMsg.indexOf("Connection reset", 0) >= 0) {
                    errorMessage = "Connection reset";
                } else if (exceptionMsg != null && exceptionMsg.indexOf("unknown host", 0) >= 0) {
                    try {
                        detailedErrorMsgMap = HTTPDProxyHandler.unknownHostHandling(conProp);
                        httpStatusText = "Unknown Host";
                        detailedErrorMsg = true;
                        detailedErrorMsgFile = "proxymsg/unknownHost.inc";
                    }
                    catch (Exception e1) {
                        errorMessage = "IP address of the destination host could not be determined";
                    }
                } else if (exceptionMsg != null && (exceptionMsg.indexOf("socket write error", 0) >= 0 || exceptionMsg.indexOf("Read timed out", 0) >= 0 || exceptionMsg.indexOf("Broken pipe", 0) >= 0 || exceptionMsg.indexOf("server has closed connection", 0) >= 0)) {
                    errorMessage = exceptionMsg;
                    ConcurrentLog.logException(e);
                } else {
                    errorMessage = "Unexpected Error. " + e.getClass().getName() + ": " + e.getMessage();
                    unknownError = true;
                    errorExc = e;
                }
            }
            if (!conProp.containsKey("PROXY_RESPOND_HEADER")) {
                if (detailedErrorMsg) {
                    HTTPDemon.sendRespondError(conProp, respond, httpStatusCode, httpStatusText, new File(detailedErrorMsgFile), detailedErrorMsgMap, errorExc);
                } else {
                    HTTPDemon.sendRespondError(conProp, respond, 4, httpStatusCode, httpStatusText, (String)errorMessage, errorExc);
                }
            } else {
                if (unknownError) {
                    log.severe("Unknown Error while processing request 'PROXY':\n" + Thread.currentThread().getName() + "\n" + (String)errorMessage, e);
                } else {
                    log.warn("Error while processing request 'PROXY':\n" + Thread.currentThread().getName() + "\n" + (String)errorMessage);
                }
                HTTPDProxyHandler.forceConnectionClose(conProp);
            }
        }
        catch (Exception ee) {
            HTTPDProxyHandler.forceConnectionClose(conProp);
        }
    }

    private static void forceConnectionClose(HashMap<String, Object> conProp) {
        if (conProp != null) {
            conProp.put("PERSISTENT", "close");
        }
    }

    private static serverObjects unknownHostHandling(HashMap<String, Object> conProp) throws Exception {
        int pos;
        InetAddress addr;
        Object orgHostArgs;
        serverObjects detailedErrorMsgMap = new serverObjects();
        HashSet<String> topLevelDomains = new HashSet<String>(Arrays.asList("aero", "arpa", "biz", "com", "coop", "edu", "gov", "info", "int", "jobs", "mil", "name", "nato", "net", "org", "pro", "travel", "de", "at", "ch", "it", "uk"));
        DigestURL orgurl = (DigestURL)conProp.get("URL");
        int orgHostPort = orgurl.getPort();
        String orgHostName = orgurl.getHost();
        if (orgHostName == null) {
            orgHostName = "unknown";
        }
        orgHostName = orgHostName.toLowerCase(Locale.ROOT);
        String orgHostPath = orgurl.getPath();
        if (orgHostPath == null) {
            orgHostPath = "";
        }
        if ((orgHostArgs = orgurl.getSearchpart()) == null) {
            orgHostArgs = "";
        }
        if (((String)orgHostArgs).length() > 0) {
            orgHostArgs = "?" + (String)orgHostArgs;
        }
        detailedErrorMsgMap.put("hostName", orgHostName);
        HashSet<Object> testHostNames = new HashSet<Object>();
        Object testHostName2 = null;
        if (!orgHostName.startsWith("www.")) {
            testHostName2 = "www." + orgHostName;
            addr = Domains.dnsResolve((String)testHostName2);
            if (addr != null) {
                testHostNames.add(testHostName2);
            }
        } else if (orgHostName.startsWith("www.") && (addr = Domains.dnsResolve((String)(testHostName2 = orgHostName.substring(4)))) != null) {
            testHostNames.add(testHostName2);
        }
        if (orgHostName.length() > 4 && orgHostName.startsWith("www") && orgHostName.charAt(3) != '.' && (addr = Domains.dnsResolve((String)(testHostName2 = orgHostName.substring(0, 3) + "." + orgHostName.substring(3)))) != null) {
            testHostNames.add(testHostName2);
        }
        if ((pos = orgHostName.lastIndexOf(46)) != -1) {
            for (String topLevelDomain : topLevelDomains) {
                testHostName2 = orgHostName.substring(0, pos) + "." + topLevelDomain;
                InetAddress addr2 = Domains.dnsResolve((String)testHostName2);
                if (addr2 == null) continue;
                testHostNames.add(testHostName2);
            }
        }
        int hostNameCount = 0;
        for (Object testHostName2 : testHostNames) {
            detailedErrorMsgMap.put("list_" + hostNameCount + "_hostName", (String)testHostName2);
            detailedErrorMsgMap.put("list_" + hostNameCount + "_hostPort", orgHostPort);
            detailedErrorMsgMap.put("list_" + hostNameCount + "_hostPath", orgHostPath);
            detailedErrorMsgMap.put("list_" + hostNameCount + "_hostArgs", (String)orgHostArgs);
            ++hostNameCount;
        }
        detailedErrorMsgMap.put("list", hostNameCount);
        if (hostNameCount != 0) {
            detailedErrorMsgMap.put("showList", 1L);
        } else {
            detailedErrorMsgMap.put("showList", 0L);
        }
        return detailedErrorMsgMap;
    }

    private static synchronized String generateUserAgent(HeaderFramework requestHeaders) {
        userAgentStr.setLength(0);
        String browserUserAgent = requestHeaders.get("User-Agent", yacyProxyUserAgent);
        int pos = browserUserAgent.lastIndexOf(41);
        if (pos >= 0) {
            userAgentStr.append(browserUserAgent.substring(0, pos)).append("; YaCy ").append(yacyBuildProperties.getVersion()).append("; yacy.net").append(browserUserAgent.substring(pos));
        } else {
            userAgentStr.append(browserUserAgent);
        }
        return userAgentStr.toString();
    }

    private static final synchronized void logProxyAccess(HashMap<String, Object> conProp) {
        logMessage.setLength(0);
        String currentTimestamp = Long.toString(System.currentTimeMillis());
        int offset = currentTimestamp.length() - 3;
        logMessage.append(currentTimestamp.substring(0, offset));
        logMessage.append('.');
        logMessage.append(currentTimestamp.substring(offset));
        logMessage.append(' ');
        Long requestStart = (Long)conProp.get("REQUEST_START");
        Long requestEnd = (Long)conProp.get("REQUEST_END");
        String elapsed = Long.toString(requestEnd - requestStart);
        for (int i = 0; i < 6 - elapsed.length(); ++i) {
            logMessage.append(' ');
        }
        logMessage.append(elapsed);
        logMessage.append(' ');
        String clientIP = (String)conProp.get("CLIENTIP");
        logMessage.append(clientIP);
        logMessage.append(' ');
        String respondStatus = (String)conProp.get("PROXY_RESPOND_STATUS");
        String respondCode = (String)conProp.get("PROXY_RESPOND_CODE");
        if (respondCode == null) {
            respondCode = "UNKNOWN";
        }
        logMessage.append(respondCode);
        logMessage.append("/");
        logMessage.append(respondStatus);
        logMessage.append(' ');
        String bytes = (String)conProp.get("PROXY_REQUEST_SIZE");
        logMessage.append(bytes.toString());
        logMessage.append(' ');
        HttpServletRequest origrequest = (HttpServletRequest)conProp.get("CLIENT_HTTPSERVLETREQUEST");
        String requestMethod = origrequest.getMethod();
        logMessage.append(requestMethod);
        logMessage.append(' ');
        DigestURL requestURL = (DigestURL)conProp.get("URL");
        logMessage.append(requestURL.toString());
        logMessage.append(' ');
        logMessage.append("-");
        logMessage.append(' ');
        logMessage.append("DIRECT/");
        logMessage.append(requestURL.getHost());
        logMessage.append(' ');
        String mime = "-";
        if (conProp.containsKey("PROXY_RESPOND_HEADER")) {
            HeaderFramework proxyRespondHeader = (HeaderFramework)conProp.get("PROXY_RESPOND_HEADER");
            mime = proxyRespondHeader.mime();
        }
        logMessage.append(mime);
        if (proxyLog.isFine()) {
            proxyLog.fine(logMessage.toString());
        }
    }

    static {
        timeout = 60000;
        redirectorProcess = null;
        redirectorEnabled = false;
        redirectorWriter = null;
        redirectorReader = null;
        log = new ConcurrentLog("PROXY");
        sb = Switchboard.getSwitchboard();
        if (sb != null) {
            block18: {
                timeout = sb.getConfigInt("proxy.clientTimeout", 60000);
                try {
                    log.info("Configuring proxy access logging ...");
                    LogManager manager = LogManager.getLogManager();
                    String className = HTTPDProxyHandler.class.getName();
                    String enabled = manager.getProperty(className + ".logging.enabled");
                    if ("true".equalsIgnoreCase(enabled)) {
                        String countStr;
                        String limitStr;
                        int limit = 0x100000;
                        int count = 20;
                        String pattern = manager.getProperty(className + ".logging.FileHandler.pattern");
                        if (pattern == null) {
                            pattern = "DATA/LOG/proxyAccess%u%g.log";
                        }
                        if (!new File(pattern).isAbsolute()) {
                            pattern = new File(sb.getDataPath(), pattern).getAbsolutePath();
                        }
                        if ((limitStr = manager.getProperty(className + ".logging.FileHandler.limit")) != null) {
                            try {
                                limit = Integer.parseInt(limitStr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((countStr = manager.getProperty(className + ".logging.FileHandler.count")) != null) {
                            try {
                                count = Integer.parseInt(countStr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        Logger proxyLogger = Logger.getLogger("PROXY.access");
                        proxyLogger.setUseParentHandlers(false);
                        proxyLogger.setLevel(Level.FINEST);
                        FileHandler txtLog = new FileHandler(pattern, limit, count, true);
                        txtLog.setFormatter(new ProxyLogFormatter());
                        txtLog.setLevel(Level.FINEST);
                        proxyLogger.addHandler(txtLog);
                        log.info("Proxy access logging configuration done.\n\tFilename: " + pattern + "\n\tLimit: " + limitStr + "\n\tCount: " + countStr);
                        break block18;
                    }
                    log.info("Proxy access logging is deactivated.");
                }
                catch (Exception e) {
                    log.severe("Unable to configure proxy access logging.", e);
                }
            }
            String f = sb.getConfig("proxyYellowList", null);
            if (f != null) {
                yellowList = FileUtils.loadList(new File(f));
                log.config("loaded yellow-list from file " + f + ", " + yellowList.size() + " entries");
            } else {
                yellowList = null;
            }
            String redirectorPath = sb.getConfig("externalRedirector", "");
            if (redirectorPath.length() > 0 && !redirectorEnabled) {
                try {
                    redirectorProcess = Runtime.getRuntime().exec(redirectorPath, null, null);
                    redirectorWriter = new PrintWriter(redirectorProcess.getOutputStream());
                    redirectorReader = new BufferedReader(new InputStreamReader(redirectorProcess.getInputStream()));
                    redirectorEnabled = true;
                }
                catch (IOException e) {
                    System.out.println("redirector not Found");
                }
            }
        } else {
            yellowList = null;
        }
        proxyLog = new ConcurrentLog("PROXY.access");
        logMessage = new StringBuilder();
        userAgentStr = new StringBuilder();
    }
}

