/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.search.Switchboard;
import net.yacy.search.index.ErrorCacheFiller;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;

public class ErrorCache {
    private static final ConcurrentLog log = new ConcurrentLog("CRAWLER");
    private static final int maxStackSize = 1000;
    private final Map<String, CollectionConfiguration.FailDoc> cache;
    private final Switchboard sb;

    public ErrorCache(Switchboard sb) {
        this.sb = sb;
        this.cache = new LinkedHashMap<String, CollectionConfiguration.FailDoc>();
        new ErrorCacheFiller(sb, this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.cache != null) {
            Map<String, CollectionConfiguration.FailDoc> map = this.cache;
            synchronized (map) {
                this.cache.clear();
            }
        }
    }

    public void clear() throws IOException {
        this.clearCache();
        this.sb.index.fulltext().getDefaultConnector().deleteByQuery(CollectionSchema.failreason_s.getSolrFieldName() + ":[* TO *]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHosts(Set<String> hosthashes) {
        if (hosthashes == null || hosthashes.size() == 0) {
            return;
        }
        this.sb.index.fulltext().deleteDomainErrors(hosthashes);
        Map<String, CollectionConfiguration.FailDoc> map = this.cache;
        synchronized (map) {
            Iterator<String> i = this.cache.keySet().iterator();
            while (i.hasNext()) {
                String b = i.next();
                if (!hosthashes.contains(b)) continue;
                i.remove();
            }
        }
    }

    public void putHashOnly(String hash) {
        this.cache.put(hash, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(DigestURL url, int crawldepth, CrawlProfile profile2, FailCategory failCategory, String anycause, int httpcode) {
        String reason;
        assert (failCategory.store || httpcode == -1) : "failCategory=" + failCategory.name();
        if (anycause == null) {
            anycause = "unknown";
        }
        if (!(reason = anycause + (String)(httpcode >= 0 ? " (http return code = " + httpcode + ")" : "")).startsWith("double")) {
            log.fine("REJECTED " + url.toNormalform(true) + " - " + reason);
        }
        if (!this.cache.containsKey(ASCII.String(url.hash()))) {
            CollectionConfiguration.FailDoc failDoc = new CollectionConfiguration.FailDoc(url, profile2 == null ? null : profile2.collections(), failCategory.name() + " " + reason, failCategory.failType, httpcode, crawldepth);
            if (this.sb.index.fulltext().getDefaultConnector() != null && failCategory.store && !RobotsTxt.isRobotsURL(url)) {
                try {
                    SolrDocument olddoc = this.sb.index.fulltext().getDefaultConnector().getDocumentById(ASCII.String(failDoc.getDigestURL().hash()), CollectionSchema.httpstatus_i.getSolrFieldName());
                    if (olddoc == null || olddoc.getFieldValue(CollectionSchema.httpstatus_i.getSolrFieldName()) == null || (Integer)olddoc.getFieldValue(CollectionSchema.httpstatus_i.getSolrFieldName()) == 200) {
                        SolrInputDocument errorDoc = failDoc.toSolr(this.sb.index.fulltext().getDefaultConfiguration());
                        this.sb.index.fulltext().getDefaultConnector().add(errorDoc);
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.warn("SOLR", "failed to send error " + url.toNormalform(true) + " to solr: " + e.getMessage());
                }
            }
            Map<String, CollectionConfiguration.FailDoc> map = this.cache;
            synchronized (map) {
                this.cache.put(ASCII.String(url.hash()), failDoc);
            }
            this.checkStackSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStackSize() {
        Map<String, CollectionConfiguration.FailDoc> map = this.cache;
        synchronized (map) {
            int dc = this.cache.size() - 1000;
            if (dc > 0) {
                ArrayList<String> d = new ArrayList<String>();
                Iterator<String> i = this.cache.keySet().iterator();
                while (dc-- > 0 && i.hasNext()) {
                    d.add(i.next());
                }
                for (String s : d) {
                    this.cache.remove(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CollectionConfiguration.FailDoc> list(int max) {
        ArrayList<CollectionConfiguration.FailDoc> l = new ArrayList<CollectionConfiguration.FailDoc>();
        Map<String, CollectionConfiguration.FailDoc> map = this.cache;
        synchronized (map) {
            Iterator<Map.Entry<String, CollectionConfiguration.FailDoc>> hi = this.cache.entrySet().iterator();
            for (int i = 0; i < this.cache.size() - max; ++i) {
                hi.next();
            }
            while (hi.hasNext()) {
                try {
                    SolrDocument doc;
                    Map.Entry<String, CollectionConfiguration.FailDoc> entry2 = hi.next();
                    String hash = entry2.getKey();
                    CollectionConfiguration.FailDoc failDoc = entry2.getValue();
                    if (failDoc == null && (doc = this.sb.index.fulltext().getDefaultConnector().getDocumentById(hash, new String[0])) != null) {
                        failDoc = new CollectionConfiguration.FailDoc(doc);
                    }
                    if (failDoc == null) continue;
                    l.add(failDoc);
                }
                catch (IOException iOException) {}
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStack() {
        Map<String, CollectionConfiguration.FailDoc> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stackSize() {
        Map<String, CollectionConfiguration.FailDoc> map = this.cache;
        synchronized (map) {
            return this.cache.size();
        }
    }
}

