/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.opensearch.SRURSSConnector;
import net.yacy.cora.federate.solr.connector.RemoteSolrConnector;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.BookmarksDB;
import net.yacy.kelondro.workflow.AbstractBusyThread;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;

public class AutoSearch
extends AbstractBusyThread {
    private Set<String> querystack;
    public String currentQuery;
    private Set<String> currentTargets;
    final Switchboard sb;
    public int gotresults;
    private long lastInitTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoSearch(Switchboard xsb) {
        block12: {
            super(3000L, 1000L);
            this.currentQuery = null;
            this.currentTargets = null;
            this.setIdleSleep(60000L);
            this.setBusySleep(10000L);
            this.sb = xsb;
            this.gotresults = 0;
            this.querystack = new HashSet<String>();
            this.lastInitTime = System.currentTimeMillis() - 600000L;
            if (!this.checkBookmarkDB()) {
                try {
                    File pfile = new File(xsb.dataPath, "DATA/SETTINGS/autosearch.conf");
                    if (!pfile.exists()) break block12;
                    ConcurrentLog.info(AutoSearch.class.getName(), "read queries from file " + pfile.getAbsolutePath());
                    Properties prop = new Properties();
                    FileInputStream fileIn = new FileInputStream(pfile);
                    try {
                        prop.load(fileIn);
                    }
                    finally {
                        try {
                            fileIn.close();
                        }
                        catch (IOException ioe) {
                            ConcurrentLog.warn(AutoSearch.class.getName(), "Could not close input stream on file " + pfile);
                        }
                    }
                    if (prop.size() > 0) {
                        Set<Object> all2 = prop.keySet();
                        for (Object s : all2) {
                            String query2 = prop.getProperty((String)s);
                            if (query2 == null || query2.isEmpty()) continue;
                            this.querystack.add(query2);
                        }
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.warn(AutoSearch.class.getName(), "Error reading config file");
                }
            }
        }
    }

    private void saveasPropFile() {
        File pfile = new File(this.sb.dataPath, "DATA/SETTINGS/autosearch.conf");
        if (this.querystack.size() == 0) {
            if (pfile.exists()) {
                pfile.delete();
            }
        } else {
            try (FileOutputStream fileOut = new FileOutputStream(pfile);){
                Properties prop = new Properties();
                for (String s : this.querystack) {
                    prop.put("query" + s.hashCode(), s);
                }
                prop.store(fileOut, "AutoSearch query list");
            }
            catch (FileNotFoundException ex) {
                ConcurrentLog.warn(AutoSearch.class.getName(), "can not create file " + pfile.getAbsolutePath());
            }
            catch (IOException ex) {
                ConcurrentLog.warn(AutoSearch.class.getName(), "IO error writing to file " + pfile.getAbsolutePath());
            }
        }
    }

    private void initPeerList() {
        if (this.currentTargets == null) {
            this.currentTargets = new HashSet<String>();
        }
        Iterator<Seed> it = Switchboard.getSwitchboard().peers.seedsConnected(true, false, null, 0.0);
        while (it.hasNext()) {
            Seed s = it.next();
            this.currentTargets.add(s.hash);
        }
    }

    private boolean checkBookmarkDB() {
        if (Switchboard.getSwitchboard().bookmarksDB != null) {
            int added = 0;
            Iterator<BookmarksDB.Bookmark> it = Switchboard.getSwitchboard().bookmarksDB.getBookmarksIterator();
            if (it != null) {
                while (it.hasNext()) {
                    String query2;
                    BookmarksDB.Bookmark bmk = it.next();
                    if (!bmk.getFoldersString().startsWith("/search") || bmk.getTimeStamp() < this.lastInitTime || (query2 = bmk.getQuery()) == null || query2.isEmpty()) continue;
                    this.querystack.add(query2);
                    ++added;
                    ConcurrentLog.info(AutoSearch.class.getName(), "add query from Bookmarks: query=" + query2);
                }
            }
            if (added > 0) {
                this.lastInitTime = System.currentTimeMillis();
                this.saveasPropFile();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean job() {
        if (this.currentQuery == null && this.querystack != null && this.querystack.size() > 0) {
            this.currentQuery = this.querystack.iterator().next();
            this.querystack.remove(this.currentQuery);
            this.initPeerList();
        }
        if (this.currentQuery != null && !this.currentQuery.isEmpty()) {
            if (this.currentTargets != null && !this.currentTargets.isEmpty()) {
                while (this.currentTargets.size() > 0) {
                    String peerhash = this.currentTargets.iterator().next();
                    this.currentTargets.remove(peerhash);
                    Seed seed = Switchboard.getSwitchboard().peers.getConnected(peerhash);
                    if (seed == null) continue;
                    this.processSingleTarget(seed);
                    return true;
                }
            }
            this.currentQuery = null;
        }
        this.checkBookmarkDB();
        ConcurrentLog.fine(AutoSearch.class.getName(), "nothing to do");
        return this.querystack.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processSingleTarget(Seed seed) {
        Set<String> ips = seed.getIPs();
        if (ips.isEmpty()) {
            ConcurrentLog.warn(AutoSearch.class.getName(), "no known IP address for peer " + seed.getName());
            return;
        }
        String ip = ips.iterator().next();
        ConcurrentLog.fine(AutoSearch.class.getName(), "ask " + ip + " " + seed.getName() + " for query=" + this.currentQuery);
        boolean preferHttps = this.sb.getConfigBool("remotesearch.https.preferred", false);
        String targetBaseURL = seed.getPublicURL(ip, preferHttps);
        if (seed.getFlagSolrAvailable()) {
            SolrDocumentList docList = null;
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.set("q", new String[]{this.currentQuery + " AND (" + CollectionSchema.httpstatus_i.name() + ":200)"});
            solrQuery.set("q.op", new String[]{"AND"});
            solrQuery.set("rows", new String[]{this.sb.getConfig("remotesearch.maxcount", "20")});
            this.setName("Protocol.solrQuery(" + solrQuery.getQuery() + " to " + seed.hash + ")");
            try {
                block19: {
                    boolean trustSelfSignedOnAuthenticatedServer = this.sb.getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false);
                    try (RemoteInstance instance = new RemoteInstance(targetBaseURL + "/solr/", null, null, 10000, trustSelfSignedOnAuthenticatedServer, Long.MAX_VALUE, false);){
                        RemoteSolrConnector solrConnector = new RemoteSolrConnector(instance, this.sb.getConfigBool("remote.solr.binaryResponse.enabled", true), null);
                        if (solrConnector.isClosed()) break block19;
                        try {
                            QueryResponse rsp = solrConnector.getResponseByParams((ModifiableSolrParams)solrQuery);
                            docList = rsp.getResults();
                            solrConnector.close();
                        }
                        catch (Throwable rsp) {
                            solrConnector.close();
                            break block19;
                            catch (Throwable throwable) {
                                solrConnector.close();
                                throw throwable;
                            }
                        }
                    }
                }
                if (docList != null) {
                    for (SolrDocument d : docList) {
                        this.sb.index.fulltext().putDocument(this.sb.index.fulltext().getDefaultConfiguration().toSolrInputDocument(d));
                        ++this.gotresults;
                    }
                    ConcurrentLog.info(AutoSearch.class.getName(), "added " + docList.size() + " results from " + seed.getName() + " to index for solrquery=" + this.currentQuery);
                }
            }
            catch (Throwable trustSelfSignedOnAuthenticatedServer) {}
        } else {
            String rssSearchServiceURL = targetBaseURL + "/yacysearch.rss";
            try {
                RSSFeed feed2 = SRURSSConnector.loadSRURSS(rssSearchServiceURL, this.currentQuery, 0, this.sb.getConfigInt("remotesearch.maxcount", 20), CacheStrategy.IFFRESH, false, ClientIdentification.yacyInternetCrawlerAgent);
                ArrayList<DigestURL> urls2 = new ArrayList<DigestURL>();
                for (MultiProtocolURL entry2 : feed2.getLinks()) {
                    urls2.add(new DigestURL(entry2, (byte[])null));
                    ++this.gotresults;
                }
                this.sb.addToCrawler(urls2, false);
                ConcurrentLog.info(AutoSearch.class.getName(), "added " + urls2.size() + " results from " + seed.getName() + " to index for query=" + this.currentQuery);
            }
            catch (IOException ex) {
                ConcurrentLog.info(AutoSearch.class.getName(), "no answer from " + seed.getName());
            }
        }
    }

    @Override
    public int getJobCount() {
        if (this.currentTargets != null) {
            int cnt = this.currentTargets.size();
            return cnt += this.querystack.size() * this.sb.peers.sizeConnected();
        }
        return 0;
    }

    @Override
    public void freemem() {
    }

    @Override
    public void close() {
        this.saveasPropFile();
    }
}

