/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.repository;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.ListManager;
import net.yacy.kelondro.util.SetTools;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;

public final class BlacklistHelper {
    public static final String APP_NAME = "Blacklist";
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("(^\\^?[a-z\\?]+://).+");

    private BlacklistHelper() {
    }

    public static String prepareEntry(String entry2) {
        Object newEntry = entry2;
        Matcher schemeMatcher = URL_SCHEME_PATTERN.matcher((CharSequence)newEntry);
        if (schemeMatcher.matches()) {
            newEntry = ((String)newEntry).substring(schemeMatcher.end(1));
        }
        if (((String)newEntry).indexOf("*") < 0 && ((String)newEntry).indexOf("?") < 0 && ((String)newEntry).indexOf("+") < 0) {
            newEntry = ".*" + (String)newEntry + ".*/.*";
            newEntry = ".*.*/.*" + (String)newEntry + ".*";
        } else {
            int pos = ((String)newEntry).indexOf(47, 0);
            if (pos < 0) {
                newEntry = (String)newEntry + "/.*";
            }
        }
        return newEntry;
    }

    public static boolean addBlacklistEntry(String blacklistToUse, String entry2) {
        String newEntry = entry2;
        if (blacklistToUse == null || blacklistToUse.isEmpty() || newEntry == null || newEntry.isEmpty()) {
            return false;
        }
        newEntry = BlacklistHelper.prepareEntry(newEntry);
        int pos = newEntry.indexOf(47, 0);
        String host = newEntry.substring(0, pos);
        String path = newEntry.substring(pos + 1);
        boolean success = false;
        for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
            if (!ListManager.listSetContains(supportedBlacklistType + ".BlackLists", blacklistToUse)) continue;
            try {
                Switchboard.urlBlacklist.add(supportedBlacklistType, blacklistToUse, host, path);
                success = true;
            }
            catch (PatternSyntaxException | Punycode.PunycodeException e) {
                ConcurrentLog.info(APP_NAME, "Unable to add blacklist entry to blacklist " + supportedBlacklistType, e);
            }
        }
        SearchEventCache.cleanupEvents(true);
        return success;
    }

    public static String deleteBlacklistEntry(String blacklistToUse, String entry2, RequestHeader header) {
        String oldEntry = entry2;
        Object location = null;
        if (blacklistToUse == null || blacklistToUse.isEmpty()) {
            location = header.getPathInfo();
        } else if (oldEntry == null || oldEntry.isEmpty()) {
            location = header.getPathInfo() + "?selectList=&selectedListName=" + blacklistToUse;
        }
        if (location != null) {
            if (((String)location).startsWith("/")) {
                location = ((String)location).substring(1, ((String)location).length());
            }
            return location;
        }
        int pos = oldEntry.indexOf(47, 0);
        String host = oldEntry.substring(0, pos);
        String path = "";
        if (pos > 0) {
            path = oldEntry.substring(pos + 1);
        }
        for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
            if (!ListManager.listSetContains(supportedBlacklistType + ".BlackLists", blacklistToUse)) continue;
            Switchboard.urlBlacklist.remove(supportedBlacklistType, blacklistToUse, host, path);
        }
        SearchEventCache.cleanupEvents(true);
        return null;
    }

    public static String[] blacklistToSortedArray(String blacklistToUse) {
        SortedMap<String, List<String>> blklist = SetTools.loadMapMultiValsPerKey(ListManager.listsPath + "/" + blacklistToUse, "/");
        ArrayList<CallSite> list2 = new ArrayList<CallSite>();
        for (String it : blklist.keySet()) {
            List thevalue = (List)blklist.get(it);
            for (String valitem : thevalue) {
                list2.add((CallSite)((Object)(it + "/" + valitem)));
            }
        }
        String[] sortedlist = new String[list2.size()];
        Arrays.sort(list2.toArray(sortedlist));
        return sortedlist;
    }
}

