/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.date.MicroDate;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.document.Document;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.AbstractReference;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.rwi.ReferenceFactory;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;

public class WebStructureGraph {
    public static final int maxref = 200;
    public static final int maxhosts = 10000;
    public static final int MAX_PARSED_ANCHORS = 1000;
    private static final ConcurrentLog log = new ConcurrentLog("WebStructureGraph");
    private final File structureFile;
    private final TreeMap<String, byte[]> structure_old = new TreeMap();
    private final TreeMap<String, byte[]> structure_new = new TreeMap();
    private final BlockingQueue<LearnObject> publicRefDNSResolvingQueue;
    private final PublicRefDNSResolvingProcess publicRefDNSResolvingWorker;
    private static final LearnObject leanrefObjectPOISON = new LearnObject(null, null);
    public static final HostReferenceFactory hostReferenceFactory = new HostReferenceFactory();
    private static ReferenceContainerCache<HostReference> hostReferenceIndexCache = null;
    private static long hostReferenceIndexCacheTime = 0L;
    private static final long hostReferenceIndexCacheTTL = 43200000L;

    public WebStructureGraph(File structureFile) {
        AbstractMap loadedStructureB;
        this.structureFile = structureFile;
        this.publicRefDNSResolvingQueue = new LinkedBlockingQueue<LearnObject>();
        try {
            if (this.structureFile != null && this.structureFile.exists()) {
                loadedStructureB = FileUtils.loadMapB(this.structureFile);
                log.info("loaded dump of " + loadedStructureB.size() + " entries from " + this.structureFile.toString());
            } else {
                loadedStructureB = new TreeMap();
            }
        }
        catch (OutOfMemoryError e) {
            loadedStructureB = new TreeMap();
        }
        this.structure_old.putAll(loadedStructureB);
        if (this.structure_old.size() > 10000) {
            TreeSet<CallSite> delset = new TreeSet<CallSite>();
            for (Map.Entry<String, byte[]> entry2 : this.structure_old.entrySet()) {
                String key = entry2.getKey();
                byte[] value = entry2.getValue();
                if (value == null || value.length < 8) continue;
                delset.add((CallSite)((Object)(UTF8.String(value).substring(0, 8) + key)));
            }
            Iterator j = delset.iterator();
            for (int delcount = this.structure_old.size() - 9000; delcount > 0 && j.hasNext(); --delcount) {
                this.structure_old.remove(((String)j.next()).substring(8));
            }
        }
        this.publicRefDNSResolvingWorker = new PublicRefDNSResolvingProcess();
        this.publicRefDNSResolvingWorker.start();
    }

    public void clear() {
        this.structure_old.clear();
        this.structure_new.clear();
    }

    public void generateCitationReference(DigestURL url, Document document) {
        Map<AnchorURL, String> hl = document.getHyperlinks();
        Iterator<AnchorURL> it = hl.keySet().iterator();
        HashSet<DigestURL> globalRefURLs = new HashSet<DigestURL>();
        String refhost = url.getHost();
        int maxref = 1000;
        while (it.hasNext() && maxref-- > 0) {
            DigestURL u = it.next();
            if (u == null || refhost == null || u.getHost() == null || u.getHost().equals(refhost)) continue;
            globalRefURLs.add(u);
        }
        LearnObject lro = new LearnObject(url, globalRefURLs);
        if (!globalRefURLs.isEmpty()) {
            try {
                if (this.publicRefDNSResolvingWorker.isAlive()) {
                    this.publicRefDNSResolvingQueue.put(lro);
                } else {
                    this.learnrefs(lro);
                }
            }
            catch (InterruptedException e) {
                this.learnrefs(lro);
            }
        }
    }

    public void generateCitationReference(DigestURL from, DigestURL to) {
        HashSet<DigestURL> globalRefURLs = new HashSet<DigestURL>();
        String refhost = from.getHost();
        if (refhost != null && to.getHost() != null && !to.getHost().equals(refhost)) {
            globalRefURLs.add(to);
        }
        LearnObject lro = new LearnObject(from, globalRefURLs);
        if (!globalRefURLs.isEmpty()) {
            try {
                if (this.publicRefDNSResolvingWorker.isAlive()) {
                    this.publicRefDNSResolvingQueue.put(lro);
                } else {
                    this.learnrefs(lro);
                }
            }
            catch (InterruptedException e) {
                this.learnrefs(lro);
            }
        }
    }

    private static int refstr2count(String refs) {
        if (refs == null || refs.length() <= 8) {
            return 0;
        }
        assert ((refs.length() - 8) % 10 == 0) : "refs = " + refs + ", length = " + refs.length();
        return (refs.length() - 8) / 10;
    }

    private static Map<String, Integer> refstr2map(String refs) {
        if (refs == null || refs.length() <= 8) {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int refsc = WebStructureGraph.refstr2count(refs);
        for (int i = 0; i < refsc; ++i) {
            int d;
            String c = refs.substring(8 + i * 10, 8 + (i + 1) * 10);
            try {
                d = Integer.valueOf(c.substring(6), 16);
            }
            catch (NumberFormatException e) {
                d = 1;
            }
            map.put(c.substring(0, 6), d);
        }
        return map;
    }

    private static String none2refstr() {
        return GenericFormatter.SHORT_DAY_FORMATTER.format();
    }

    private static String map2refstr(Map<String, Integer> map) {
        StringBuilder s = new StringBuilder("yyyyMMdd".length() + map.size() * 10);
        s.append(GenericFormatter.SHORT_DAY_FORMATTER.format());
        for (Map.Entry<String, Integer> entry2 : map.entrySet()) {
            s.append(entry2.getKey());
            String h = Integer.toHexString(entry2.getValue());
            int hl = h.length();
            if (hl == 0) {
                s.append("0000");
                continue;
            }
            if (hl == 1) {
                s.append("000").append(h);
                continue;
            }
            if (hl == 2) {
                s.append("00").append(h);
                continue;
            }
            if (hl == 3) {
                s.append('0').append(h);
                continue;
            }
            if (hl == 4) {
                s.append(h);
                continue;
            }
            s.append("FFFF");
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String hosthash) {
        String key;
        SortedMap<String, byte[]> tailMap;
        assert (hosthash.length() == 6);
        TreeMap<String, byte[]> treeMap = this.structure_old;
        synchronized (treeMap) {
            tailMap = this.structure_old.tailMap(hosthash);
            if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                return true;
            }
        }
        treeMap = this.structure_new;
        synchronized (treeMap) {
            tailMap = this.structure_new.tailMap(hosthash);
            if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureEntry outgoingReferences(String hosthash) {
        String ref;
        String key;
        SortedMap<String, byte[]> tailMap;
        assert (hosthash.length() == 6);
        HashMap<String, Integer> h = new HashMap();
        String hostname = "";
        String date = "";
        TreeMap<String, byte[]> treeMap = this.structure_old;
        synchronized (treeMap) {
            tailMap = this.structure_old.tailMap(hosthash);
            if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                hostname = key.substring(7);
                ref = ASCII.String((byte[])tailMap.get(key));
                date = ref.substring(0, 8);
                h = WebStructureGraph.refstr2map(ref);
            }
        }
        treeMap = this.structure_new;
        synchronized (treeMap) {
            tailMap = this.structure_new.tailMap(hosthash);
            if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                ref = ASCII.String((byte[])tailMap.get(key));
                if (hostname.isEmpty()) {
                    hostname = key.substring(7);
                }
                if (date.isEmpty()) {
                    date = ref.substring(0, 8);
                }
                h.putAll(WebStructureGraph.refstr2map(ref));
            }
        }
        if (h.isEmpty()) {
            return null;
        }
        return new StructureEntry(hosthash, hostname, date, h);
    }

    public Map<String, Integer> outgoingReferencesByHostName(String srcHostName) {
        Set<String> srcHostHashes = this.hostName2HostHashes(srcHostName);
        HashMap<String, Integer> targetHashesToCount = new HashMap<String, Integer>();
        for (String srcHostHash : srcHostHashes) {
            StructureEntry sr = this.outgoingReferences(srcHostHash);
            if (sr == null) continue;
            for (Map.Entry<String, Integer> ref : sr.references.entrySet()) {
                Integer refsNb = (Integer)targetHashesToCount.get(ref.getKey());
                if (refsNb != null) {
                    if (ref.getValue() != null) {
                        refsNb = refsNb + ref.getValue();
                    }
                } else {
                    refsNb = ref.getValue() != null ? ref.getValue() : Integer.valueOf(0);
                }
                targetHashesToCount.put(ref.getKey(), refsNb);
            }
        }
        return targetHashesToCount;
    }

    public StructureEntry incomingReferences(String hosthash) {
        StructureEntry sentry;
        String hostname = this.hostHash2hostName(hosthash);
        if (hostname == null) {
            return null;
        }
        HashMap<String, Integer> hosthashes = new HashMap<String, Integer>();
        StructureIterator i = new StructureIterator(false);
        while (i.hasNext()) {
            sentry = (StructureEntry)i.next();
            if (!sentry.references.containsKey(hosthash)) continue;
            hosthashes.put(sentry.hosthash, sentry.references.get(hosthash));
        }
        i = new StructureIterator(true);
        while (i.hasNext()) {
            sentry = (StructureEntry)i.next();
            if (!sentry.references.containsKey(hosthash)) continue;
            hosthashes.put(sentry.hosthash, sentry.references.get(hosthash));
        }
        return new StructureEntry(hosthash, hostname, GenericFormatter.SHORT_DAY_FORMATTER.format(), hosthashes);
    }

    public synchronized ReferenceContainerCache<HostReference> incomingReferences() {
        if (hostReferenceIndexCache != null && hostReferenceIndexCacheTime + 43200000L > System.currentTimeMillis()) {
            return hostReferenceIndexCache;
        }
        ReferenceContainerCache<HostReference> idx2 = new ReferenceContainerCache<HostReference>(hostReferenceFactory, Base64Order.enhancedCoder, 6);
        this.incomingReferencesEnrich(idx2, new StructureIterator(false), 3000L);
        this.incomingReferencesEnrich(idx2, new StructureIterator(true), 3000L);
        hostReferenceIndexCache = idx2;
        hostReferenceIndexCacheTime = System.currentTimeMillis();
        return hostReferenceIndexCache;
    }

    private void incomingReferencesEnrich(ReferenceContainerCache<HostReference> idx2, Iterator<StructureEntry> structureIterator, long time) {
        long timeout;
        long l = timeout = time == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + time;
        while (structureIterator.hasNext()) {
            StructureEntry sentry = structureIterator.next();
            for (Map.Entry<String, Integer> refhosthashandcounter : sentry.references.entrySet()) {
                HostReference hr;
                byte[] term = UTF8.getBytes(refhosthashandcounter.getKey());
                try {
                    hr = new HostReference(ASCII.getBytes(sentry.hosthash), GenericFormatter.SHORT_DAY_FORMATTER.parse(sentry.date, 0).getTime().getTime(), refhosthashandcounter.getValue());
                }
                catch (ParseException e) {
                    continue;
                }
                ReferenceContainer<HostReference> r = idx2.get(term, null);
                try {
                    if (r == null) {
                        r = new ReferenceContainer<HostReference>(hostReferenceFactory, term);
                        r.add(hr);
                        idx2.add(r);
                        continue;
                    }
                    r.put(hr);
                }
                catch (SpaceExceededException e) {}
            }
            if (System.currentTimeMillis() <= timeout) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int referencesCount(String hosthash) {
        assert (hosthash.length() == 6) : "hosthash = " + hosthash;
        if (hosthash == null || hosthash.length() != 6) {
            return 0;
        }
        int c = 0;
        try {
            String key;
            SortedMap<String, byte[]> tailMap;
            TreeMap<String, byte[]> treeMap = this.structure_old;
            synchronized (treeMap) {
                tailMap = this.structure_old.tailMap(hosthash);
                if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                    c = WebStructureGraph.refstr2count(UTF8.String((byte[])tailMap.get(key)));
                }
            }
            treeMap = this.structure_new;
            synchronized (treeMap) {
                tailMap = this.structure_new.tailMap(hosthash);
                if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                    c += WebStructureGraph.refstr2count(UTF8.String((byte[])tailMap.get(key)));
                }
            }
        }
        catch (Throwable t) {
            this.clear();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hostHash2hostName(String hosthash) {
        String key;
        SortedMap<String, byte[]> tailMap;
        assert (hosthash.length() == 6);
        TreeMap<String, byte[]> treeMap = this.structure_old;
        synchronized (treeMap) {
            tailMap = this.structure_old.tailMap(hosthash);
            if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                return key.substring(7);
            }
        }
        treeMap = this.structure_new;
        synchronized (treeMap) {
            tailMap = this.structure_new.tailMap(hosthash);
            if (!tailMap.isEmpty() && (key = tailMap.firstKey()).startsWith(hosthash)) {
                return key.substring(7);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hostName2HostHashes(String hostName) {
        String keyHostName;
        String hash;
        HashSet<String> hashes = new HashSet<String>();
        TreeMap<String, byte[]> treeMap = this.structure_old;
        synchronized (treeMap) {
            for (String key : this.structure_old.keySet()) {
                hash = key.substring(0, 6);
                keyHostName = key.substring(7);
                if (!keyHostName.equalsIgnoreCase(hostName)) continue;
                hashes.add(hash);
            }
        }
        treeMap = this.structure_new;
        synchronized (treeMap) {
            for (String key : this.structure_new.keySet()) {
                hash = key.substring(0, 6);
                keyHostName = key.substring(7);
                if (!keyHostName.equalsIgnoreCase(hostName)) continue;
                hashes.add(hash);
            }
        }
        return hashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void learnrefs(LearnObject lro) {
        DigestURL url = lro.url;
        String sourceHosthash = url.hosthash();
        StructureEntry structure = this.outgoingReferences(sourceHosthash);
        Map<Object, Object> refs = structure == null ? new HashMap() : structure.references;
        for (DigestURL u : lro.globalRefURLs) {
            String domain = u.hosthash();
            if (Switchboard.getSwitchboard() != null && Switchboard.getSwitchboard().shallTerminate()) break;
            if (!this.exists(domain)) {
                TreeMap<String, byte[]> treeMap = this.structure_new;
                synchronized (treeMap) {
                    this.structure_new.put(domain + "," + u.getHost(), UTF8.getBytes(WebStructureGraph.none2refstr()));
                }
            }
            int c = 0;
            Integer existingCount = (Integer)refs.get(domain);
            if (existingCount != null) {
                c = existingCount;
            }
            refs.put(domain, ++c);
        }
        if (refs.size() > 200) {
            for (int shrink = refs.size() - 180; shrink > 0; --shrink) {
                int minrefcount = Integer.MAX_VALUE;
                String minrefkey = null;
                for (Map.Entry entry2 : refs.entrySet()) {
                    if ((Integer)entry2.getValue() < minrefcount) {
                        minrefcount = (Integer)entry2.getValue();
                        minrefkey = (String)entry2.getKey();
                    }
                    if (minrefcount != 1) continue;
                    break;
                }
                if (minrefkey == null) break;
                refs.remove(minrefkey);
            }
        }
        TreeMap<String, byte[]> treeMap = this.structure_new;
        synchronized (treeMap) {
            this.structure_new.put(sourceHosthash + "," + url.getHost(), UTF8.getBytes(WebStructureGraph.map2refstr(refs)));
        }
    }

    private static void joinStructure(TreeMap<String, byte[]> into, TreeMap<String, byte[]> from) {
        for (Map.Entry<String, byte[]> e : from.entrySet()) {
            if (into.containsKey(e.getKey())) {
                Map<String, Integer> s0 = WebStructureGraph.refstr2map(UTF8.String(into.get(e.getKey())));
                Map<String, Integer> s1 = WebStructureGraph.refstr2map(UTF8.String(e.getValue()));
                for (Map.Entry<String, Integer> r : s1.entrySet()) {
                    if (s0.containsKey(r.getKey())) {
                        s0.put(r.getKey(), s0.get(r.getKey()) + r.getValue());
                        continue;
                    }
                    s0.put(r.getKey(), (int)r.getValue());
                }
                into.put(e.getKey(), UTF8.getBytes(WebStructureGraph.map2refstr(s0)));
                continue;
            }
            into.put(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinOldNew() {
        TreeMap<String, byte[]> treeMap = this.structure_new;
        synchronized (treeMap) {
            WebStructureGraph.joinStructure(this.structure_old, this.structure_new);
            this.structure_new.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hostWithMaxReferences() {
        Integer refsNb;
        String hostName;
        int refsize;
        TreeMap<String, Integer> hostNamesToRefsNb = new TreeMap<String, Integer>();
        int maxref = 0;
        String maxHostName = null;
        TreeMap<String, byte[]> treeMap = this.structure_old;
        synchronized (treeMap) {
            for (Map.Entry<String, byte[]> entry2 : this.structure_old.entrySet()) {
                refsize = entry2.getValue().length;
                hostName = entry2.getKey().substring(7);
                refsNb = (Integer)hostNamesToRefsNb.get(hostName);
                refsNb = refsNb == null ? Integer.valueOf(refsize) : Integer.valueOf(refsNb + refsize);
                if (refsNb > maxref) {
                    maxref = refsNb;
                    maxHostName = hostName;
                }
                hostNamesToRefsNb.put(hostName, refsNb);
            }
        }
        treeMap = this.structure_new;
        synchronized (treeMap) {
            for (Map.Entry<String, byte[]> entry2 : this.structure_new.entrySet()) {
                refsize = entry2.getValue().length;
                hostName = entry2.getKey().substring(7);
                refsNb = (Integer)hostNamesToRefsNb.get(hostName);
                refsNb = refsNb == null ? Integer.valueOf(refsize) : Integer.valueOf(refsNb + refsize);
                if (refsNb > maxref) {
                    maxref = refsNb;
                    maxHostName = hostName;
                }
                hostNamesToRefsNb.put(hostName, refsNb);
            }
        }
        return maxHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReversibleScoreMap<String> hostReferenceScore() {
        ClusteredScoreMap<String> result = new ClusteredScoreMap<String>(ASCII.identityASCIIComparator);
        TreeMap<String, byte[]> treeMap = this.structure_old;
        synchronized (treeMap) {
            for (Map.Entry<String, byte[]> entry2 : this.structure_old.entrySet()) {
                result.set(entry2.getKey().substring(7), (entry2.getValue().length - 8) / 10);
            }
        }
        treeMap = this.structure_new;
        synchronized (treeMap) {
            for (Map.Entry<String, byte[]> entry2 : this.structure_new.entrySet()) {
                result.set(entry2.getKey().substring(7), (entry2.getValue().length - 8) / 10);
            }
        }
        return result;
    }

    public Iterator<StructureEntry> structureEntryIterator(boolean latest) {
        return new StructureIterator(latest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.publicRefDNSResolvingWorker.isAlive()) {
            log.info("Waiting for the DNS Resolving Queue to terminate");
            try {
                this.publicRefDNSResolvingQueue.put(leanrefObjectPOISON);
                this.publicRefDNSResolvingWorker.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.structureFile != null) {
            log.info("Saving Web Structure File: new = " + this.structure_new.size() + " entries, old = " + this.structure_old.size() + " entries");
            long time = System.currentTimeMillis();
            this.joinOldNew();
            log.info("dumping " + this.structure_old.size() + " entries to " + this.structureFile.toString());
            if (!this.structure_old.isEmpty()) {
                TreeMap<String, byte[]> treeMap = this.structure_old;
                synchronized (treeMap) {
                    if (!this.structure_old.isEmpty()) {
                        FileUtils.saveMapB(this.structureFile, this.structure_old, "Web Structure Syntax: <b64hash(6)>','<host> to <date-yyyymmdd(8)>{<target-b64hash(6)><target-count-hex(4)>}*");
                        long t = Math.max(1L, System.currentTimeMillis() - time);
                        log.info("Saved Web Structure File: " + this.structure_old.size() + " entries in " + t + " milliseconds, " + (long)(this.structure_old.size() * 1000) / t + " entries/second");
                    }
                    this.structure_old.clear();
                }
            }
        }
    }

    private class PublicRefDNSResolvingProcess
    extends Thread {
        private PublicRefDNSResolvingProcess() {
            super("WebStructureGraph.PublicRefDNSResolvingProcess");
        }

        @Override
        public void run() {
            try {
                LearnObject lro;
                while ((lro = WebStructureGraph.this.publicRefDNSResolvingQueue.take()) != leanrefObjectPOISON) {
                    WebStructureGraph.this.learnrefs(lro);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected static class LearnObject {
        private final DigestURL url;
        private final Set<DigestURL> globalRefURLs;

        protected LearnObject(DigestURL url, Set<DigestURL> globalRefURLs) {
            this.url = url;
            this.globalRefURLs = globalRefURLs;
        }
    }

    public static class StructureEntry
    implements Comparable<StructureEntry> {
        public String hosthash;
        public String hostname;
        public String date;
        public Map<String, Integer> references;

        private StructureEntry(String hosthash, String hostname) {
            this(hosthash, hostname, GenericFormatter.SHORT_DAY_FORMATTER.format(), new HashMap<String, Integer>());
        }

        private StructureEntry(String hosthash, String hostname, String date, Map<String, Integer> references) {
            this.hosthash = hosthash;
            this.hostname = hostname;
            this.date = date;
            this.references = references;
        }

        @Override
        public int compareTo(StructureEntry arg0) {
            return this.hosthash.compareTo(arg0.hosthash);
        }

        public boolean equals(Object o) {
            if (!(o instanceof StructureEntry)) {
                return false;
            }
            return this.hosthash.equals(((StructureEntry)o).hosthash);
        }

        public int hashCode() {
            return this.hosthash.hashCode();
        }
    }

    private class StructureIterator
    extends LookAheadIterator<StructureEntry>
    implements Iterator<StructureEntry> {
        private final Iterator<Map.Entry<String, byte[]>> i;

        private StructureIterator(boolean latest) {
            this.i = (latest ? WebStructureGraph.this.structure_new : WebStructureGraph.this.structure_old).entrySet().iterator();
        }

        @Override
        public StructureEntry next0() {
            Map.Entry<String, byte[]> entry2 = null;
            String dom = null;
            byte[] ref = null;
            while (this.i.hasNext()) {
                entry2 = this.i.next();
                ref = entry2.getValue();
                if ((ref.length - 8) % 10 != 0) continue;
                dom = entry2.getKey();
                if (dom.length() >= 8) break;
                dom = null;
            }
            if (entry2 == null || dom == null) {
                return null;
            }
            assert ((ref.length - 8) % 10 == 0) : "refs = " + ref + ", length = " + ref.length;
            String refs = UTF8.String(ref);
            return new StructureEntry(dom.substring(0, 6), dom.substring(7), refs.substring(0, 8), WebStructureGraph.refstr2map(refs));
        }
    }

    public static class HostReferenceFactory
    implements ReferenceFactory<HostReference>,
    Serializable {
        private static final long serialVersionUID = 7461135579006223155L;
        private static final Row hostReferenceRow = new Row("String h-6, Cardinal m-4 {b256}, Cardinal c-4 {b256}", (ByteOrder)Base64Order.enhancedCoder);

        @Override
        public Row getRow() {
            return hostReferenceRow;
        }

        @Override
        public HostReference produceSlow(Row.Entry e) {
            return new HostReference(e);
        }

        @Override
        public HostReference produceFast(HostReference e, boolean local) {
            return e;
        }
    }

    public static class HostReference
    extends AbstractReference
    implements Reference,
    Serializable {
        private static final long serialVersionUID = -9170091435821206765L;
        private final Row.Entry entry;

        private HostReference(byte[] hostHash, long modified, int count) {
            assert (hostHash.length == 6) : "hostHash = " + ASCII.String(hostHash);
            this.entry = hostReferenceFactory.getRow().newEntry();
            this.entry.setCol(0, hostHash);
            this.entry.setCol(1, MicroDate.microDateDays(modified));
            this.entry.setCol(2, count);
        }

        public HostReference(String json) {
            this.entry = hostReferenceFactory.getRow().newEntry(json, true);
        }

        private HostReference(Row.Entry entry2) {
            this.entry = entry2;
        }

        @Override
        public String toPropertyForm() {
            return this.entry.toPropertyForm(':', true, true, false, true);
        }

        @Override
        public Row.Entry toKelondroEntry() {
            return this.entry;
        }

        @Override
        public byte[] urlhash() {
            return this.entry.getPrimaryKeyBytes();
        }

        private int count() {
            return (int)this.entry.getColLong(2);
        }

        @Override
        public long lastModified() {
            return MicroDate.reverseMicroDateDays((int)this.entry.getColLong(1));
        }

        @Override
        public void join(Reference r) {
            HostReference oe = (HostReference)r;
            long o = oe.lastModified();
            if (this.lastModified() < o) {
                this.entry.setCol(1, MicroDate.microDateDays(o));
            }
            int c = oe.count();
            if (this.count() < c) {
                this.entry.setCol(2, c);
            }
        }

        @Override
        public Collection<Integer> positions() {
            return null;
        }

        @Override
        public int posintext() {
            throw new UnsupportedOperationException();
        }
    }
}

