/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.peers.Accessible;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.EventChannel;
import net.yacy.peers.NewsDB;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.operation.yacySeedUploadFile;
import net.yacy.peers.operation.yacySeedUploadFtp;
import net.yacy.peers.operation.yacySeedUploadScp;
import net.yacy.peers.operation.yacySeedUploader;
import net.yacy.search.Switchboard;
import net.yacy.server.serverCore;
import net.yacy.utils.crypt;

public class Network {
    public static final ThreadGroup publishThreadGroup = new ThreadGroup("publishThreadGroup");
    public static final HashMap<String, String> seedUploadMethods = new HashMap();
    public static final ConcurrentLog log = new ConcurrentLog("NETWORK");
    public static long speedKey = 0L;
    public static long magic = System.currentTimeMillis();
    public static final Map<String, Accessible> amIAccessibleDB = new ConcurrentHashMap<String, Accessible>();
    private static final int PING_INITIAL = 20;
    private static final int PING_MAX_RUNNING = 3;
    private static final int PING_MIN_RUNNING = 1;
    private static final int PING_MIN_DBSIZE = 5;
    private static final int PING_MIN_PEERSEEN = 1;
    private static final long PING_MAX_DBAGE = 900000L;
    Switchboard sb;

    public Network(Switchboard sb) {
        long time = System.currentTimeMillis();
        this.sb = sb;
        sb.setConfig("yacyStatus", "");
        RSSFeed peernews = EventChannel.channels(EventChannel.PEERNEWS);
        peernews.addMessage(new RSSMessage("YaCy started", "", ""));
        String staticIP = sb.getConfig("staticIP", "");
        if (staticIP.length() != 0 && Seed.isProperIP(staticIP)) {
            serverCore.useStaticIP = true;
            sb.peers.mySeed().setIP(staticIP);
            log.info("staticIP set to " + staticIP);
        } else {
            serverCore.useStaticIP = false;
        }
        Network.loadSeedUploadMethods();
        log.config("CORE INITIALIZED");
        speedKey = System.currentTimeMillis() - time;
    }

    public final void publishSeedList() {
        if (log.isFine()) {
            log.fine("yacyCore.publishSeedList: Triggered Seed Publish");
        }
        if (this.sb.peers.mySeed().getIPs().contains(this.sb.peers.lastSeedUpload_myIP) && this.sb.peers.lastSeedUpload_seedDBSize == this.sb.peers.sizeConnected() && System.currentTimeMillis() - this.sb.peers.lastSeedUpload_timeStamp < 86400000L && this.sb.peers.mySeed().isPrincipal()) {
            if (log.isFine()) {
                log.fine("yacyCore.publishSeedList: not necessary to publish: oldIP is equal, sizeConnected is equal and I can reach myself under the old IP.");
            }
            return;
        }
        String seedUploadMethod = this.sb.getConfig("seedUploadMethod", "");
        if (!seedUploadMethod.equalsIgnoreCase("none") || seedUploadMethod.equals("") && this.sb.getConfig("seedFTPPassword", "").length() > 0 || seedUploadMethod.equals("") && this.sb.getConfig("seedFilePath", "").length() > 0) {
            if (seedUploadMethod.equals("")) {
                if (this.sb.getConfig("seedFTPPassword", "").length() > 0) {
                    this.sb.setConfig("seedUploadMethod", "Ftp");
                }
                if (this.sb.getConfig("seedFilePath", "").length() > 0) {
                    this.sb.setConfig("seedUploadMethod", "File");
                }
            }
        } else {
            if (seedUploadMethod.equals("")) {
                this.sb.setConfig("seedUploadMethod", "none");
            }
            if (log.isFine()) {
                log.fine("yacyCore.publishSeedList: No uploading method configured");
            }
            return;
        }
        Network.saveSeedList(this.sb);
    }

    public final void peerPing() {
        if (this.sb.isRobinsonMode() && this.sb.getConfig("cluster.mode", "").equals("privatepeer")) {
            return;
        }
        this.sb.updateMySeed();
        if (this.sb.peers.sizeConnected() == 0) {
            this.sb.loadSeedLists();
            log.info("re-initialized seed list. received " + this.sb.peers.sizeConnected() + " new peer(s)");
        }
        this.publishMySeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publishMySeed() {
        try {
            ConcurrentMap<String, Seed> seeds2;
            int attempts = this.sb.peers.sizeConnected();
            if (this.sb.peers.mySeed().get("PeerType", "virgin").equals("virgin")) {
                if (attempts > 20) {
                    attempts = 20;
                }
                SortedSet<byte[]> ch = Switchboard.getSwitchboard().clusterhashes;
                seeds2 = DHTSelection.seedsByAge(this.sb.peers, true, Math.max(1, attempts - (ch == null ? 0 : ch.size())));
                if (ch != null) {
                    for (byte[] hashb : ch) {
                        String hash = ASCII.String(hashb);
                        Seed seed = (Seed)seeds2.get(hash);
                        if (seed == null && (seed = this.sb.peers.get(hash)) == null) continue;
                        seeds2.put(hash, seed);
                    }
                }
            } else {
                int diff = 5 - amIAccessibleDB.size();
                if (diff > 1) {
                    if (attempts > (diff = Math.min(diff, 3))) {
                        attempts = diff;
                    }
                } else if (attempts > 3) {
                    attempts = 3;
                }
                seeds2 = DHTSelection.seedsByAge(this.sb.peers, false, attempts);
            }
            if (seeds2 == null || seeds2.isEmpty()) {
                return false;
            }
            if (seeds2.size() < attempts) {
                attempts = seeds2.size();
            }
            Iterator si = seeds2.values().iterator();
            try {
                NewsDB.Record record = this.sb.peers.newsPool.myPublication();
                if (record == null) {
                    this.sb.peers.mySeed().put("news", "");
                } else {
                    this.sb.peers.mySeed().put("news", crypt.simpleEncode(record.toString()));
                }
            }
            catch (Exception e) {
                log.severe("publishMySeed: problem with news encoding", e);
            }
            this.sb.peers.mySeed().setUnusedFlags();
            List<publishThread> syncList = Collections.synchronizedList(new LinkedList());
            int i = 0;
            while (si.hasNext()) {
                Seed seed = (Seed)si.next();
                if (seed == null || seed.hash.equals(this.sb.peers.mySeed().hash)) continue;
                ++i;
                Set<String> ips = seed.getIPs();
                if (ips.isEmpty()) {
                    log.warn("Peer " + seed.getName() + "has no known IP address");
                    continue;
                }
                String ip = (String)ips.iterator().next();
                String address = seed.getPublicAddress(ip);
                if (log.isFine()) {
                    log.fine("HELLO #" + i + " to peer '" + seed.getName() + "' at " + address);
                }
                String seederror = seed.isProper(false);
                if (address == null || seederror != null) {
                    this.sb.peers.peerActions.interfaceDeparture(seed, ip);
                    continue;
                }
                publishThread t = new publishThread(publishThreadGroup, seed);
                t.start();
                syncList.add(t);
            }
            for (publishThread t : syncList) {
                t.join();
            }
            int accessible = 0;
            int notaccessible = 0;
            long cutofftime = System.currentTimeMillis() - 900000L;
            Map<String, Accessible> map = amIAccessibleDB;
            synchronized (map) {
                int dbSize = amIAccessibleDB.size();
                Iterator<String> ai = amIAccessibleDB.keySet().iterator();
                while (ai.hasNext()) {
                    Accessible ya = amIAccessibleDB.get(ai.next());
                    if (ya.lastUpdated < cutofftime) {
                        ai.remove();
                        continue;
                    }
                    if (ya.IWasAccessed) {
                        ++accessible;
                        continue;
                    }
                    ++notaccessible;
                }
                if (log.isFine()) {
                    log.fine("DBSize before -> after Cleanup: " + dbSize + " -> " + amIAccessibleDB.size());
                }
            }
            log.info("PeerPing: I am accessible for " + accessible + " peer(s), not accessible for " + notaccessible + " peer(s).");
            if (accessible + notaccessible > 0) {
                String newPeerType = accessible >= 1 || accessible >= notaccessible ? (this.sb.peers.mySeed().isPrincipal() ? "principal" : "senior") : "junior";
                if (this.sb.peers.mySeed().orVirgin().equals(newPeerType)) {
                    log.info("PeerPing: myType is " + this.sb.peers.mySeed().orVirgin());
                } else {
                    log.info("PeerPing: changing myType from '" + this.sb.peers.mySeed().orVirgin() + "' to '" + newPeerType + "'");
                    this.sb.peers.mySeed().put("PeerType", newPeerType);
                }
            } else {
                log.info("PeerPing: No data, staying at myType: " + this.sb.peers.mySeed().orVirgin());
            }
            this.sb.peers.saveMySeed();
            if (this.sb.peers.mySeed().isProper(true) == null) {
                return true;
            }
            String ip = this.sb.getConfig("staticIP", "");
            if (Seed.isProperIP(ip)) {
                this.sb.peers.mySeed().setIP(ip);
            }
            if (this.sb.peers.mySeed().get("PeerType", "junior").equals("junior")) {
                this.sb.peers.mySeed().put("PeerType", "senior");
            }
            log.info("publish: no recipient found, our address is " + this.sb.peers.mySeed().getIPs());
            this.sb.peers.saveMySeed();
            return false;
        }
        catch (InterruptedException e) {
            try {
                log.info("publish: Interruption detected while publishing my seed.");
                Thread.interrupted();
                log.info("publish: Signaling shutdown to " + publishThreadGroup.activeCount() + " remaining publishing threads ...");
                publishThreadGroup.interrupt();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException attempts) {
                    // empty catch block
                }
                int threadCount = publishThreadGroup.activeCount();
                Thread[] threadList = new Thread[threadCount];
                threadCount = publishThreadGroup.enumerate(threadList);
                if (log.isFine()) {
                    log.fine("publish: Waiting for " + publishThreadGroup.activeCount() + " remaining publishing threads to finish shutdown ...");
                }
                for (int currentThreadIdx = 0; currentThreadIdx < threadCount; ++currentThreadIdx) {
                    Thread currentThread = threadList[currentThreadIdx];
                    if (!currentThread.isAlive()) continue;
                    if (log.isFine()) {
                        log.fine("publish: Waiting for remaining publishing thread '" + currentThread.getName() + "' to finish shutdown");
                    }
                    try {
                        currentThread.join(500L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                log.info("publish: Shutdown off all remaining publishing thread finished.");
            }
            catch (Exception ee) {
                log.warn("publish: Unexpected error while trying to shutdown all remaining publishing threads.", e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getSeedUploadMethods() {
        HashMap<String, String> hashMap = seedUploadMethods;
        synchronized (hashMap) {
            return (HashMap)seedUploadMethods.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static yacySeedUploader getSeedUploader(String methodname) {
        String className = null;
        HashMap<String, String> hashMap = seedUploadMethods;
        synchronized (hashMap) {
            if (seedUploadMethods.containsKey(methodname)) {
                className = seedUploadMethods.get(methodname);
            }
        }
        if (className == null) {
            return null;
        }
        try {
            Class<?> uploaderClass = Class.forName(className);
            Object uploader = uploaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (yacySeedUploader)uploader;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void loadSeedUploadMethods() {
        yacySeedUploader uploader = new yacySeedUploadFile();
        seedUploadMethods.put(uploader.getClass().getSimpleName().substring("yacySeedUpload".length()), uploader.getClass().getCanonicalName());
        uploader = new yacySeedUploadFtp();
        seedUploadMethods.put(uploader.getClass().getSimpleName().substring("yacySeedUpload".length()), uploader.getClass().getCanonicalName());
        uploader = new yacySeedUploadScp();
        seedUploadMethods.put(uploader.getClass().getSimpleName().substring("yacySeedUpload".length()), uploader.getClass().getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeSeedUploadMethod(String method) {
        if (method == null || method.isEmpty()) {
            return false;
        }
        if (method.equalsIgnoreCase("none")) {
            return true;
        }
        HashMap<String, String> hashMap = seedUploadMethods;
        synchronized (hashMap) {
            return seedUploadMethods.containsKey(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String saveSeedList(Switchboard sb) {
        try {
            String errorMsg;
            block26: {
                if (sb.peers.mySeed().getIPs().isEmpty()) {
                    String errorMsg2 = "We have no valid IP address until now";
                    log.warn("SaveSeedList: We have no valid IP address until now");
                    String string = "We have no valid IP address until now";
                    return string;
                }
                String seedUploadMethod = sb.getConfig("seedUploadMethod", "");
                if (seedUploadMethod.equalsIgnoreCase("Ftp") || seedUploadMethod.equals("") && sb.getConfig("seedFTPPassword", "").length() > 0) {
                    seedUploadMethod = "Ftp";
                    sb.setConfig("seedUploadMethod", seedUploadMethod);
                } else if (seedUploadMethod.equalsIgnoreCase("File") || seedUploadMethod.equals("") && sb.getConfig("seedFilePath", "").length() > 0) {
                    seedUploadMethod = "File";
                    sb.setConfig("seedUploadMethod", seedUploadMethod);
                }
                if (seedUploadMethod.equalsIgnoreCase("none")) {
                    String string = "no uploader specified";
                    return string;
                }
                yacySeedUploader uploader = Network.getSeedUploader(seedUploadMethod);
                if (uploader == null) {
                    String errorMsg3 = "Unable to get the proper uploader-class for seed uploading method '" + seedUploadMethod + "'.";
                    log.warn("SaveSeedList: " + errorMsg3);
                    String string = errorMsg3;
                    return string;
                }
                String seedURLStr = sb.peers.mySeed().get("seedURL", "");
                if (seedURLStr.isEmpty()) {
                    throw new MalformedURLException("The seed-file url must not be empty.");
                }
                if (!seedURLStr.toLowerCase(Locale.ROOT).startsWith("http://") && !seedURLStr.toLowerCase(Locale.ROOT).startsWith("https://")) {
                    throw new MalformedURLException("Unsupported protocol.");
                }
                DigestURL seedURL = new DigestURL(seedURLStr);
                String host = seedURL.getHost();
                if (Domains.isLocalhost(host) || Domains.isIntranet(host) && !sb.isIntranetMode()) {
                    String errorMsg4 = "seedURL in local network rejected (local hosts can't be reached from outside)";
                    log.warn("SaveSeedList: seedURL in local network rejected (local hosts can't be reached from outside)");
                    String string = "seedURL in local network rejected (local hosts can't be reached from outside)";
                    return string;
                }
                String prevStatus = sb.peers.mySeed().get("PeerType", "junior");
                if (prevStatus.equals("principal")) {
                    prevStatus = "senior";
                }
                try {
                    String logt;
                    sb.peers.mySeed().put("PeerType", "principal");
                    if (log.isFine()) {
                        log.fine("SaveSeedList: Using seed uploading method '" + seedUploadMethod + "' for seed-list uploading.\n\tPrevious peerType is '" + sb.peers.mySeed().get("PeerType", "junior") + "'.");
                    }
                    if ((logt = sb.peers.uploadSeedList(uploader, sb, sb.peers, seedURL)) == null) break block26;
                    if (logt.indexOf("Error", 0) >= 0) {
                        sb.peers.mySeed().put("PeerType", prevStatus);
                        errorMsg = "SaveSeedList: seed upload failed using " + uploader.getClass().getName() + " (error): " + logt.substring(logt.indexOf("Error", 0) + 6);
                        log.severe(errorMsg);
                        String errorMsg4 = errorMsg;
                        return errorMsg4;
                    }
                    log.info(logt);
                }
                catch (Exception e) {
                    sb.peers.mySeed().put("PeerType", prevStatus);
                    sb.setConfig("yacyStatus", prevStatus);
                    String errorMsg5 = "SaveSeedList: Seed upload failed (IO error): " + e.getMessage();
                    log.info(errorMsg5, e);
                    String string = errorMsg5;
                    return string;
                }
            }
            sb.setConfig("yacyStatus", "principal");
            errorMsg = null;
            return errorMsg;
        }
        finally {
            sb.peers.lastSeedUpload_seedDBSize = sb.peers.sizeConnected();
            sb.peers.lastSeedUpload_timeStamp = System.currentTimeMillis();
            Set<String> myIPs = sb.peers.myIPs();
            if (!myIPs.isEmpty()) {
                sb.peers.lastSeedUpload_myIP = myIPs.iterator().next();
            }
        }
    }

    protected class publishThread
    extends Thread {
        private final Seed seed;

        public publishThread(ThreadGroup tg, Seed seed) {
            super(tg, "PublishSeed_" + seed.getName());
            this.seed = seed;
        }

        @Override
        public final void run() {
            Map<String, String> result = null;
            try {
                boolean preferHttps = Network.this.sb.getConfigBool("network.unit.protocol.https.preferred", false);
                for (String ip : this.seed.getIPs()) {
                    block14: {
                        String cause;
                        try {
                            MultiProtocolURL targetBaseURL = this.seed.getPublicMultiprotocolURL(ip, preferHttps);
                            result = Protocol.hello(Network.this.sb.peers.mySeed(), Network.this.sb.peers.peerActions, targetBaseURL, this.seed.hash);
                            if (result == null && targetBaseURL.isHTTPS()) {
                                targetBaseURL = this.seed.getPublicMultiprotocolURL(ip, false);
                                result = Protocol.hello(Network.this.sb.peers.mySeed(), Network.this.sb.peers.peerActions, targetBaseURL, this.seed.hash);
                                if (result != null) {
                                    log.info("publish: SSL/TLS unavailable on " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' : can be reached using http but not https on address " + ip);
                                    this.seed.setFlagSSLAvailable(false);
                                    Network.this.sb.peers.updateConnected(this.seed);
                                }
                            }
                            if (result == null) {
                                cause = "peer ping to peer resulted in error response (added < 0)";
                                log.info("publish: disconnected " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' from " + this.seed.getIPs() + ": peer ping to peer resulted in error response (added < 0)");
                                Network.this.sb.peers.peerActions.interfaceDeparture(this.seed, ip);
                            }
                            break block14;
                        }
                        catch (MalformedURLException e) {
                            cause = "malformed peer URL";
                            log.info("publish: disconnected " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' from " + this.seed.getIPs() + ": malformed peer URL");
                            Network.this.sb.peers.peerActions.interfaceDeparture(this.seed, ip);
                        }
                        continue;
                    }
                    log.info("publish: handshaked " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' at " + this.seed.getIPs());
                    Seed newSeed = Network.this.sb.peers.getConnected(this.seed.hash);
                    if (newSeed != null) {
                        String newSeedLastSeenStr;
                        if (!newSeed.isOnline()) {
                            if (log.isFine()) {
                                log.fine("publish: recently handshaked " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' at " + this.seed.getIPs() + " is not online. Removing Peer from connected");
                            }
                            Network.this.sb.peers.peerActions.interfaceDeparture(newSeed, ip);
                            continue;
                        }
                        if (newSeed.getLastSeenUTC() >= System.currentTimeMillis() - 10000L) continue;
                        if (newSeed.getLastSeenUTC() >= this.seed.getLastSeenUTC()) {
                            if (log.isFine()) {
                                newSeedLastSeenStr = GenericFormatter.formatSafely(newSeed.getLastSeenUTC(), GenericFormatter.FORMAT_SHORT_SECOND);
                                log.fine("publish: recently handshaked " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' at " + this.seed.getIPs() + " with old LastSeen: '" + newSeedLastSeenStr + "'");
                            }
                            newSeed.setLastSeenUTC();
                            Network.this.sb.peers.peerActions.peerArrival(newSeed, true);
                            continue;
                        }
                        if (log.isFine()) {
                            newSeedLastSeenStr = GenericFormatter.formatSafely(newSeed.getLastSeenUTC(), GenericFormatter.FORMAT_SHORT_SECOND);
                            String thisSeedLastSeenStr = GenericFormatter.formatSafely(newSeed.getLastSeenUTC(), GenericFormatter.FORMAT_SHORT_SECOND);
                            log.fine("publish: recently handshaked " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' at " + this.seed.getIPs() + " with old LastSeen: '" + newSeedLastSeenStr + "', this is more recent: '" + thisSeedLastSeenStr + "'");
                        }
                        this.seed.setLastSeenUTC();
                        Network.this.sb.peers.peerActions.peerArrival(this.seed, true);
                        continue;
                    }
                    if (!log.isFine()) continue;
                    log.fine("publish: recently handshaked " + this.seed.get("PeerType", "senior") + " peer '" + this.seed.getName() + "' at " + this.seed.getIPs() + " not in connectedDB");
                }
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                log.severe("publishThread: error with target seed " + this.seed.toString() + ": " + e.getMessage(), e);
            }
        }
    }
}

