/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.table;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;

public class SQLTable
implements Index,
Iterable<Row.Entry> {
    private static final String db_driver_str_mysql = "org.gjt.mm.mysql.Driver";
    private static final String db_driver_str_pgsql = "org.postgresql.Driver";
    private static final String db_conn_str_mysql = "jdbc:mysql://192.168.0.2:3306/yacy";
    private static final String db_conn_str_pgsql = "jdbc:postgresql://192.168.0.2:5432";
    private static final String db_usr_str = "yacy";
    private static final String db_pwd_str = "yacy";
    private Connection theDBConnection = null;
    private final Row rowdef;

    public SQLTable(String dbType, Row rowdef) throws Exception {
        this.rowdef = rowdef;
        this.openDatabaseConnection(dbType);
    }

    private void openDatabaseConnection(String dbType) throws Exception {
        if (dbType == null) {
            throw new IllegalArgumentException();
        }
        String dbDriverStr = null;
        String dbConnStr = null;
        if (dbType.equalsIgnoreCase("mysql")) {
            dbDriverStr = db_driver_str_mysql;
            dbConnStr = db_conn_str_mysql;
        } else if (dbType.equalsIgnoreCase("pgsql")) {
            dbDriverStr = db_driver_str_pgsql;
            dbConnStr = db_conn_str_pgsql;
        }
        try {
            Class.forName(dbDriverStr).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new Exception("Unable to load the jdbc driver: " + e.getMessage(), e);
        }
        try {
            this.theDBConnection = DriverManager.getConnection(dbConnStr, "yacy", "yacy");
        }
        catch (Exception e) {
            throw new Exception("Unable to establish a database connection: " + e.getMessage(), e);
        }
    }

    @Override
    public void optimize() {
    }

    @Override
    public long mem() {
        return 0L;
    }

    @Override
    public byte[] smallestKey() {
        return null;
    }

    @Override
    public byte[] largestKey() {
        return null;
    }

    @Override
    public String filename() {
        return "dbtest." + this.theDBConnection.hashCode();
    }

    @Override
    public synchronized void close() {
        if (this.theDBConnection != null) {
            try {
                this.theDBConnection.close();
            }
            catch (SQLException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.theDBConnection = null;
    }

    @Override
    public int size() {
        int size = -1;
        try {
            String sqlQuery = "SELECT count(value) from test";
            PreparedStatement sqlStatement = this.theDBConnection.prepareStatement("SELECT count(value) from test");
            ResultSet result = sqlStatement.executeQuery();
            while (result.next()) {
                size = result.getInt(1);
            }
            result.close();
            sqlStatement.close();
            return size;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return -1;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Row row() {
        return this.rowdef;
    }

    @Override
    public boolean has(byte[] key) {
        try {
            return this.get(key, false) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public ArrayList<RowCollection> removeDoubles() {
        return new ArrayList<RowCollection>();
    }

    @Override
    public Row.Entry get(byte[] key, boolean forcecopy) throws IOException {
        try {
            String sqlQuery = "SELECT value from test where hash = ?";
            PreparedStatement sqlStatement = this.theDBConnection.prepareStatement("SELECT value from test where hash = ?");
            sqlStatement.setString(1, ASCII.String(key));
            byte[] value = null;
            ResultSet result = sqlStatement.executeQuery();
            while (result.next()) {
                value = result.getBytes("value");
            }
            result.close();
            sqlStatement.close();
            if (value == null) {
                return null;
            }
            Row.Entry entry2 = this.rowdef.newEntry(value);
            return entry2;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Map<byte[], Row.Entry> get(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public Row.Entry replace(Row.Entry row) throws IOException {
        try {
            Row.Entry oldEntry = this.remove(row.getPrimaryKeyBytes());
            String sqlQuery = "INSERT INTO test (hash, value) VALUES (?,?)";
            PreparedStatement sqlStatement = this.theDBConnection.prepareStatement("INSERT INTO test (hash, value) VALUES (?,?)");
            sqlStatement.setString(1, row.getPrimaryKeyASCII());
            sqlStatement.setBytes(2, row.bytes());
            sqlStatement.execute();
            sqlStatement.close();
            return oldEntry;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean put(Row.Entry row) throws IOException {
        try {
            String sqlQuery = "INSERT INTO test (hash, value) VALUES (?,?)";
            PreparedStatement sqlStatement = this.theDBConnection.prepareStatement("INSERT INTO test (hash, value) VALUES (?,?)");
            sqlStatement.setString(1, row.getPrimaryKeyASCII());
            sqlStatement.setBytes(2, row.bytes());
            sqlStatement.execute();
            sqlStatement.close();
            return false;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public synchronized void addUnique(Row.Entry row) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Row.Entry remove(byte[] key) throws IOException {
        Statement sqlStatement = null;
        try {
            Row.Entry entry2 = this.get(key, false);
            if (entry2 == null) {
                Row.Entry entry3 = null;
                return entry3;
            }
            String sqlQuery = "DELETE FROM test WHERE hash = ?";
            sqlStatement = this.theDBConnection.prepareStatement("DELETE FROM test WHERE hash = ?");
            sqlStatement.setString(1, UTF8.String(key));
            sqlStatement.execute();
            Row.Entry entry4 = entry2;
            return entry4;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (sqlStatement != null) {
                try {
                    sqlStatement.close();
                }
                catch (SQLException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
    }

    @Override
    public boolean delete(byte[] key) throws IOException {
        return this.remove(key) != null;
    }

    @Override
    public Row.Entry removeOne() {
        return null;
    }

    @Override
    public List<Row.Entry> top(int count) throws IOException {
        return null;
    }

    @Override
    public List<Row.Entry> random(int count) throws IOException {
        return null;
    }

    @Override
    public CloneableIterator<Row.Entry> rows(boolean up, byte[] startKey) throws IOException {
        return null;
    }

    @Override
    public Iterator<Row.Entry> iterator() {
        try {
            return this.rows();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public CloneableIterator<Row.Entry> rows() throws IOException {
        return null;
    }

    @Override
    public CloneableIterator<byte[]> keys(boolean up, byte[] startKey) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void deleteOnExit() {
    }
}

