/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.HeapReader;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;

public class ReferenceIterator<ReferenceType extends Reference>
extends LookAheadIterator<ReferenceContainer<ReferenceType>>
implements CloneableIterator<ReferenceContainer<ReferenceType>>,
Iterable<ReferenceContainer<ReferenceType>> {
    private HeapReader.entries blobs;
    private File blobFile;
    private ReferenceFactory<ReferenceType> factory;

    public ReferenceIterator(File blobFile, ReferenceFactory<ReferenceType> factory) throws IOException {
        this.blobs = new HeapReader.entries(blobFile, factory.getRow().primaryKeyLength);
        this.blobFile = blobFile;
        this.factory = factory;
    }

    @Override
    public ReferenceContainer<ReferenceType> next0() {
        Map.Entry entry2;
        if (this.blobs == null) {
            return null;
        }
        while (this.blobs.hasNext() && (entry2 = (Map.Entry)this.blobs.next()) != null) {
            try {
                RowSet row = RowSet.importRowSet((byte[])entry2.getValue(), this.factory.getRow());
                if (row == null) {
                    ConcurrentLog.severe("ReferenceIterator", "lost entry '" + UTF8.String((byte[])entry2.getKey()) + "' because importRowSet returned null");
                    continue;
                }
                return new ReferenceContainer<ReferenceType>(this.factory, (byte[])entry2.getKey(), row);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.severe("ReferenceIterator", "lost entry '" + UTF8.String((byte[])entry2.getKey()) + "' because of too low memory: " + e.toString());
            }
            catch (Throwable e) {
                ConcurrentLog.severe("ReferenceIterator", "lost entry '" + UTF8.String((byte[])entry2.getKey()) + "' because of error: " + e.toString());
            }
        }
        this.close();
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.blobs != null) {
            this.blobs.close();
        }
        this.blobs = null;
    }

    @Override
    public CloneableIterator<ReferenceContainer<ReferenceType>> clone(Object modifier) {
        if (this.blobs != null) {
            this.blobs.close();
        }
        this.blobs = null;
        try {
            return new ReferenceIterator<ReferenceType>(this.blobFile, this.factory);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }
}

