/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.logging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogParser {
    private static final String PARSER_VERSION = "version";
    private static final String URLS_RECEIVED = "urlSum";
    private static final String URLS_REQUESTED = "urlReqSum";
    private static final String URLS_BLOCKED = "blockedURLSum";
    private static final String WORDS_RECEIVED = "wordsSum";
    private static final String RWIS_RECEIVED = "rwiSum";
    private static final String RWIS_BLOCKED = "blockedRWISum";
    private static final String RWIS_RECEIVED_TIME = "rwiTimeSum";
    private static final String URLS_RECEIVED_TIME = "urlTimeSum";
    private static final String DHT_TRAFFIC_SENT = "DHTSendTraffic";
    private static final String DHT_URLS_SENT = "DHTSendURLs";
    private static final String DHT_REJECTED = "RWIRejectCount";
    private static final String DHT_REJECTED_PEERS_NAME = "DHTRejectPeerNames";
    private static final String DHT_REJECTED_PEERS_HASH = "DHTRejectPeerHashs";
    private static final String DHT_SENT_PEERS_NAME = "DHTPeerNames";
    private static final String DHT_SENT_PEERS_HASH = "DHTPeerHashs";
    private static final String DHT_SELECTED = "DHTSelectionTargetCount";
    private static final String DHT_WORDS_SELECTED = "DHTSelectionWordsCount";
    private static final String DHT_WORDS_SELECTED_TIME = "DHTSelectionWordsTimeCount";
    private static final String DHT_DISTANCE_MIN = "minDHTDist";
    private static final String DHT_DISTANCE_MAX = "maxDHTDist";
    private static final String DHT_DISTANCE_AVERAGE = "avgDHTDist";
    private static final String PEERS_BUSY = "busyPeerCount";
    private static final String PEERS_TOO_LESS = "notEnoughDHTPeers";
    private static final String DHT_SENT_FAILED = "failedIndexDistributionCount";
    private static final String ERROR_CHILD_TWICE_LEFT = "leftChildTwiceCount";
    private static final String ERROR_CHILD_TWICE_RIGHT = "rightChildTwiceCount";
    private static final String RANKING_DIST = "rankingDistributionCount";
    private static final String RANKING_DIST_TIME = "rankingDistributionTime";
    private static final String RANKING_DIST_FAILED = "rankingDistributionFailCount";
    private static final String ERROR_MALFORMED_URL = "malformedURLCount";
    private static final String INDEXED_SITES = "indexedSites";
    private static final String INDEXED_WORDS = "indexedWords";
    private static final String INDEXED_SITES_SIZE = "indexedSiteSizeSum";
    private static final String INDEXED_ANCHORS = "indexedAnchors";
    private static final String INDEXED_LINKSTORE_TIME = "indexedLinkStorageTime";
    private static final String INDEXED_INDEXSTORE_TIME = "indexedIndexStorageTime";
    private static final String TOTAL_PARSER_TIME = "totalParserTime";
    private static final String TOTAL_PARSER_RUNS = "totalParserRuns";
    private static final float parserVersion = 0.1f;
    private static final String parserType = "PLASMA";
    private static final Pattern i1 = Pattern.compile("Received (\\d*) URLs from peer [\\w-_]{12}:[\\w-_]*/[\\w.-]* in (\\d*) ms, blocked (\\d*) URLs");
    private static final Pattern i2 = Pattern.compile("Received (\\d*) Entries (\\d*) Words \\[[\\w-_]{12} .. [\\w-_]{12}\\]/[\\w.-]* from [\\w-_]{12}:[\\w-_]*/[\\w.-]*, processed in (\\d*) milliseconds, requesting (\\d*)/(\\d*) URLs, blocked (\\d*) RWIs");
    private static final Pattern i2_2 = Pattern.compile("Received (\\d*) Entries (\\d*) Words \\[[\\w-_]{12} .. [\\w-_]{12}\\]/[\\w.-]* from [\\w-_]{12}:[\\w-_]*, processed in (\\d*) milliseconds, requesting (\\d*)/(\\d*) URLs, blocked (\\d*) RWIs");
    private static final Pattern i3 = Pattern.compile("Index transfer of (\\d*) words \\[[\\w-_]{12} .. [\\w-_]{12}\\] to peer ([\\w-_]*):([\\w-_]{12}) in (\\d*) seconds successful \\((\\d*) words/s, (\\d*) Bytes\\)");
    private static final Pattern i4 = Pattern.compile("Index transfer of (\\d*) entries (\\d*) words \\[[\\w-_]{12} .. [\\w-_]{12}\\] and (\\d*) URLs to peer ([\\w-_]*):([\\w-_]{12}) in (\\d*) seconds successful \\((\\d*) words/s, (\\d*) Bytes\\)");
    private static final Pattern i5 = Pattern.compile("Selected DHT target peer ([\\w-_]*):([\\w-_]{12}), distance2first = ([\\d]*), distance2last = ([\\d]*)");
    private static final Pattern i6 = Pattern.compile("Rejecting RWIs from peer ([\\w-_]{12}):([\\w-_]*)/([\\w.]*). ([\\w. ]*)");
    private static final Pattern i7 = Pattern.compile("DHT distribution: transfer to peer [\\w-]* finished.");
    private static final Pattern i8 = Pattern.compile("Index selection of (\\d*) words \\[[\\w-_]{12} .. [\\w-_]{12}\\] in (\\d*) seconds");
    private static final Pattern i9 = Pattern.compile("RankingDistribution - transmitted file [\\w\\s-:.\\\\]* to [\\w.]*:\\d* successfully in (\\d)* seconds");
    private static final Pattern i10 = Pattern.compile("RankingDistribution - error transmitting file");
    private static final Pattern i11 = Pattern.compile("Peer [\\w-_]*:[\\w-_]{12} is busy\\. Waiting \\d* ms\\.");
    private static final Pattern i13 = Pattern.compile("WROTE HEADER for |LOCALCRAWL\\[\\d*, \\d*, \\d*, \\d*\\]|REJECTED WRONG STATUS TYPE");
    private static final Pattern w1 = Pattern.compile("found not enough \\(\\d*\\) peers for distribution");
    private static final Pattern w2 = Pattern.compile("Transfer to peer ([\\w-_]*):([\\w-_]{12}) failed:'(\\w*)'");
    private static final Pattern e1 = Pattern.compile("INTERNAL ERROR AT plasmaCrawlLURL:store:de.anomic.kelondro.kelondroException: tried to create (\\w*) node twice in db");
    private static final Pattern e2 = Pattern.compile("INTERNAL ERROR [\\w./: ]* java.net.MalformedURLException");
    private Matcher m;
    private static final Pattern adv1 = Pattern.compile("\\*Indexed (\\d+) words in URL [\\w:.&/%-~;$\u00a7@=]* \\[[\\w_-]{12}\\]\\r?\\n?\\tDescription: +([\\w-\\.,:!='\"|/+@\\(\\) \\t]*)\\r?\\n?\\tMimeType: ([\\w_~/-]*) \\| Charset: ([\\w-]*) \\| Size: (\\d+) bytes \\| Anchors: (\\d+)\\r?\\n?\\tLinkStorageTime: (\\d+) ms \\| indexStorageTime: (\\d+) ms");
    private int urlSum = 0;
    private int urlReqSum = 0;
    private int blockedURLSum = 0;
    private int wordsSum = 0;
    private int rwiSum = 0;
    private int blockedRWISum = 0;
    private long urlTimeSum = 0L;
    private long rwiTimeSum = 0L;
    private long DHTSendTraffic = 0L;
    private int DHTSendURLs = 0;
    private int RWIRejectCount = 0;
    private final Set<String> RWIRejectPeerNames = new HashSet<String>();
    private final Set<String> RWIRejectPeerHashs = new HashSet<String>();
    private final Set<String> DHTPeerNames = new HashSet<String>();
    private final Set<String> DHTPeerHashs = new HashSet<String>();
    private int DHTSelectionTargetCount = 1;
    private int DHTSelectionWordsCount = 0;
    private int DHTSelectionWordsTimeCount = 0;
    private long minDHTDist = Long.MAX_VALUE;
    private long maxDHTDist = 0L;
    private long avgDHTDist = 0L;
    private int busyPeerCount = 0;
    private int notEnoughDHTPeers = 0;
    private int failedIndexDistributionCount = 0;
    private int leftChildTwiceCount = 0;
    private int rightChildTwiceCount = 0;
    private int rankingDistributionCount = 0;
    private int rankingDistributionTime = 0;
    private int rankingDistributionFailCount = 0;
    private int malformedURLCount = 0;
    private int indexedSites = 0;
    private int indexedWordSum = 0;
    private int indexedSiteSizeSum = 0;
    private int indexedAnchorsCount = 0;
    private int indexedLinkStorageTime = 0;
    private int indexedIndexStorageTime = 0;
    private long totalParserTime = 0L;
    private int totalParserRuns = 0;

    public final int parse(String logLevel, String logLine) {
        long start = System.currentTimeMillis();
        if ("INFO".equals(logLevel)) {
            this.m = i1.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 3) {
                this.urlSum += Integer.parseInt(this.m.group(1));
                this.urlTimeSum += (long)Integer.parseInt(this.m.group(2));
                this.blockedURLSum += Integer.parseInt(this.m.group(3));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i2.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 6) {
                this.rwiSum += Integer.parseInt(this.m.group(1));
                this.wordsSum += Integer.parseInt(this.m.group(2));
                this.rwiTimeSum += (long)Integer.parseInt(this.m.group(3));
                this.urlReqSum += Integer.parseInt(this.m.group(4));
                this.blockedRWISum += Integer.parseInt(this.m.group(6));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i2_2.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 6) {
                this.rwiSum += Integer.parseInt(this.m.group(1));
                this.wordsSum += Integer.parseInt(this.m.group(2));
                this.rwiTimeSum += (long)Integer.parseInt(this.m.group(3));
                this.urlReqSum += Integer.parseInt(this.m.group(4));
                this.blockedRWISum += Integer.parseInt(this.m.group(6));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i3.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 6) {
                this.DHTSendTraffic += (long)Integer.parseInt(this.m.group(6));
                this.DHTPeerNames.add(this.m.group(2));
                this.DHTPeerHashs.add(this.m.group(3));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i4.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 8) {
                this.DHTSendTraffic += (long)Integer.parseInt(this.m.group(8));
                this.DHTSendURLs += Integer.parseInt(this.m.group(3));
                this.DHTPeerNames.add(this.m.group(4));
                this.DHTPeerHashs.add(this.m.group(5));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i5.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 4) {
                this.minDHTDist = Math.min(this.minDHTDist, Math.min(Long.parseLong(this.m.group(3)), Long.parseLong(this.m.group(4))));
                this.maxDHTDist = Math.max(this.maxDHTDist, Math.max(Long.parseLong(this.m.group(3)), Long.parseLong(this.m.group(4))));
                this.avgDHTDist += Long.parseLong(this.m.group(3));
                ++this.DHTSelectionTargetCount;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i6.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 2) {
                this.RWIRejectPeerNames.add(this.m.group(2));
                this.RWIRejectPeerHashs.add(this.m.group(1));
                ++this.RWIRejectCount;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i7.matcher(logLine);
            if (this.m.find()) {
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i8.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 2) {
                this.DHTSelectionWordsCount = (int)((float)this.DHTSelectionWordsCount + Float.parseFloat(this.m.group(1)));
                this.DHTSelectionWordsTimeCount = (int)((float)this.DHTSelectionWordsTimeCount + Float.parseFloat(this.m.group(2)));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i9.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 1) {
                ++this.rankingDistributionCount;
                this.rankingDistributionTime += Integer.parseInt(this.m.group(1));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i10.matcher(logLine);
            if (this.m.find()) {
                ++this.rankingDistributionFailCount;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i11.matcher(logLine);
            if (this.m.find()) {
                ++this.busyPeerCount;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = i13.matcher(logLine);
            if (this.m.find()) {
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = adv1.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 8) {
                ++this.indexedSites;
                this.indexedWordSum += Integer.parseInt(this.m.group(1));
                this.indexedSiteSizeSum += Integer.parseInt(this.m.group(5));
                this.indexedAnchorsCount += Integer.parseInt(this.m.group(6));
                this.indexedLinkStorageTime += Integer.parseInt(this.m.group(7));
                this.indexedIndexStorageTime += Integer.parseInt(this.m.group(8));
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
        } else if ("WARNING".equals(logLevel)) {
            this.m = w1.matcher(logLine);
            if (this.m.find()) {
                ++this.notEnoughDHTPeers;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = w2.matcher(logLine);
            if (this.m.find()) {
                ++this.failedIndexDistributionCount;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
        } else if ("SEVERE".equals(logLevel)) {
            this.m = e1.matcher(logLine);
            if (this.m.find() && this.m.groupCount() >= 1) {
                if ("leftchild".equals(this.m.group(1))) {
                    ++this.leftChildTwiceCount;
                } else if ("rightchild".equals(this.m.group(1))) {
                    ++this.rightChildTwiceCount;
                }
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
            this.m = e2.matcher(logLine);
            if (this.m.find()) {
                ++this.malformedURLCount;
                this.totalParserTime += System.currentTimeMillis() - start;
                ++this.totalParserRuns;
                return 0;
            }
        }
        this.totalParserTime += System.currentTimeMillis() - start;
        ++this.totalParserRuns;
        return -1;
    }

    public final Map<String, Object> getResults() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(PARSER_VERSION, Float.valueOf(0.1f));
        results.put(URLS_RECEIVED, this.urlSum);
        results.put(URLS_REQUESTED, this.urlReqSum);
        results.put(URLS_BLOCKED, this.blockedURLSum);
        results.put(WORDS_RECEIVED, this.wordsSum);
        results.put(RWIS_RECEIVED, this.rwiSum);
        results.put(RWIS_BLOCKED, this.blockedRWISum);
        results.put(URLS_RECEIVED_TIME, this.urlTimeSum);
        results.put(RWIS_RECEIVED_TIME, this.rwiTimeSum);
        results.put(DHT_TRAFFIC_SENT, this.DHTSendTraffic);
        results.put(DHT_URLS_SENT, this.DHTSendURLs);
        results.put(DHT_REJECTED, this.RWIRejectCount);
        results.put(DHT_REJECTED_PEERS_NAME, this.RWIRejectPeerNames);
        results.put(DHT_REJECTED_PEERS_HASH, this.RWIRejectPeerHashs);
        results.put(DHT_SENT_PEERS_NAME, this.DHTPeerNames);
        results.put(DHT_SENT_PEERS_HASH, this.DHTPeerHashs);
        results.put(DHT_SELECTED, this.DHTSelectionTargetCount);
        results.put(DHT_WORDS_SELECTED, this.DHTSelectionWordsCount);
        results.put(DHT_WORDS_SELECTED_TIME, this.DHTSelectionWordsTimeCount);
        results.put(DHT_DISTANCE_MIN, this.minDHTDist);
        results.put(DHT_DISTANCE_MAX, this.maxDHTDist);
        results.put(DHT_DISTANCE_AVERAGE, this.avgDHTDist / (long)this.DHTSelectionTargetCount / Long.MAX_VALUE);
        results.put(PEERS_BUSY, this.busyPeerCount);
        results.put(PEERS_TOO_LESS, this.notEnoughDHTPeers);
        results.put(DHT_SENT_FAILED, this.failedIndexDistributionCount);
        results.put(ERROR_CHILD_TWICE_LEFT, this.leftChildTwiceCount);
        results.put(ERROR_CHILD_TWICE_RIGHT, this.rightChildTwiceCount);
        results.put(RANKING_DIST, this.rankingDistributionCount);
        results.put(RANKING_DIST_TIME, this.rankingDistributionTime);
        results.put(RANKING_DIST_FAILED, this.rankingDistributionFailCount);
        results.put(ERROR_MALFORMED_URL, this.malformedURLCount);
        results.put(INDEXED_SITES, this.indexedSites);
        results.put(INDEXED_WORDS, this.indexedWordSum);
        results.put(INDEXED_SITES_SIZE, this.indexedSiteSizeSum);
        results.put(INDEXED_ANCHORS, this.indexedAnchorsCount);
        results.put(INDEXED_LINKSTORE_TIME, this.indexedLinkStorageTime);
        results.put(INDEXED_INDEXSTORE_TIME, this.indexedIndexStorageTime);
        results.put(TOTAL_PARSER_TIME, this.totalParserTime);
        results.put(TOTAL_PARSER_RUNS, this.totalParserRuns);
        return results;
    }

    public static final String getParserType() {
        return parserType;
    }

    public static final double getParserVersion() {
        return 0.1f;
    }

    public final void printResults() {
        if (this.rankingDistributionCount == 0) {
            this.rankingDistributionCount = 1;
        }
        if (this.DHTSelectionWordsTimeCount == 0) {
            this.DHTSelectionWordsTimeCount = 1;
        }
        if (this.indexedSites != 0) {
            ++this.indexedSites;
        }
        System.out.println("INDEXER: Indexed " + this.indexedSites + " sites in " + (this.indexedLinkStorageTime + this.indexedIndexStorageTime) + " milliseconds.");
        System.out.println("INDEXER: Indexed " + this.indexedWordSum + " words on " + this.indexedSites + " sites. (avg. words per site: " + this.indexedWordSum / this.indexedSites + ").");
        System.out.println("INDEXER: Total Size of indexed sites: " + this.indexedSiteSizeSum + " bytes (avg. size per site: " + this.indexedSiteSizeSum / this.indexedSites + " bytes).");
        System.out.println("INDEXER: Total Number of Anchors found: " + this.indexedAnchorsCount + "(avg. Anchors per site: " + this.indexedAnchorsCount / this.indexedSites + ").");
        System.out.println("INDEXER: Total LinkStorageTime: " + this.indexedLinkStorageTime + " milliseconds (avg. StorageTime: " + this.indexedLinkStorageTime / this.indexedSites + " milliseconds).");
        System.out.println("INDEXER: Total indexStorageTime: " + this.indexedIndexStorageTime + " milliseconds (avg. StorageTime: " + this.indexedIndexStorageTime / this.indexedSites + " milliseconds).");
        if (this.urlSum != 0) {
            ++this.urlSum;
        }
        System.out.println("DHT: Recieved " + this.urlSum + " Urls in " + this.urlTimeSum + " ms. Blocked " + this.blockedURLSum + " URLs.");
        System.out.println("DHT: " + this.urlTimeSum / (long)this.urlSum + " milliseconds per URL.");
        if (this.rwiSum != 0) {
            ++this.rwiSum;
        }
        System.out.println("DHT: Recieved " + this.rwiSum + " RWIs from " + this.wordsSum + " Words in " + this.rwiTimeSum + " ms. " + this.urlReqSum + " requested URLs.");
        System.out.println("DHT: Blocked " + this.blockedRWISum + " RWIs before requesting URLs, because URL-Hash was blacklisted.");
        System.out.println("DHT: " + this.rwiTimeSum / (long)this.rwiSum + " milliseconds per RWI.");
        System.out.println("DHT: Rejected " + this.RWIRejectCount + " Indextransfers from " + this.RWIRejectPeerNames.size() + " PeerNames with " + this.RWIRejectPeerHashs.size() + " PeerHashs.");
        System.out.println("DHT: " + this.DHTSendTraffic / 0x100000L + " MegaBytes (" + this.DHTSendTraffic + " Bytes) of DHT-Transfertraffic.");
        System.out.println("DHT: Sended " + this.DHTSendURLs + " URLs via DHT.");
        System.out.println("DHT: DHT Transfers send to " + this.DHTPeerNames.size() + " Peernames with " + this.DHTPeerHashs.size() + " Peerhashs.");
        System.out.println("DHT: Totally selected " + this.DHTSelectionWordsCount + " words in " + this.DHTSelectionWordsTimeCount + " seconds (" + (float)this.DHTSelectionWordsCount / (float)this.DHTSelectionWordsTimeCount + " words/s)");
        System.out.println("DHT: Selected " + this.DHTSelectionTargetCount + " possible DHT Targets (min. Distance: " + this.minDHTDist + " max. Distance: " + this.maxDHTDist + " avg. Distance: " + this.avgDHTDist / (long)this.DHTSelectionTargetCount);
        System.out.println("DHT: " + this.busyPeerCount + " times a targetpeer was too busy to accept a transfer.");
        System.out.println("DHT: " + this.notEnoughDHTPeers + " times there were not enought targetpeers for the selected DHTChunk");
        System.out.println("DHT: IndexDistribution failed " + this.failedIndexDistributionCount + " times.");
        System.out.println("RANKING: Transmitted " + this.rankingDistributionCount + " Rankingfiles in " + this.rankingDistributionTime + " seconds (" + this.rankingDistributionTime / this.rankingDistributionCount + " seconds/file)");
        System.out.println("RANKING: RankingDistribution failed " + this.rankingDistributionFailCount + " times.");
        if (this.leftChildTwiceCount != 0) {
            System.out.println("ERRORS: tried " + this.leftChildTwiceCount + " times to create leftchild node twice in db");
        }
        if (this.rightChildTwiceCount != 0) {
            System.out.println("ERRORS: tried " + this.rightChildTwiceCount + " times to create rightchild node twice in db");
        }
        if (this.malformedURLCount != 0) {
            System.out.println("ERRORS: " + this.malformedURLCount + " MalformedURLExceptions accord.");
        }
    }
}

