/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.sorting.Array;
import net.yacy.cora.sorting.Sortable;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.kelondroException;

public class RowCollection
implements Sortable<Row.Entry>,
Iterable<Row.Entry>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4670634138825982705L;
    private static final byte[] EMPTY_CACHE = new byte[0];
    public static final long growfactorLarge100 = 140L;
    public static final long growfactorSmall100 = 110L;
    private static final int isortlimit = 20;
    private static final int exp_chunkcount = 0;
    private static final int exp_last_read = 1;
    private static final int exp_last_wrote = 2;
    private static final int exp_order_type = 3;
    private static final int exp_order_bound = 4;
    private static final int exp_collection = 5;
    protected final Row rowdef;
    protected byte[] chunkcache;
    protected int chunkcount;
    protected int sortBound;
    protected long lastTimeWrote;
    private static final Row exportMeasureRow = RowCollection.exportRow(0);
    private static final long day = 86400000L;
    private static Column exportColumn0;
    private static Column exportColumn1;
    private static Column exportColumn2;
    private static Column exportColumn3;
    private static Column exportColumn4;
    private static Column collectionColumnProducer;
    protected static final long exportOverheadSize = 14L;
    private static Random random;

    protected RowCollection(RowCollection rc) {
        this.rowdef = rc.rowdef;
        this.chunkcache = rc.chunkcache;
        this.chunkcount = rc.chunkcount;
        this.sortBound = rc.sortBound;
        this.lastTimeWrote = rc.lastTimeWrote;
    }

    protected RowCollection(Row rowdef) {
        this.rowdef = rowdef;
        this.sortBound = 0;
        this.lastTimeWrote = System.currentTimeMillis();
        this.chunkcache = EMPTY_CACHE;
        this.chunkcount = 0;
    }

    public RowCollection(Row rowdef, int objectCount) throws SpaceExceededException {
        this(rowdef);
        this.ensureSize(objectCount);
    }

    protected RowCollection(Row rowdef, int objectCount, byte[] cache, int sortBound) {
        this.rowdef = rowdef;
        this.chunkcache = cache;
        this.chunkcount = objectCount;
        this.sortBound = sortBound;
        this.lastTimeWrote = System.currentTimeMillis();
    }

    protected RowCollection(Row rowdef, Row.Entry exportedCollectionRowEnvironment) {
        int chunkcachelength = exportedCollectionRowEnvironment.cellwidth(1) - 14;
        Row.Entry exportedCollection = RowCollection.exportRow(chunkcachelength).newEntry(exportedCollectionRowEnvironment, 1);
        this.rowdef = rowdef;
        this.chunkcount = (int)exportedCollection.getColLong(0);
        if (this.chunkcount > chunkcachelength / rowdef.objectsize) {
            ConcurrentLog.warn("RowCollection", "corrected wrong chunkcount; chunkcount = " + this.chunkcount + ", chunkcachelength = " + chunkcachelength + ", rowdef.objectsize = " + rowdef.objectsize);
            this.chunkcount = chunkcachelength / rowdef.objectsize;
        }
        this.lastTimeWrote = (exportedCollection.getColLong(2) + 10957L) * 86400000L;
        String sortOrderKey = exportedCollection.getColASCII(3);
        ByteOrder oldOrder = null;
        if (sortOrderKey == null || sortOrderKey.equals("__")) {
            oldOrder = null;
        } else {
            oldOrder = NaturalOrder.bySignature(sortOrderKey);
            if (oldOrder == null) {
                oldOrder = Base64Order.bySignature(sortOrderKey);
            }
        }
        if (rowdef.objectOrder != null && oldOrder != null && !rowdef.objectOrder.signature().equals(oldOrder.signature())) {
            throw new kelondroException("old collection order does not match with new order; objectOrder.signature = " + rowdef.objectOrder.signature() + ", oldOrder.signature = " + oldOrder.signature());
        }
        this.sortBound = (int)exportedCollection.getColLong(4);
        if (this.sortBound > this.chunkcount) {
            ConcurrentLog.warn("RowCollection", "corrected wrong sortBound; sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount);
            this.sortBound = this.chunkcount;
        }
        this.chunkcache = exportedCollection.getColBytes(5, false);
    }

    protected RowCollection(Row rowdef, byte[] chunkcache, int chunkcount, int sortBound, long lastTimeWrote) {
        this.rowdef = rowdef;
        this.chunkcache = new byte[chunkcache.length];
        System.arraycopy(chunkcache, 0, this.chunkcache, 0, chunkcache.length);
        this.chunkcount = chunkcount;
        this.sortBound = sortBound;
        this.lastTimeWrote = lastTimeWrote;
    }

    public RowCollection clone() {
        return new RowCollection(this.rowdef, this.chunkcache, this.chunkcount, this.sortBound, this.lastTimeWrote);
    }

    public void reset() {
        this.chunkcache = new byte[0];
        this.chunkcount = 0;
        this.sortBound = 0;
    }

    public long mem() {
        return this.chunkcache.length;
    }

    public static final int sizeOfExportedCollectionRows(Row.Entry exportedCollectionRowEnvironment, int columnInEnvironment) {
        Row.Entry exportedCollectionEntry = exportMeasureRow.newEntry(exportedCollectionRowEnvironment, columnInEnvironment);
        int chunkcount = (int)exportedCollectionEntry.getColLong(0);
        return chunkcount;
    }

    private static int daysSince2000(long time) {
        return (int)(time / 86400000L) - 10957;
    }

    private static Row exportRow(int chunkcachelength) {
        if (exportColumn0 == null) {
            exportColumn0 = new Column("int size-4 {b256}");
        }
        if (exportColumn1 == null) {
            exportColumn1 = new Column("short lastread-2 {b256}");
        }
        if (exportColumn2 == null) {
            exportColumn2 = new Column("short lastwrote-2 {b256}");
        }
        if (exportColumn3 == null) {
            exportColumn3 = new Column("byte[] orderkey-2");
        }
        if (exportColumn4 == null) {
            exportColumn4 = new Column("int orderbound-4 {b256}");
        }
        if (collectionColumnProducer == null) {
            collectionColumnProducer = new Column("byte[] collection-1");
        }
        Column collectionColumn = (Column)collectionColumnProducer.clone();
        collectionColumn.setCellwidth(chunkcachelength);
        Row er = new Row(new Column[]{exportColumn0, exportColumn1, exportColumn2, exportColumn3, exportColumn4, collectionColumn}, NaturalOrder.naturalOrder);
        assert ((long)er.objectsize == (long)chunkcachelength + 14L);
        return er;
    }

    public synchronized byte[] exportCollection() {
        this.sort();
        assert (this.sortBound == this.chunkcount);
        assert (this.size() * this.rowdef.objectsize <= this.chunkcache.length) : "this.size() = " + this.size() + ", objectsize = " + this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        Row row = RowCollection.exportRow(this.size() * this.rowdef.objectsize);
        Row.Entry entry2 = row.newEntry();
        assert (this.sortBound <= this.chunkcount) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        assert (this.chunkcount <= this.chunkcache.length / this.rowdef.objectsize) : "chunkcount = " + this.chunkcount + ", chunkcache.length = " + this.chunkcache.length + ", rowdef.objectsize = " + this.rowdef.objectsize;
        entry2.setCol(0, this.chunkcount);
        entry2.setCol(1, RowCollection.daysSince2000(System.currentTimeMillis()));
        entry2.setCol(2, RowCollection.daysSince2000(this.lastTimeWrote));
        entry2.setCol(3, this.rowdef.objectOrder == null ? ASCII.getBytes("__") : ASCII.getBytes(this.rowdef.objectOrder.signature()));
        entry2.setCol(4, this.sortBound);
        entry2.setCol(5, this.chunkcache);
        return entry2.bytes();
    }

    public void saveCollection(File file) throws IOException {
        FileUtils.copy(this.exportCollection(), file);
    }

    public Row row() {
        return this.rowdef;
    }

    private final long neededSpaceForEnsuredSize(int elements) {
        assert (elements > 0) : "elements = " + elements;
        long needed = elements * this.rowdef.objectsize;
        if ((long)this.chunkcache.length >= needed) {
            return 0L;
        }
        assert (needed > 0L) : "needed = " + needed;
        long allocram = Math.max(1024L, needed * 140L / 100L);
        allocram -= allocram % (long)this.rowdef.objectsize;
        assert (allocram > 0L) : "elements = " + elements + ", new = " + allocram;
        if (allocram <= Integer.MAX_VALUE && MemoryControl.request(allocram, false)) {
            return allocram;
        }
        allocram = needed * 110L / 100L;
        allocram -= allocram % (long)this.rowdef.objectsize;
        assert (allocram >= 0L) : "elements = " + elements + ", new = " + allocram;
        return allocram;
    }

    private final void ensureSize(int elements) throws SpaceExceededException {
        if (elements == 0) {
            return;
        }
        long allocram = this.neededSpaceForEnsuredSize(elements);
        if (allocram == 0L) {
            return;
        }
        assert (this.chunkcache.length < elements * this.rowdef.objectsize) : "wrong alloc computation (1): elements * rowdef.objectsize = " + elements * this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        assert (allocram > (long)this.chunkcache.length) : "wrong alloc computation (2): allocram = " + allocram + ", chunkcache.length = " + this.chunkcache.length;
        if (allocram > Integer.MAX_VALUE || !MemoryControl.request(allocram + 32L, true)) {
            throw new SpaceExceededException(allocram + 32L, "RowCollection grow");
        }
        try {
            byte[] newChunkcache = new byte[(int)allocram];
            System.arraycopy(this.chunkcache, 0, newChunkcache, 0, this.chunkcache.length);
            this.chunkcache = newChunkcache;
        }
        catch (OutOfMemoryError e) {
            System.gc();
            try {
                byte[] newChunkcache = new byte[(int)allocram];
                System.arraycopy(this.chunkcache, 0, newChunkcache, 0, this.chunkcache.length);
                this.chunkcache = newChunkcache;
            }
            catch (OutOfMemoryError ee) {
                throw new SpaceExceededException(allocram, "RowCollection grow after OutOfMemoryError " + ee.getMessage());
            }
        }
    }

    protected final long memoryNeededForGrow() {
        return this.neededSpaceForEnsuredSize(this.chunkcount + 1);
    }

    @Override
    public int compare(Row.Entry o1, Row.Entry o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Row.Entry buffer() {
        return this.row().newEntry();
    }

    @Override
    public void swap(int i, int j, Row.Entry buffer) {
        if (i == j) {
            return;
        }
        byte[] swapspace = buffer.bytes();
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * i, swapspace, 0, this.rowdef.objectsize);
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * j, this.chunkcache, this.rowdef.objectsize * i, this.rowdef.objectsize);
        System.arraycopy(swapspace, 0, this.chunkcache, this.rowdef.objectsize * j, this.rowdef.objectsize);
    }

    private final void checkShrink() {
        long allocram = this.rowdef.objectsize * this.chunkcount;
        if (allocram < (long)(this.chunkcache.length / 2) && MemoryControl.request(allocram + 32L, true)) {
            this.trim();
        }
    }

    protected synchronized void trim() {
        if (this.chunkcache.length == 0) {
            return;
        }
        long needed = this.chunkcount * this.rowdef.objectsize;
        assert (needed <= (long)this.chunkcache.length);
        if (needed >= (long)this.chunkcache.length) {
            return;
        }
        if (MemoryControl.available() + 1000L < needed) {
            return;
        }
        try {
            byte[] newChunkcache = new byte[(int)needed];
            System.arraycopy(this.chunkcache, 0, newChunkcache, 0, newChunkcache.length);
            this.chunkcache = newChunkcache;
        }
        catch (OutOfMemoryError e) {
            System.gc();
            try {
                byte[] newChunkcache = new byte[(int)needed];
                System.arraycopy(this.chunkcache, 0, newChunkcache, 0, newChunkcache.length);
                this.chunkcache = newChunkcache;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
    }

    public final long lastWrote() {
        return this.lastTimeWrote;
    }

    protected final synchronized byte[] getKey(int index2) {
        assert (index2 >= 0) : "get: access with index " + index2 + " is below zero";
        assert (index2 < this.chunkcount) : "get: access with index " + index2 + " is above chunkcount " + this.chunkcount + "; sortBound = " + this.sortBound;
        assert (index2 * this.rowdef.objectsize < this.chunkcache.length);
        if (this.chunkcache == null || this.rowdef == null) {
            return null;
        }
        if (index2 >= this.chunkcount) {
            return null;
        }
        if ((index2 + 1) * this.rowdef.objectsize > this.chunkcache.length) {
            return null;
        }
        byte[] b = new byte[this.rowdef.primaryKeyLength];
        System.arraycopy(this.chunkcache, index2 * this.rowdef.objectsize, b, 0, b.length);
        return b;
    }

    @Override
    public final synchronized Row.Entry get(int index2, boolean clone) {
        assert (index2 >= 0) : "get: access with index " + index2 + " is below zero";
        assert (index2 < this.chunkcount) : "get: access with index " + index2 + " is above chunkcount " + this.chunkcount + "; sortBound = " + this.sortBound;
        assert (this.chunkcache != null && index2 * this.rowdef.objectsize < this.chunkcache.length);
        assert (this.sortBound <= this.chunkcount) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        if (this.chunkcache == null || this.rowdef == null) {
            return null;
        }
        int addr = index2 * this.rowdef.objectsize;
        if (index2 >= this.chunkcount) {
            return null;
        }
        if (addr + this.rowdef.objectsize > this.chunkcache.length) {
            return null;
        }
        Row.Entry entry2 = this.rowdef.newEntry(this.chunkcache, addr, clone);
        return entry2;
    }

    public final synchronized void set(int index2, Row.Entry a) throws SpaceExceededException {
        assert (index2 >= 0) : "set: access with index " + index2 + " is below zero";
        this.ensureSize(index2 + 1);
        byte[] column = a.bytes();
        assert (a.cellwidth(0) == this.rowdef.primaryKeyLength);
        assert (column.length >= this.rowdef.primaryKeyLength);
        boolean sameKey = this.match(column, 0, index2);
        a.writeToArray(this.chunkcache, index2 * this.rowdef.objectsize);
        if (index2 >= this.chunkcount) {
            this.chunkcount = index2 + 1;
        }
        if (!sameKey && index2 < this.sortBound) {
            this.sortBound = index2;
        }
        this.lastTimeWrote = System.currentTimeMillis();
    }

    public final void insertUnique(int index2, Row.Entry a) throws SpaceExceededException {
        assert (a != null);
        if (index2 < this.chunkcount) {
            this.ensureSize(this.chunkcount + 1);
            System.arraycopy(this.chunkcache, this.rowdef.objectsize * index2, this.chunkcache, this.rowdef.objectsize * (index2 + 1), (this.chunkcount - index2) * this.rowdef.objectsize);
            ++this.chunkcount;
        }
        this.set(index2, a);
    }

    public synchronized void addUnique(Row.Entry row) throws SpaceExceededException {
        byte[] r = row.bytes();
        this.addUnique(r, 0, r.length);
    }

    public synchronized void addUnique(List<Row.Entry> rows) throws SpaceExceededException {
        assert (this.sortBound == 0) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        Iterator<Row.Entry> i = rows.iterator();
        while (i.hasNext()) {
            this.addUnique(i.next());
        }
    }

    public synchronized void add(byte[] a) throws SpaceExceededException {
        assert (a.length == this.rowdef.objectsize) : "a.length = " + a.length + ", objectsize = " + this.rowdef.objectsize;
        this.addUnique(a, 0, a.length);
    }

    private final void addUnique(byte[] a, int astart, int alength) throws SpaceExceededException {
        assert (a != null);
        assert (astart >= 0 && astart < a.length) : " astart = " + astart;
        assert (!RowCollection.allZero(a, astart, alength)) : "a = " + NaturalOrder.arrayList(a, astart, alength);
        assert (alength > 0);
        assert (astart + alength <= a.length);
        assert (alength == this.rowdef.objectsize) : "alength =" + alength + ", rowdef.objectsize = " + this.rowdef.objectsize;
        int l = Math.min(this.rowdef.objectsize, Math.min(alength, a.length - astart));
        this.ensureSize(this.chunkcount + 1);
        System.arraycopy(a, astart, this.chunkcache, this.rowdef.objectsize * this.chunkcount, l);
        ++this.chunkcount;
        if (this.chunkcount == 1) {
            assert (this.sortBound == 0);
            this.sortBound = 1;
        } else if (this.sortBound + 1 == this.chunkcount && this.rowdef.objectOrder.compare(this.chunkcache, this.rowdef.objectsize * (this.chunkcount - 2), this.chunkcache, this.rowdef.objectsize * (this.chunkcount - 1), this.rowdef.primaryKeyLength) == -1) {
            this.sortBound = this.chunkcount;
        }
        this.lastTimeWrote = System.currentTimeMillis();
    }

    protected final void addSorted(byte[] a, int astart, int alength) throws SpaceExceededException {
        assert (a != null);
        assert (astart >= 0 && astart < a.length) : " astart = " + astart;
        assert (!RowCollection.allZero(a, astart, alength)) : "a = " + NaturalOrder.arrayList(a, astart, alength);
        assert (alength > 0);
        assert (astart + alength <= a.length);
        assert (alength == this.rowdef.objectsize) : "alength =" + alength + ", rowdef.objectsize = " + this.rowdef.objectsize;
        int l = Math.min(this.rowdef.objectsize, Math.min(alength, a.length - astart));
        this.ensureSize(this.chunkcount + 1);
        System.arraycopy(a, astart, this.chunkcache, this.rowdef.objectsize * this.chunkcount, l);
        ++this.chunkcount;
        this.sortBound = this.chunkcount;
        this.lastTimeWrote = System.currentTimeMillis();
    }

    private static final boolean allZero(byte[] a, int astart, int alength) {
        for (int i = 0; i < alength; ++i) {
            if (a[astart + i] == 0) continue;
            return false;
        }
        return true;
    }

    public final synchronized void addAllUnique(RowCollection c) throws SpaceExceededException {
        if (c == null) {
            return;
        }
        assert (this.rowdef.objectsize == c.rowdef.objectsize);
        this.ensureSize(this.chunkcount + c.size());
        System.arraycopy(c.chunkcache, 0, this.chunkcache, this.rowdef.objectsize * this.chunkcount, this.rowdef.objectsize * c.size());
        this.chunkcount += c.size();
    }

    public final synchronized void removeRow(int p, boolean keepOrder) {
        assert (p >= 0) : "p = " + p;
        assert (p < this.chunkcount) : "p = " + p + ", chunkcount = " + this.chunkcount;
        assert (this.chunkcount > 0) : "chunkcount = " + this.chunkcount;
        assert (this.sortBound <= this.chunkcount) : "sortBound = " + this.sortBound + ", chunkcount = " + this.chunkcount;
        if (keepOrder && p < this.sortBound) {
            int addr = p * this.rowdef.objectsize;
            System.arraycopy(this.chunkcache, addr + this.rowdef.objectsize, this.chunkcache, addr, (this.chunkcount - p - 1) * this.rowdef.objectsize);
            --this.sortBound;
        } else {
            if (p != this.chunkcount - 1) {
                System.arraycopy(this.chunkcache, (this.chunkcount - 1) * this.rowdef.objectsize, this.chunkcache, p * this.rowdef.objectsize, this.rowdef.objectsize);
            }
            if (this.sortBound > p) {
                this.sortBound = p;
            }
        }
        --this.chunkcount;
        this.lastTimeWrote = System.currentTimeMillis();
        this.checkShrink();
    }

    @Override
    public final void delete(int p) {
        this.removeRow(p, true);
    }

    public synchronized Row.Entry removeOne() {
        if (this.chunkcount == 0) {
            return null;
        }
        Row.Entry r = this.get(this.chunkcount - 1, true);
        if (this.chunkcount == this.sortBound) {
            --this.sortBound;
        }
        --this.chunkcount;
        this.lastTimeWrote = System.currentTimeMillis();
        this.checkShrink();
        return r;
    }

    public synchronized List<Row.Entry> top(int count) {
        if (count > this.chunkcount) {
            count = this.chunkcount;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        if (this.chunkcount == 0 || count == 0) {
            return list2;
        }
        for (int cursor = this.chunkcount - 1; count > 0 && cursor >= 0; --count, --cursor) {
            Row.Entry entry2 = this.get(cursor, true);
            list2.add(entry2);
        }
        return list2;
    }

    public synchronized List<Row.Entry> random(int count) {
        if (count > this.chunkcount) {
            count = this.chunkcount;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        if (this.chunkcount == 0 || count == 0) {
            return list2;
        }
        int stepsize = this.chunkcount / count;
        for (int cursor = 0; count > 0 && cursor < this.chunkcount; --count, cursor += stepsize) {
            Row.Entry entry2 = this.get(cursor, true);
            list2.add(entry2);
        }
        return list2;
    }

    public synchronized byte[] smallestKey() {
        if (this.chunkcount == 0) {
            return null;
        }
        this.sort();
        Row.Entry r = this.get(0, false);
        byte[] b = r.getPrimaryKeyBytes();
        return b;
    }

    public synchronized byte[] largestKey() {
        if (this.chunkcount == 0) {
            return null;
        }
        this.sort();
        Row.Entry r = this.get(this.chunkcount - 1, false);
        byte[] b = r.getPrimaryKeyBytes();
        return b;
    }

    public synchronized void clear() {
        if (this.chunkcache.length == 0) {
            return;
        }
        this.chunkcache = new byte[0];
        this.chunkcount = 0;
        this.sortBound = 0;
        this.lastTimeWrote = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return this.chunkcount;
    }

    public boolean isEmpty() {
        return this.chunkcount == 0;
    }

    public int sorted() {
        return this.sortBound;
    }

    public synchronized Iterator<byte[]> keys(boolean keepOrderWhenRemoving) {
        return new keyIterator(keepOrderWhenRemoving);
    }

    @Override
    public Iterator<Row.Entry> iterator() {
        return new rowIterator();
    }

    public void optimize() {
        this.sort();
        this.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sort() {
        if (this.sortBound == this.chunkcount) {
            return;
        }
        RowCollection rowCollection = this;
        synchronized (rowCollection) {
            if (this.sortBound == this.chunkcount) {
                return;
            }
            Array.sort(this);
            this.sortBound = this.chunkcount;
        }
    }

    final int partition(int L, int R, int S, byte[] swapspace) {
        assert (L < R - 1) : "L = " + L + ", R = " + R + ", S = " + S;
        assert (R - L >= 20) : "L = " + L + ", R = " + R + ", S = " + S + ", isortlimit = 20";
        int p = L;
        int q = R - 1;
        int pivot = this.pivot(L, R, S);
        if (this.rowdef.objectOrder instanceof Base64Order) {
            while (p <= q) {
                if (pivot < S && p < pivot) {
                    p = pivot;
                    S = 0;
                } else {
                    while (p < R - 1 && this.compare(pivot, p) >= 0) {
                        ++p;
                    }
                }
                while (q > L && this.compare(pivot, q) <= 0) {
                    --q;
                }
                if (p > q) continue;
                pivot = this.swap(p, q, pivot, swapspace);
                ++p;
                --q;
            }
        } else {
            while (p <= q) {
                if (pivot < S && p < pivot) {
                    p = pivot;
                    S = 0;
                } else {
                    while (p < R - 1 && this.compare(pivot, p) >= 0) {
                        ++p;
                    }
                }
                while (q > L && this.compare(pivot, q) <= 0) {
                    --q;
                }
                if (p > q) continue;
                pivot = this.swap(p, q, pivot, swapspace);
                ++p;
                --q;
            }
        }
        if (pivot < p) {
            this.swap(pivot, p - 1, pivot, swapspace);
            return p - 1;
        }
        if (pivot > p) {
            this.swap(pivot, p, pivot, swapspace);
            return p;
        }
        assert (pivot == p);
        return p;
    }

    private final int pivot(int L, int R, int S) {
        if (S == 0 || S < L) {
            int m = this.picMiddle(L, (3 * L + R - 1) / 4, (L + R - 1) / 2, (L + 3 * R - 3) / 4, R - 1);
            assert (L <= m);
            assert (m < R);
            return m;
        }
        if (S < R) {
            int m = this.picMiddle(L, L + (S - L) / 3, (L + R - 1) / 2, S, R - 1);
            assert (L <= m);
            assert (m < R);
            return m;
        }
        return (L + R - 1) / 2;
    }

    private final int picMiddle(int a, int b, int c, int d, int e) {
        return this.picMiddle(this.picMiddle(a, b, c), d, e);
    }

    private final int picMiddle(int a, int b, int c) {
        if (this.compare(a, b) > 0) {
            if (this.compare(c, a) > 0) {
                return a;
            }
            if (this.compare(b, c) > 0) {
                return b;
            }
        } else {
            if (this.compare(a, c) > 0) {
                return a;
            }
            if (this.compare(c, b) > 0) {
                return b;
            }
        }
        return c;
    }

    private final int swap(int i, int j, int p, byte[] swapspace) {
        if (i == j) {
            return p;
        }
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * i, swapspace, 0, this.rowdef.objectsize);
        System.arraycopy(this.chunkcache, this.rowdef.objectsize * j, this.chunkcache, this.rowdef.objectsize * i, this.rowdef.objectsize);
        System.arraycopy(swapspace, 0, this.chunkcache, this.rowdef.objectsize * j, this.rowdef.objectsize);
        if (i == p) {
            return j;
        }
        if (j == p) {
            return i;
        }
        return p;
    }

    protected synchronized void uniq() {
        Array.uniq(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<RowCollection> removeDoubles() throws SpaceExceededException {
        assert (this.rowdef.objectOrder != null);
        this.sort();
        ArrayList<RowCollection> report = new ArrayList<RowCollection>();
        if (this.chunkcount < 2) {
            return report;
        }
        boolean u = true;
        RowCollection collection = new RowCollection(this.rowdef, 2);
        try {
            for (int i = this.chunkcount - 2; i >= 0; --i) {
                if (this.match(i, i + 1)) {
                    collection.addUnique(this.get(i + 1, false));
                    this.removeRow(i + 1, false);
                    if (i + 1 >= this.chunkcount - 1) continue;
                    u = false;
                    continue;
                }
                if (collection.isEmpty()) continue;
                collection.addUnique(this.get(i + 1, false));
                this.removeRow(i + 1, false);
                if (i + 1 < this.chunkcount - 1) {
                    u = false;
                }
                collection.trim();
                report.add(collection);
                collection = new RowSet(this.rowdef, 2);
            }
        }
        catch (RuntimeException e) {
            ConcurrentLog.warn("kelondroRowCollection", e.getMessage(), e);
        }
        finally {
            if (!u) {
                this.sort();
            }
        }
        return report;
    }

    public synchronized boolean isSorted() {
        assert (this.rowdef.objectOrder != null);
        if (this.chunkcount <= 1) {
            return true;
        }
        return this.chunkcount == this.sortBound;
    }

    public synchronized String toString() {
        StringBuilder s = new StringBuilder(80);
        Iterator<Row.Entry> i = this.iterator();
        if (i.hasNext()) {
            s.append(i.next().toString());
        }
        while (i.hasNext()) {
            s.append(", " + i.next().toString());
        }
        return s.toString();
    }

    @Override
    private final int compare(int i, int j) {
        assert (this.chunkcount * this.rowdef.objectsize <= this.chunkcache.length) : "chunkcount = " + this.chunkcount + ", objsize = " + this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        assert (i >= 0 && i < this.chunkcount) : "i = " + i + ", chunkcount = " + this.chunkcount;
        assert (j >= 0 && j < this.chunkcount) : "j = " + j + ", chunkcount = " + this.chunkcount;
        assert (this.rowdef.objectOrder != null);
        if (i == j) {
            return 0;
        }
        int c = this.rowdef.objectOrder.compare(this.chunkcache, i * this.rowdef.objectsize, this.chunkcache, j * this.rowdef.objectsize, this.rowdef.primaryKeyLength);
        return c;
    }

    protected int compare(byte[] a, int astart, int chunknumber) {
        assert (chunknumber < this.chunkcount);
        assert (a.length - astart >= this.rowdef.primaryKeyLength);
        int len = Math.min(a.length - astart, this.rowdef.primaryKeyLength);
        return this.rowdef.objectOrder.compare(a, astart, this.chunkcache, chunknumber * this.rowdef.objectsize, len);
    }

    protected final boolean match(int i, int j) {
        assert (this.chunkcount * this.rowdef.objectsize <= this.chunkcache.length) : "chunkcount = " + this.chunkcount + ", objsize = " + this.rowdef.objectsize + ", chunkcache.length = " + this.chunkcache.length;
        assert (i >= 0 && i < this.chunkcount) : "i = " + i + ", chunkcount = " + this.chunkcount;
        assert (j >= 0 && j < this.chunkcount) : "j = " + j + ", chunkcount = " + this.chunkcount;
        if (i >= this.chunkcount) {
            return false;
        }
        if (j >= this.chunkcount) {
            return false;
        }
        assert (this.rowdef.objectOrder != null);
        if (i == j) {
            return true;
        }
        int astart = i * this.rowdef.objectsize;
        int bstart = j * this.rowdef.objectsize;
        int k = this.rowdef.primaryKeyLength;
        while (k-- != 0) {
            if (this.chunkcache[astart++] == this.chunkcache[bstart++]) continue;
            return false;
        }
        return true;
    }

    protected boolean match(byte[] a, int astart, int chunknumber) {
        if (chunknumber >= this.chunkcount) {
            return false;
        }
        assert (a.length - astart >= this.rowdef.primaryKeyLength);
        int p = chunknumber * this.rowdef.objectsize;
        int len = Math.min(a.length - astart, this.rowdef.primaryKeyLength);
        while (len != 0) {
            if (a[astart] != this.chunkcache[p]) {
                return false;
            }
            --len;
            ++astart;
            ++p;
        }
        return true;
    }

    public synchronized void close() {
        this.chunkcache = null;
    }

    private static long d(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return a / b;
    }

    private static String randomHash() {
        return Base64Order.enhancedCoder.encodeLongSB(random.nextLong(), 4).toString() + Base64Order.enhancedCoder.encodeLongSB(random.nextLong(), 4).toString() + Base64Order.enhancedCoder.encodeLongSB(random.nextLong(), 4).toString();
    }

    public static void test(int testsize) throws SpaceExceededException {
        int i;
        Row r = new Row(new Column[]{new Column("hash", 3, 3, 12, "hash")}, (ByteOrder)Base64Order.enhancedCoder);
        random = new Random(0L);
        for (int i2 = 0; i2 < testsize; ++i2) {
            byte[] b;
            byte[] a = ASCII.getBytes(RowCollection.randomHash());
            int c = Base64Order.enhancedCoder.compare(a, b = ASCII.getBytes(RowCollection.randomHash()));
            if (c == 0 && Base64Order.enhancedCoder.compare(b, a) != 0) {
                System.out.println("compare failed / =; a = " + ASCII.String(a) + ", b = " + ASCII.String(b));
            }
            if (c == -1 && Base64Order.enhancedCoder.compare(b, a) != 1) {
                System.out.println("compare failed / =; a < " + ASCII.String(a) + ", b = " + ASCII.String(b));
            }
            if (c != 1 || Base64Order.enhancedCoder.compare(b, a) == -1) continue;
            System.out.println("compare failed / =; a > " + ASCII.String(a) + ", b = " + ASCII.String(b));
        }
        RowCollection a = new RowCollection(r, testsize);
        a.add("AAAAAAAAAAAA".getBytes());
        a.add("BBBBBBBBBBBB".getBytes());
        a.add("BBBBBBBBBBBB".getBytes());
        a.add("BBBBBBBBBBBB".getBytes());
        a.add("CCCCCCCCCCCC".getBytes());
        ArrayList<RowCollection> del = a.removeDoubles();
        System.out.println(del + "rows double");
        Iterator<Row.Entry> j = a.iterator();
        while (j.hasNext()) {
            System.out.println(UTF8.String(j.next().bytes()));
        }
        System.out.println("kelondroRowCollection test with size = " + testsize);
        a = new RowCollection(r, testsize);
        long t0 = System.nanoTime();
        random = new Random(0L);
        for (i = 0; i < testsize / 2; ++i) {
            a.add(RowCollection.randomHash().getBytes());
        }
        random = new Random(0L);
        for (i = 0; i < testsize / 2; ++i) {
            a.add(RowCollection.randomHash().getBytes());
        }
        a.sort();
        a.uniq();
        for (i = 0; i < a.size() - 1; ++i) {
            if (a.get(i, false).compareTo(a.get(i + 1, false)) < 0) continue;
            System.out.println("Compare error at pos " + i + ": a.get(i)=" + a.get(i, false) + ", a.get(i + 1)=" + a.get(i + 1, false));
        }
        long t1 = System.nanoTime();
        System.out.println("create a   : " + (t1 - t0) + " nanoseconds, " + RowCollection.d(testsize, t1 - t0) + " entries/nanoseconds; a.size() = " + a.size());
        RowCollection c = new RowCollection(r, testsize);
        random = new Random(0L);
        t0 = System.nanoTime();
        for (int i3 = 0; i3 < testsize; ++i3) {
            c.add(RowCollection.randomHash().getBytes());
        }
        t1 = System.nanoTime();
        System.out.println("create c   : " + (t1 - t0) + " nanoseconds, " + RowCollection.d(testsize, t1 - t0) + " entries/nanoseconds");
        RowCollection d = new RowCollection(r, testsize);
        for (int i4 = 0; i4 < testsize; ++i4) {
            d.add(c.get(i4, false).getPrimaryKeyBytes());
        }
        long t2 = System.nanoTime();
        System.out.println("copy c -> d: " + (t2 - t1) + " nanoseconds, " + RowCollection.d(testsize, t2 - t1) + " entries/nanoseconds");
        c.sort();
        long t3 = System.nanoTime();
        System.out.println("sort c (1) : " + (t3 - t2) + " nanoseconds, " + RowCollection.d(testsize, t3 - t2) + " entries/nanoseconds");
        d.sort();
        long t4 = System.nanoTime();
        System.out.println("sort d (2) : " + (t4 - t3) + " nanoseconds, " + RowCollection.d(testsize, t4 - t3) + " entries/nanoseconds");
        c.uniq();
        long t5 = System.nanoTime();
        System.out.println("uniq c     : " + (t5 - t4) + " nanoseconds, " + RowCollection.d(testsize, t5 - t4) + " entries/nanoseconds");
        d.uniq();
        long t6 = System.nanoTime();
        System.out.println("uniq d     : " + (t6 - t5) + " nanoseconds, " + RowCollection.d(testsize, t6 - t5) + " entries/nanoseconds");
        random = new Random(0L);
        RowSet e = new RowSet(r, testsize);
        for (int i5 = 0; i5 < testsize; ++i5) {
            e.put(r.newEntry(RowCollection.randomHash().getBytes()));
        }
        long t7 = System.nanoTime();
        System.out.println("create e   : " + (t7 - t6) + " nanoseconds, " + RowCollection.d(testsize, t7 - t6) + " entries/nanoseconds");
        e.sort();
        long t8 = System.nanoTime();
        System.out.println("sort e (2) : " + (t8 - t7) + " nanoseconds, " + RowCollection.d(testsize, t8 - t7) + " entries/nanoseconds");
        e.uniq();
        long t9 = System.nanoTime();
        System.out.println("uniq e     : " + (t9 - t8) + " nanoseconds, " + RowCollection.d(testsize, t9 - t8) + " entries/nanoseconds");
        boolean cis = c.isSorted();
        long t10 = System.nanoTime();
        System.out.println("c isSorted = " + (cis ? "true" : "false") + ": " + (t10 - t9) + " nanoseconds");
        boolean dis = d.isSorted();
        long t11 = System.nanoTime();
        System.out.println("d isSorted = " + (dis ? "true" : "false") + ": " + (t11 - t10) + " nanoseconds");
        boolean eis = e.isSorted();
        long t12 = System.nanoTime();
        System.out.println("e isSorted = " + (eis ? "true" : "false") + ": " + (t12 - t11) + " nanoseconds");
        random = new Random(0L);
        boolean allfound = true;
        for (int i6 = 0; i6 < testsize; ++i6) {
            String rh = RowCollection.randomHash();
            if (e.get(rh.getBytes(), true) != null) continue;
            allfound = false;
            System.out.println("not found hash " + rh + " at attempt " + i6);
            break;
        }
        long t13 = System.nanoTime();
        System.out.println("e allfound = " + (allfound ? "true" : "false") + ": " + (t13 - t12) + " nanoseconds");
        boolean noghosts = true;
        for (int i7 = 0; i7 < testsize; ++i7) {
            if (e.get(RowCollection.randomHash().getBytes(), true) == null) continue;
            noghosts = false;
            break;
        }
        long t14 = System.nanoTime();
        System.out.println("e noghosts = " + (noghosts ? "true" : "false") + ": " + (t14 - t13) + " nanoseconds");
        System.out.println("Result size: c = " + c.size() + ", d = " + d.size() + ", e = " + e.size());
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            RowCollection.test(500000);
            ConcurrentLog.shutdown();
        }
        catch (SpaceExceededException e) {
            e.printStackTrace();
        }
    }

    static {
        random = null;
    }

    private class keyIterator
    implements Iterator<byte[]> {
        private int p = 0;
        private final boolean keepOrderWhenRemoving;

        private keyIterator(boolean keepOrderWhenRemoving) {
            this.keepOrderWhenRemoving = keepOrderWhenRemoving;
        }

        @Override
        public boolean hasNext() {
            return this.p < RowCollection.this.chunkcount;
        }

        @Override
        public byte[] next() {
            return RowCollection.this.getKey(this.p++);
        }

        @Override
        public void remove() {
            --this.p;
            RowCollection.this.removeRow(this.p, this.keepOrderWhenRemoving);
        }
    }

    private class rowIterator
    implements Iterator<Row.Entry> {
        private int p = 0;

        @Override
        public boolean hasNext() {
            return this.p < RowCollection.this.chunkcount;
        }

        @Override
        public Row.Entry next() {
            return RowCollection.this.get(this.p++, true);
        }

        @Override
        public void remove() {
            --this.p;
            RowCollection.this.removeRow(this.p, true);
        }
    }

    public static class partitionthread
    implements Callable<Integer> {
        RowCollection rc;
        int L;
        int R;
        int S;

        public partitionthread(RowCollection rc, int L, int R, int S) {
            this.rc = rc;
            this.L = L;
            this.R = R;
            this.S = S;
        }

        @Override
        public Integer call() throws Exception {
            return this.rc.partition(this.L, this.R, this.S, new byte[this.rc.rowdef.objectsize]);
        }
    }
}

