/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.AbstractOrder;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.order.Order;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.kelondroException;

public final class Row
implements Serializable {
    private static final long serialVersionUID = -148412365988669116L;
    protected final Column[] row;
    public final int[] colstart;
    public final ByteOrder objectOrder;
    public final int objectsize;
    public final int primaryKeyLength;
    protected Map<String, Object[]> nickref = null;

    public Row(Column[] row, ByteOrder objectOrder) {
        assert (objectOrder != null);
        this.objectOrder = objectOrder;
        this.row = row;
        assert (objectOrder != null);
        this.colstart = new int[row.length];
        int os = 0;
        for (int i = 0; i < row.length; ++i) {
            this.colstart[i] = os;
            os += this.row[i].cellwidth;
        }
        this.objectsize = os;
        this.primaryKeyLength = this.row[0].cellwidth;
    }

    public Row(String structure, ByteOrder objectOrder) {
        assert (objectOrder != null);
        this.objectOrder = objectOrder;
        int p = structure.indexOf(124);
        if (p < 0) {
            p = structure.length();
        }
        ArrayList<Column> l = new ArrayList<Column>();
        String attr = structure.substring(0, p);
        StringTokenizer st = new StringTokenizer(attr, ",");
        while (st.hasMoreTokens()) {
            l.add(new Column(st.nextToken()));
        }
        this.row = new Column[l.size()];
        this.colstart = new int[this.row.length];
        int os = 0;
        for (int i = 0; i < l.size(); ++i) {
            this.colstart[i] = os;
            this.row[i] = (Column)l.get(i);
            os += this.row[i].cellwidth;
        }
        this.objectsize = os;
        this.primaryKeyLength = this.row[0].cellwidth;
    }

    public final ByteOrder getOrdering() {
        return this.objectOrder;
    }

    protected final void genNickRef() {
        if (this.nickref != null) {
            return;
        }
        this.nickref = new ConcurrentHashMap<String, Object[]>(this.row.length);
        for (int i = 0; i < this.row.length; ++i) {
            this.nickref.put(this.row[i].nickname, new Object[]{this.row[i], this.colstart[i]});
        }
    }

    public final int columns() {
        return this.row.length;
    }

    public final Column column(int col) {
        return this.row[col];
    }

    public final int width(int column) {
        return this.row[column].cellwidth;
    }

    public final int[] widths() {
        int[] w = new int[this.row.length];
        for (int i = 0; i < this.row.length; ++i) {
            w[i] = this.row[i].cellwidth;
        }
        return w;
    }

    public final String toString() {
        StringBuilder s = new StringBuilder(80);
        s.append(this.row[0].toString());
        for (int i = 1; i < this.row.length; ++i) {
            s.append(", ");
            s.append(this.row[i].toString());
        }
        return s.toString();
    }

    public final Entry newEntry() {
        return new Entry();
    }

    public final Entry newEntry(byte[] rowinstance) {
        if (rowinstance == null) {
            return null;
        }
        assert (this.objectOrder.wellformed(rowinstance, 0, this.primaryKeyLength)) : "row not well-formed: rowinstance[0] = " + UTF8.String(rowinstance, 0, this.primaryKeyLength) + " / " + NaturalOrder.arrayList(rowinstance, 0, this.primaryKeyLength);
        return new Entry(rowinstance, 0, false);
    }

    public final Entry newEntry(Entry oldrow, int fromColumn) {
        if (oldrow == null) {
            return null;
        }
        assert (oldrow.getColBytes(0, false)[0] != 0);
        assert (this.objectOrder.wellformed(oldrow.getPrimaryKeyBytes(), 0, this.primaryKeyLength));
        return new Entry(oldrow.rowinstance, oldrow.offset + oldrow.colstart(fromColumn), false);
    }

    public final Entry newEntry(byte[] rowinstance, int start, boolean clone) {
        if (rowinstance == null) {
            return null;
        }
        try {
            assert (this.objectOrder.wellformed(rowinstance, start, this.primaryKeyLength)) : "rowinstance = " + UTF8.String(rowinstance);
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
        return new Entry(rowinstance, start, clone);
    }

    public final Entry newEntry(byte[][] cells) {
        if (cells == null) {
            return null;
        }
        assert (cells[0][0] != 0);
        assert (this.objectOrder.wellformed(cells[0], 0, this.primaryKeyLength));
        return new Entry(cells);
    }

    public final Entry newEntry(String external, boolean decimalCardinal) {
        if (external == null) {
            return null;
        }
        return new Entry(external, decimalCardinal);
    }

    public final EntryIndex newEntryIndex(byte[] rowinstance, int index2) {
        if (rowinstance == null) {
            return null;
        }
        assert (rowinstance[0] != 0);
        assert (this.objectOrder.wellformed(rowinstance, 0, this.primaryKeyLength));
        return new EntryIndex(rowinstance, index2);
    }

    public Queue newQueue(int maxsize) {
        return new Queue(maxsize);
    }

    public static final void long2bytes(long x, byte[] b, int offset, int length) {
        for (int i = length - 1; i >= 0; --i) {
            b[offset + i] = (byte)(x & 0xFFL);
            x >>= 8;
        }
    }

    public static final long bytes2long(byte[] b, int offset, int length) {
        if (b == null) {
            return 0L;
        }
        long x = 0L;
        for (int i = 0; i < length; ++i) {
            x = x << 8 | (long)(0xFF & b[offset + i]);
        }
        return x;
    }

    public final boolean subsumes(Row otherRow) {
        if (this.objectsize < otherRow.objectsize) {
            return false;
        }
        for (int i = 0; i < otherRow.row.length; ++i) {
            if (this.row[i].cellwidth == otherRow.row[i].cellwidth && this.row[i].celltype == 5 && otherRow.row[i].celltype == 2 || this.row[i].equals(otherRow.row[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        if (this.objectsize != other.objectsize) {
            return false;
        }
        if (this.columns() != other.columns()) {
            return false;
        }
        for (int i = 0; i < other.row.length; ++i) {
            if (this.row[i].equals(other.row[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public class Entry
    implements Comparable<Entry>,
    Comparator<Entry>,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -2576312347345553495L;
        private byte[] rowinstance;
        private int offset;

        public Entry() {
            this.rowinstance = new byte[Row.this.objectsize];
            this.offset = 0;
        }

        public Entry(byte[] newrow, int start, boolean forceclone) {
            if (forceclone || newrow.length - start < Row.this.objectsize) {
                this.rowinstance = new byte[Row.this.objectsize];
                System.arraycopy(newrow, start, this.rowinstance, 0, Math.min(newrow.length, Row.this.objectsize));
                this.offset = 0;
            } else {
                this.rowinstance = newrow;
                this.offset = start;
            }
        }

        public Entry(byte[][] cols) {
            assert (Row.this.row.length == cols.length) : "cols.length = " + cols.length + ", row.length = " + this$0.row.length;
            this.rowinstance = new byte[Row.this.objectsize];
            this.offset = 0;
            for (int i = 0; i < Row.this.row.length; ++i) {
                int j;
                int cs = Row.this.colstart[i];
                int cw = Row.this.row[i].cellwidth;
                if (i >= cols.length || cols[i] == null) {
                    for (j = 0; j < cw; ++j) {
                        this.rowinstance[cs + j] = 0;
                    }
                    continue;
                }
                int ll = Math.min(cols[i].length, cw);
                System.arraycopy(cols[i], 0, this.rowinstance, cs, ll);
                for (j = ll; j < cw; ++j) {
                    this.rowinstance[cs + j] = 0;
                }
            }
        }

        public Entry(String external, boolean decimalCardinal) {
            if (!external.isEmpty() && external.charAt(0) == '{') {
                external = external.substring(1, external.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(external, ",");
            if (Row.this.nickref == null) {
                Row.this.genNickRef();
            }
            this.rowinstance = new byte[Row.this.objectsize];
            this.offset = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int p = token.indexOf(61);
                if (p < 0) {
                    p = token.indexOf(58);
                }
                if (p <= 0) continue;
                String nick = token.substring(0, p).trim();
                if (nick.charAt(0) == '\"' && nick.charAt(nick.length() - 1) == '\"') {
                    nick = nick.substring(1, nick.length() - 1);
                }
                Object[] ref = Row.this.nickref.get(nick);
                Column col = (Column)ref[0];
                int clstrt = (Integer)ref[1];
                if (p + 1 == token.length()) {
                    this.setCol(clstrt, col.cellwidth, null);
                    continue;
                }
                if (decimalCardinal && col.celltype == 4) {
                    try {
                        this.setCol(col.encoder, this.offset + clstrt, col.cellwidth, NumberTools.parseLongDecSubstring(token, p + 1));
                    }
                    catch (NumberFormatException e) {
                        ConcurrentLog.severe("kelondroRow", "NumberFormatException for celltype_cardinal, celltype = " + col.celltype + ", encoder = " + col.encoder + ", value = '" + token.substring(p + 1).trim() + "'");
                        this.setCol(col.encoder, this.offset + clstrt, col.cellwidth, 0L);
                    }
                    continue;
                }
                if (decimalCardinal && col.celltype == 2) {
                    assert (col.cellwidth == 1);
                    try {
                        this.setCol(clstrt, col.cellwidth, new byte[]{(byte)NumberTools.parseIntDecSubstring(token, p + 1)});
                    }
                    catch (NumberFormatException e) {
                        ConcurrentLog.severe("kelondroRow", "NumberFormatException for celltype_binary, celltype = " + col.celltype + ", encoder = " + col.encoder + ", value = '" + token.substring(p + 1).trim() + "'");
                        this.setCol(clstrt, col.cellwidth, new byte[]{0});
                    }
                    continue;
                }
                if (decimalCardinal && col.celltype == 5) {
                    this.setCol(clstrt, col.cellwidth, new Bitfield(col.cellwidth, token.substring(p + 1).trim()).bytes());
                    continue;
                }
                this.setCol(clstrt, col.cellwidth, UTF8.getBytes(token.substring(p + 1).trim()));
            }
        }

        protected final int colstart(int column) {
            return Row.this.colstart[column];
        }

        protected final int cellwidth(int column) {
            return Row.this.row[column].cellwidth;
        }

        @Override
        public final int compareTo(Entry o) {
            if (Row.this.objectOrder == null) {
                throw new kelondroException("objects cannot be compared, no order given");
            }
            assert (Row.this.primaryKeyLength == o.getPrimaryKeyLength());
            return Row.this.objectOrder.compare(this.bytes(), o.bytes(), Row.this.primaryKeyLength);
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            byte[] t = this.bytes();
            byte[] o = other.bytes();
            for (int i = 0; i < Row.this.primaryKeyLength; ++i) {
                if (t[i] == o[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            byte[] b = this.getPrimaryKeyBytes();
            int len = b.length;
            int h = 1;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + b[i];
            }
            return h;
        }

        public final byte[] bytes() {
            if (this.offset == 0 && this.rowinstance.length == Row.this.objectsize) {
                return this.rowinstance;
            }
            byte[] tmp = new byte[Row.this.objectsize];
            System.arraycopy(this.rowinstance, this.offset, tmp, 0, Row.this.objectsize);
            return tmp;
        }

        public final void writeToArray(byte[] target, int targetOffset) {
            assert (targetOffset + Row.this.objectsize <= target.length) : "targetOffset = " + targetOffset + ", target.length = " + target.length + ", objectsize = " + Row.this.objectsize;
            System.arraycopy(this.rowinstance, this.offset, target, targetOffset, Row.this.objectsize);
        }

        public final int columns() {
            return Row.this.row.length;
        }

        public final int objectsize() {
            return Row.this.objectsize;
        }

        public final boolean empty(int column) {
            return this.rowinstance[this.offset + Row.this.colstart[column]] == 0;
        }

        public final void setCol(int column, byte[] cell) {
            this.setCol(Row.this.colstart[column], Row.this.row[column].cellwidth, cell);
        }

        public final void setCol(int column, char[] cell) {
            int i;
            int clstrt = Row.this.colstart[column];
            for (i = 0; i < cell.length; ++i) {
                this.rowinstance[this.offset + clstrt + i] = (byte)cell[i];
            }
            for (i = cell.length; i < Row.this.row[column].cellwidth; ++i) {
                this.rowinstance[this.offset + clstrt + i] = 0;
            }
        }

        private final void setCol(int clstrt, int length, byte[] cell) {
            if (cell == null) {
                while (length-- > 0) {
                    this.rowinstance[this.offset + clstrt + length] = 0;
                }
            } else if (cell.length < length) {
                System.arraycopy(cell, 0, this.rowinstance, this.offset + clstrt, cell.length);
                while (length-- > cell.length) {
                    this.rowinstance[this.offset + clstrt + length] = 0;
                }
            } else {
                System.arraycopy(cell, 0, this.rowinstance, this.offset + clstrt, length);
            }
        }

        public final void setCol(int column, byte c) {
            this.rowinstance[this.offset + Row.this.colstart[column]] = c;
        }

        public final void setCol(int column, String cell) {
            this.setCol(column, UTF8.getBytes(cell));
        }

        public final void setCol(int column, long cell) {
            this.setCol(Row.this.row[column].encoder, this.offset + Row.this.colstart[column], Row.this.row[column].cellwidth, cell);
        }

        private final void setCol(int encoder, int offset, int length, long cell) {
            switch (encoder) {
                case 0: {
                    throw new kelondroException("ROW", "setColLong has celltype none, no encoder given");
                }
                case 1: {
                    Base64Order.enhancedCoder.encodeLong(cell, this.rowinstance, offset, length);
                    break;
                }
                case 2: {
                    NaturalOrder.encodeLong(cell, this.rowinstance, offset, length);
                    break;
                }
                case 3: {
                    throw new kelondroException("ROW", "setColLong of celltype bytes not applicable");
                }
                default: {
                    throw new kelondroException("ROW", "setColLong has celltype none, no encoder given");
                }
            }
        }

        public final long incCol(int column, long c) {
            int encoder = Row.this.row[column].encoder;
            int colstrt = Row.this.colstart[column];
            int cellwidth = Row.this.row[column].cellwidth;
            switch (encoder) {
                case 1: {
                    long l = c + Base64Order.enhancedCoder.decodeLong(this.rowinstance, this.offset + colstrt, cellwidth);
                    Base64Order.enhancedCoder.encodeLong(l, this.rowinstance, this.offset + colstrt, cellwidth);
                    return l;
                }
                case 2: {
                    long l = c + NaturalOrder.decodeLong(this.rowinstance, this.offset + colstrt, cellwidth);
                    NaturalOrder.encodeLong(l, this.rowinstance, this.offset + colstrt, cellwidth);
                    return l;
                }
            }
            throw new kelondroException("ROW", "addCol did not find appropriate encoding");
        }

        public final byte[] getPrimaryKeyBytes() {
            if (this.rowinstance[this.offset] == 0) {
                return null;
            }
            if (Row.this.row.length == 1 && this.offset == 0 && this.rowinstance.length == Row.this.primaryKeyLength) {
                return this.rowinstance;
            }
            byte[] c = new byte[Row.this.primaryKeyLength];
            System.arraycopy(this.rowinstance, this.offset, c, 0, Row.this.primaryKeyLength);
            return c;
        }

        public final String getPrimaryKeyUTF8() {
            if (this.rowinstance[this.offset] == 0) {
                return null;
            }
            if (Row.this.row.length == 1 && this.offset == 0 && this.rowinstance.length == Row.this.primaryKeyLength) {
                return UTF8.String(this.rowinstance);
            }
            return UTF8.String(this.rowinstance, this.offset, Row.this.primaryKeyLength);
        }

        public final String getPrimaryKeyASCII() {
            if (this.rowinstance[this.offset] == 0) {
                return null;
            }
            if (Row.this.row.length == 1 && this.offset == 0 && this.rowinstance.length == Row.this.primaryKeyLength) {
                return ASCII.String(this.rowinstance);
            }
            return ASCII.String(this.rowinstance, this.offset, Row.this.primaryKeyLength);
        }

        public final String getColUTF8(int column) {
            int clstrt = Row.this.colstart[column];
            if (this.rowinstance[this.offset + clstrt] == 0) {
                return null;
            }
            int length = this.getColLength(column, clstrt);
            if (length == 0) {
                return null;
            }
            return UTF8.String(this.rowinstance, this.offset + clstrt, length);
        }

        public final String getColASCII(int column) {
            int clstrt = Row.this.colstart[column];
            if (this.rowinstance[this.offset + clstrt] == 0) {
                return null;
            }
            int length = this.getColLength(column, clstrt);
            if (length == 0) {
                return null;
            }
            return ASCII.String(this.rowinstance, this.offset + clstrt, length);
        }

        private final int getColLength(int column, int clstrt) {
            int length = Row.this.row[column].cellwidth;
            assert (length <= this.rowinstance.length - this.offset - clstrt);
            if (length > this.rowinstance.length - this.offset - clstrt) {
                length = this.rowinstance.length - this.offset - clstrt;
            }
            while (length > 0 && this.rowinstance[this.offset + clstrt + length - 1] == 0) {
                --length;
            }
            return length;
        }

        public final long getColLong(int column) {
            return this.getColLong(Row.this.row[column].encoder, Row.this.colstart[column], Row.this.row[column].cellwidth);
        }

        protected final long getColLong(int encoder, int clstrt, int length) {
            switch (encoder) {
                case 0: {
                    throw new kelondroException("ROW", "getColLong has celltype none, no encoder given");
                }
                case 1: {
                    if (length >= 3 && this.rowinstance[this.offset + clstrt] == 91 && this.rowinstance[this.offset + clstrt + 1] == 66 && this.rowinstance[this.offset + clstrt + 2] == 64) {
                        return 0L;
                    }
                    if (length == 2 && this.rowinstance[this.offset + clstrt] == 91 && this.rowinstance[this.offset + clstrt + 1] == 66) {
                        return 0L;
                    }
                    if (length == 1 && this.rowinstance[this.offset + clstrt] == 91) {
                        return 0L;
                    }
                    boolean maxvalue = true;
                    for (int i = 0; i < length; ++i) {
                        if (this.rowinstance[this.offset + clstrt + i] == 95) continue;
                        maxvalue = false;
                        break;
                    }
                    if (maxvalue) {
                        return 0L;
                    }
                    return Base64Order.enhancedCoder.decodeLong(this.rowinstance, this.offset + clstrt, length);
                }
                case 2: {
                    return NaturalOrder.decodeLong(this.rowinstance, this.offset + clstrt, length);
                }
                case 3: {
                    throw new kelondroException("ROW", "getColLong of celltype bytes not applicable");
                }
            }
            throw new kelondroException("ROW", "getColLong did not find appropriate encoding");
        }

        public final byte getColByte(int column) {
            return this.rowinstance[this.offset + Row.this.colstart[column]];
        }

        public final int getPrimaryKeyLength() {
            return Row.this.primaryKeyLength;
        }

        public final byte[] getColBytes(int column, boolean nullIfEmpty) {
            assert (this.offset + Row.this.colstart[column] + Row.this.row[column].cellwidth <= this.rowinstance.length) : "column = " + column + ", offset = " + this.offset + ", colstart[column] = " + Row.this.colstart[column] + ", row[column].cellwidth() = " + Row.this.row[column].cellwidth + ", rowinstance.length = " + this.rowinstance.length;
            int clstrt = Row.this.colstart[column];
            int w = Row.this.row[column].cellwidth;
            if (nullIfEmpty) {
                int length;
                for (length = w; length > 0 && this.rowinstance[this.offset + clstrt + length - 1] == 0; --length) {
                }
                if (length == 0) {
                    return null;
                }
            }
            byte[] c = new byte[w];
            System.arraycopy(this.rowinstance, this.offset + clstrt, c, 0, w);
            return c;
        }

        public final void writeToArray(int column, byte[] target, int targetOffset) {
            assert (targetOffset + Row.this.row[column].cellwidth <= target.length) : "targetOffset = " + targetOffset + ", target.length = " + target.length + ", row[column].cellwidth() = " + Row.this.row[column].cellwidth;
            System.arraycopy(this.rowinstance, this.offset + Row.this.colstart[column], target, targetOffset, Row.this.row[column].cellwidth);
        }

        public final String toPropertyForm(char propertySymbol, boolean includeBraces, boolean decimalCardinal, boolean longname, boolean quotes) {
            ByteBuffer bb = new ByteBuffer(this.objectsize() * 2);
            if (includeBraces) {
                bb.append('{');
            }
            for (int i = 0; i < Row.this.row.length; ++i) {
                if (quotes) {
                    bb.append('\"');
                }
                bb.append(longname ? Row.this.row[i].description : Row.this.row[i].nickname);
                if (quotes) {
                    bb.append('\"');
                }
                bb.append(propertySymbol);
                if (quotes) {
                    bb.append('\"');
                }
                if (decimalCardinal && Row.this.row[i].celltype == 4) {
                    bb.append(Long.toString(this.getColLong(i)));
                } else if (decimalCardinal && Row.this.row[i].celltype == 5) {
                    bb.append(new Bitfield(this.getColBytes(i, true)).exportB64());
                } else if (decimalCardinal && Row.this.row[i].celltype == 2) {
                    assert (Row.this.row[i].cellwidth == 1) : this.toString();
                    bb.append(Integer.toString(0xFF & this.getColByte(i)));
                } else {
                    bb.append(this.rowinstance, this.offset + Row.this.colstart[i], Row.this.row[i].cellwidth);
                }
                if (quotes) {
                    bb.append('\"');
                }
                if (i >= Row.this.row.length - 1) continue;
                bb.append(',');
                if (!longname) continue;
                bb.append(' ');
            }
            if (includeBraces) {
                bb.append('}');
            }
            String bbs = bb.toString();
            try {
                bb.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bbs;
        }

        public final String toString() {
            return this.toPropertyForm('=', true, false, false, false);
        }
    }

    public final class EntryIndex
    extends Entry
    implements Serializable {
        private static final long serialVersionUID = 153069052590699231L;
        private final int index;

        public EntryIndex(byte[] row, int i) {
            super(row, 0, false);
            this.index = i;
        }

        public int index() {
            return this.index;
        }
    }

    public final class Queue {
        private final ArrayBlockingQueue<Entry> queue;

        public Queue(int maxsize) {
            this.queue = new ArrayBlockingQueue(maxsize);
        }

        public void put(Entry e) throws InterruptedException {
            this.queue.put(e);
        }

        public Entry take() throws InterruptedException {
            return this.queue.take();
        }

        public Entry get(byte[] key) {
            for (Entry e : this.queue) {
                assert (key.length == e.getPrimaryKeyLength());
                if (Row.this.objectOrder.compare(key, 0, e.bytes(), 0, key.length) != 0) continue;
                return e;
            }
            return null;
        }

        public Entry delete(byte[] key) {
            Iterator<Entry> i = this.queue.iterator();
            while (i.hasNext()) {
                Entry e = i.next();
                assert (key.length == e.getPrimaryKeyLength());
                if (Row.this.objectOrder.compare(key, 0, e.bytes(), 0, key.length) != 0) continue;
                i.remove();
                return e;
            }
            return null;
        }
    }

    public static class EntryComparator
    extends AbstractOrder<Entry>
    implements Order<Entry>,
    Comparator<Entry>,
    Cloneable {
        ByteOrder base;

        public EntryComparator(ByteOrder baseOrder) {
            this.base = baseOrder;
        }

        @Override
        public int compare(Entry a, Entry b) {
            return a.compareTo(b);
        }

        @Override
        public boolean equal(Entry a, Entry b) {
            return a.equals(b);
        }

        @Override
        public Order<Entry> clone() {
            return new EntryComparator(this.base);
        }

        @Override
        public long cardinal(Entry key) {
            return this.base.cardinal(key.bytes(), 0, key.getPrimaryKeyLength());
        }

        @Override
        public String signature() {
            return this.base.signature();
        }

        @Override
        public boolean wellformed(Entry a) {
            return this.base.wellformed(a.getPrimaryKeyBytes());
        }
    }
}

