/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.Serializable;
import net.yacy.cora.util.NumberTools;
import net.yacy.kelondro.util.kelondroException;

public final class Column
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6558500565023465301L;
    public static final int celltype_undefined = 0;
    public static final int celltype_boolean = 1;
    public static final int celltype_binary = 2;
    public static final int celltype_string = 3;
    public static final int celltype_cardinal = 4;
    public static final int celltype_bitfield = 5;
    public static final int encoder_none = 0;
    public static final int encoder_b64e = 1;
    public static final int encoder_b256 = 2;
    public static final int encoder_bytes = 3;
    public int cellwidth;
    public final String nickname;
    protected final int celltype;
    protected final int encoder;
    protected final String description;

    public Column(String nickname, int celltype, int encoder, int cellwidth, String description) {
        this.celltype = celltype;
        this.cellwidth = cellwidth;
        this.encoder = encoder;
        this.nickname = nickname;
        this.description = description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Column(String celldef) {
        int q;
        celldef = celldef.trim();
        if (!celldef.isEmpty() && celldef.charAt(0) == '<') {
            celldef = celldef.substring(1);
        }
        if (celldef.endsWith(">")) {
            celldef = celldef.substring(0, celldef.length() - 1);
        }
        int p = celldef.indexOf(32);
        String typename = "";
        if (p < 0) {
            this.celltype = 0;
            this.cellwidth = -1;
        } else {
            typename = celldef.substring(0, p);
            celldef = celldef.substring(p + 1).trim();
            if (typename.equals("boolean")) {
                this.celltype = 1;
                this.cellwidth = 1;
            } else if (typename.equals("byte")) {
                this.celltype = 4;
                this.cellwidth = 1;
            } else if (typename.equals("short")) {
                this.celltype = 4;
                this.cellwidth = 2;
            } else if (typename.equals("int")) {
                this.celltype = 4;
                this.cellwidth = 4;
            } else if (typename.equals("long")) {
                this.celltype = 4;
                this.cellwidth = 8;
            } else if (typename.equals("byte[]")) {
                this.celltype = 2;
                this.cellwidth = -1;
            } else if (typename.equals("char")) {
                this.celltype = 3;
                this.cellwidth = 1;
            } else if (typename.equals("String")) {
                this.celltype = 3;
                this.cellwidth = -1;
            } else if (typename.equals("Cardinal")) {
                this.celltype = 4;
                this.cellwidth = -1;
            } else {
                if (!typename.equals("Bitfield")) throw new kelondroException("kelondroColumn - undefined type def '" + typename + "'");
                this.celltype = 5;
                this.cellwidth = -1;
            }
        }
        p = celldef.indexOf(45);
        if (p < 0) {
            if (this.cellwidth < 0) {
                throw new kelondroException("kelondroColumn - no cell width definition given");
            }
            q = celldef.indexOf(32);
            if (q < 0) {
                this.nickname = celldef;
                celldef = "";
            } else {
                this.nickname = celldef.substring(0, q);
                celldef = celldef.substring(q + 1).trim();
            }
        } else {
            this.nickname = celldef.substring(0, p);
            q = celldef.indexOf(32);
            if (q < 0) {
                try {
                    this.cellwidth = NumberTools.parseIntDecSubstring(celldef, p + 1);
                }
                catch (NumberFormatException e) {
                    throw new kelondroException("kelondroColumn - cellwidth description wrong:" + celldef.substring(p + 1));
                }
                celldef = "";
            } else {
                try {
                    this.cellwidth = NumberTools.parseIntDecSubstring(celldef, p + 1, q);
                }
                catch (NumberFormatException e) {
                    throw new kelondroException("kelondroColumn - cellwidth description wrong:" + celldef.substring(p + 1, q));
                }
                celldef = celldef.substring(q + 1);
            }
        }
        if (this.cellwidth < 0) {
            throw new kelondroException("kelondroColumn - no cell width given for " + this.nickname);
        }
        if (typename.equals("boolean") && this.cellwidth > 1 || typename.equals("byte") && this.cellwidth > 1 || typename.equals("short") && this.cellwidth > 2 || typename.equals("int") && this.cellwidth > 4 || typename.equals("long") && this.cellwidth > 8 || typename.equals("char") && this.cellwidth > 1) {
            throw new kelondroException("kelondroColumn - cell width " + this.cellwidth + " too wide for type " + typename);
        }
        if (!celldef.isEmpty() && celldef.charAt(0) == '{') {
            p = celldef.indexOf(125);
            String expf = celldef.substring(1, p);
            celldef = celldef.substring(p + 1).trim();
            if (expf.equals("b64e")) {
                this.encoder = 1;
            } else if (expf.equals("b256")) {
                this.encoder = 2;
            } else if (expf.equals("bytes")) {
                this.encoder = 3;
            } else if (this.celltype == 0) {
                this.encoder = 3;
            } else if (this.celltype == 1) {
                this.encoder = 3;
            } else if (this.celltype == 2) {
                this.encoder = 3;
            } else {
                if (this.celltype != 3) throw new kelondroException("kelondroColumn - encoder missing for cell '" + this.nickname + "'");
                this.encoder = 3;
            }
        } else {
            if (this.celltype == 4) {
                throw new kelondroException("kelondroColumn - encoder missing for cell " + this.nickname);
            }
            this.encoder = 3;
        }
        assert (this.celltype != 4 || this.encoder == 1 || this.encoder == 2);
        if (!celldef.isEmpty() && celldef.charAt(0) == '\"') {
            p = celldef.indexOf(34, 1);
            this.description = celldef.substring(1, p);
            return;
        } else {
            this.description = this.nickname;
        }
    }

    public Object clone() {
        return new Column(this.nickname, this.celltype, this.encoder, this.cellwidth, this.description);
    }

    public void setCellwidth(int cellwidth) {
        assert (this.celltype == 3 || this.celltype == 2);
        this.cellwidth = cellwidth;
    }

    public final String toString() {
        StringBuilder s = new StringBuilder(20);
        switch (this.celltype) {
            case 0: {
                s.append(this.nickname);
                s.append('-');
                s.append(this.cellwidth);
                break;
            }
            case 1: {
                s.append("boolean ");
                s.append(this.nickname);
                break;
            }
            case 2: {
                s.append("byte[] ");
                s.append(this.nickname);
                s.append('-');
                s.append(this.cellwidth);
                break;
            }
            case 3: {
                s.append("String ");
                s.append(this.nickname);
                s.append('-');
                s.append(this.cellwidth);
                break;
            }
            case 4: {
                s.append("Cardinal ");
                s.append(this.nickname);
                s.append('-');
                s.append(this.cellwidth);
                break;
            }
            case 5: {
                s.append("Bitfield ");
                s.append(this.nickname);
                s.append('-');
                s.append(this.cellwidth);
                break;
            }
            default: {
                s.append("String ");
                s.append(this.nickname);
                s.append('-');
                s.append(this.cellwidth);
            }
        }
        switch (this.encoder) {
            case 1: {
                s.append(" {b64e}");
                break;
            }
            case 2: {
                s.append(" {b256}");
                break;
            }
            case 3: {
                s.append(" {bytes}");
                break;
            }
            default: {
                s.append(" {b256}");
            }
        }
        return s.toString();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.celltype;
        result = 31 * result + this.cellwidth;
        result = 31 * result + this.encoder;
        result = 31 * result + (this.nickname == null ? 0 : this.nickname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column other = (Column)obj;
        if (this.celltype != other.celltype) {
            return false;
        }
        if (this.cellwidth != other.cellwidth) {
            return false;
        }
        if (this.encoder != other.encoder) {
            return false;
        }
        return !(this.nickname == null ? other.nickname != null : !this.nickname.equals(other.nickname));
    }
}

