/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.meta;

import java.awt.Dimension;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.date.MicroDate;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.SentenceReader;
import net.yacy.document.Tokenizer;
import net.yacy.document.parser.html.ContentScraper;
import net.yacy.document.parser.html.IconEntry;
import net.yacy.document.parser.html.IconLinkRelations;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.MapTools;
import net.yacy.kelondro.util.kelondroException;
import net.yacy.peers.Seed;
import net.yacy.peers.SeedDB;
import net.yacy.search.index.Segment;
import net.yacy.search.query.QueryParams;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.utils.crypt;
import org.apache.solr.common.SolrDocument;

public class URIMetadataNode
extends SolrDocument {
    private static final long serialVersionUID = -256046934741561968L;
    protected String keywords = null;
    protected DigestURL url;
    protected Bitfield flags = null;
    protected int imagec = -1;
    protected int audioc = -1;
    protected int videoc = -1;
    protected int appc = -1;
    protected double lat = Double.NaN;
    protected double lon = Double.NaN;
    protected long score = 0L;
    protected String snippet = null;
    protected WordReferenceVars word = null;
    private String alternative_urlstring;
    private String alternative_urlname;
    private TextSnippet textSnippet = null;

    public URIMetadataNode(Properties prop, String collection) throws MalformedURLException {
        String tags;
        String dc_creator;
        String urlRaw = crypt.simpleDecode(prop.getProperty("url", ""));
        this.url = new DigestURL(urlRaw);
        String descr = crypt.simpleDecode(prop.getProperty("descr", ""));
        if (descr == null) {
            descr = "";
        }
        if ((dc_creator = crypt.simpleDecode(prop.getProperty("author", ""))) == null) {
            dc_creator = "";
        }
        if ((tags = crypt.simpleDecode(prop.getProperty("tags", ""))) == null) {
            tags = "";
        }
        this.keywords = Tagging.cleanTagFromAutotagging(tags);
        String dc_publisher = crypt.simpleDecode(prop.getProperty("publisher", ""));
        if (dc_publisher == null) {
            dc_publisher = "";
        }
        String lons = crypt.simpleDecode(prop.getProperty("lon"));
        String lats = crypt.simpleDecode(prop.getProperty("lat"));
        this.setField(CollectionSchema.title.name(), descr);
        this.setField(CollectionSchema.author.name(), dc_creator);
        this.setField(CollectionSchema.publisher_t.name(), dc_publisher);
        this.lon = lons == null ? 0.0 : Double.parseDouble(lons);
        this.lat = lats == null ? 0.0 : Double.parseDouble(lats);
        this.setField(CollectionSchema.last_modified.name(), this.parseShortDayDate(prop.getProperty("mod", "20000101")));
        this.setField(CollectionSchema.load_date_dt.name(), this.parseShortDayDate(prop.getProperty("load", "20000101")));
        this.setField(CollectionSchema.fresh_date_dt.name(), this.parseShortDayDate(prop.getProperty("fresh", "20000101")));
        this.setField(CollectionSchema.referrer_id_s.name(), prop.getProperty("referrer", ""));
        this.setField(CollectionSchema.size_i.name(), Integer.parseInt(prop.getProperty("size", "0")));
        this.setField(CollectionSchema.wordcount_i.name(), Integer.parseInt(prop.getProperty("wc", "0")));
        String dt = prop.getProperty("dt", "t");
        String mime = crypt.simpleDecode(prop.getProperty("mime"));
        if (mime != null && !mime.isEmpty() && Response.docType(mime) == dt.charAt(0)) {
            this.setField(CollectionSchema.content_type.name(), mime);
        } else {
            String[] mimes = Response.doctype2mime(null, dt.charAt(0));
            this.setField(CollectionSchema.content_type.name(), mimes);
        }
        String flagsp = prop.getProperty("flags", "AAAAAA");
        this.flags = flagsp.length() > 6 ? QueryParams.empty_constraint : new Bitfield(4, flagsp);
        this.setField(CollectionSchema.language_s.name(), prop.getProperty("lang", ""));
        this.setField(CollectionSchema.inboundlinkscount_i.name(), Integer.parseInt(prop.getProperty("llocal", "0")));
        this.setField(CollectionSchema.outboundlinkscount_i.name(), Integer.parseInt(prop.getProperty("lother", "0")));
        this.imagec = Integer.parseInt(prop.getProperty("limage", "0"));
        this.audioc = Integer.parseInt(prop.getProperty("laudio", "0"));
        this.videoc = Integer.parseInt(prop.getProperty("lvideo", "0"));
        this.appc = Integer.parseInt(prop.getProperty("lapp", "0"));
        this.snippet = crypt.simpleDecode(prop.getProperty("snippet", ""));
        ArrayList<String> cs = new ArrayList<String>();
        cs.add(collection);
        this.setField(CollectionSchema.collection_sxt.name(), cs);
        this.word = null;
        if (prop.containsKey("wi")) {
            this.word = new WordReferenceVars(new WordReferenceRow(Base64Order.enhancedCoder.decodeString(prop.getProperty("wi", ""))), false);
        }
        if (prop.containsKey("favicon")) {
            String rawFaviconURL = crypt.simpleDecode(prop.getProperty("favicon", ""));
            DigestURL faviconURL = new DigestURL(rawFaviconURL);
            this.setIconsFields(faviconURL);
        }
    }

    public URIMetadataNode(SolrDocument doc) throws MalformedURLException {
        String myhash;
        for (String name : doc.getFieldNames()) {
            this.setField(name, doc.getFieldValue(name));
        }
        String hashstr = this.getString(CollectionSchema.id);
        String urlRaw = this.getString(CollectionSchema.sku);
        this.url = new DigestURL(urlRaw);
        if (!hashstr.isEmpty() && !hashstr.equals(myhash = ASCII.String(this.url.hash()))) {
            this.setField(CollectionSchema.id.getSolrFieldName(), myhash);
            ConcurrentLog.fine("URIMetadataNode", "updated document.ID of " + urlRaw + " from " + hashstr + " to " + myhash);
            String hostidstr = this.getString(CollectionSchema.host_id_s);
            if (!hostidstr.isEmpty() && !hostidstr.equals(this.url.hosthash())) {
                this.setField(CollectionSchema.host_id_s.getSolrFieldName(), this.url.hosthash());
            }
        }
    }

    public URIMetadataNode(SolrDocument doc, WordReferenceVars searchedWord, long scorex) throws MalformedURLException {
        this(doc);
        this.word = searchedWord;
        this.score = scorex;
    }

    public URIMetadataNode(DigestURL theurl) {
        this.url = theurl;
        this.setField(CollectionSchema.sku.name(), this.url.toNormalform(true));
        this.setField(CollectionSchema.id.name(), ASCII.String(this.url.hash()));
    }

    public Classification.ContentDomain getContentDomain() {
        String mime = this.mime();
        if (mime == null) {
            return this.url.getContentDomainFromExt();
        }
        Classification.ContentDomain contentDomain = Classification.getContentDomainFromMime(mime);
        if (contentDomain != Classification.ContentDomain.ALL) {
            return contentDomain;
        }
        return this.url.getContentDomainFromExt();
    }

    public byte[] hash() {
        return this.url.hash();
    }

    public String hosthash() {
        String hosthash = (String)this.getFieldValue(CollectionSchema.host_id_s.getSolrFieldName());
        if (hosthash == null) {
            hosthash = this.url.hosthash();
        }
        return hosthash;
    }

    public Date moddate() {
        return this.getDate(CollectionSchema.last_modified);
    }

    public Date[] datesInContent() {
        return this.getDates(CollectionSchema.dates_in_content_dts);
    }

    public DigestURL url() {
        return this.url;
    }

    public boolean matches(Pattern pattern) {
        return pattern.matcher(this.url.toNormalform(true)).matches();
    }

    public String dc_title() {
        ArrayList<String> a = this.getStringList(CollectionSchema.title);
        if (a == null || a.size() == 0) {
            return "";
        }
        return a.get(0);
    }

    public List<String> h1() {
        ArrayList<String> a = this.getStringList(CollectionSchema.h1_txt);
        if (a == null || a.size() == 0) {
            return new ArrayList<String>(0);
        }
        return a;
    }

    public List<String> h2() {
        ArrayList<String> a = this.getStringList(CollectionSchema.h2_txt);
        if (a == null || a.size() == 0) {
            return new ArrayList<String>(0);
        }
        return a;
    }

    public List<String> h3() {
        ArrayList<String> a = this.getStringList(CollectionSchema.h3_txt);
        if (a == null || a.size() == 0) {
            return new ArrayList<String>(0);
        }
        return a;
    }

    public List<String> h4() {
        ArrayList<String> a = this.getStringList(CollectionSchema.h4_txt);
        if (a == null || a.size() == 0) {
            return new ArrayList<String>(0);
        }
        return a;
    }

    public List<String> h5() {
        ArrayList<String> a = this.getStringList(CollectionSchema.h5_txt);
        if (a == null || a.size() == 0) {
            return new ArrayList<String>(0);
        }
        return a;
    }

    public List<String> h6() {
        ArrayList<String> a = this.getStringList(CollectionSchema.h6_txt);
        if (a == null || a.size() == 0) {
            return new ArrayList<String>(0);
        }
        return a;
    }

    public String dc_creator() {
        return this.getString(CollectionSchema.author);
    }

    public String dc_publisher() {
        return this.getString(CollectionSchema.publisher_t);
    }

    public String dc_subject() {
        if (this.keywords == null) {
            this.keywords = this.getString(CollectionSchema.keywords);
        }
        return this.keywords;
    }

    public double lat() {
        if (Double.isNaN(this.lat)) {
            int p;
            this.lon = 0.0;
            this.lat = 0.0;
            String latlon = (String)this.getFieldValue(CollectionSchema.coordinate_p.getSolrFieldName());
            if (latlon != null && (p = latlon.indexOf(44)) > 0) {
                if (latlon.charAt(0) <= '9') {
                    this.lat = Double.parseDouble(latlon.substring(0, p));
                    if (this.lat < -90.0 || this.lat > 90.0) {
                        this.lat = 0.0;
                    }
                }
                if (p < latlon.length() - 1 && latlon.charAt(p + 1) <= '9') {
                    this.lon = Double.parseDouble(latlon.substring(p + 1));
                    if (this.lon < -180.0 || this.lon > 180.0) {
                        this.lon = 0.0;
                    }
                }
            }
        }
        return this.lat;
    }

    public double lon() {
        if (Double.isNaN(this.lon)) {
            this.lat();
        }
        return this.lon;
    }

    public long score() {
        return this.score;
    }

    public void setScore(long theScore) {
        this.score = theScore;
    }

    public Date loaddate() {
        return this.getDate(CollectionSchema.load_date_dt);
    }

    public Date freshdate() {
        Date x = (Date)this.getFieldValue(CollectionSchema.fresh_date_dt.getSolrFieldName());
        if (x == null) {
            return new Date(0L);
        }
        return x;
    }

    @Deprecated
    public String md5() {
        return this.getString(CollectionSchema.md5_s);
    }

    public char doctype() {
        ArrayList<String> a = this.getStringList(CollectionSchema.content_type);
        if (a == null || a.size() == 0) {
            return Response.docType(this.url());
        }
        return Response.docType(a.get(0));
    }

    public String mime() {
        ArrayList<String> mime = this.getStringList(CollectionSchema.content_type);
        return mime == null || mime.size() == 0 ? null : mime.get(0);
    }

    public String language() {
        String language = this.getString(CollectionSchema.language_s);
        return language;
    }

    public byte[] referrerHash() {
        String referrer = this.getString(CollectionSchema.referrer_id_s);
        if (referrer == null || referrer.length() == 0) {
            return null;
        }
        return ASCII.getBytes(referrer);
    }

    public int filesize() {
        return this.getInt(CollectionSchema.size_i);
    }

    public Bitfield flags() {
        if (this.flags == null) {
            this.flags = new Bitfield();
            if (this.dc_subject() != null && this.dc_subject().indexOf("indexof") >= 0) {
                this.flags.set(0, true);
            }
            Classification.ContentDomain cd = this.getContentDomain();
            if (this.lon() != 0.0 || this.lat() != 0.0) {
                this.flags.set(19, true);
            }
            if (cd == Classification.ContentDomain.IMAGE || this.limage() > 0) {
                this.flags.set(20, true);
            }
            if (cd == Classification.ContentDomain.AUDIO || this.laudio() > 0) {
                this.flags.set(21, true);
            }
            if (cd == Classification.ContentDomain.VIDEO || this.lvideo() > 0) {
                this.flags.set(22, true);
            }
            if (cd == Classification.ContentDomain.APP) {
                this.flags.set(23, true);
            }
            if (this.lapp() > 0) {
                this.flags.set(23, true);
            }
        }
        return this.flags;
    }

    public int wordCount() {
        return this.getInt(CollectionSchema.wordcount_i);
    }

    public String imageURL() throws UnsupportedOperationException {
        if (this.limage() == 0) {
            throw new UnsupportedOperationException();
        }
        List<String> images_protocol = CollectionConfiguration.indexedList2protocolList(this.getFieldValues(CollectionSchema.images_protocol_sxt.getSolrFieldName()), this.limage());
        ArrayList<String> images_stub = this.getStringList(CollectionSchema.images_urlstub_sxt);
        int c = Math.min(images_protocol.size(), images_stub.size());
        if (c == 0) {
            throw new UnsupportedOperationException();
        }
        String url = images_protocol.get(0) + "://" + (String)images_stub.get(0);
        return url;
    }

    public int llocal() {
        return this.getInt(CollectionSchema.inboundlinkscount_i);
    }

    public int lother() {
        return this.getInt(CollectionSchema.outboundlinkscount_i);
    }

    public int limage() {
        if (this.imagec == -1) {
            this.imagec = this.getInt(CollectionSchema.imagescount_i);
        }
        return this.imagec;
    }

    public int laudio() {
        if (this.audioc == -1) {
            this.audioc = this.getInt(CollectionSchema.audiolinkscount_i);
        }
        return this.audioc;
    }

    public int lvideo() {
        if (this.videoc == -1) {
            this.videoc = this.getInt(CollectionSchema.videolinkscount_i);
        }
        return this.videoc;
    }

    public int lapp() {
        if (this.appc == -1) {
            this.appc = this.getInt(CollectionSchema.applinkscount_i);
        }
        return this.appc;
    }

    public int virtualAge() {
        return MicroDate.microDateDays(this.moddate());
    }

    public int wordsintitle() {
        ArrayList<Integer> x = this.getIntList(CollectionSchema.title_words_val);
        if (x == null || x.size() == 0) {
            return 0;
        }
        return x.get(0);
    }

    public int urllength() {
        return this.getInt(CollectionSchema.url_chars_i);
    }

    public String snippet() {
        return this.snippet;
    }

    public String[] collections() {
        ArrayList<String> a = this.getStringList(CollectionSchema.collection_sxt);
        return a.toArray(new String[a.size()]);
    }

    public WordReferenceVars word() {
        return this.word;
    }

    public ArrayList<String> getSynonyms() {
        return this.getStringList(CollectionSchema.synonyms_sxt);
    }

    public static Iterator<String> getLinks(SolrDocument doc, boolean inbound) {
        Collection urlstub = doc.getFieldValues((inbound ? CollectionSchema.inboundlinks_urlstub_sxt : CollectionSchema.outboundlinks_urlstub_sxt).getSolrFieldName());
        List<String> urlprot = urlstub == null ? null : CollectionConfiguration.indexedList2protocolList(doc.getFieldValues((inbound ? CollectionSchema.inboundlinks_protocol_sxt : CollectionSchema.outboundlinks_protocol_sxt).getSolrFieldName()), urlstub.size());
        LinkedHashSet<CallSite> list2 = new LinkedHashSet<CallSite>();
        if (urlprot != null && urlstub != null) {
            assert (urlprot.size() == urlstub.size());
            Object[] urlprota = urlprot.toArray();
            Object[] urlstuba = urlstub.toArray();
            for (int i = 0; i < urlprota.length; ++i) {
                Object u = (String)urlprota[i] + "://" + (String)urlstuba[i];
                int hp = ((String)u).indexOf(35);
                if (hp > 0) {
                    u = ((String)u).substring(0, hp);
                }
                list2.add((CallSite)u);
            }
        }
        return list2.iterator();
    }

    public final Collection<IconEntry> getIcons() {
        ArrayList<IconEntry> icons = new ArrayList<IconEntry>();
        List<?> iconsUrlStubsList = this.getFieldValuesAsList(CollectionSchema.icons_urlstub_sxt.getSolrFieldName());
        if (iconsUrlStubsList != null) {
            List<String> ports = CollectionConfiguration.indexedList2protocolList(this.getFieldValues(CollectionSchema.icons_protocol_sxt.getSolrFieldName()), iconsUrlStubsList.size());
            List<?> allSizes = this.getFieldValuesAsList(CollectionSchema.icons_sizes_sxt.getSolrFieldName());
            List<?> allRels = this.getFieldValuesAsList(CollectionSchema.icons_rel_sxt.getSolrFieldName());
            for (int index2 = 0; index2 < iconsUrlStubsList.size(); ++index2) {
                DigestURL iconURL;
                Object item = iconsUrlStubsList.get(index2);
                String urlStub = null;
                if (!(item instanceof String)) continue;
                urlStub = (String)item;
                String iconURLStr = (ports != null && ports.size() > index2 ? ports.get(index2) : "http") + "://" + urlStub;
                try {
                    iconURL = new DigestURL(iconURLStr);
                }
                catch (MalformedURLException e) {
                    continue;
                }
                HashSet<String> rels = null;
                if (allRels.size() > index2 && (item = allRels.get(index2)) instanceof String) {
                    rels = ContentScraper.parseSpaceSeparatedTokens((String)item);
                }
                if (rels == null) {
                    rels = new HashSet<String>();
                    rels.add("unknown");
                }
                Set<Dimension> sizes = null;
                if (allSizes.size() > index2 && (item = allSizes.get(index2)) instanceof String) {
                    sizes = ContentScraper.parseSizes((String)item);
                }
                icons.add(new IconEntry(iconURL, rels, sizes));
            }
        }
        return icons;
    }

    public IconEntry getFavicon(Dimension preferredSize) {
        IconEntry faviconEntry = null;
        boolean foundStandard = false;
        double closestDistance = Double.MAX_VALUE;
        for (IconEntry icon : this.getIcons()) {
            boolean isStandard = icon.isStandardIcon();
            double distance = IconEntry.getDistance(icon.getClosestSize(preferredSize), preferredSize);
            boolean match = false;
            if (foundStandard) {
                match = isStandard && distance < closestDistance;
            } else {
                boolean bl = match = isStandard || distance <= closestDistance;
            }
            if (!match) continue;
            faviconEntry = icon;
            closestDistance = distance;
            foundStandard = isStandard;
            if (!isStandard || distance != 0.0) continue;
            break;
        }
        return faviconEntry;
    }

    private void setIconsFields(DigestURL iconURL) {
        ArrayList<String> protocols = new ArrayList<String>(1);
        ArrayList<String> sizes = new ArrayList<String>(1);
        ArrayList<String> stubs = new ArrayList<String>(1);
        ArrayList<String> rels = new ArrayList<String>(1);
        if (iconURL != null) {
            String protocol = iconURL.getProtocol();
            protocols.add(protocol);
            sizes.add("");
            stubs.add(iconURL.toString().substring(protocol.length() + 3));
            rels.add(IconLinkRelations.ICON.getRelValue());
        }
        this.setField(CollectionSchema.icons_protocol_sxt.name(), protocols);
        this.setField(CollectionSchema.icons_urlstub_sxt.name(), stubs);
        this.setField(CollectionSchema.icons_rel_sxt.name(), rels);
        this.setField(CollectionSchema.icons_sizes_sxt.name(), sizes);
    }

    public List<?> getFieldValuesAsList(String name) {
        Collection fieldValues = this.getFieldValues(name);
        List list2 = fieldValues instanceof List ? (List)fieldValues : Collections.EMPTY_LIST;
        return list2;
    }

    public static Date getDate(SolrDocument doc, CollectionSchema key) {
        Date x = doc == null ? null : (Date)doc.getFieldValue(key.getSolrFieldName());
        Date now = new Date();
        return x == null ? new Date(0L) : (x.after(now) ? now : x);
    }

    public String getText() {
        return this.getString(CollectionSchema.text_t);
    }

    public List<StringBuilder> getSentences(boolean pre) {
        ArrayList<StringBuilder> sentences = new ArrayList<StringBuilder>();
        String text = this.getText();
        if (text == null || text.length() == 0) {
            return sentences;
        }
        SentenceReader sr = new SentenceReader(text, pre);
        while (sr.hasNext()) {
            sentences.add(sr.next());
        }
        sr.close();
        sr = null;
        text = null;
        return sentences;
    }

    public ArrayList<String> getDescription() {
        return this.getStringList(CollectionSchema.description_txt);
    }

    public static URIMetadataNode importEntry(String propStr, String collection) {
        if (propStr == null || propStr.isEmpty() || propStr.charAt(0) != '{' || !propStr.endsWith("}")) {
            ConcurrentLog.severe("URIMetadataNode", "importEntry: propStr is not proper: " + propStr);
            return null;
        }
        try {
            return new URIMetadataNode(MapTools.s2p(propStr.substring(1, propStr.length() - 1)), collection);
        }
        catch (MalformedURLException | kelondroException e) {
            ConcurrentLog.severe("URIMetadataNode", e.getMessage());
            return null;
        }
    }

    private String formatShortDayDate(Date date) {
        String formattedDate;
        try {
            formattedDate = GenericFormatter.FORMAT_SHORT_DAY.format(date.toInstant());
        }
        catch (DateTimeException e) {
            formattedDate = GenericFormatter.SHORT_DAY_FORMATTER.format(date);
        }
        return formattedDate;
    }

    private Date parseShortDayDate(String dateStr) {
        Date parsed;
        try {
            parsed = Date.from(LocalDate.parse(dateStr, GenericFormatter.FORMAT_SHORT_DAY).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        catch (RuntimeException e) {
            try {
                parsed = GenericFormatter.SHORT_DAY_FORMATTER.parse(dateStr, 0).getTime();
            }
            catch (ParseException pe) {
                parsed = new Date();
            }
        }
        return parsed;
    }

    protected StringBuilder corePropList() {
        StringBuilder s = new StringBuilder(300);
        try {
            IconEntry faviconEntry;
            String[] mimex;
            s.append("hash=").append(ASCII.String(this.hash()));
            s.append(",url=").append(crypt.simpleEncode(this.url().toNormalform(true)));
            s.append(",descr=").append(crypt.simpleEncode(this.dc_title()));
            s.append(",author=").append(crypt.simpleEncode(this.dc_creator()));
            s.append(",tags=").append(crypt.simpleEncode(Tagging.cleanTagFromAutotagging(this.dc_subject())));
            s.append(",publisher=").append(crypt.simpleEncode(this.dc_publisher()));
            s.append(",lat=").append(this.lat());
            s.append(",lon=").append(this.lon());
            s.append(",mod=").append(this.formatShortDayDate(this.moddate()));
            s.append(",load=").append(this.formatShortDayDate(this.loaddate()));
            s.append(",fresh=").append(this.formatShortDayDate(this.freshdate()));
            s.append(",referrer=").append(this.referrerHash() == null ? "" : ASCII.String(this.referrerHash()));
            s.append(",size=").append(this.filesize());
            s.append(",wc=").append(this.wordCount());
            char dt = this.doctype();
            s.append(",dt=").append(dt);
            String mime = this.mime();
            if (mime != null && !mime.equals((mimex = Response.doctype2mime(null, dt))[0])) {
                s.append(",mime=").append(crypt.simpleEncode(mime));
            }
            s.append(",flags=").append(this.flags().exportB64());
            s.append(",lang=").append(this.language());
            s.append(",llocal=").append(this.llocal());
            s.append(",lother=").append(this.lother());
            s.append(",limage=").append(this.limage());
            s.append(",laudio=").append(this.laudio());
            s.append(",lvideo=").append(this.lvideo());
            s.append(",lapp=").append(this.lapp());
            s.append(",score=").append(Long.toString(this.score()));
            if (this.word() != null) {
                String wprop = this.word().toPropertyForm();
                s.append(",wi=").append(Base64Order.enhancedCoder.encodeString(wprop));
            }
            if (!this.getIcons().isEmpty() && (faviconEntry = this.getFavicon(new Dimension(16, 16))) != null) {
                s.append(",favicon=").append(crypt.simpleEncode(faviconEntry.getUrl().toNormalform(false)));
            }
            return s;
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public String toString(String snippet) {
        StringBuilder core = this.corePropList();
        if (core == null) {
            return null;
        }
        core.ensureCapacity(core.length() + snippet.length() * 2);
        core.insert(0, '{');
        core.append(",snippet=").append(crypt.simpleEncode(snippet));
        core.append('}');
        return core.toString();
    }

    public String toString() {
        StringBuilder core = this.corePropList();
        if (core == null) {
            return null;
        }
        core.insert(0, '{');
        core.append('}');
        return core.toString();
    }

    private int getInt(CollectionSchema field) {
        assert (!field.isMultiValued());
        assert (field.getType() == SolrType.num_integer);
        Object x = this.getFieldValue(field.getSolrFieldName());
        if (x == null) {
            return 0;
        }
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof Long) {
            return ((Long)x).intValue();
        }
        return 0;
    }

    private Date getDate(CollectionSchema field) {
        assert (!field.isMultiValued());
        assert (field.getType() == SolrType.date);
        Date x = (Date)this.getFieldValue(field.getSolrFieldName());
        if (x == null) {
            return new Date(0L);
        }
        Date now = new Date();
        return x.after(now) ? now : x;
    }

    private Date[] getDates(CollectionSchema field) {
        assert (field.isMultiValued());
        assert (field.getType() == SolrType.date);
        Object content = this.getFieldValue(field.getSolrFieldName());
        if (content == null) {
            return new Date[0];
        }
        if (content instanceof Date) {
            return new Date[]{(Date)content};
        }
        if (content instanceof List) {
            List x = (List)content;
            return x.toArray(new Date[x.size()]);
        }
        return new Date[0];
    }

    private String getString(CollectionSchema field) {
        assert (!field.isMultiValued());
        assert (field.getType() == SolrType.string || field.getType() == SolrType.text_general || field.getType() == SolrType.text_en_splitting_tight);
        Object x = this.getFieldValue(field.getSolrFieldName());
        if (x == null) {
            return "";
        }
        if (x instanceof ArrayList) {
            ArrayList xa = (ArrayList)x;
            return xa.size() == 0 ? "" : (String)xa.get(0);
        }
        return (String)x;
    }

    private ArrayList<String> getStringList(CollectionSchema field) {
        assert (field.isMultiValued());
        assert (field.getType() == SolrType.string || field.getType() == SolrType.text_general);
        Object r = this.getFieldValue(field.getSolrFieldName());
        if (r == null) {
            return new ArrayList<String>(0);
        }
        if (r instanceof ArrayList) {
            return (ArrayList)r;
        }
        ArrayList<String> a = new ArrayList<String>(1);
        a.add((String)r);
        return a;
    }

    private ArrayList<Integer> getIntList(CollectionSchema field) {
        assert (field.isMultiValued());
        assert (field.getType() == SolrType.num_integer);
        Object r = this.getFieldValue(field.getSolrFieldName());
        if (r == null) {
            return new ArrayList<Integer>(0);
        }
        if (r instanceof ArrayList) {
            return (ArrayList)r;
        }
        ArrayList<Integer> a = new ArrayList<Integer>(1);
        a.add((Integer)r);
        return a;
    }

    public URIMetadataNode makeResultEntry(Segment indexSegment, SeedDB peers, TextSnippet textSnippet) {
        this.removeFields(CollectionSchema.text_t.getSolrFieldName());
        this.alternative_urlstring = null;
        this.alternative_urlname = null;
        this.textSnippet = textSnippet;
        String host = this.url().getHost();
        if (host != null && host.endsWith(".yacyh")) {
            Set<String> ips;
            int p = host.indexOf(46);
            String hash = Seed.hexHash2b64Hash(host.substring(p + 1, host.length() - 6));
            Seed seed = peers.getConnected(hash);
            String path = this.url().getFile();
            String address = null;
            if (seed != null && !(ips = seed.getIPs()).isEmpty()) {
                address = seed.getPublicAddress(ips.iterator().next());
            }
            if (address == null) {
                try {
                    if (indexSegment.termIndex() != null) {
                        indexSegment.termIndex().remove(Word.words2hashesHandles(Tokenizer.getWords(path.replace('?', ' ') + " " + this.dc_title(), null).keySet()), this.hash());
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                indexSegment.fulltext().remove(this.hash());
            } else {
                this.alternative_urlstring = "http://" + address + "/" + host.substring(0, p) + path;
                this.alternative_urlname = "http://" + seed.getName() + ".yacy" + path;
                p = this.alternative_urlname.indexOf(63);
                if (p > 0) {
                    this.alternative_urlname = this.alternative_urlname.substring(0, p);
                }
            }
        }
        return this;
    }

    public String urlstring() {
        if (this.alternative_urlstring != null) {
            return this.alternative_urlstring;
        }
        return this.url().toNormalform(true);
    }

    public String urlname() {
        return this.alternative_urlname == null ? MultiProtocolURL.unescape(this.urlstring()) : this.alternative_urlname;
    }

    public String title() {
        String titlestr = this.dc_title();
        if (titlestr.isEmpty()) {
            titlestr = this.url() != null ? this.url().getFileName() : "";
        }
        return titlestr;
    }

    public TextSnippet textSnippet() {
        return this.textSnippet;
    }

    public Date[] events() {
        return this.datesInContent();
    }

    public boolean hasTextSnippet() {
        return this.textSnippet != null && !this.textSnippet.getErrorCode().fail();
    }

    public String resource() {
        if (this.textSnippet == null || !this.textSnippet.exists()) {
            return this.toString();
        }
        return this.toString(this.textSnippet.getLineRaw());
    }

    public int hashCode() {
        return this.url().hashCode();
    }
}

