/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.storage.AbstractMapStore;
import net.yacy.cora.storage.MapStore;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.blob.BEncodedHeap;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MergeIterator;

public class BEncodedHeapBag
extends AbstractMapStore
implements MapStore {
    private Map<String, BEncodedHeap> bag;
    private final File baseDir;
    private final String prefix;
    private final int keylength;
    private final int buffermax;
    private final ByteOrder entryOrder;
    private String current;
    private final long fileAgeLimit;
    private final long fileSizeLimit;

    public BEncodedHeapBag(File path, String prefix, int keylength, ByteOrder ordering, int buffermax, long fileAgeLimit, long fileSizeLimit) {
        this.baseDir = path;
        this.prefix = prefix;
        this.keylength = keylength;
        this.buffermax = buffermax;
        this.entryOrder = ordering;
        this.fileAgeLimit = fileAgeLimit;
        this.fileSizeLimit = fileSizeLimit;
        this.init();
    }

    private void init() {
        File f;
        this.current = null;
        this.bag = new HashMap<String, BEncodedHeap>();
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        String[] tablefile = this.baseDir.list();
        HashMap<String, Long> t = new HashMap<String, Long>();
        long maxtime = 0L;
        for (String element : tablefile) {
            Date d;
            if (!element.startsWith(this.prefix) || element.length() <= this.prefix.length() || element.charAt(this.prefix.length()) != '.' || element.length() != this.prefix.length() + 23) continue;
            f = new File(this.baseDir, element);
            try {
                d = GenericFormatter.SHORT_MILSEC_FORMATTER.parse(element.substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime();
            }
            catch (ParseException e) {
                ConcurrentLog.severe("BEncodedHeapBag", "", e);
                continue;
            }
            long time = d.getTime();
            if (time > maxtime) {
                this.current = element;
                assert (this.current != null);
                maxtime = time;
            }
            t.put(element, f.length());
        }
        while (!t.isEmpty()) {
            long maxram = 0L;
            String maxf = null;
            for (Map.Entry entry2 : t.entrySet()) {
                long ram = (Long)entry2.getValue();
                if (maxf != null && ram <= maxram) continue;
                maxf = (String)entry2.getKey();
                maxram = ram;
            }
            t.remove(maxf);
            f = new File(this.baseDir, maxf);
            try {
                ConcurrentLog.info("BEncodedHeapBag", "opening partial heap " + f);
                BEncodedHeap heap = new BEncodedHeap(f, this.keylength, this.entryOrder, this.buffermax);
                this.bag.put(maxf, heap);
            }
            catch (IOException e) {
                ConcurrentLog.severe("BEncodedHeapBag", "error opening partial heap " + f);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.bag == null) {
            return;
        }
        Iterator<BEncodedHeap> i = this.bag.values().iterator();
        while (i.hasNext()) {
            i.next().close();
        }
        this.bag = null;
    }

    @Override
    public void clear() {
        String[] l;
        this.close();
        for (String element : l = this.baseDir.list()) {
            File f;
            if (!element.startsWith(this.prefix) || (f = new File(this.baseDir, element)).isDirectory()) continue;
            FileUtils.deletedelete(f);
        }
        this.init();
    }

    private MapStore keeperOf(byte[] key) {
        if (key == null) {
            return null;
        }
        if (this.bag == null) {
            return null;
        }
        for (MapStore mapStore : this.bag.values()) {
            if (!mapStore.containsKey(key)) continue;
            return mapStore;
        }
        return null;
    }

    private String newFilename() {
        return this.prefix + "." + GenericFormatter.SHORT_MILSEC_FORMATTER.format() + ".heap";
    }

    private MapStore newHeap() {
        BEncodedHeap heap;
        this.current = this.newFilename();
        File f = new File(this.baseDir, this.current);
        try {
            heap = new BEncodedHeap(f, this.keylength, this.entryOrder, this.buffermax);
        }
        catch (IOException e) {
            ConcurrentLog.severe("BEncodedHeapBag", "unable to open new heap file: " + e.getMessage(), e);
            return null;
        }
        this.bag.put(this.current, heap);
        return heap;
    }

    private MapStore checkHeap(BEncodedHeap heap) {
        long d;
        assert (heap != null);
        long t = System.currentTimeMillis();
        if (t / 1000L % 10L != 0L) {
            return heap;
        }
        String name = heap.getFile().getName();
        try {
            d = GenericFormatter.SHORT_MILSEC_FORMATTER.parse(name.substring(this.prefix.length() + 1, this.prefix.length() + 18), 0).getTime().getTime();
        }
        catch (ParseException e) {
            ConcurrentLog.severe("BEncodedHeapBag", "", e);
            d = 0L;
        }
        if (d + this.fileAgeLimit < t || new File(this.baseDir, name).length() >= this.fileSizeLimit) {
            return this.newHeap();
        }
        return heap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (key == null || !(key instanceof byte[])) {
            return false;
        }
        Map<String, BEncodedHeap> map = this.bag;
        synchronized (map) {
            return this.keeperOf((byte[])key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> put(byte[] key, Map<String, byte[]> map) {
        if (this.bag == null) {
            return null;
        }
        MapStore keeper = null;
        Map<String, BEncodedHeap> map2 = this.bag;
        synchronized (map2) {
            keeper = this.keeperOf(key);
        }
        if (keeper != null) {
            return keeper.put(key, map);
        }
        map2 = this.bag;
        synchronized (map2) {
            keeper = this.keeperOf(key);
            if (keeper != null) {
                return keeper.put(key, map);
            }
            if (this.current == null) {
                keeper = this.newHeap();
                return keeper.put(key, map);
            }
            keeper = this.checkHeap(this.bag.get(this.current));
        }
        return keeper.put(key, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> get(Object key) {
        if (key == null || !(key instanceof byte[])) {
            return null;
        }
        Map<String, BEncodedHeap> map = this.bag;
        synchronized (map) {
            return (Map)this.keeperOf((byte[])key).get(key);
        }
    }

    @Override
    public boolean isEmpty() {
        Iterator<BEncodedHeap> i = this.bag.values().iterator();
        while (i.hasNext()) {
            if (i.next().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        Iterator<BEncodedHeap> i = this.bag.values().iterator();
        int s = 0;
        while (i.hasNext()) {
            s += i.next().size();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> remove(Object key) {
        MapStore heap;
        if (key == null || !(key instanceof byte[])) {
            return null;
        }
        Map<String, BEncodedHeap> map = this.bag;
        synchronized (map) {
            heap = this.keeperOf((byte[])key);
        }
        if (heap == null) {
            return null;
        }
        return (Map)heap.remove(key);
    }

    @Override
    public ByteOrder getOrdering() {
        return this.entryOrder;
    }

    @Override
    public CloneableIterator<byte[]> keyIterator() {
        ArrayList c = new ArrayList(this.bag.size());
        Iterator<BEncodedHeap> i = this.bag.values().iterator();
        while (i.hasNext()) {
            CloneableIterator<byte[]> k = i.next().keyIterator();
            if (k == null || !k.hasNext()) continue;
            c.add(k);
        }
        return MergeIterator.cascade(c, this.entryOrder, MergeIterator.simpleMerge, true);
    }

    protected static Map<String, byte[]> testMap(int i) {
        HashMap<String, byte[]> t = new HashMap<String, byte[]>();
        t.put("rdf:about", UTF8.getBytes("http://abc.de/testmap#" + i));
        t.put("dc:title", UTF8.getBytes("test nr " + i));
        return t;
    }

    private static BEncodedHeapBag testHeapBag(File f) {
        return new BEncodedHeapBag(f, "testbag", 12, Base64Order.enhancedCoder, 10, 2628000000L, 100L);
    }

    public static void main(String[] args) {
        File f = new File("/tmp");
        BEncodedHeapBag hb = BEncodedHeapBag.testHeapBag(f);
        for (int i = 0; i < 10000; ++i) {
            hb.put(Word.word2hash(Integer.toString(i)), BEncodedHeapBag.testMap(i));
        }
        System.out.println("test size after put = " + hb.size());
        hb.close();
        hb = BEncodedHeapBag.testHeapBag(f);
        Iterator<Map.Entry<byte[], Map<String, byte[]>>> mi = hb.iterator();
        int c = 1000;
        while (mi.hasNext() && c-- > 0) {
            Map.Entry<byte[], Map<String, byte[]>> entry2 = mi.next();
            System.out.println(UTF8.String(entry2.getKey()) + ": " + AbstractMapStore.map2String(entry2.getValue()));
        }
        for (int i = 10000; i > 0; --i) {
            hb.remove(Word.word2hash(Integer.toString(i - 1)));
        }
        System.out.println("test size after remove = " + hb.size());
        hb.close();
        ConcurrentLog.shutdown();
    }
}

