/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import java.io.IOException;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;

public final class crawlReceipt {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post == null || env == null || !Protocol.authentifyRequest(post, env)) {
            return prop;
        }
        ConcurrentLog log = sb.getLog();
        String iam = post.get("iam", "");
        String youare = post.get("youare", "");
        String result = post.get("result", "");
        String reason = post.get("reason", "");
        String propStr = crypt.simpleDecode(post.get("lurlEntry", ""));
        Seed otherPeer = sb.peers.get(iam);
        String otherPeerName = iam + ":" + (String)(otherPeer == null ? "NULL" : otherPeer.getName() + "/" + otherPeer.getVersion());
        if (sb.peers.mySeed() == null || !sb.peers.mySeed().hash.equals(youare)) {
            prop.put("delay", "3600");
            return prop;
        }
        if (propStr == null) {
            prop.put("delay", "3600");
            return prop;
        }
        if (sb.isRobinsonMode() && !sb.isInMyCluster(otherPeer)) {
            prop.put("delay", "9999");
            return prop;
        }
        URIMetadataNode entry2 = URIMetadataNode.importEntry(propStr, "dht");
        if (entry2 == null) {
            if (log.isWarn()) {
                log.warn("crawlReceipt: RECEIVED wrong RECEIPT (entry null) from peer " + iam + "\n\tURL properties: " + propStr);
            }
            prop.put("delay", "3600");
            return prop;
        }
        if (entry2.url() == null) {
            if (log.isWarn()) {
                log.warn("crawlReceipt: RECEIVED wrong RECEIPT (url null) for hash " + ASCII.String(entry2.hash()) + " from peer " + iam + "\n\tURL properties: " + propStr);
            }
            prop.put("delay", "3600");
            return prop;
        }
        String urlRejectReason = sb.crawlStacker.urlInAcceptedDomain(entry2.url());
        if (urlRejectReason != null) {
            log.warn("crawlReceipt: RECEIVED wrong RECEIPT (" + urlRejectReason + ") for hash " + ASCII.String(entry2.hash()) + " from peer " + iam + "\n\tURL properties: " + propStr);
            prop.put("delay", "9999");
            return prop;
        }
        if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.DHT, entry2.url())) {
            log.warn("crawlReceipt: RECEIVED wrong RECEIPT (URL is blacklisted) for URL " + ASCII.String(entry2.hash()) + ":" + entry2.url().toNormalform(false) + " from peer " + iam);
            prop.put("delay", "9999");
            return prop;
        }
        if ("fill".equals(result) && sb.crawlQueues.delegatedURL != null) {
            try {
                sb.index.fulltext().putMetadata(entry2);
                ResultURLs.stack(ASCII.String(entry2.url().hash()), entry2.url().getHost(), youare.getBytes(), iam.getBytes(), ResultURLs.EventOrigin.REMOTE_RECEIPTS);
                sb.crawlQueues.delegatedURL.remove(ASCII.String(entry2.hash()));
                if (log.isInfo()) {
                    log.info("crawlReceipt: RECEIVED RECEIPT from " + otherPeerName + " for URL " + ASCII.String(entry2.hash()) + ":" + entry2.url().toNormalform(false));
                }
                prop.put("delay", "10");
                return prop;
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                prop.put("delay", "3600");
                return prop;
            }
        }
        if (sb.crawlQueues.delegatedURL != null) {
            sb.crawlQueues.delegatedURL.remove(ASCII.String(entry2.hash()));
            sb.crawlQueues.errorURL.push(entry2.url(), 997, null, FailCategory.FINAL_LOAD_CONTEXT, result + ":" + reason, -1);
        }
        prop.put("delay", "3600");
        return prop;
    }
}

