/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.DidYouMean;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;

public class suggest {
    private static final int meanMax = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Collection<StringBuilder> suggestions;
        Switchboard sb = (Switchboard)env;
        servletProperties prop = new servletProperties();
        String ext = header.get("EXT", "");
        boolean json = ext.equals("json");
        boolean xml = ext.equals("xml");
        String originalquerystring = post == null ? "" : post.get("query", post.get("q", ""));
        String querystring = originalquerystring.trim();
        int timeout = post == null ? 300 : post.getInt("timeout", 300);
        int count = post == null ? 10 : Math.min(30, post.getInt("count", 20));
        int c = 0;
        DidYouMean didYouMean = new DidYouMean(sb.index, querystring);
        Collection<StringBuilder> collection = suggestions = didYouMean.getSuggestions(timeout, count, sb.index.fulltext().collectionSize() < 2000000L);
        synchronized (collection) {
            for (StringBuilder suggestion : suggestions) {
                if (c >= 30) break;
                try {
                    String s = suggestion.toString();
                    if (json) {
                        prop.putJSON("suggestions_" + c + "_text", s);
                    } else if (xml) {
                        prop.putXML("suggestions_" + c + "_text", s);
                    } else {
                        prop.putHTML("suggestions_" + c + "_text", s);
                    }
                    prop.put("suggestions_" + c + "_eol", 0L);
                    ++c;
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (c > 0) {
            prop.put("suggestions_" + (c - 1) + "_eol", 1L);
        }
        prop.put("suggestions", c);
        if (json) {
            prop.putJSON("query", originalquerystring);
        } else if (xml) {
            prop.putXML("query", originalquerystring);
        } else {
            prop.putHTML("query", originalquerystring);
        }
        if (post != null && post.containsKey("callback")) {
            String jsonp = post.get("callback") + "([";
            prop.put("jsonp-start", jsonp);
            prop.put("jsonp-end", "])");
        } else {
            prop.put("jsonp-start", "");
            prop.put("jsonp-end", "");
        }
        if (xml) {
            ResponseHeader outgoingHeader = new ResponseHeader(200);
            outgoingHeader.put("Access-Control-Allow-Origin", "*");
            prop.setOutgoingHeader(outgoingHeader);
        }
        return prop;
    }
}

