/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.util.Date;
import java.util.Iterator;
import net.yacy.cora.document.feed.Hit;
import net.yacy.cora.document.feed.RSSFeed;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.crawler.retrieval.Request;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class rct_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post != null && post.containsKey("retrieve")) {
            RSSFeed feed2;
            String peerhash = post.get("peer", null);
            Seed seed = peerhash == null ? null : sb.peers.getConnected(peerhash);
            boolean preferHttps = sb.getConfigBool("network.unit.protocol.https.preferred", false);
            RSSFeed rSSFeed = feed2 = seed == null ? null : Protocol.queryRemoteCrawlURLs(sb.peers, seed, 20, 60000L, preferHttps);
            if (feed2 != null) {
                for (Hit item : feed2) {
                    DigestURL url;
                    try {
                        url = new DigestURL(item.getLink());
                    }
                    catch (MalformedURLException e) {
                        url = null;
                    }
                    Date loaddate = item.getPubDate();
                    DigestURL referrer = null;
                    String urlRejectReason = sb.crawlStacker.urlInAcceptedDomain(url);
                    if (urlRejectReason == null) {
                        if (sb.getLog().isFinest()) {
                            sb.getLog().finest("crawlOrder: stack: url='" + url + "'");
                        }
                        sb.crawlStacker.enqueueEntry(new Request(peerhash.getBytes(), url, referrer == null ? null : referrer.hash(), "REMOTE-CRAWLING", loaddate, sb.crawler.defaultRemoteProfile.handle(), 0, sb.crawler.defaultRemoteProfile.timezoneOffset()));
                        continue;
                    }
                    env.getLog().warn("crawlOrder: Rejected URL '" + rct_p.urlToString(url) + "': " + urlRejectReason);
                }
            }
        }
        rct_p.listHosts(sb, prop);
        return prop;
    }

    private static String urlToString(DigestURL url) {
        return url == null ? "null" : url.toNormalform(true);
    }

    private static void listHosts(Switchboard sb, serverObjects prop) {
        int hc = 0;
        if (sb.peers != null && sb.peers.sizeConnected() > 0) {
            Iterator<Seed> e = DHTSelection.getProvidesRemoteCrawlURLs(sb.peers);
            while (e.hasNext()) {
                Seed seed = e.next();
                if (seed == null) continue;
                prop.put("hosts_" + hc + "_hosthash", seed.hash);
                prop.putHTML("hosts_" + hc + "_hostname", seed.hash + " " + seed.get("Name", "nameless") + " (" + seed.getLong("RCount", 0L) + ")");
                ++hc;
            }
            prop.put("hosts", hc);
        } else {
            prop.put("hosts", "0");
        }
    }
}

