/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.OrderedScoreMap;
import net.yacy.cora.util.CommonPattern;
import net.yacy.search.EventTracker;
import net.yacy.search.query.AccessTracker;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public final class timeline_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        if (post == null || env == null) {
            return prop;
        }
        int maxeventsperperiod = post.getInt("head", 1);
        String period = post.get("period", "");
        long periodlength = 0L;
        if (period.length() > 0) {
            char c = period.charAt(period.length() - 1);
            long p = Long.parseLong(period.substring(0, period.length() - 1));
            periodlength = c == 's' ? p * 1000L : (c == 'm' ? p * 60000L : (c == 'h' ? p * 3600000L : (c == 'd' ? p * 86400000L : (c == 'M' ? p * 2592000000L : (c == 'Y' || c == 'y' ? p * 31536000000L : 0L)))));
        }
        String[] data = CommonPattern.COMMA.split(post.get("data", ""));
        HashMap<String, List<EventTracker.Event>> proc = new HashMap<String, List<EventTracker.Event>>();
        for (String s : data) {
            if (s.length() <= 0) continue;
            proc.put(s, null);
        }
        Date fromDate = new Date(0L);
        Date toDate = new Date();
        try {
            fromDate = GenericFormatter.SHORT_SECOND_FORMATTER.parse(post.get("from", GenericFormatter.SHORT_SECOND_FORMATTER.format(fromDate)), 0).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            toDate = GenericFormatter.SHORT_SECOND_FORMATTER.parse(post.get("to", GenericFormatter.SHORT_SECOND_FORMATTER.format(toDate)), 0).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        AccessTracker.dumpLog();
        if (proc.containsKey("queries")) {
            List<EventTracker.Event> events = AccessTracker.readLog(AccessTracker.getDumpFile(), fromDate, toDate);
            proc.put("queries", events);
        }
        TreeMap<String, EventTracker.Event> eax = new TreeMap<String, EventTracker.Event>();
        for (Object events : proc.values()) {
            if (events == null) continue;
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                EventTracker.Event event = (EventTracker.Event)iterator.next();
                eax.put(event.getFormattedDate(), event);
            }
        }
        proc.clear();
        ArrayList<EventTracker.Event> ea = new ArrayList<EventTracker.Event>();
        for (EventTracker.Event event : eax.values()) {
            ea.add(event);
        }
        if (periodlength > 0L && ea.size() > 0) {
            EventTracker.Event firstEvent = (EventTracker.Event)ea.iterator().next();
            long startDate = fromDate.getTime();
            OrderedScoreMap<String> accumulation = new OrderedScoreMap<String>(null);
            ArrayList<EventTracker.Event> eap = new ArrayList<EventTracker.Event>();
            String limit = GenericFormatter.SHORT_SECOND_FORMATTER.format(new Date(startDate + periodlength));
            for (EventTracker.Event event : ea) {
                if (event.getFormattedDate().compareTo(limit) >= 0) {
                    timeline_p.stats(accumulation, eap, startDate, periodlength, maxeventsperperiod, firstEvent.type);
                    firstEvent = event;
                    limit = GenericFormatter.SHORT_SECOND_FORMATTER.format(new Date((startDate += periodlength) + periodlength));
                }
                accumulation.inc(event.payload.toString());
            }
            timeline_p.stats(accumulation, eap, startDate, periodlength, maxeventsperperiod, firstEvent.type);
            ea = eap;
        }
        int count = 0;
        for (EventTracker.Event event : ea) {
            prop.put("event_" + count + "_time", event.getFormattedDate());
            prop.put("event_" + count + "_isPeriod", event.duration == 0L ? 0L : 1L);
            prop.put("event_" + count + "_isPeriod_duration", event.duration);
            prop.put("event_" + count + "_isPeriod_count", event.count);
            prop.putHTML("event_" + count + "_type", event.type);
            prop.putXML("event_" + count + "_description", event.payload.toString());
            ++count;
        }
        prop.put("event", count);
        prop.put("count", count);
        return prop;
    }

    private static void stats(OrderedScoreMap<String> accumulation, List<EventTracker.Event> eap, long startDate, long periodlength, int head, String type) {
        Iterator<String> si = accumulation.keys(false);
        int c = 0;
        while (si.hasNext() && c++ < head) {
            String key = si.next();
            eap.add(new EventTracker.Event(startDate, periodlength, type, (Object)key, accumulation.get(key)));
        }
        accumulation.clear();
    }
}

