/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.blacklists;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.ListManager;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.Blacklist;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class get_list_p {
    private static final Blacklist.BlacklistType[] BLACKLIST_TYPE_VALUES = Blacklist.BlacklistType.values();
    private static final String KEY_CURRENT_BLACKLIST = "list";
    private static final String ITEMS = "items";
    private static final String POSTFIX_ITEM = "_item";
    private static final String PREFIX_ITEMS = "items_";
    private static final String SHARED = "shared";
    private static final String NAME = "name";
    private static final String TYPES = "types";
    private static final String PREFIX_TYPES = "types_";
    private static final String POSTFIX_VALUE = "_value";
    private static final String POSTFIX_NAME = "_name";
    private static final String POSTFIX_COMMA = "_comma";
    private static final String TYPES_EXT = ".BlackLists";
    private static final String BLACK_LISTS_SHARED = "BlackLists.Shared";
    private static final int lastTypeIndex = BLACKLIST_TYPE_VALUES.length - 1;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        String blackListName;
        serverObjects prop = new serverObjects();
        List<String> dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
        String string = blackListName = post == null ? "" : post.get(KEY_CURRENT_BLACKLIST, "");
        if (dirlist != null) {
            for (String element : dirlist) {
                if (!element.equals(blackListName)) continue;
                prop.putXML(NAME, element);
                prop.put(SHARED, ListManager.listSetContains(BLACK_LISTS_SHARED, element));
                int j = 0;
                for (Blacklist.BlacklistType type : BLACKLIST_TYPE_VALUES) {
                    prop.putXML(PREFIX_TYPES + j + POSTFIX_NAME, type.toString());
                    prop.put(PREFIX_TYPES + j + POSTFIX_VALUE, ListManager.listSetContains(type + TYPES_EXT, element));
                    prop.put(PREFIX_TYPES + j + POSTFIX_COMMA, j < lastTypeIndex);
                    ++j;
                }
                prop.put(TYPES, Blacklist.BlacklistType.values().length);
                prop.putXML(NAME, element);
                ArrayList<String> list2 = FileUtils.getListArray(new File(ListManager.listsPath, element));
                int count = 0;
                int lastItemCount = list2.size() - 1;
                for (String entry2 : list2) {
                    if (entry2.isEmpty() || entry2.charAt(0) == '#') continue;
                    prop.putXML(PREFIX_ITEMS + count + POSTFIX_ITEM, entry2);
                    prop.put(PREFIX_ITEMS + count + POSTFIX_COMMA, count < lastItemCount);
                    ++count;
                }
                prop.put(ITEMS, count);
            }
        }
        return prop;
    }
}

