/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.Diff;
import net.yacy.data.wiki.WikiBoard;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Wiki {
    private static final String ANONYMOUS = "anonymous";

    public static String dateString(Date date) {
        return GenericFormatter.SIMPLE_FORMATTER.format(date);
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) throws IOException {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post == null) {
            post = new serverObjects();
            post.put("page", "start");
        }
        prop.put("topmenu", sb.getConfigBool("publicTopmenu", true) ? 1L : 0L);
        String access = sb.getConfig("WikiAccess", "admin");
        String pagename = Wiki.get(post, "page", "start");
        String ip = Wiki.get(post, "CLIENTIP", "localhost");
        String author = Wiki.get(post, "author", ANONYMOUS);
        if (author.equals(ANONYMOUS) && (author = WikiBoard.guessAuthor(ip)) == null) {
            String string = author = sb.peers.mySeed() == null ? ANONYMOUS : sb.peers.mySeed().get("Name", ANONYMOUS);
        }
        if (post != null && post.containsKey("access")) {
            if (!sb.verifyAuthentication(header)) {
                prop.authenticationRequired();
                return prop;
            }
            access = post.get("access", "admin");
            sb.setConfig("WikiAccess", access);
        }
        if (access.equals("admin")) {
            prop.put("mode_access", "0");
        } else if (access.equals("all")) {
            prop.put("mode_access", "1");
        }
        WikiBoard.Entry page = sb.wikiDB.read(pagename);
        if (post != null && post.containsKey("submit")) {
            if (access.equals("admin") && !sb.verifyAuthentication(header)) {
                prop.authenticationRequired();
                return prop;
            }
            byte[] content = UTF8.getBytes(post.get("content", ""));
            WikiBoard.Entry newEntry = sb.wikiDB.newEntry(pagename, author, ip, post.get("reason", "edit"), content);
            sb.wikiDB.write(newEntry);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("page", pagename);
            map.put("author", author.replace(',', ' '));
            if (!sb.isRobinsonMode() && post.get("content", "").trim().length() > 0 && !Arrays.equals(page.page(), content)) {
                sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "wiki_upd", map);
            }
            page = newEntry;
            prop.putHTML("LOCATION", "Wiki.html?page=" + pagename);
            prop.put("LOCATION", prop.get("LOCATION"));
        }
        if (post != null && post.containsKey("edit")) {
            if (access.equals("admin") && !sb.verifyAuthentication(header)) {
                prop.authenticationRequired();
                return prop;
            }
            prop.put("mode", "1");
            prop.putHTML("mode_author", author);
            prop.putHTML("mode_page-code", UTF8.String(page.page()));
            prop.putHTML("mode_pagename", pagename);
        } else if (post != null && post.containsKey("preview")) {
            prop.put("mode", "2");
            prop.putHTML("mode_pagename", pagename);
            prop.putHTML("mode_author", author);
            prop.put("mode_date", Wiki.dateString(new Date()));
            prop.putWiki("mode_page", post.get("content", ""));
            prop.putHTML("mode_page-code", post.get("content", ""));
        } else if (post != null && post.containsKey("index")) {
            prop.put("mode", "3");
            try {
                Iterator<byte[]> i = sb.wikiDB.keys(true);
                int count = 0;
                while (i.hasNext()) {
                    String subject = UTF8.String(i.next());
                    WikiBoard.Entry entry2 = sb.wikiDB.read(subject);
                    prop.putHTML("mode_pages_" + count + "_name", WikiBoard.webalize(subject));
                    prop.putHTML("mode_pages_" + count + "_subject", subject);
                    prop.put("mode_pages_" + count + "_date", Wiki.dateString(entry2.date()));
                    prop.putHTML("mode_pages_" + count + "_author", entry2.author());
                    ++count;
                }
                prop.put("mode_pages", count);
            }
            catch (IOException e) {
                prop.put("mode_error", "1");
                prop.putHTML("mode_error_message", e.getMessage());
            }
            prop.putHTML("mode_pagename", pagename);
        } else if (post != null && post.containsKey("diff")) {
            prop.put("mode", "4");
            prop.putHTML("mode_page", pagename);
            prop.putHTML("mode_error_page", pagename);
            try {
                WikiBoard.Entry entry3;
                Iterator<byte[]> it = sb.wikiDB.keysBkp(true);
                WikiBoard.Entry oentry = null;
                WikiBoard.Entry nentry = null;
                int count = 0;
                boolean oldselected = false;
                boolean newselected = false;
                while (it.hasNext()) {
                    entry3 = sb.wikiDB.readBkp(UTF8.String(it.next()));
                    prop.put("mode_error_versions_" + count + "_date", WikiBoard.dateString(entry3.date()));
                    prop.put("mode_error_versions_" + count + "_fdate", Wiki.dateString(entry3.date()));
                    if (WikiBoard.dateString(entry3.date()).equals(post.get("old", null))) {
                        prop.put("mode_error_versions_" + count + "_oldselected", "1");
                        oentry = entry3;
                        oldselected = true;
                    } else if (WikiBoard.dateString(entry3.date()).equals(post.get("new", null))) {
                        prop.put("mode_error_versions_" + count + "_newselected", "1");
                        nentry = entry3;
                        newselected = true;
                    }
                    ++count;
                }
                --count;
                if (!oldselected) {
                    prop.put("mode_error_versions_" + (count - 1) + "_oldselected", "1");
                }
                if (!newselected) {
                    prop.put("mode_error_curselected", "1");
                }
                if (count == 0) {
                    prop.put("mode_error", "2");
                } else {
                    prop.put("mode_error_versions", count);
                }
                entry3 = sb.wikiDB.read(pagename);
                if (entry3 != null) {
                    prop.put("mode_error_curdate", WikiBoard.dateString(entry3.date()));
                    prop.put("mode_error_curfdate", Wiki.dateString(entry3.date()));
                }
                if (nentry == null) {
                    nentry = entry3;
                }
                if (post.containsKey("compare") && oentry != null && nentry != null) {
                    Diff diff = new Diff(UTF8.String(oentry.page()), UTF8.String(nentry.page()), 3);
                    prop.put("mode_versioning_diff", Diff.toHTML(new Diff[]{diff}));
                    prop.put("mode_versioning", "1");
                } else if (post.containsKey("viewold") && oentry != null) {
                    prop.put("mode_versioning", "2");
                    prop.putHTML("mode_versioning_pagename", pagename);
                    prop.putHTML("mode_versioning_author", oentry.author());
                    prop.put("mode_versioning_date", Wiki.dateString(oentry.date()));
                    prop.putWiki("mode_versioning_page", oentry.page());
                    prop.putHTML("mode_versioning_page-code", UTF8.String(oentry.page()));
                }
            }
            catch (IOException e) {
                prop.put("mode_error", "1");
                prop.putHTML("mode_error_message", e.getMessage());
            }
        } else {
            prop.put("mode", "0");
            prop.putHTML("mode_pagename", pagename);
            prop.putHTML("mode_author", page.author());
            prop.put("mode_date", Wiki.dateString(page.date()));
            prop.putWiki("mode_page", page.page());
            prop.put("controls", "0");
            prop.putHTML("controls_pagename", pagename);
        }
        return prop;
    }

    private static String get(serverObjects post, String key, String dflt) {
        return post == null ? dflt : post.get(key, dflt);
    }
}

