/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.Document;
import net.yacy.document.LibraryProvider;
import net.yacy.document.Parser;
import net.yacy.document.SentenceReader;
import net.yacy.document.WordTokenizer;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.document.parser.html.IconEntry;
import net.yacy.document.parser.html.ImageEntry;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrDocument;

public class ViewFile {
    public static final int VIEW_MODE_NO_TEXT = 0;
    public static final int VIEW_MODE_AS_PLAIN_TEXT = 1;
    public static final int VIEW_MODE_AS_PARSED_TEXT = 2;
    public static final int VIEW_MODE_AS_PARSED_SENTENCES = 3;
    public static final int VIEW_MODE_AS_IFRAME_FROM_WEB = 4;
    public static final int VIEW_MODE_AS_IFRAME_FROM_CACHE = 5;
    public static final int VIEW_MODE_AS_LINKLIST = 6;
    public static final int VIEW_MODE_AS_PARSED_WORDS = 7;
    public static final int VIEW_MODE_AS_SCHEMA = 8;
    public static final int VIEW_MODE_AS_IFRAME_FROM_CITATION_REPORT = 9;
    private static final String HIGHLIGHT_CSS = "searchHighlight";
    private static final int MAX_HIGHLIGHTS = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        prop.put("topmenu", sb.getConfigBool("publicTopmenu", true) ? 1L : 0L);
        prop.put("searchindocument", 0L);
        prop.put("viewMode", 0L);
        prop.put("viewModeValue", "sentences");
        prop.putHTML("error_words", "");
        prop.put("error_vMode-sentences", "1");
        prop.put("error", "1");
        prop.put("url", "");
        prop.put("showSnippet", 0L);
        if (post == null) {
            return prop;
        }
        Segment indexSegment = sb.index;
        boolean authorized = sb.verifyAuthentication(header);
        if (post.containsKey("words")) {
            prop.putHTML("error_words", post.get("words"));
        } else {
            prop.putHTML("error_words", "");
        }
        prop.put("error_vMode-iframeWeb", "0");
        prop.put("error_vMode-iframeCache", "0");
        prop.put("error_vMode-plain", "0");
        prop.put("error_vMode-parsed", "0");
        prop.put("error_vMode-sentences", "0");
        prop.put("error_vMode-words", "0");
        prop.put("error_vMode-links", "0");
        prop.put("error_vMode-iframeCitations", "0");
        prop.put("error_vMode-schema", "0");
        boolean showSnippet = post.get("show", "").equals("Show Snippet");
        String viewMode = showSnippet ? "sentences" : post.get("viewMode", "sentences");
        prop.put("error_vMode-" + viewMode, "1");
        prop.put("viewModeValue", viewMode);
        DigestURL url = null;
        String descr = "";
        boolean wordCount = false;
        int size = 0;
        boolean pre = false;
        String urlHash = post.get("urlHash", post.get("urlhash", ""));
        String urlString = post.get("url", "");
        if (urlString.length() > 0) {
            try {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
                url = new DigestURL(MultiProtocolURL.unescape(urlString));
                urlHash = ASCII.String(url.hash());
                pre = post.getBoolean("pre");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URIMetadataNode urlEntry = null;
        if (urlHash.length() > 0 && (urlEntry = indexSegment.fulltext().getMetadata(ASCII.getBytes(urlHash))) == null) {
            indexSegment.fulltext().commit(true);
        }
        if (urlHash.length() > 0 && (urlEntry = indexSegment.fulltext().getMetadata(ASCII.getBytes(urlHash))) != null) {
            if (urlEntry == null || urlEntry.url() == null) {
                prop.put("error", "3");
                prop.put("viewMode", 0L);
                return prop;
            }
            url = urlEntry.url();
            descr = urlEntry.dc_title();
            size = urlEntry.filesize();
            pre = urlEntry.flags().get(0);
            prop.put("searchindocument", 1L);
            prop.putHTML("searchindocument_query", post.get("query", ""));
        }
        prop.put("error_inurldb", urlEntry == null ? 0L : 1L);
        if (url == null) {
            prop.put("error", "1");
            prop.put("viewMode", 0L);
            prop.put("url", "");
            return prop;
        }
        prop.put("url", url.toNormalform(true));
        prop.put("error_incache", Cache.has(url.hash()) ? 1L : 0L);
        Response response = null;
        try {
            ClientIdentification.Agent agent = ClientIdentification.getAgent(post.get("agentName", "YaCy Internet (cautious)"));
            response = sb.loader.load(sb.loader.request(url, true, true), authorized ? CacheStrategy.IFEXIST : CacheStrategy.CACHEONLY, Integer.MAX_VALUE, null, agent);
        }
        catch (IOException e) {
            prop.put("error", "4");
            prop.put("error_errorText", "error loading resource: " + e.getMessage());
            prop.put("viewMode", 0L);
            return prop;
        }
        if (response == null) {
            prop.put("error", "4");
            prop.put("error_errorText", "No resource available");
            prop.put("viewMode", 0L);
            return prop;
        }
        String[] wordArray = ViewFile.wordArray(post.get("words", null));
        if (viewMode.equals("iframeWeb")) {
            prop.put("viewMode", 4L);
            prop.put("viewMode_url", url.toNormalform(true));
        } else if (viewMode.equals("iframeCache")) {
            prop.put("viewMode", 5L);
            prop.put("viewMode_png", 0L);
            prop.put("viewMode_html", 0L);
            if (response.docType() == 'i') {
                prop.put("viewMode_png", 1L);
                prop.put("viewMode_png_url", url.toNormalform(true));
            } else {
                prop.put("viewMode_html", 1L);
                prop.put("viewMode_html_url", url.toNormalform(true));
            }
        } else if (viewMode.equals("plain")) {
            String content;
            try {
                String charsetName = response.getCharacterEncoding();
                try {
                    if (charsetName == null) {
                        charsetName = StandardCharsets.UTF_8.name();
                    } else if (!Charset.isSupported(charsetName)) {
                        charsetName = StandardCharsets.UTF_8.name();
                    }
                }
                catch (IllegalCharsetNameException e) {
                    charsetName = StandardCharsets.UTF_8.name();
                }
                content = new String(response.getContent(), charsetName);
            }
            catch (Exception e) {
                prop.put("error", "4");
                prop.putHTML("error_errorText", e.getMessage());
                prop.put("viewMode", 0L);
                return prop;
            }
            prop.put("error", "0");
            prop.put("viewMode", 1L);
            prop.put("viewMode_plainText", ViewFile.markup(wordArray, content).replaceAll("\n", "<br />").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;"));
        } else if (viewMode.equals("parsed") || viewMode.equals("sentences") || viewMode.equals("words") || viewMode.equals("links")) {
            String sentence;
            int i;
            boolean dark;
            List<StringBuilder> sentences;
            Document document = null;
            try {
                document = Document.mergeDocuments(response.url(), response.getMimeType(), response.parse());
                if (document == null) {
                    prop.put("error", "5");
                    prop.put("error_errorText", "Unknown error");
                    prop.put("viewMode", 0L);
                    return prop;
                }
            }
            catch (Parser.Failure e) {
                prop.put("error", "5");
                prop.putHTML("error_errorText", e.getMessage());
                prop.put("viewMode", 0L);
                return prop;
            }
            if (viewMode.equals("parsed")) {
                String[] stringArray;
                String content = document.getTextString();
                prop.put("viewMode", 2L);
                prop.put("viewMode_title", document.dc_title());
                prop.put("viewMode_creator", document.dc_creator());
                prop.put("viewMode_subject", document.dc_subject(','));
                if (document.dc_description().length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    stringArray = document.dc_description();
                }
                prop.put("viewMode_description", stringArray);
                prop.put("viewMode_publisher", document.dc_publisher());
                prop.put("viewMode_format", document.dc_format());
                prop.put("viewMode_identifier", document.dc_identifier());
                prop.put("viewMode_source", url.toNormalform(false));
                prop.put("viewMode_lat", document.lat());
                prop.put("viewMode_lon", document.lon());
                prop.put("viewMode_parsedText", ViewFile.markup(wordArray, content).replaceAll("\n", "<br />").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;"));
            } else if (viewMode.equals("sentences")) {
                prop.put("viewMode", 3L);
                sentences = document.getSentences(pre);
                dark = true;
                i = 0;
                if (sentences != null) {
                    for (StringBuilder s : sentences) {
                        sentence = s.toString();
                        if (sentence.trim().length() <= 0) continue;
                        prop.put("viewMode_sentences_" + i + "_nr", i + 1);
                        prop.put("viewMode_sentences_" + i + "_text", ViewFile.markup(wordArray, sentence));
                        prop.put("viewMode_sentences_" + i + "_dark", dark ? "1" : "0");
                        dark = !dark;
                        ++i;
                    }
                }
                prop.put("viewMode_sentences", i);
            } else if (viewMode.equals("words")) {
                prop.put("viewMode", 7L);
                sentences = document.getSentences(pre);
                dark = true;
                i = 0;
                if (sentences != null) {
                    for (StringBuilder s : sentences) {
                        sentence = s.toString();
                        WordTokenizer tokens = new WordTokenizer(new SentenceReader(sentence), LibraryProvider.dymLib);
                        try {
                            while (tokens.hasMoreElements()) {
                                StringBuilder token = tokens.nextElement();
                                if (token.length() <= 0) continue;
                                prop.put("viewMode_words_" + i + "_nr", i + 1);
                                prop.put("viewMode_words_" + i + "_word", token.toString());
                                prop.put("viewMode_words_" + i + "_dark", dark ? "1" : "0");
                                dark = !dark;
                                ++i;
                            }
                        }
                        finally {
                            tokens.close();
                            tokens = null;
                        }
                    }
                }
                prop.put("viewMode_words", i);
            } else if (viewMode.equals("links")) {
                ViewFile.putLinks(prop, wordArray, document, post.get("agentName"));
            }
            if (showSnippet) {
                QueryGoal goal = new QueryGoal(post.get("search", ""));
                try {
                    TextSnippet snippet = new TextSnippet(sb.loader, urlEntry, goal.getIncludeWordsSet(), goal.getIncludeHashes(), CacheStrategy.CACHEONLY, false, 220, false);
                    String titlestr = urlEntry.dc_title();
                    if (titlestr.isEmpty()) {
                        titlestr = urlEntry.url() != null ? urlEntry.url().getFileName() : "";
                    }
                    String desc = snippet == null ? "" : snippet.descriptionline(goal);
                    prop.put("showSnippet_headline", titlestr);
                    prop.put("showSnippet_teasertext", desc);
                    prop.put("showSnippet", 1L);
                }
                catch (UnsupportedOperationException e) {
                    prop.put("showSnippet_headline", "<no snippet found>");
                    prop.put("showSnippet_teasertext", "<no snippet found>");
                    prop.put("showSnippet", 1L);
                }
            }
            long responseSize = response.size();
            if ((urlEntry == null || urlEntry.loaddate().before(response.lastModified())) && responseSize >= 0L && responseSize <= (long)Switchboard.getSwitchboard().loader.protocolMaxFileSize(response.url())) {
                Switchboard.getSwitchboard().toIndexer(response);
            }
            if (document != null) {
                document.close();
            }
        } else if (viewMode.equals("schema")) {
            prop.put("viewMode", 8L);
            prop.put("viewMode_url", url.toNormalform(true));
            try {
                SolrDocument solrDocument = indexSegment.fulltext().getDefaultConnector().getDocumentById(ASCII.String(url.hash()), new String[0]);
                if (solrDocument != null) {
                    int c = 0;
                    for (String fieldName : solrDocument.getFieldNames()) {
                        Object value = solrDocument.getFieldValue(fieldName);
                        if (!(value instanceof String) && !(value instanceof Collection)) continue;
                        prop.put("viewMode_fields_" + c + "_key", fieldName);
                        prop.put("viewMode_fields_" + c + "_value", value.toString());
                        ++c;
                    }
                    prop.put("viewMode_fields", c);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (viewMode.equals("iframeCitations")) {
            prop.put("viewMode", 9L);
            prop.put("viewMode_url", url.toNormalform(true));
        }
        prop.put("error", "0");
        prop.put("error_url", url.toNormalform(true));
        prop.put("error_hash", urlHash);
        prop.put("error_inurldb_hash", urlHash);
        prop.put("error_wordCount", 0L);
        prop.put("error_firstSeen", "");
        long firstseen = sb.index.getFirstSeenTime(ASCII.getBytes(urlHash));
        prop.put("error_firstSeen", firstseen < 0L ? "" : new Date(firstseen).toString());
        prop.putHTML("error_desc", descr.isEmpty() ? "&nbsp;" : descr);
        prop.putNum("error_size", size);
        prop.put("error_mimeTypeAvailable", response.getMimeType() == null ? "0" : "1");
        prop.put("error_mimeTypeAvailable_mimeType", response.getMimeType());
        if (urlEntry == null) {
            prop.put("error_referrerHash", "");
            prop.put("error_moddate", "");
            prop.put("error_loaddate", "");
            prop.put("error_freshdate", "");
            prop.put("error_hosthash", "");
            prop.putHTML("error_dc_creator", "");
            prop.putHTML("error_dc_publisher", "");
            prop.putHTML("error_dc_subject", "");
            prop.put("error_lat", "");
            prop.put("error_lon", "");
            prop.put("error_language", "");
            prop.put("error_flags", "");
            prop.put("error_wordCount", "");
            prop.put("error_llocal", "");
            prop.put("error_lother", "");
            prop.put("error_limage", "");
            prop.put("error_laudio", "");
            prop.put("error_lvideo", "");
            prop.put("error_lapp", "");
            prop.put("error_collections", "");
        } else {
            prop.put("error_referrerHash", urlEntry.referrerHash());
            prop.put("error_moddate", urlEntry.moddate());
            prop.put("error_loaddate", urlEntry.loaddate());
            prop.put("error_freshdate", urlEntry.freshdate());
            prop.put("error_hosthash", urlEntry.hosthash());
            prop.putHTML("error_dc_creator", urlEntry.dc_creator());
            prop.putHTML("error_dc_publisher", urlEntry.dc_publisher());
            prop.putHTML("error_dc_subject", urlEntry.dc_subject());
            prop.put("error_lat", urlEntry.lat());
            prop.put("error_lon", urlEntry.lon());
            prop.put("error_language", urlEntry.language());
            prop.put("error_flags", urlEntry.flags().toString());
            prop.put("error_wordCount", urlEntry.wordCount());
            prop.put("error_llocal", urlEntry.llocal());
            prop.put("error_lother", urlEntry.lother());
            prop.put("error_limage", urlEntry.limage());
            prop.put("error_laudio", urlEntry.laudio());
            prop.put("error_lvideo", urlEntry.lvideo());
            prop.put("error_lapp", urlEntry.lapp());
            prop.put("error_collections", Arrays.toString(urlEntry.collections()));
        }
        return prop;
    }

    private static void putLinks(serverObjects prop, String[] wordArray, Document document, String agentName) {
        prop.put("viewMode", 6L);
        boolean dark = true;
        int i = 0;
        i += ViewFile.putMediaInfo(prop, wordArray, i, document.getVideolinks(), "video", i % 2 == 0, agentName);
        i += ViewFile.putMediaInfo(prop, wordArray, i, document.getAudiolinks(), "audio", i % 2 == 0, agentName);
        dark = i % 2 == 0;
        i += ViewFile.putIconsInfos(prop, wordArray, i, document.getIcons().values(), i % 2 == 0, agentName);
        dark = i % 2 == 0;
        LinkedHashMap<DigestURL, ImageEntry> ts = document.getImages();
        for (ImageEntry entry2 : ts.values()) {
            String urlStr = entry2.url().toNormalform(true);
            prop.put("viewMode_links_" + i + "_nr", i);
            prop.put("viewMode_links_" + i + "_dark", dark ? "1" : "0");
            prop.put("viewMode_links_" + i + "_type", "image");
            prop.put("viewMode_links_" + i + "_text", entry2.alt().isEmpty() ? "&nbsp;" : ViewFile.markup(wordArray, entry2.alt()));
            prop.put("viewMode_links_" + i + "_encodedUrl", UTF8.encodeUrl(urlStr));
            if (agentName != null) {
                prop.put("viewMode_links_" + i + "_agent", true);
                prop.put("viewMode_links_" + i + "_agent_name", UTF8.encodeUrl(agentName));
            } else {
                prop.put("viewMode_links_" + i + "_agent", false);
            }
            prop.put("viewMode_links_" + i + "_url", urlStr);
            prop.put("viewMode_links_" + i + "_link", ViewFile.markup(wordArray, urlStr));
            if (entry2.width() > 0 && entry2.height() > 0) {
                prop.put("viewMode_links_" + i + "_rel", entry2.width() + "x" + entry2.height() + " Pixel");
            } else {
                prop.put("viewMode_links_" + i + "_rel", "");
            }
            prop.put("viewMode_links_" + i + "_name", "");
            dark = !dark;
            ++i;
        }
        i += ViewFile.putMediaInfo(prop, wordArray, i, document.getApplinks(), "app", i % 2 == 0, agentName);
        i += ViewFile.putMediaInfo(prop, wordArray, i, document.getHyperlinks(), "link", i % 2 == 0, agentName);
        prop.put("viewMode_links", i);
    }

    private static final String[] wordArray(String words) {
        String[] w = new String[]{};
        if (words == null || words.isEmpty()) {
            return w;
        }
        if (words.length() > 1 && words.charAt(0) == '[' && words.charAt(words.length() - 1) == ']') {
            words = words.substring(1, words.length() - 1);
        }
        if ((words = UTF8.decodeURL(words)).indexOf(32, 0) >= 0) {
            return CommonPattern.SPACES.split(words);
        }
        if (words.indexOf(44, 0) >= 0) {
            return CommonPattern.COMMA.split(words);
        }
        if (words.indexOf(43, 0) >= 0) {
            return words.split("\\+");
        }
        w = new String[]{words};
        return w;
    }

    private static final String markup(String[] wordArray, String message2) {
        message2 = CharacterCoding.unicode2html(message2, true);
        if (wordArray != null) {
            int j = 0;
            for (String currentWord : wordArray) {
                currentWord = currentWord.trim();
                message2 = message2.replaceAll(currentWord, "<span class=\"searchHighlight" + (j++ % 6 + 1) + "\">" + currentWord + "</span>");
            }
        }
        return message2;
    }

    private static int putMediaInfo(serverObjects prop, String[] wordArray, int c, Map<AnchorURL, String> media, String type, boolean dark, String agentName) {
        int i = 0;
        for (Map.Entry<AnchorURL, String> entry2 : media.entrySet()) {
            String name = entry2.getKey().getNameProperty();
            String rel = entry2.getKey().getRelProperty();
            String text = entry2.getKey().getTextProperty();
            String urlStr = entry2.getKey().toNormalform(true);
            prop.put("viewMode_links_" + c + "_nr", c);
            prop.put("viewMode_links_" + c + "_dark", dark ? 1 : 0);
            prop.putHTML("viewMode_links_" + c + "_type", type);
            prop.put("viewMode_links_" + c + "_text", text);
            prop.put("viewMode_links_" + c + "_link", ViewFile.markup(wordArray, urlStr));
            prop.put("viewMode_links_" + c + "_url", urlStr);
            prop.put("viewMode_links_" + c + "_encodedUrl", UTF8.encodeUrl(urlStr));
            if (agentName != null) {
                prop.put("viewMode_links_" + c + "_agent", true);
                prop.put("viewMode_links_" + c + "_agent_name", UTF8.encodeUrl(agentName));
            } else {
                prop.put("viewMode_links_" + c + "_agent", false);
            }
            prop.put("viewMode_links_" + c + "_rel", rel);
            prop.put("viewMode_links_" + c + "_name", name);
            dark = !dark;
            ++c;
            ++i;
        }
        return i;
    }

    private static int putIconsInfos(serverObjects prop, String[] wordArray, int c, Collection<IconEntry> icons, boolean dark, String agentName) {
        int i = 0;
        for (IconEntry entry2 : icons) {
            String name = "";
            String rel = entry2.relToString();
            String text = "";
            String urlStr = entry2.getUrl().toNormalform(true);
            prop.put("viewMode_links_" + c + "_nr", c);
            prop.put("viewMode_links_" + c + "_dark", dark ? 1 : 0);
            prop.putHTML("viewMode_links_" + c + "_type", "icon");
            prop.put("viewMode_links_" + c + "_text", "");
            prop.put("viewMode_links_" + c + "_link", ViewFile.markup(wordArray, urlStr));
            prop.put("viewMode_links_" + c + "_url", urlStr);
            prop.put("viewMode_links_" + c + "_encodedUrl", UTF8.encodeUrl(urlStr));
            if (agentName != null) {
                prop.put("viewMode_links_" + c + "_agent", true);
                prop.put("viewMode_links_" + c + "_agent_name", UTF8.encodeUrl(agentName));
            } else {
                prop.put("viewMode_links_" + c + "_agent", false);
            }
            prop.put("viewMode_links_" + c + "_rel", rel);
            prop.put("viewMode_links_" + c + "_name", "");
            dark = !dark;
            ++c;
            ++i;
        }
        return i;
    }
}

