/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.peers.NewsDB;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;
import net.yacy.utils.translation.TranslationManager;

public class TransNews_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        String refid;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String currentlang = sb.getConfig("locale.language", "default");
        prop.put("currentlang", currentlang);
        if ("default".equals(currentlang) || "browser".equals(currentlang)) {
            prop.put("errmsg", 1L);
            prop.put("transsize", 0L);
            return prop;
        }
        prop.put("errmsg", 0L);
        TranslationManager transMgr = new TranslationManager();
        File locallangFile = transMgr.getScratchFile(new File(currentlang + ".lng"));
        Map<String, Map<String, String>> localTrans = transMgr.loadTranslationsLists(locallangFile);
        int size = 0;
        for (Map<String, String> lst : localTrans.values()) {
            size += lst.size();
        }
        prop.put("transsize", size);
        if (post != null && post.containsKey("publishtranslation")) {
            Iterator<String> filenameit = localTrans.keySet().iterator();
            int msgcounter = 0;
            while (filenameit.hasNext()) {
                String file = filenameit.next();
                Map<String, String> tmptrans = localTrans.get(file);
                for (String sourcetxt : tmptrans.keySet()) {
                    String targettxt = tmptrans.get(sourcetxt);
                    if (targettxt == null || targettxt.isEmpty()) continue;
                    boolean sendit = true;
                    Iterator<NewsDB.Record> it = sb.peers.newsPool.recordIterator(0);
                    while (it.hasNext()) {
                        NewsDB.Record rtmp = it.next();
                        if (rtmp == null || !"transadd".equals(rtmp.category())) continue;
                        String tmplng = rtmp.attribute("language", null);
                        String tmpfile = rtmp.attribute("file", null);
                        String tmpsource = rtmp.attribute("source", null);
                        if (tmplng == null || !tmplng.equals(currentlang) || tmpfile == null || !tmpfile.equals(file) || tmpsource == null || !tmpsource.equals(sourcetxt)) continue;
                        sendit = false;
                        break;
                    }
                    if (!sendit) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("language", currentlang);
                    map.put("file", file);
                    map.put("source", sourcetxt);
                    map.put("target", targettxt);
                    map.put("#", Integer.toString(msgcounter++));
                    sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "transadd", map);
                }
            }
        }
        if (post != null && (refid = post.get("voteNegative", null)) != null && !sb.isRobinsonMode()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("language", currentlang);
            map.put("file", crypt.simpleDecode(post.get("filename", "")));
            map.put("source", crypt.simpleDecode(post.get("source", "")));
            map.put("target", crypt.simpleDecode(post.get("target", "")));
            map.put("vote", "negative");
            map.put("refid", refid);
            sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "transavt", map);
            try {
                sb.peers.newsPool.moveOff(0, refid);
            }
            catch (IOException | SpaceExceededException file) {
                // empty catch block
            }
        }
        if (post != null && (refid = post.get("votePositive", null)) != null) {
            String filename = post.get("filename");
            File lngfile = new File(sb.getAppPath("locale.source", "locales"), currentlang + ".lng");
            transMgr = new TranslationManager(lngfile);
            if (transMgr.addTranslation(filename, post.get("source"), post.get("target"))) {
                transMgr.addTranslation(localTrans, filename, post.get("source"), post.get("target"));
                transMgr.saveAsLngFile(currentlang, locallangFile, localTrans);
                transMgr.translateFile(filename);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("language", currentlang);
            map.put("file", crypt.simpleDecode(filename));
            map.put("source", crypt.simpleDecode(post.get("source", "")));
            map.put("target", crypt.simpleDecode(post.get("target", "")));
            map.put("vote", "positive");
            map.put("refid", refid);
            sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "transavt", map);
            try {
                sb.peers.newsPool.moveOff(0, refid);
            }
            catch (IOException | SpaceExceededException exception) {
                // empty catch block
            }
        }
        HashMap<String, Integer> negativeHashes = new HashMap<String, Integer>();
        HashMap<String, Integer> positiveHashes = new HashMap<String, Integer>();
        TransNews_p.accumulateVotes(sb, negativeHashes, positiveHashes, 0);
        ConcurrentScoreMap<String> ranking = new ConcurrentScoreMap<String>();
        HashMap<String, NewsDB.Record> translation = new HashMap<String, NewsDB.Record>();
        TransNews_p.accumulateTranslations(sb, translation, ranking, negativeHashes, positiveHashes, 0);
        Iterator k = ranking.keys(false);
        int i = 0;
        while (k.hasNext()) {
            NewsDB.Record row;
            refid = (String)k.next();
            if (refid == null || (row = translation.get(refid)) == null) continue;
            String lang = row.attribute("language", null);
            String filename = row.attribute("file", null);
            String source = row.attribute("source", null);
            String target = row.attribute("target", null);
            if (lang == null || filename == null || source == null || target == null || !lang.equals(currentlang)) continue;
            String existingtarget = null;
            Map<String, String> tmpMap = localTrans.get(filename);
            if (tmpMap != null) {
                existingtarget = tmpMap.get(source);
            }
            boolean altexist = existingtarget != null && !target.isEmpty() && !existingtarget.isEmpty() && !existingtarget.equals(target);
            prop.put("results_" + i + "_refid", refid);
            prop.put("results_" + i + "_url", filename);
            prop.put("results_" + i + "_targetlanguage", lang);
            prop.put("results_" + i + "_filename", filename);
            prop.putHTML("results_" + i + "_source", source);
            prop.putHTML("results_" + i + "_target", target);
            prop.put("results_" + i + "_existing", altexist);
            prop.putHTML("results_" + i + "_existing_target", existingtarget);
            prop.put("results_" + i + "_score", ranking.get(refid));
            prop.put("results_" + i + "_peername", sb.peers.get(row.originator()).getName());
            if (++i < 50) continue;
            break;
        }
        prop.put("results", i);
        return prop;
    }

    private static void accumulateVotes(Switchboard sb, HashMap<String, Integer> negativeHashes, HashMap<String, Integer> positiveHashes, int dbtype) {
        int maxCount = Math.min(1000, sb.peers.newsPool.size(dbtype));
        Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(dbtype);
        int j = 0;
        while (recordIterator.hasNext() && j++ < maxCount) {
            Integer i;
            int factor;
            NewsDB.Record newsrecord = recordIterator.next();
            if (newsrecord == null || !newsrecord.category().equals("transavt")) continue;
            String refid = newsrecord.attribute("refid", "");
            String vote = newsrecord.attribute("vote", "");
            int n = factor = dbtype == 2 || dbtype == 3 ? 2 : 1;
            if (vote.equals("negative")) {
                i = negativeHashes.get(refid);
                if (i == null) {
                    negativeHashes.put(refid, factor);
                } else {
                    negativeHashes.put(refid, i + factor);
                }
            }
            if (!vote.equals("positive")) continue;
            i = positiveHashes.get(refid);
            if (i == null) {
                positiveHashes.put(refid, factor);
                continue;
            }
            positiveHashes.put(refid, i + factor);
        }
    }

    private static void accumulateTranslations(Switchboard sb, HashMap<String, NewsDB.Record> translationmsg, ScoreMap<String> ranking, HashMap<String, Integer> negativeHashes, HashMap<String, Integer> positiveHashes, int dbtype) {
        int maxCount = Math.min(1000, sb.peers.newsPool.size(dbtype));
        Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(dbtype);
        int j = 0;
        String refid = "";
        String targetlanguage = "";
        String filename = "";
        String source = "";
        String target = "";
        int score = 0;
        while (recordIterator.hasNext() && j++ < maxCount) {
            Integer vote;
            NewsDB.Record newsrecord = recordIterator.next();
            if (newsrecord == null) continue;
            if (newsrecord.category().equals("transadd") && sb.peers.get(newsrecord.originator()) != null) {
                refid = newsrecord.id();
                targetlanguage = newsrecord.attribute("language", "");
                filename = newsrecord.attribute("file", "");
                source = newsrecord.attribute("source", "");
                target = newsrecord.attribute("target", "");
                if (refid.isEmpty() || targetlanguage.isEmpty() || filename.isEmpty() || source.isEmpty() || target.isEmpty()) continue;
                score = 0;
            }
            if ((vote = negativeHashes.get(refid)) != null) {
                score -= vote.intValue();
            }
            if ((vote = positiveHashes.get(refid)) != null) {
                score += vote.intValue();
            }
            if (translationmsg.containsKey(refid)) {
                ranking.inc(refid, score);
                continue;
            }
            ranking.set(refid, score);
            translationmsg.put(refid, newsrecord);
        }
    }
}

