/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.blob.Tables;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.visualization.ChartPlotter;
import net.yacy.visualization.RasterPlotter;

public class NetworkHistory {
    public static RasterPlotter respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int n;
        int n2;
        int order;
        Switchboard sb = (Switchboard)env;
        if (post == null) {
            post = new serverObjects();
        }
        int maxtime = post.getInt("maxtime", 48);
        int bottomscale = post.getInt("scale", 1);
        String[] columnsx = post.get("columns", "cC").split("\\|");
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (String col : columnsx) {
            columns.add(col);
        }
        ArrayList rows = new ArrayList(maxtime * 2);
        long now = System.currentTimeMillis();
        long timelimit = now - (long)maxtime * 3600000L;
        try {
            Object row;
            String string;
            Object date;
            Iterator<Tables.Row> rowi = sb.tables.iterator("stats", false);
            while (rowi.hasNext() && ((Date)(date = GenericFormatter.SHORT_MINUTE_FORMATTER.parse(string = ASCII.String(((Tables.Row)(row = rowi.next())).getPK()), 0).getTime())).getTime() >= timelimit) {
                HashMap<String, Long> statrow = new HashMap<String, Long>();
                for (String key : columns) {
                    byte[] x = (byte[])((LinkedHashMap)row).get(key);
                    if (x == null) continue;
                    statrow.put(key, Long.parseLong(ASCII.String(x)));
                }
                statrow.put("time", ((Date)date).getTime());
                rows.add(statrow);
            }
        }
        catch (IOException | ParseException e) {
            ConcurrentLog.logException(e);
        }
        int maxpeers = 100;
        int minpeers = Integer.MAX_VALUE;
        for (Map map : rows) {
            for (String column : columns) {
                Long v = (Long)map.get(column);
                if (v != null) {
                    maxpeers = Math.max(maxpeers, (int)v.longValue());
                }
                if (v == null || v <= 0L) continue;
                minpeers = Math.min(minpeers, (int)v.longValue());
            }
        }
        if (minpeers == Integer.MAX_VALUE) {
            minpeers = 0;
        }
        if (minpeers < 0) {
            ConcurrentLog.warn("NetworkHistory", "Negative value in plot. columns:" + columns);
            minpeers = 0;
        }
        if (maxpeers - minpeers > 2 * minpeers) {
            minpeers = 0;
        }
        if ((order = (int)Math.log10(maxpeers - minpeers)) < 1) {
            order = 1;
        }
        if (((maxpeers = (maxpeers / (n2 = (int)Math.pow(10.0, order)) + 1) * n2) - (minpeers = minpeers / n2 * n2)) / n2 < 3) {
            n = Math.max(5, n2 / 2);
        }
        int leftborder = 30;
        int rightborder = 10;
        int width = post.getInt("width", 808);
        int hspace = width - 30 - 10;
        int height = post.getInt("height", 240);
        int topborder = 20;
        int bottomborder = 20;
        int vspace = height - 20 - 20;
        int leftscale = n;
        Object timestr = maxtime + " HOURS";
        if (maxtime > 24 && maxtime % 24 == 0) {
            timestr = maxtime / 24 + " DAYS";
        }
        if (maxtime == 168) {
            timestr = "WEEK";
        }
        if (maxtime > 168 && maxtime % 168 == 0) {
            timestr = maxtime / 168 + " WEEKS";
        }
        Object headline = "YACY NETWORK HISTORY";
        if (columns.contains("aM")) {
            headline = (String)headline + ", ACTIVE PEERS WITHIN THE LAST MONTH";
        }
        if (columns.contains("aW")) {
            headline = (String)headline + ", ACTIVE PEERS WITHIN THE LAST WEEK";
        }
        if (columns.contains("aD")) {
            headline = (String)headline + ", ACTIVE PEERS WITHIN THE LAST DAY";
        }
        if (columns.contains("aH")) {
            headline = (String)headline + ", ACTIVE PEERS WITHIN THE LAST HOUR";
        }
        if (columns.contains("cC")) {
            headline = (String)headline + ", ACTIVE SENIOR PEERS";
        }
        if (columns.contains("cD")) {
            headline = (String)headline + ", PASSIVE SENIOR PEERS";
        }
        if (columns.contains("cP")) {
            headline = (String)headline + ", POTENTIAL JUNIOR PEERS";
        }
        if (columns.contains("cI")) {
            headline = "YACY PEER '" + sb.peers.myName().toUpperCase() + "' INDEX SIZE HISTORY: NUMBER OF DOCUMENTS";
        }
        if (columns.contains("cR")) {
            headline = "YACY PEER '" + sb.peers.myName().toUpperCase() + "' INDEX SIZE HISTORY: NUMBER OF RWI ENTRIES";
        }
        ChartPlotter chart = new ChartPlotter(width, height, 0xFFFFFFL, 0L, 0xAAAAAAL, 30, 10, 20, 20, (String)headline, "IN THE LAST " + (String)timestr);
        long pps = (long)hspace * (long)bottomscale / (long)maxtime;
        int pixelperscale = Math.max(8, (int)pps);
        chart.declareDimension(3, bottomscale, pixelperscale, -maxtime, 0L, 0xCCCCCCL, "TIME/HOURS");
        pps = (long)vspace * (long)leftscale / (long)(maxpeers - minpeers);
        pixelperscale = Math.max(8, (int)pps);
        chart.declareDimension(2, leftscale, pixelperscale, minpeers, 34816L, null, columns.contains("cI") ? "DOCUMENTS" : (columns.contains("cR") ? "RWIs" : "PEERS"));
        for (String column : columns) {
            float x0 = 1.0f;
            int y0 = 0;
            for (Map map : rows) {
                Long v;
                Long time = (Long)map.get("time");
                if (time == null || (v = (Long)map.get(column)) == null) continue;
                float x1 = (float)(time - now) / 3600000.0f;
                int y1 = (int)v.longValue();
                chart.setColor(0x228822L);
                chart.chartDot(3, 2, x1, y1, 2, null, 315);
                chart.setColor(34816L);
                if (x0 < 0.0f) {
                    chart.chartLine(3, 2, x0, y0, x1, y1);
                }
                x0 = x1;
                y0 = y1;
            }
        }
        return chart;
    }
}

