/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.document.importer.WarcImporter;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexImportWarc_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        if (WarcImporter.job != null && WarcImporter.job.isAlive()) {
            prop.put("import", 1L);
            prop.put("import_thread", "running");
            prop.put("import_warcfile", WarcImporter.job.source());
            prop.put("import_count", WarcImporter.job.count());
            prop.put("import_speed", WarcImporter.job.speed());
            prop.put("import_runningHours", WarcImporter.job.runningTime() / 60L / 60L);
            prop.put("import_runningMinutes", WarcImporter.job.runningTime() / 60L % 60L);
            prop.put("import_remainingHours", WarcImporter.job.remainingTime() / 60L / 60L);
            prop.put("import_remainingMinutes", WarcImporter.job.remainingTime() / 60L % 60L);
            if (post != null && post.containsKey("abort")) {
                WarcImporter.job.quit();
            }
        } else {
            prop.put("import", 0L);
            if (post != null && (post.containsKey("file") || post.containsKey("url"))) {
                String filename = post.get("file");
                if (filename != null && filename.length() > 0) {
                    File sourcefile = new File(filename);
                    if (sourcefile.exists()) {
                        try {
                            WarcImporter wi = new WarcImporter(sourcefile);
                            wi.start();
                            prop.put("import_thread", "started");
                        }
                        catch (IOException ex) {
                            prop.put("import_thread", "Error: file not found [" + filename + "]");
                        }
                        prop.put("import", 1L);
                        prop.put("import_warcfile", filename);
                    } else {
                        prop.put("import_warcfile", "");
                        prop.put("import_thread", "Error: file not found [" + filename + "]");
                    }
                } else {
                    String urlstr = post.get("url");
                    if (urlstr != null && urlstr.length() > 0) {
                        try {
                            MultiProtocolURL url = new MultiProtocolURL(urlstr);
                            WarcImporter wi = new WarcImporter(url);
                            wi.start();
                            prop.put("import_thread", "started");
                        }
                        catch (MalformedURLException ex) {
                            prop.put("import_thread", ex.getMessage());
                        }
                        catch (IOException ex) {
                            prop.put("import_thread", ex.getMessage());
                        }
                        prop.put("import", 1L);
                        prop.put("import_warcfile", urlstr);
                    }
                }
                prop.put("import_count", 0L);
                prop.put("import_speed", 0L);
                prop.put("import_runningHours", 0L);
                prop.put("import_runningMinutes", 0L);
                prop.put("import_remainingHours", 0L);
                prop.put("import_remainingMinutes", 0L);
            }
        }
        return prop;
    }
}

