/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.data.ListManager;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.repository.BlacklistHostAndPath;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexControlRWIs_p {
    private static final String APP_NAME = "IndexControlRWIs_p";
    private static final String errmsg = "not possible to compute word from hash";

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.putHTML("keystring", "");
        prop.put("keyhash", "");
        prop.put("result", "");
        boolean limitationsEnabled = post == null || post.containsKey("maxReferencesLimit");
        prop.put("limitations", limitationsEnabled ? 1L : 0L);
        if (limitationsEnabled) {
            prop.put("limitations_transactionToken", TransactionManager.getTransactionToken(header));
        }
        prop.put("searchresult", 0L);
        prop.put("keyhashsimilar", 0L);
        prop.put("genUrlList", 0L);
        SearchEventCache.cleanupEvents(true);
        Segment segment = sb.index;
        if (post != null) {
            RowHandleSet urlb;
            byte[] keyhash;
            block80: {
                ClientIdentification.Agent agent = ClientIdentification.getAgent(post.get("agentName", "YaCy Internet (cautious)"));
                String keystring = post.get("keystring", "").trim();
                keyhash = post.get("keyhash", "").trim().getBytes();
                if (keystring.length() > 0 && !keystring.contains(errmsg)) {
                    keyhash = Word.word2hash(keystring);
                }
                prop.putHTML("keystring", keystring);
                prop.putHTML("keyhash", ASCII.String(keyhash));
                String[] urls2 = post.getAll("urlhx.*");
                urlb = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, urls2.length);
                if (urls2 != null) {
                    for (String s : urls2) {
                        try {
                            urlb.put(s.getBytes());
                        }
                        catch (SpaceExceededException e) {
                            ConcurrentLog.logException(e);
                        }
                    }
                }
                boolean delurl = post.containsKey("delurl");
                boolean delurlref = post.containsKey("delurlref");
                if (post.containsKey("keystringsearch")) {
                    prop.put("keyhash", keyhash);
                    SearchEvent theSearch = IndexControlRWIs_p.genSearchresult(prop, sb, keyhash, null);
                    if (theSearch.local_rwi_available.get() == 0) {
                        prop.put("searchresult", 1L);
                        prop.putHTML("searchresult_word", keystring);
                    }
                }
                if (post.containsKey("keyhashsearch")) {
                    if (keystring.isEmpty() || !Arrays.equals(Word.word2hash(keystring), keyhash)) {
                        prop.put("keystring", "&lt;not possible to compute word from hash&gt;");
                    }
                    SearchEvent theSearch = IndexControlRWIs_p.genSearchresult(prop, sb, keyhash, null);
                    if (theSearch.local_rwi_available.get() == 0) {
                        prop.put("searchresult", 2L);
                        prop.putHTML("searchresult_wordhash", ASCII.String(keyhash));
                    }
                }
                if (post.containsKey("maxReferencesLimit")) {
                    TransactionManager.checkPostTransaction(header, post);
                    ReferenceContainer.maxReferences = post.get("maxReferencesRadio", "").equals("on") ? post.getInt("maxReferences", 0) : 0;
                    sb.setConfig("index.maxReferences", ReferenceContainer.maxReferences);
                }
                if (post.containsKey("keyhashdeleteall")) {
                    TransactionManager.checkPostTransaction(header, post);
                    try {
                        if (delurl || delurlref) {
                            ReferenceContainer<WordReference> index2 = null;
                            index2 = segment.termIndex().get(keyhash, null);
                            Iterator<WordReference> en = index2.entries();
                            urlb = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, index2.size());
                            while (en.hasNext()) {
                                try {
                                    urlb.put(en.next().urlhash());
                                }
                                catch (SpaceExceededException e) {
                                    ConcurrentLog.logException(e);
                                }
                            }
                            index2 = null;
                        }
                        if (delurlref) {
                            segment.removeAllUrlReferences(urlb, sb.loader, agent, CacheStrategy.IFEXIST);
                        }
                        segment.termIndex().delete(keyhash);
                        if (delurl || delurlref) {
                            for (Object b2 : urlb) {
                                sb.urlRemove(segment, (byte[])b2);
                            }
                        }
                        post.remove("keyhashdeleteall");
                        post.put("urllist", "generated");
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (post.containsKey("keyhashdelete")) {
                    try {
                        Object b2;
                        if (delurlref) {
                            segment.removeAllUrlReferences(urlb, sb.loader, agent, CacheStrategy.IFEXIST);
                        }
                        if (delurl || delurlref) {
                            for (Object b2 : urlb) {
                                sb.urlRemove(segment, (byte[])b2);
                            }
                        }
                        RowHandleSet urlHashes = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
                        b2 = urlb.iterator();
                        while (b2.hasNext()) {
                            byte[] b3 = (byte[])b2.next();
                            try {
                                urlHashes.put(b3);
                            }
                            catch (SpaceExceededException e) {
                                ConcurrentLog.logException(e);
                            }
                        }
                        segment.termIndex().remove(keyhash, urlHashes);
                        post.remove("keyhashdelete");
                        post.put("urllist", "generated");
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (post.containsKey("urllist")) {
                    if (keystring.isEmpty() || !Arrays.equals(Word.word2hash(keystring), keyhash)) {
                        prop.put("keystring", "&lt;not possible to compute word from hash&gt;");
                    }
                    Bitfield flags = IndexControlRWIs_p.compileFlags(post);
                    int count = post.get("lines", "all").equals("all") ? -1 : post.getInt("lines", -1);
                    SearchEvent theSearch = IndexControlRWIs_p.genSearchresult(prop, sb, keyhash, flags);
                    IndexControlRWIs_p.genURLList(prop, keyhash, keystring, theSearch, flags, count);
                }
                if (post.containsKey("keyhashtransfer")) {
                    TransactionManager.checkPostTransaction(header, post);
                    try {
                        if (keystring.isEmpty() || !Arrays.equals(Word.word2hash(keystring), keyhash)) {
                            prop.put("keystring", "&lt;not possible to compute word from hash&gt;");
                        }
                        String host = post.get("host", "");
                        Seed seed = null;
                        if (host.length() != 0) {
                            if (host.length() == 12) {
                                seed = sb.peers.getConnected(host);
                                if (seed == null) {
                                    seed = sb.peers.lookupByName(host);
                                }
                            } else {
                                seed = sb.peers.lookupByName(host);
                            }
                        } else {
                            host = post.get("hostHash", "");
                            seed = sb.peers.getConnected(host);
                        }
                        if (seed != null) {
                            long starttime = System.currentTimeMillis();
                            ReferenceContainer<WordReference> index3 = segment.termIndex().get(keyhash, null);
                            Iterator<WordReference> urlIter = index3.entries();
                            RowHandleSet knownURLs = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, index3.size());
                            RowHandleSet unknownURLEntries = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, index3.size());
                            while (urlIter.hasNext()) {
                                Reference iEntry = urlIter.next();
                                boolean exists = segment.fulltext().exists(ASCII.String(iEntry.urlhash()));
                                if (exists) {
                                    try {
                                        knownURLs.put(iEntry.urlhash());
                                    }
                                    catch (SpaceExceededException e) {
                                        ConcurrentLog.logException(e);
                                    }
                                    continue;
                                }
                                try {
                                    unknownURLEntries.put(iEntry.urlhash());
                                }
                                catch (SpaceExceededException e) {
                                    ConcurrentLog.logException(e);
                                }
                                urlIter.remove();
                            }
                            ReferenceContainerCache<WordReference> icc = new ReferenceContainerCache<WordReference>(Segment.wordReferenceFactory, Segment.wordOrder, 12);
                            try {
                                icc.add(index3);
                            }
                            catch (SpaceExceededException e) {
                                ConcurrentLog.logException(e);
                            }
                            boolean gzipBody = sb.getConfigBool("indexControl.gzipBody", false);
                            int timeout = (int)sb.getConfigLong("indexControl.timeout", 60000L);
                            String error = Protocol.transferIndex(sb, seed, icc, knownURLs, segment, gzipBody, timeout);
                            prop.put("result", error == null ? "Successfully transferred " + knownURLs.size() + " words in " + (System.currentTimeMillis() - starttime) / 1000L + " seconds, " + unknownURLEntries.size() + " URL not found" : "error: " + error);
                            index3 = null;
                            break block80;
                        }
                        prop.put("result", "Peer " + host + " not found");
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            }
            if (sb.getConfigBool("core.service.rwi.tmp", true)) {
                if (post.containsKey("keyhashsimilar")) {
                    try {
                        Iterator containerIt = segment.termIndex().referenceContainer(keyhash, true, false, 256, false).iterator();
                        int rows = 0;
                        int cols = 0;
                        prop.put("keyhashsimilar", "1");
                        for (int i = 0; containerIt.hasNext() && i < 256; ++i) {
                            ReferenceContainer container = containerIt.next();
                            prop.put("keyhashsimilar_rows_" + rows + "_cols_" + cols + "_wordHash", container.getTermHash());
                            if (++cols != 8) continue;
                            prop.put("keyhashsimilar_rows_" + rows + "_cols", cols);
                            cols = 0;
                            ++rows;
                        }
                        prop.put("keyhashsimilar_rows_" + rows + "_cols", cols);
                        prop.put("keyhashsimilar_rows", rows + 1);
                        prop.put("result", "");
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            } else {
                prop.put("result", "RWI index not connected (see Index Sources & Targets -> <a href='IndexFederated_p.html'>Peer-to-Peer Operation</a>)");
            }
            if (post.containsKey("blacklist")) {
                String blacklist = post.get("blacklist", "");
                RowHandleSet urlHashes = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, urlb.size());
                if (post.containsKey("blacklisturls")) {
                    ArrayList<BlacklistHostAndPath> items = new ArrayList<BlacklistHostAndPath>();
                    for (byte[] b : urlb) {
                        try {
                            urlHashes.put(b);
                        }
                        catch (SpaceExceededException e) {
                            ConcurrentLog.logException(e);
                        }
                        try {
                            String u = segment.fulltext().getURL(ASCII.String(b));
                            DigestURL url = u == null ? null : new DigestURL(u);
                            segment.fulltext().remove(b);
                            if (url == null) continue;
                            items.add(new BlacklistHostAndPath(url.getHost(), url.getFile()));
                        }
                        catch (IOException e1) {
                            ConcurrentLog.logException(e1);
                        }
                    }
                    for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
                        if (!ListManager.listSetContains(supportedBlacklistType + ".BlackLists", blacklist)) continue;
                        try {
                            Switchboard.urlBlacklist.add(supportedBlacklistType, blacklist, items);
                        }
                        catch (Punycode.PunycodeException e) {
                            ConcurrentLog.warn(APP_NAME, "Unable to add blacklist entries to blacklist " + supportedBlacklistType, e);
                        }
                    }
                    SearchEventCache.cleanupEvents(true);
                }
                if (post.containsKey("blacklistdomains")) {
                    for (byte[] b : urlb) {
                        try {
                            urlHashes.put(b);
                        }
                        catch (SpaceExceededException e) {
                            ConcurrentLog.logException(e);
                        }
                        try {
                            String u = segment.fulltext().getURL(ASCII.String(b));
                            DigestURL url = u == null ? null : new DigestURL(u);
                            segment.fulltext().remove(b);
                            if (url == null) continue;
                            for (Blacklist.BlacklistType supportedBlacklistType : Blacklist.BlacklistType.values()) {
                                if (!ListManager.listSetContains(supportedBlacklistType + ".BlackLists", blacklist)) continue;
                                try {
                                    Switchboard.urlBlacklist.add(supportedBlacklistType, blacklist, url.getHost(), ".*");
                                }
                                catch (PatternSyntaxException | Punycode.PunycodeException e) {
                                    ConcurrentLog.warn(APP_NAME, "Unable to add blacklist entry to blacklist " + supportedBlacklistType, e);
                                }
                            }
                        }
                        catch (IOException e1) {
                            ConcurrentLog.logException(e1);
                        }
                    }
                }
                try {
                    segment.termIndex().remove(keyhash, urlHashes);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            if (prop.getInt("searchresult", 0) == 3) {
                prop.put("searchresult_transactionToken", TransactionManager.getTransactionToken(header));
                IndexControlRWIs_p.listHosts(prop, keyhash, sb);
            }
        }
        prop.putNum("wcount", segment.RWICount());
        prop.put("limitations_maxReferencesRadioChecked", ReferenceContainer.maxReferences > 0 ? 1L : 0L);
        prop.put("limitations_maxReferences", ReferenceContainer.maxReferences > 0 ? (long)ReferenceContainer.maxReferences : 100000L);
        return prop;
    }

    public static void genURLList(serverObjects prop, byte[] keyhash, String keystring, SearchEvent theSearch, Bitfield flags, int maxlines) {
        String keyhashs = ASCII.String(keyhash);
        prop.put("genUrlList_keyHash", keyhashs);
        if (theSearch.local_rwi_stored.get() == 0) {
            prop.put("genUrlList", 1L);
            prop.put("genUrlList_count", 0L);
            prop.put("searchresult", 2L);
        } else {
            URIMetadataNode entry2;
            prop.put("genUrlList", 2L);
            prop.put("searchresult", 3L);
            prop.put("genUrlList_flags", flags == null ? "" : flags.exportB64());
            prop.put("genUrlList_lines", maxlines);
            int i = 0;
            long rn = Long.MIN_VALUE;
            while (!theSearch.rwiIsEmpty() && (entry2 = theSearch.pullOneFilteredFromRWI(false)) != null) {
                DigestURL url = entry2.url();
                if (url == null) continue;
                String us = url.toNormalform(true);
                if (rn == Long.MIN_VALUE) {
                    rn = entry2.score();
                }
                prop.put("genUrlList_urlList_" + i + "_urlExists", "1");
                prop.put("genUrlList_urlList_" + i + "_urlExists_urlhxCount", i);
                prop.putHTML("genUrlList_urlList_" + i + "_urlExists_urlhxValue", entry2.word().urlhash());
                prop.putHTML("genUrlList_urlList_" + i + "_urlExists_keyString", keystring);
                prop.put("genUrlList_urlList_" + i + "_urlExists_keyHash", keyhashs);
                prop.putHTML("genUrlList_urlList_" + i + "_urlExists_urlString", us);
                prop.put("genUrlList_urlList_" + i + "_urlExists_urlStringShort", (String)(us.length() > 40 ? us.substring(0, 20) + "<br>" + us.substring(20, 40) + "..." : (us.length() > 30 ? us.substring(0, 20) + "<br>" + us.substring(20) : us)));
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_ranking", entry2.score() - rn);
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_domlength", DigestURL.domLengthEstimation(entry2.hash()));
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_tf", 1000.0 * entry2.word().termFrequency());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_authority", theSearch.getOrder() == null ? -1L : (long)theSearch.getOrder().authority(ASCII.String(entry2.hash(), 6, 6)));
                prop.put("genUrlList_urlList_" + i + "_urlExists_date", GenericFormatter.SHORT_DAY_FORMATTER.format(new Date(entry2.word().lastModified())));
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_wordsintitle", entry2.word().wordsintitle());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_wordsintext", entry2.word().wordsintext());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_phrasesintext", entry2.word().phrasesintext());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_llocal", entry2.word().llocal());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_lother", entry2.word().lother());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_hitcount", entry2.word().hitcount());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_pos", entry2.word().posintext());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_phrase", entry2.word().posofphrase());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_posinphrase", entry2.word().posinphrase());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_urlcomps", entry2.word().urlcomps());
                prop.putNum("genUrlList_urlList_" + i + "_urlExists_urllength", entry2.word().urllength());
                prop.put("genUrlList_urlList_" + i + "_urlExists_props", (entry2.word().flags().get(0) ? "appears on index page, " : "") + (entry2.word().flags().get(20) ? "contains images, " : "") + (entry2.word().flags().get(21) ? "contains audio, " : "") + (entry2.word().flags().get(22) ? "contains video, " : "") + (entry2.word().flags().get(23) ? "contains applications, " : "") + (entry2.word().flags().get(28) ? "appears in url, " : "") + (entry2.word().flags().get(25) ? "appears in title, " : "") + (entry2.word().flags().get(26) ? "appears in author, " : "") + (entry2.word().flags().get(27) ? "appears in subject, " : "") + (entry2.word().flags().get(24) ? "appears in description, " : "") + (entry2.word().flags().get(29) ? "appears emphasized, " : ""));
                if (Switchboard.urlBlacklist.isListed(Blacklist.BlacklistType.DHT, url)) {
                    prop.put("genUrlList_urlList_" + i + "_urlExists_urlhxChecked", "1");
                }
                if (maxlines < 0 || ++i < maxlines) continue;
            }
            prop.put("genUrlList_urlList", i);
            prop.putHTML("genUrlList_keyString", keystring);
            prop.put("genUrlList_count", i);
            IndexControlRWIs_p.putBlacklists(prop, FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$"));
        }
    }

    public static void putBlacklists(serverObjects prop, List<String> lists) {
        prop.put("genUrlList_blacklists", lists.size());
        int i = 0;
        for (String list2 : lists) {
            prop.put("genUrlList_blacklists_" + i++ + "_name", list2);
        }
    }

    public static Bitfield compileFlags(serverObjects post) {
        Bitfield b = new Bitfield(4);
        if (post.get("allurl", "").equals("on")) {
            return null;
        }
        if (post.get("flags") != null) {
            if (post.get("flags", "").isEmpty()) {
                return null;
            }
            return new Bitfield(4, post.get("flags"));
        }
        if (post.get("description", "").equals("on")) {
            b.set(24, true);
        }
        if (post.get("title", "").equals("on")) {
            b.set(25, true);
        }
        if (post.get("creator", "").equals("on")) {
            b.set(26, true);
        }
        if (post.get("subject", "").equals("on")) {
            b.set(27, true);
        }
        if (post.get("url", "").equals("on")) {
            b.set(28, true);
        }
        if (post.get("emphasized", "").equals("on")) {
            b.set(29, true);
        }
        if (post.get("image", "").equals("on")) {
            b.set(20, true);
        }
        if (post.get("audio", "").equals("on")) {
            b.set(21, true);
        }
        if (post.get("video", "").equals("on")) {
            b.set(22, true);
        }
        if (post.get("app", "").equals("on")) {
            b.set(23, true);
        }
        if (post.get("indexof", "").equals("on")) {
            b.set(0, true);
        }
        return b;
    }

    public static void listHosts(serverObjects prop, byte[] startHash, Switchboard sb) {
        int hc = 0;
        prop.put("searchresult_keyhash", startHash);
        Iterator<Seed> e = DHTSelection.getAcceptRemoteIndexSeeds(sb.peers, startHash, sb.peers.sizeConnected(), true);
        while (e.hasNext()) {
            Seed seed = e.next();
            if (seed == null) continue;
            prop.put("searchresult_hosts_" + hc + "_hosthash", seed.hash);
            prop.putHTML("searchresult_hosts_" + hc + "_hostname", seed.hash + " " + seed.get("Name", "nameless"));
            ++hc;
        }
        prop.put("searchresult_hosts", hc);
    }

    public static SearchEvent genSearchresult(serverObjects prop, Switchboard sb, byte[] keyhash, Bitfield filter) {
        HandleSet queryhashes = QueryParams.hashes2Set(ASCII.String(keyhash));
        QueryGoal qg = new QueryGoal(queryhashes, null);
        QueryParams query2 = new QueryParams(qg, new QueryModifier(0), Integer.MAX_VALUE, "", Classification.ContentDomain.ALL, "", 0, null, CacheStrategy.IFFRESH, 1000, 0, ".*", null, null, QueryParams.Searchdom.LOCAL, filter, false, null, 255, "", false, sb.index, sb.getRanking(), "", 0.0, 0.0, 0.0, new HashSet<String>());
        SearchEvent theSearch = SearchEventCache.getEvent(query2, sb.peers, sb.tables, null, false, sb.loader, Integer.MAX_VALUE, Long.MAX_VALUE);
        if (theSearch.rwiProcess != null && theSearch.rwiProcess.isAlive()) {
            try {
                theSearch.rwiProcess.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (theSearch.local_rwi_available.get() == 0) {
            prop.put("searchresult", 2L);
            prop.put("searchresult_wordhash", keyhash);
        } else {
            prop.put("searchresult", 3L);
            prop.put("searchresult_allurl", theSearch.local_rwi_available.get());
            prop.put("searchresult_description", theSearch.flagCount()[24]);
            prop.put("searchresult_title", theSearch.flagCount()[25]);
            prop.put("searchresult_creator", theSearch.flagCount()[26]);
            prop.put("searchresult_subject", theSearch.flagCount()[27]);
            prop.put("searchresult_url", theSearch.flagCount()[28]);
            prop.put("searchresult_emphasized", theSearch.flagCount()[29]);
            prop.put("searchresult_image", theSearch.flagCount()[20]);
            prop.put("searchresult_audio", theSearch.flagCount()[21]);
            prop.put("searchresult_video", theSearch.flagCount()[22]);
            prop.put("searchresult_app", theSearch.flagCount()[23]);
            prop.put("searchresult_indexof", theSearch.flagCount()[0]);
        }
        return theSearch;
    }
}

