/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.FailType;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.HarvestProcess;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.NoticedURL;
import net.yacy.crawler.retrieval.Request;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.peers.graphics.WebStructureGraph;
import net.yacy.repository.Blacklist;
import net.yacy.repository.BlacklistHelper;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.query.QueryParams;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrDocument;

public class IndexBrowser_p {
    static final long TIMEOUT = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        Fulltext fulltext = sb.index.fulltext();
        boolean autoload = sb.getConfigBool("browser.autoload", true);
        boolean load4everyone = sb.getConfigBool("browser.load4everyone", false);
        boolean loadRight = autoload || load4everyone;
        serverObjects prop = new serverObjects();
        prop.put("path", "");
        prop.put("result", "");
        prop.put("hosts", 0L);
        prop.put("files", 0L);
        prop.put("hostanalysis", 0L);
        Object path = post == null ? "" : post.get("path", "").trim();
        sb.index.fulltext().commit(true);
        if (post == null || env == null) {
            prop.putNum("ucount", fulltext.collectionSize());
            return prop;
        }
        int p = ((String)path).lastIndexOf(47);
        if (p < 0 && ((String)path).length() > 0) {
            path = (String)path + "/";
        } else if (p > 7) {
            path = ((String)path).substring(0, p + 1);
        }
        if (!(((String)path).length() <= 0 || ((String)path).startsWith("http://") || ((String)path).startsWith("https://") || ((String)path).startsWith("ftp://") || ((String)path).startsWith("smb://") || ((String)path).startsWith("file://"))) {
            path = "https://" + (String)path;
        }
        prop.putHTML("path", (String)path);
        prop.put("delete", ((String)path).length() > 0 ? 1L : 0L);
        DigestURL pathURI = null;
        try {
            pathURI = new DigestURL((String)path);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Object load = post.get("load", "");
        boolean wait = false;
        if (loadRight && autoload && ((String)path).length() != 0 && pathURI != null && ((String)load).length() == 0 && !sb.index.exists(ASCII.String(pathURI.hash()))) {
            load = path;
            wait = true;
        }
        if (((String)load).length() > 0 && loadRight) {
            if (sb.crawlStacker.size() > 2) {
                wait = false;
            }
            try {
                DigestURL url = new DigestURL((String)load);
                String reasonString = sb.crawlStacker.stackCrawl(new Request(sb.peers.mySeed().hash.getBytes(), url, null, (String)load, new Date(), sb.crawler.defaultProxyProfile.handle(), 0, sb.crawler.defaultProxyProfile.timezoneOffset()));
                prop.putHTML("result", reasonString == null ? "added url to indexer: " + (String)load : "not indexed url '" + (String)load + "': " + reasonString);
                if (wait) {
                    for (int i = 0; i < 30 && !sb.index.exists(ASCII.String(url.hash())); ++i) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (MalformedURLException e) {
                prop.putHTML("result", "bad url '" + (String)load + "'");
            }
        }
        if (post.containsKey("deleteLoadErrors")) {
            try {
                fulltext.getDefaultConnector().deleteByQuery("-" + CollectionSchema.httpstatus_i.getSolrFieldName() + ":200 AND " + CollectionSchema.httpstatus_i.getSolrFieldName() + ":[* TO *]");
                ConcurrentLog.info("IndexBrowser_p:", "delete documents with httpstatus_i <> 200");
                fulltext.getDefaultConnector().deleteByQuery(CollectionSchema.failtype_s.getSolrFieldName() + ":\"" + FailType.fail.name() + "\"");
                ConcurrentLog.info("IndexBrowser_p:", "delete documents with failtype_s = fail");
                fulltext.getDefaultConnector().deleteByQuery(CollectionSchema.failtype_s.getSolrFieldName() + ":\"" + FailType.excl.name() + "\"");
                ConcurrentLog.info("IndexBrowser_p:", "delete documents with failtype_s = excl");
                prop.putNum("ucount", fulltext.collectionSize());
                return prop;
            }
            catch (IOException ex) {
                ConcurrentLog.logException(ex);
            }
        }
        if (post.containsKey("hosts")) {
            try {
                boolean onlyCrawling = "crawling".equals(post.get("hosts", ""));
                boolean onlyErrors = "error".equals(post.get("hosts", ""));
                int maxcount = 2520;
                Object hostscore = fulltext.getDefaultConnector().getFacets(CollectionSchema.httpstatus_i.getSolrFieldName() + ":200", 2520, CollectionSchema.host_s.getSolrFieldName()).get(CollectionSchema.host_s.getSolrFieldName());
                if (hostscore == null) {
                    hostscore = new ClusteredScoreMap(true);
                }
                Map<String, Integer[]> crawler = sb.crawlQueues.noticeURL.getDomainStackHosts(NoticedURL.StackType.LOCAL, sb.robots);
                HashMap<String, Integer> hostNameToPendingCount = new HashMap<String, Integer>();
                for (Map.Entry<String, Integer[]> crawlerEntry : crawler.entrySet()) {
                    String string = Domains.stripToHostName(crawlerEntry.getKey());
                    Integer pendingCount = (Integer)hostNameToPendingCount.get(string);
                    if (pendingCount == null) {
                        pendingCount = 0;
                    }
                    pendingCount = pendingCount + crawlerEntry.getValue()[0];
                    hostNameToPendingCount.put(string, pendingCount);
                }
                LinkedHashMap<String, ReversibleScoreMap<String>> exclfacets = fulltext.getDefaultConnector().getFacets(CollectionSchema.failtype_s.getSolrFieldName() + ":" + FailType.excl.name(), 2520, CollectionSchema.host_s.getSolrFieldName());
                ReversibleScoreMap<String> exclscore = exclfacets == null ? new ClusteredScoreMap(true) : (ReversibleScoreMap)exclfacets.get(CollectionSchema.host_s.getSolrFieldName());
                LinkedHashMap<String, ReversibleScoreMap<String>> linkedHashMap = fulltext.getDefaultConnector().getFacets(CollectionSchema.failtype_s.getSolrFieldName() + ":" + FailType.fail.name(), 2520, CollectionSchema.host_s.getSolrFieldName());
                ReversibleScoreMap<String> failscore = linkedHashMap == null ? new ClusteredScoreMap(true) : (ReversibleScoreMap)linkedHashMap.get(CollectionSchema.host_s.getSolrFieldName());
                int c = 0;
                Iterator i = hostscore.keys(false);
                while (i.hasNext() && c < 2520) {
                    String string = (String)i.next();
                    prop.putHTML("hosts_list_" + c + "_host", string);
                    boolean inCrawler = hostNameToPendingCount.containsKey(string);
                    int exclcount = exclscore.get(string);
                    int failcount = failscore.get(string);
                    int errors = exclcount + failcount;
                    prop.put("hosts_list_" + c + "_count", hostscore.get(string));
                    prop.put("hosts_list_" + c + "_crawler", inCrawler ? 1L : 0L);
                    if (inCrawler) {
                        prop.put("hosts_list_" + c + "_crawler_pending", ((Integer)hostNameToPendingCount.get(string)).intValue());
                    }
                    prop.put("hosts_list_" + c + "_errors", errors > 0 ? 1L : 0L);
                    if (errors > 0) {
                        prop.put("hosts_list_" + c + "_errors_exclcount", exclcount);
                        prop.put("hosts_list_" + c + "_errors_failcount", failcount);
                    }
                    prop.put("hosts_list_" + c + "_type", inCrawler ? 2L : (errors > 0 ? 1L : 0L));
                    if (onlyCrawling) {
                        if (!inCrawler) continue;
                        ++c;
                        continue;
                    }
                    if (onlyErrors) {
                        if (errors <= 0) continue;
                        ++c;
                        continue;
                    }
                    ++c;
                }
                prop.put("hosts_list", c);
                prop.put("hosts_authorized", 1L);
                prop.put("hosts", 1L);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        if (((String)path).length() > 0) {
            try {
                ClusteredScoreMap<String> score;
                DigestURL uri = new DigestURL((String)path);
                String host = uri.getHost();
                if (uri.getPath().length() <= 1 && host != null && host.length() > 0 && sb.getConfigBool("decoration.hostanalysis", false)) {
                    ArrayList<Object> ff = new ArrayList<Object>();
                    for (CollectionSchema csf : CollectionSchema.values()) {
                        if (csf.getType() != SolrType.num_integer && csf.getType() != SolrType.num_long || csf.isMultiValued()) continue;
                        String facetfield = csf.getSolrFieldName();
                        if (!fulltext.getDefaultConfiguration().contains(facetfield)) continue;
                        ff.add(csf.getSolrFieldName());
                    }
                    LinkedHashMap<String, ReversibleScoreMap<String>> vocabularyFacet = sb.index.fulltext().getDefaultConnector().getFacets(CollectionSchema.vocabularies_sxt.getSolrFieldName() + ":[* TO *]", 100, CollectionSchema.vocabularies_sxt.getSolrFieldName());
                    if (vocabularyFacet.size() > 0) {
                        Collection vocnames = ((ReversibleScoreMap)vocabularyFacet.values().iterator().next()).keyList(true);
                        for (String vocname : vocnames) {
                            ff.add("vocabulary_" + vocname + "_log_i");
                            ff.add("vocabulary_" + vocname + "_log_val");
                        }
                    }
                    String[] facetfields = ff.toArray(new String[ff.size()]);
                    LinkedHashMap<String, ReversibleScoreMap<String>> facets = fulltext.getDefaultConnector().getFacets(CollectionSchema.host_s.getSolrFieldName() + ":\"" + host + "\"", 100, facetfields);
                    int fc = 0;
                    for (Map.Entry entry2 : facets.entrySet()) {
                        String[] facetfieldmap = (String[])entry2.getValue();
                        if (facetfieldmap.size() == 0) continue;
                        TreeMap<Long, Integer> statMap = new TreeMap<Long, Integer>();
                        for (String string : facetfieldmap) {
                            statMap.put(Long.parseLong(string), facetfieldmap.get(string));
                        }
                        prop.put("hostanalysis_facets_" + fc + "_facetname", (String)entry2.getKey());
                        int c = 0;
                        for (Map.Entry entry22 : statMap.entrySet()) {
                            prop.put("hostanalysis_facets_" + fc + "_facet_" + c + "_key", (Long)entry22.getKey());
                            prop.put("hostanalysis_facets_" + fc + "_facet_" + c + "_count", ((Integer)entry22.getValue()).intValue());
                            prop.put("hostanalysis_facets_" + fc + "_facet_" + c + "_a", "solr/collection1/select?q=host_s:" + host + " AND " + (String)entry2.getKey() + ":" + entry22.getKey() + "&defType=edismax&start=0&rows=1000&fl=sku,crawldepth_i");
                            ++c;
                        }
                        prop.put("hostanalysis_facets_" + fc + "_facet", c);
                        ++fc;
                    }
                    prop.put("hostanalysis_facets", fc);
                    prop.put("hostanalysis", 1L);
                }
                boolean delete = false;
                boolean reload404 = false;
                if (post.containsKey("delete")) {
                    delete = true;
                }
                if (post.containsKey("reload404")) {
                    reload404 = true;
                }
                int facetcount = post.getInt("facetcount", 0);
                boolean complete = post.getBoolean("complete");
                if (complete && (p = ((String)path).indexOf(47, 10)) > 0) {
                    path = ((String)path).substring(0, p + 1);
                }
                prop.put("files_complete", complete ? 1L : 0L);
                prop.putHTML("files_complete_path", (String)path);
                p = ((String)path).substring(0, ((String)path).length() - 1).lastIndexOf(47);
                if (p < 8) {
                    prop.put("files_root", 1L);
                } else {
                    prop.put("files_root", 0L);
                    prop.putHTML("files_root_path", ((String)path).substring(0, p + 1));
                }
                prop.putHTML("outbound_host", host);
                prop.putHTML("inbound_host", host);
                String hosthash = uri.hosthash();
                String[] pathparts = uri.getPaths();
                StringBuilder stringBuilder = new StringBuilder();
                if (host == null) {
                    if (((String)path).startsWith("file://")) {
                        stringBuilder.append(CollectionSchema.url_protocol_s.getSolrFieldName()).append(":file");
                    }
                } else {
                    stringBuilder.append(CollectionSchema.host_s.getSolrFieldName()).append(":\"").append(host).append("\"");
                }
                if (pathparts.length > 0 && pathparts[0].length() > 0) {
                    for (String string : pathparts) {
                        if (string.length() <= 0) continue;
                        stringBuilder.append(" AND ").append(CollectionSchema.url_paths_sxt.getSolrFieldName()).append(":\"").append(string).append('\"');
                    }
                } else if (facetcount > 1000 || post.containsKey("nepr")) {
                    stringBuilder.append(" AND ").append(CollectionSchema.url_paths_sxt.getSolrFieldName()).append(":[* TO *]");
                }
                if (reload404) {
                    stringBuilder.append(" AND ").append(CollectionSchema.failtype_s.getSolrFieldName()).append(":[* TO *]");
                }
                int pageSize = 100;
                ArrayBlockingQueue<SolrDocument> docs = new ArrayBlockingQueue<SolrDocument>(100);
                ArrayList<String> queries = new ArrayList<String>();
                queries.add(stringBuilder.toString());
                Thread thread = new Thread(fulltext.getDefaultConnector().newDocumentsByQueriesTask(docs, queries, CollectionSchema.url_chars_i.getSolrFieldName() + " asc", 0, 100000, 10000L, 100, 1, CollectionSchema.id.getSolrFieldName(), CollectionSchema.sku.getSolrFieldName(), CollectionSchema.failreason_s.getSolrFieldName(), CollectionSchema.failtype_s.getSolrFieldName(), CollectionSchema.inboundlinks_protocol_sxt.getSolrFieldName(), CollectionSchema.inboundlinks_urlstub_sxt.getSolrFieldName(), CollectionSchema.outboundlinks_protocol_sxt.getSolrFieldName(), CollectionSchema.outboundlinks_urlstub_sxt.getSolrFieldName(), CollectionSchema.crawldepth_i.getSolrFieldName(), CollectionSchema.references_i.getSolrFieldName(), CollectionSchema.references_internal_i.getSolrFieldName(), CollectionSchema.references_external_i.getSolrFieldName(), CollectionSchema.references_exthosts_i.getSolrFieldName()));
                thread.start();
                HashSet<Object> storedDocs = new HashSet<Object>();
                HashMap<Object, FailType> errorDocs = new HashMap<Object, FailType>();
                HashSet<Object> inboundLinks = new HashSet<Object>();
                HashMap<String, ClusteredScoreMap<String>> outboundHosts = new HashMap<String, ClusteredScoreMap<String>>();
                HashMap<String, InfoCacheEntry> infoCache = new HashMap<String, InfoCacheEntry>();
                int hostsize = 0;
                ArrayList<String> deleteIDs = new ArrayList<String>();
                ArrayList<String> reloadURLs = new ArrayList<String>();
                HashSet reloadURLCollection = new HashSet();
                long timeoutList = System.currentTimeMillis() + 10000L;
                long remainingTime = 10000L;
                long timeoutReferences = System.currentTimeMillis() + 10000L;
                Segment.ReferenceReportCache rrCache = sb.index.getReferenceReportCache();
                try {
                    SolrDocument doc = (SolrDocument)docs.poll(remainingTime, TimeUnit.MILLISECONDS);
                    while (doc != AbstractSolrConnector.POISON_DOCUMENT && doc != null) {
                        Object u = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                        String errortype = (String)doc.getFieldValue(CollectionSchema.failtype_s.getSolrFieldName());
                        FailType failType = errortype == null ? null : FailType.valueOf(errortype);
                        String string = (String)doc.getFieldValue(CollectionSchema.id.getSolrFieldName());
                        infoCache.put(string, new InfoCacheEntry(sb.index.fulltext(), rrCache, doc, string, System.currentTimeMillis() < timeoutReferences));
                        if (((String)u).startsWith((String)path)) {
                            if (delete) {
                                deleteIDs.add(string);
                            } else if (failType == null) {
                                storedDocs.add(u);
                            } else {
                                if (reload404 && failType == FailType.fail) {
                                    ArrayList collections = (ArrayList)doc.getFieldValue(CollectionSchema.collection_sxt.getSolrFieldName());
                                    if (collections != null) {
                                        reloadURLCollection.addAll(collections);
                                    }
                                    reloadURLs.add((String)u);
                                }
                                errorDocs.put(u, failType);
                            }
                        } else if (complete) {
                            if (failType == null) {
                                storedDocs.add(u);
                            } else {
                                errorDocs.put(u, failType);
                            }
                        }
                        if ((complete || ((String)u).startsWith((String)path)) && !storedDocs.contains(u)) {
                            inboundLinks.add(u);
                        }
                        if (failType == null) {
                            ++hostsize;
                            Iterator<String> links = URIMetadataNode.getLinks(doc, true);
                            while (links.hasNext()) {
                                u = links.next();
                                if (!complete && !((String)u).startsWith((String)path) || storedDocs.contains(u)) continue;
                                inboundLinks.add(u);
                            }
                            links = URIMetadataNode.getLinks(doc, false);
                            while (links.hasNext()) {
                                u = links.next();
                                try {
                                    MultiProtocolURL mu = new MultiProtocolURL((String)u);
                                    if (mu.getHost() == null) continue;
                                    ClusteredScoreMap<String> lks = (ClusteredScoreMap<String>)outboundHosts.get(mu.getHost());
                                    if (lks == null) {
                                        lks = new ClusteredScoreMap<String>(UTF8.insensitiveUTF8Comparator);
                                        outboundHosts.put(mu.getHost(), lks);
                                    }
                                    lks.set((String)u, ((String)u).length());
                                }
                                catch (MalformedURLException mu) {}
                            }
                        }
                        if ((remainingTime = timeoutList - System.currentTimeMillis()) <= 0L) {
                            break;
                        }
                        doc = (SolrDocument)docs.poll(remainingTime, TimeUnit.MILLISECONDS);
                    }
                }
                finally {
                    thread.interrupt();
                }
                if (deleteIDs.size() > 0) {
                    sb.remove(deleteIDs);
                }
                if (reloadURLs.size() > 0) {
                    LinkedHashMap<String, Pattern> cm = new LinkedHashMap<String, Pattern>();
                    for (Object collection : reloadURLCollection) {
                        cm.put((String)collection, QueryParams.catchall_pattern);
                    }
                    sb.reload(reloadURLs, cm.size() > 0 ? cm : CrawlProfile.collectionParser("user"), false);
                }
                List<Request> domainStackReferences = sb.crawlQueues.noticeURL.getDomainStackReferences(NoticedURL.StackType.LOCAL, host, 1000, 3000L);
                HashSet<String> loadingLinks = new HashSet<String>();
                for (Request request : domainStackReferences) {
                    loadingLinks.add(request.url().toNormalform(true));
                }
                HashMap<String, StoreType> files = new HashMap<String, StoreType>();
                for (String string : storedDocs) {
                    files.put(string, StoreType.INDEX);
                }
                for (Map.Entry entry3 : errorDocs.entrySet()) {
                    files.put((String)entry3.getKey(), entry3.getValue() == FailType.fail ? StoreType.FAILED : StoreType.EXCLUDED);
                }
                for (String string : inboundLinks) {
                    if (files.containsKey(string)) continue;
                    files.put(string, StoreType.LINK);
                }
                if (!reload404) {
                    for (String string : loadingLinks) {
                        if (!string.startsWith((String)path) || files.containsKey(string)) continue;
                        files.put(string, StoreType.LINK);
                    }
                }
                ConcurrentLog.info("IndexBrowser_p", "collected " + files.size() + " urls for path " + (String)path);
                TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
                int n = ((String)path).length();
                for (Map.Entry entry3 : files.entrySet()) {
                    if (((String)entry3.getKey()).length() < n || !((String)entry3.getKey()).startsWith((String)path)) continue;
                    String file = ((String)entry3.getKey()).substring(n);
                    StoreType type = (StoreType)((Object)entry3.getValue());
                    p = file.indexOf(47);
                    if (p < 0) {
                        treeMap.put((String)entry3.getKey(), (Object)type);
                        continue;
                    }
                    String remainingPath = file.substring(0, p + 1);
                    if (complete && remainingPath.indexOf(46) > 0) {
                        treeMap.put((String)entry3.getKey(), (Object)type);
                        continue;
                    }
                    String dir = (String)path + (String)remainingPath;
                    Object c = treeMap.get(dir);
                    if (c == null) {
                        int[] linkedStoredIncrawlerError = new int[]{0, 0, 0, 0, 0};
                        if (type == StoreType.LINK) {
                            linkedStoredIncrawlerError[0] = linkedStoredIncrawlerError[0] + 1;
                        }
                        if (type == StoreType.INDEX) {
                            linkedStoredIncrawlerError[1] = linkedStoredIncrawlerError[1] + 1;
                        }
                        if (loadingLinks.contains(entry3.getKey())) {
                            linkedStoredIncrawlerError[2] = linkedStoredIncrawlerError[2] + 1;
                        }
                        if (errorDocs.containsKey(entry3.getKey())) {
                            int n2 = errorDocs.get(entry3.getKey()) == FailType.excl ? 3 : 4;
                            linkedStoredIncrawlerError[n2] = linkedStoredIncrawlerError[n2] + 1;
                        }
                        treeMap.put(dir, linkedStoredIncrawlerError);
                        continue;
                    }
                    if (!(c instanceof int[])) continue;
                    if (type == StoreType.LINK) {
                        int[] nArray = (int[])c;
                        nArray[0] = nArray[0] + 1;
                    }
                    if (type == StoreType.INDEX) {
                        int[] nArray = (int[])c;
                        nArray[1] = nArray[1] + 1;
                    }
                    if (loadingLinks.contains(entry3.getKey())) {
                        int[] nArray = (int[])c;
                        nArray[2] = nArray[2] + 1;
                    }
                    if (!errorDocs.containsKey(entry3.getKey())) continue;
                    int[] nArray = (int[])c;
                    int n3 = errorDocs.get(entry3.getKey()) == FailType.excl ? 3 : 4;
                    nArray[n3] = nArray[n3] + 1;
                }
                int maxcount = 1000;
                int c = 0;
                int filecounter = 0;
                for (Map.Entry entry4 : treeMap.entrySet()) {
                    if (entry4.getValue() instanceof StoreType) {
                        ++filecounter;
                        continue;
                    }
                    prop.put("files_list_" + c + "_type", 1L);
                    prop.putHTML("files_list_" + c + "_type_url", (String)entry4.getKey());
                    int linked = ((int[])entry4.getValue())[0];
                    int stored = ((int[])entry4.getValue())[1];
                    int crawler = ((int[])entry4.getValue())[2];
                    int excl = ((int[])entry4.getValue())[3];
                    int error = ((int[])entry4.getValue())[4];
                    prop.put("files_list_" + c + "_type_stored", stored);
                    prop.put("files_list_" + c + "_type_linked", linked);
                    prop.put("files_list_" + c + "_type_pendingVisible", crawler > 0 ? 1L : 0L);
                    prop.put("files_list_" + c + "_type_pending", crawler);
                    prop.put("files_list_" + c + "_type_excludedVisible", excl > 0 ? 1L : 0L);
                    prop.put("files_list_" + c + "_type_excluded", excl);
                    prop.put("files_list_" + c + "_type_failedVisible", error > 0 ? 1L : 0L);
                    prop.put("files_list_" + c + "_type_failed", error);
                    if (++c < maxcount) continue;
                    break;
                }
                for (Map.Entry entry4 : treeMap.entrySet()) {
                    if (!(entry4.getValue() instanceof StoreType)) continue;
                    prop.put("files_list_" + c + "_type", 0L);
                    prop.putHTML("files_list_" + c + "_type_url", (String)entry4.getKey());
                    StoreType type = (StoreType)((Object)entry4.getValue());
                    try {
                        uri = new DigestURL((String)entry4.getKey());
                    }
                    catch (MalformedURLException e) {
                        uri = null;
                    }
                    HarvestProcess process = uri == null ? null : sb.crawlQueues.exists(uri.hash());
                    boolean loading = ((String)load).equals(entry4.getKey()) || process != null && process != HarvestProcess.ERRORS;
                    boolean error = process == HarvestProcess.ERRORS || type == StoreType.EXCLUDED || type == StoreType.FAILED;
                    boolean dc = type != StoreType.INDEX && !error && !loading && treeMap.containsKey((String)entry4.getKey() + "/");
                    if (dc) continue;
                    prop.put("files_list_" + c + "_type_stored", type == StoreType.INDEX ? 1L : (error ? 3L : (loading ? 2L : 0L)));
                    if (type == StoreType.INDEX) {
                        String ids = ASCII.String(uri.hash());
                        InfoCacheEntry ice = (InfoCacheEntry)infoCache.get(ids);
                        prop.put("files_list_" + c + "_type_stored_comment", ice == null ? "" : ice.toString());
                    }
                    prop.put("files_list_" + c + "_type_stored_load", loadRight ? 1L : 0L);
                    if (error) {
                        FailType failType = (FailType)((Object)errorDocs.get(entry4.getKey()));
                        if (failType == null) {
                            prop.putHTML("files_list_" + c + "_type_stored_error", "unknown error");
                        } else {
                            String ids = ASCII.String(uri.hash());
                            InfoCacheEntry ice = (InfoCacheEntry)infoCache.get(ids);
                            prop.put("files_list_" + c + "_type_stored_error", (String)(failType == FailType.excl ? "excluded from indexing" : "load fail" + (String)(ice == null ? "" : "; " + ice.toString())));
                        }
                    }
                    if (loadRight) {
                        prop.putHTML("files_list_" + c + "_type_stored_load_url", (String)entry4.getKey());
                        prop.putHTML("files_list_" + c + "_type_stored_load_path", (String)path);
                    }
                    if (++c < maxcount) continue;
                    break;
                }
                prop.put("files_list", c);
                prop.putHTML("files_path", (String)path);
                prop.put("files_hostsize", hostsize);
                prop.put("files_subpathloadsize", storedDocs.size());
                prop.put("files_subpathdetectedsize", filecounter - storedDocs.size());
                prop.put("files", 1L);
                uri = new DigestURL((String)path);
                if (post.containsKey("showlinkstructure")) {
                    sb.setConfig("decoration.grafics.linkstructure", true);
                }
                prop.put("files_linkgraph", uri.getPath().length() <= 1 && hostsize > 0 && sb.getConfigBool("decoration.grafics.linkstructure", true));
                prop.put("files_linkgraph_host", uri.getHost());
                WebStructureGraph.StructureEntry struct = sb.webStructure.incomingReferences(hosthash);
                if (struct != null && struct.references.size() > 0) {
                    maxcount = 200;
                    score = new ClusteredScoreMap<String>(UTF8.insensitiveUTF8Comparator);
                    for (Map.Entry<String, Integer> entry5 : struct.references.entrySet()) {
                        score.set(entry5.getKey(), entry5.getValue());
                    }
                    Iterator i = score.keys(false);
                    for (c = 0; i.hasNext() && c < maxcount; ++c) {
                        host = (String)i.next();
                        prop.putHTML("inbound_list_" + c + "_host", sb.webStructure.hostHash2hostName(host));
                        prop.put("inbound_list_" + c + "_count", score.get(host));
                    }
                    prop.put("inbound_list", c);
                    prop.put("inbound", 1L);
                } else {
                    prop.put("inbound", 0L);
                }
                if (outboundHosts.size() > 0) {
                    maxcount = 200;
                    score = new ClusteredScoreMap<String>(UTF8.insensitiveUTF8Comparator);
                    for (Map.Entry entry6 : outboundHosts.entrySet()) {
                        score.set((String)entry6.getKey(), ((ReversibleScoreMap)entry6.getValue()).size());
                    }
                    Iterator i = score.keys(false);
                    for (c = 0; i.hasNext() && c < maxcount; ++c) {
                        host = (String)((Object)i.next());
                        prop.putHTML("outbound_list_" + c + "_host", host);
                        prop.put("outbound_list_" + c + "_count", score.get(host));
                        prop.put("outbound_list_" + c + "_link", (String)((ReversibleScoreMap)outboundHosts.get(host)).getMinKey());
                    }
                    prop.put("outbound_list", c);
                    prop.put("outbound", 1L);
                } else {
                    prop.put("outbound", 0L);
                }
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
            }
            if (post.containsKey("addtoblacklist") && sb != null) {
                File blacklistsPath = sb.getDataPath("listsPath", "DATA/LISTS");
                String blacklistname = Blacklist.defaultBlacklist(blacklistsPath);
                if (blacklistname != null) {
                    boolean isok;
                    String hoststr = pathURI.getHost();
                    if (hoststr.startsWith("www.")) {
                        hoststr = hoststr.substring(4);
                    }
                    if (isok = BlacklistHelper.addBlacklistEntry(blacklistname, hoststr + "/.*")) {
                        prop.put("files_blkadded", 1L);
                    } else {
                        prop.put("files_blkadded", 2L);
                    }
                }
            } else {
                prop.put("files_blkadded", 0L);
            }
        }
        prop.putNum("ucount", fulltext.collectionSize());
        return prop;
    }

    public static final class InfoCacheEntry {
        public Integer cr_n;
        public Double cr_c;
        public int crawldepth;
        public int references;
        public int references_internal;
        public int references_external;
        public int references_exthosts;
        public List<String> references_internal_urls;
        public List<String> references_external_urls;

        public InfoCacheEntry(Fulltext fulltext, Segment.ReferenceReportCache rrCache, SolrDocument doc, String urlhash, boolean fetchReferences) {
            this.cr_c = (Double)doc.getFieldValue(CollectionSchema.cr_host_chance_d.getSolrFieldName());
            this.cr_n = (Integer)doc.getFieldValue(CollectionSchema.cr_host_norm_i.getSolrFieldName());
            Integer cr = (Integer)doc.getFieldValue(CollectionSchema.crawldepth_i.getSolrFieldName());
            Integer rc = (Integer)doc.getFieldValue(CollectionSchema.references_i.getSolrFieldName());
            Integer rc_internal = (Integer)doc.getFieldValue(CollectionSchema.references_internal_i.getSolrFieldName());
            Integer rc_external = (Integer)doc.getFieldValue(CollectionSchema.references_external_i.getSolrFieldName());
            Integer rc_exthosts = (Integer)doc.getFieldValue(CollectionSchema.references_exthosts_i.getSolrFieldName());
            this.crawldepth = cr == null || cr < 0 ? 0 : cr;
            this.references = rc == null || rc <= 0 ? 0 : rc;
            this.references_internal = rc_internal == null || rc_internal <= 0 ? 0 : rc_internal;
            this.references_internal_urls = new ArrayList<String>();
            this.references_external_urls = new ArrayList<String>();
            if (fetchReferences) {
                try {
                    String u;
                    Segment.ReferenceReport rr = rrCache.getReferenceReport(urlhash, false);
                    ArrayList<String> internalIDs = new ArrayList<String>();
                    ArrayList<String> externalIDs = new ArrayList<String>();
                    HandleSet iids = rr.getInternallIDs();
                    for (byte[] b : iids) {
                        internalIDs.add(ASCII.String(b));
                    }
                    HandleSet eids = rr.getExternalIDs();
                    for (byte[] b : eids) {
                        externalIDs.add(ASCII.String(b));
                    }
                    for (String id : internalIDs) {
                        if (id.equals(urlhash) || (u = fulltext.getURL(id)) == null) continue;
                        this.references_internal_urls.add(u);
                    }
                    for (String id : externalIDs) {
                        if (id.equals(urlhash) || (u = fulltext.getURL(id)) == null) continue;
                        this.references_external_urls.add(u);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.references_external = rc_external == null || rc_external <= 0 ? 0 : rc_external;
            this.references_exthosts = rc_exthosts == null || rc_exthosts <= 0 ? 0 : rc_exthosts;
        }

        public String toString() {
            StringBuilder sbi = new StringBuilder();
            int c = 0;
            for (String s : this.references_internal_urls) {
                sbi.append("<a href='").append(s).append("' target='_blank'><img src='env/grafics/i16.gif' alt='info' title='" + s + "' width='12' height='12'/></a>");
                if (++c % 80 != 0) continue;
                sbi.append("<br/>");
            }
            if (sbi.length() > 0) {
                sbi.insert(0, "<br/>internal referrer:");
            }
            StringBuilder sbe = new StringBuilder();
            c = 0;
            for (String s : this.references_external_urls) {
                sbe.append("<a href='").append(s).append("' target='_blank'><img src='env/grafics/i16.gif' alt='info' title='" + s + "' width='12' height='12'/></a>");
                if (++c % 80 != 0) continue;
                sbe.append("<br/>");
            }
            if (sbe.length() > 0) {
                sbe.insert(0, "<br/>external referrer:");
            }
            return (String)(this.crawldepth == 998 ? "unknown crawldepth" : (this.crawldepth >= 0 ? "crawldepth: " + this.crawldepth : "")) + (String)(this.cr_c != null ? ", cr=" + (double)Math.round(this.cr_c * 1000.0) / 1000.0 : "") + (String)(this.cr_n != null ? ", crn=" + this.cr_n : "") + (String)(this.references >= 0 ? ", refs: " + this.references_exthosts + " hosts, " + this.references_external + " ext, " + this.references_internal + " int" + sbi.toString() + sbe.toString() : "");
        }
    }

    public static enum StoreType {
        LINK,
        INDEX,
        EXCLUDED,
        FAILED,
        RELOAD;

    }
}

