/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.BookmarkHelper;
import net.yacy.data.BookmarksDB;
import net.yacy.data.ListManager;
import net.yacy.data.UserDB;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.search.AutoSearch;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Bookmarks {
    private static final serverObjects prop = new serverObjects();
    private static Switchboard sb = null;
    private static UserDB.Entry user = null;
    private static boolean isAdmin = false;
    static final int SORT_ALPHA = 1;
    static final int SORT_SIZE = 2;
    static final int SHOW_ALL = -1;
    static final boolean TAGS = false;
    static final boolean FOLDERS = true;
    static final float TAGCLOUD_FONTSIZE_MIN = 0.75f;
    static final float TAGCLOUD_FONTSIZE_MAX = 2.0f;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        BookmarksDB.Bookmark bookmark;
        int max_count = 10;
        int start = 0;
        boolean display = false;
        String tagName = "";
        String username = "";
        prop.clear();
        sb = (Switchboard)env;
        user = Bookmarks.sb.userDB.getUser(header);
        boolean bl = isAdmin = sb.verifyAuthentication(header) || user != null && user.hasRight(UserDB.AccessRight.BOOKMARK_RIGHT);
        if (user != null) {
            username = user.getUserName();
        } else if (isAdmin) {
            username = "admin";
        }
        prop.putHTML("user", username);
        prop.put("address", YaCyDefaultServlet.getContext(header, sb));
        if (isAdmin) {
            prop.put("mode", "1");
            prop.put("admin", "1");
            prop.put("display", "0");
        } else {
            prop.put("mode", "0");
            prop.put("admin", "0");
            prop.put("display", "0");
        }
        prop.put("mode_edit", "0");
        prop.put("mode_title", "");
        prop.put("mode_description", "");
        prop.put("mode_url", "");
        prop.put("mode_tags", "");
        prop.put("mode_path", "");
        prop.put("mode_public", "1");
        prop.put("mode_feed", "0");
        if (post != null) {
            if (!isAdmin) {
                if (post.containsKey("login")) {
                    prop.authenticationRequired();
                }
            } else if (post.containsKey("mode")) {
                String mode = post.get("mode");
                if ("add".equals(mode)) {
                    prop.put("mode", "2");
                    prop.put("display", "1");
                    display = true;
                } else if ("importxml".equals(mode)) {
                    prop.put("mode", "3");
                    prop.put("display", "1");
                    display = true;
                }
            } else if (post.containsKey("add")) {
                String url = post.get("url");
                String title = post.get("title");
                String description = post.get("description");
                Object tagsString = post.get("tags");
                String pathString = post.get("path");
                if (pathString == null || "".equals(pathString)) {
                    pathString = "/unsorted";
                }
                tagsString = (String)tagsString + "," + pathString;
                Set<String> tags = ListManager.string2set(BookmarkHelper.cleanTagsString((String)tagsString));
                BookmarksDB.Bookmark bookmark2 = Bookmarks.sb.bookmarksDB.createorgetBookmark(url, username);
                if (bookmark2 != null) {
                    bookmark2.setProperty("bookmarkTitle", title);
                    bookmark2.setProperty("bookmarkDesc", description);
                    if (user != null) {
                        bookmark2.setOwner(user.getUserName());
                    }
                    if ("public".equals(post.get("public"))) {
                        bookmark2.setPublic(true);
                        Bookmarks.publishNews(url, title, description, (String)tagsString);
                    } else {
                        bookmark2.setPublic(false);
                    }
                    if (post.containsKey("feed") && "true".equals(post.get("feed"))) {
                        bookmark2.setFeed(true);
                    } else {
                        bookmark2.setFeed(false);
                    }
                    bookmark2.setTags(tags, true);
                    if (post.containsKey("query")) {
                        bookmark2.setProperty("bookmarkQuery", post.get("query"));
                        bookmark2.setTimeStamp(System.currentTimeMillis());
                    }
                    Bookmarks.sb.bookmarksDB.saveBookmark(bookmark2);
                }
            } else if (post.containsKey("edit")) {
                String urlHash = post.get("edit");
                prop.put("mode", "2");
                prop.put("display", "1");
                display = true;
                ClientIdentification.Agent agent = ClientIdentification.getAgent(post.get("agentName", "YaCy Internet (cautious)"));
                if (urlHash.isEmpty()) {
                    prop.put("mode_edit", "0");
                    prop.putHTML("mode_title", post.get("title"));
                    prop.putHTML("mode_description", post.get("description"));
                    prop.putHTML("mode_url", post.get("url"));
                    prop.putHTML("mode_tags", post.get("tags"));
                    prop.putHTML("mode_path", post.get("path"));
                    prop.put("mode_public", "0");
                    prop.put("mode_feed", "0");
                } else {
                    bookmark = Bookmarks.sb.bookmarksDB.getBookmark(urlHash);
                    if (bookmark == null) {
                        URIMetadataNode urlentry = Bookmarks.sb.index.fulltext().getMetadata(ASCII.getBytes(urlHash));
                        if (urlentry != null) {
                            try {
                                Document document = Document.mergeDocuments(urlentry.url(), null, Bookmarks.sb.loader.loadDocuments(Bookmarks.sb.loader.request(urlentry.url(), true, false), CacheStrategy.IFEXIST, Integer.MAX_VALUE, null, agent));
                                prop.put("mode_edit", "0");
                                prop.put("mode_url", urlentry.url().toNormalform(false));
                                prop.putHTML("mode_title", urlentry.dc_title());
                                prop.putHTML("mode_description", document == null ? urlentry.dc_title() : document.dc_title());
                                prop.putHTML("mode_author", urlentry.dc_creator());
                                prop.putHTML("mode_tags", document == null ? urlentry.dc_subject() : document.dc_subject(','));
                                prop.putHTML("mode_path", "");
                                prop.put("mode_public", "0");
                                prop.put("mode_feed", "0");
                            }
                            catch (IOException e) {
                                ConcurrentLog.logException(e);
                            }
                            catch (Parser.Failure e) {
                                ConcurrentLog.logException(e);
                            }
                        }
                    } else {
                        prop.put("mode_edit", "1");
                        prop.putHTML("mode_title", bookmark.getTitle());
                        prop.putHTML("mode_description", bookmark.getDescription());
                        prop.put("mode_url", bookmark.getUrl());
                        prop.putHTML("mode_tags", bookmark.getTagsString());
                        prop.putHTML("mode_path", bookmark.getFoldersString());
                        if (bookmark.getQuery() != null) {
                            prop.put("mode_hasquery", "1");
                            prop.putHTML("mode_hasquery_query", bookmark.getQuery());
                        } else {
                            prop.put("mode_hasquery", "0");
                        }
                        if (bookmark.getPublic()) {
                            prop.put("mode_public", "1");
                        } else {
                            prop.put("mode_public", "0");
                        }
                        if (bookmark.getFeed()) {
                            prop.put("mode_feed", "1");
                        } else {
                            prop.put("mode_feed", "0");
                        }
                    }
                }
            } else if (post.containsKey("htmlfile")) {
                boolean isPublic = "public".equals(post.get("public"));
                String tags = post.get("tags");
                if ("".equals(tags)) {
                    tags = "unsorted";
                }
                ConcurrentLog.info("BOOKMARKS", "Trying to import bookmarks from HTML-file");
                try {
                    File file = new File(post.get("htmlfile"));
                    BookmarkHelper.importFromBookmarks(Bookmarks.sb.bookmarksDB, new DigestURL(file), post.get("htmlfile$file"), tags, isPublic);
                }
                catch (MalformedURLException file) {
                    // empty catch block
                }
                ConcurrentLog.info("BOOKMARKS", "success!!");
            } else if (post.containsKey("xmlfile")) {
                boolean isPublic = "public".equals(post.get("public"));
                BookmarkHelper.importFromXML(Bookmarks.sb.bookmarksDB, post.get("xmlfile$file"), isPublic);
            } else if (post.containsKey("delete")) {
                String urlHash = post.get("delete");
                Bookmarks.sb.bookmarksDB.removeBookmark(urlHash);
            }
            if (post.containsKey("tag")) {
                tagName = post.get("tag");
            }
            if (post.containsKey("start")) {
                start = post.getInt("start", 0);
            }
            if (post.containsKey("num")) {
                max_count = post.getInt("num", 10);
            }
        }
        if (!display) {
            Bookmarks.printTagList("taglist", tagName, 2, 25, false);
            Bookmarks.printTagList("optlist", tagName, 1, -1, true);
            int count = 0;
            Iterator<String> it = null;
            prop.put("display_num-bookmarks", Bookmarks.sb.bookmarksDB.bookmarksSize());
            if (!"".equals(tagName)) {
                prop.put("display_selected", "");
                it = Bookmarks.sb.bookmarksDB.getBookmarksIterator(tagName, isAdmin);
            } else {
                prop.put("display_selected", " selected=\"selected\"");
                it = Bookmarks.sb.bookmarksDB.getBookmarksIterator(isAdmin);
            }
            for (count = 0; count < start && it.hasNext(); ++count) {
                it.next();
            }
            count = 0;
            while (count < max_count && it.hasNext()) {
                bookmark = Bookmarks.sb.bookmarksDB.getBookmark(it.next());
                if (bookmark == null) continue;
                if (bookmark.getFeed() && isAdmin) {
                    prop.putXML("display_bookmarks_" + count + "_link", "/FeedReader_p.html?url=" + bookmark.getUrl());
                } else {
                    prop.putXML("display_bookmarks_" + count + "_link", bookmark.getUrl());
                }
                prop.putHTML("display_bookmarks_" + count + "_title", bookmark.getTitle());
                prop.putHTML("display_bookmarks_" + count + "_description", bookmark.getDescription());
                if (bookmark.getQuery() == null) {
                    prop.put("display_bookmarks_" + count + "_hasquery", false);
                } else {
                    prop.put("display_bookmarks_" + count + "_hasquery", true);
                    prop.put("display_bookmarks_" + count + "_hasquery_query", bookmark.getQuery());
                }
                prop.put("display_bookmarks_" + count + "_date", ISO8601Formatter.FORMATTER.format(new Date(bookmark.getTimeStamp())));
                prop.put("display_bookmarks_" + count + "_rfc822date", HeaderFramework.formatRFC1123(new Date(bookmark.getTimeStamp())));
                prop.put("display_bookmarks_" + count + "_public", bookmark.getPublic() ? "1" : "0");
                Set<String> tags = bookmark.getTags();
                int tagCount = 0;
                for (String tag : tags) {
                    if (tag.length() <= 0 || tag.charAt(0) == '/') continue;
                    prop.putHTML("display_bookmarks_" + count + "_tags_" + tagCount + "_tag", tag);
                    ++tagCount;
                }
                prop.put("display_bookmarks_" + count + "_tags", tagCount);
                prop.put("display_bookmarks_" + count + "_hash", bookmark.getUrlHash());
                ++count;
            }
            prop.putHTML("display_tag", tagName);
            prop.put("display_start", start);
            if (it.hasNext()) {
                prop.put("display_next-page", "1");
                prop.put("display_next-page_start", start + max_count);
                prop.putHTML("display_next-page_tag", tagName);
                prop.put("display_next-page_num", max_count);
            }
            if (start >= max_count) {
                if ((start -= max_count) < 0) {
                    start = 0;
                }
                prop.put("display_prev-page", "1");
                prop.put("display_prev-page_start", start);
                prop.putHTML("display_prev-page_tag", tagName);
                prop.put("display_prev-page_num", max_count);
            }
            prop.put("display_bookmarks", count);
            count = 0;
            count = Bookmarks.recurseFolders(BookmarkHelper.getFolderList("/", Bookmarks.sb.bookmarksDB.getTagIterator(isAdmin)), "/", 0, true, "");
            prop.put("display_folderlist", count);
            BusyThread bt = sb.getThread("autosearch");
            if (bt != null) {
                prop.put("display_autosearchrunning", "1");
                prop.put("display_autosearchrunning_msg", "");
                if (post != null && post.containsKey("stopautosearch")) {
                    sb.terminateThread("autosearch", false);
                    prop.put("display_autosearchrunning_msg", "autosearch will terminate");
                    prop.put("display_autosearchrunning", "0");
                }
                int jobs = bt.getJobCount();
                prop.put("display_autosearchrunning_jobcount", jobs);
                int cnt = 0;
                String qstr = "";
                if (bt instanceof AutoSearch) {
                    cnt = ((AutoSearch)bt).gotresults;
                    qstr = ((AutoSearch)bt).currentQuery;
                    if (qstr == null) {
                        qstr = "---";
                    }
                }
                prop.put("display_autosearchrunning_totalcount", cnt);
                prop.put("display_autosearchrunning_query", qstr);
            } else {
                prop.put("display_autosearchrunning", "0");
                prop.put("display_autosearchrunning_msg", "");
                if (post != null && post.containsKey("startautosearch")) {
                    sb.deployThread("autosearch", "Auto Search", "query all peers for given search terms", null, new AutoSearch(Switchboard.getSwitchboard()), 1000L);
                    prop.put("display_autosearchrunning_msg", "autsearch job started");
                }
            }
        }
        return prop;
    }

    private static void printTagList(String id, String tagName, int comp, int max, boolean opt) {
        if (Bookmarks.sb.bookmarksDB == null) {
            prop.put("display_" + id, 0L);
            return;
        }
        int count = 0;
        Iterator<BookmarksDB.Tag> it = "".equals(tagName) ? Bookmarks.sb.bookmarksDB.getTagIterator(isAdmin, comp, max) : Bookmarks.sb.bookmarksDB.getTagIterator(tagName, isAdmin, comp, max);
        while (it.hasNext()) {
            BookmarksDB.Tag tag = it.next();
            if (tag.getTagName().startsWith("/") || "".equals(tag.getTagName())) continue;
            prop.putHTML("display_" + id + "_" + count + "_name", tag.getFriendlyName());
            prop.putHTML("display_" + id + "_" + count + "_tag", tag.getTagName());
            prop.put("display_" + id + "_" + count + "_num", tag.size());
            if (opt) {
                if (tag.getFriendlyName().equals(tagName)) {
                    prop.put("display_" + id + "_" + count + "_selected", " selected=\"selected\"");
                } else {
                    prop.put("display_" + id + "_" + count + "_selected", "");
                }
            } else {
                prop.put("display_" + id + "_" + count + "_size", Math.min(2.0f, (float)Math.round((0.75 + Math.log(tag.size()) / 4.0) * 100.0) / 100.0f));
            }
            ++count;
        }
        prop.put("display_" + id, count);
    }

    private static int recurseFolders(Iterator<String> it, String root, int count, boolean next, String prev) {
        String fn;
        String string = fn = next ? it.next() : prev;
        if ("\uffff".equals(fn)) {
            for (int i = prev.replaceAll("[^/]", "").length(); i > 0; --i) {
                prop.put("display_folderlist_" + count + "_folder", "</ul></li>");
                ++count;
            }
            return count;
        }
        if (fn.startsWith((String)("/".equals(root) ? root : root + "/"))) {
            BookmarksDB.Bookmark bookmark;
            prop.put("display_folderlist_" + count + "_folder", "<li>" + fn.replaceFirst(root + "/*", "") + "<ul class=\"folder\">");
            ++count;
            Iterator<String> bit = Bookmarks.sb.bookmarksDB.getBookmarksIterator(fn, isAdmin);
            while (bit.hasNext() && (bookmark = Bookmarks.sb.bookmarksDB.getBookmark(bit.next())) != null) {
                prop.put("display_folderlist_" + count + "_folder", "<li><a href=\"" + bookmark.getUrl() + "\" title=\"" + bookmark.getDescription() + "\">" + bookmark.getTitle() + "</a></li>");
                ++count;
            }
            if (it.hasNext()) {
                count = Bookmarks.recurseFolders(it, fn, count, true, fn);
            }
        } else {
            prop.put("display_folderlist_" + count + "_folder", "</ul></li>");
            ++count;
            root = root.replaceAll("(/.[^/]*$)", "");
            if ("".equals(root)) {
                root = "/";
            }
            count = Bookmarks.recurseFolders(it, root, count, false, fn);
        }
        return count;
    }

    private static void publishNews(String url, String title, String description, String tagsString) {
        if (sb.isRobinsonMode()) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", url.replace(',', '|'));
        map.put("title", title.replace(',', ' '));
        map.put("description", description.replace(',', ' '));
        map.put("tags", tagsString.replace(',', ' '));
        Bookmarks.sb.peers.newsPool.publishMyNews(Bookmarks.sb.peers.mySeed(), "bkmrkadd", map);
    }
}

