/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.peers.Seed;
import net.yacy.peers.graphics.BannerData;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.visualization.RasterPlotter;

public class Banner {
    public static RasterPlotter respond(RequestHeader header, serverObjects post, serverSwitch env) throws IOException {
        Switchboard sb = (Switchboard)env;
        String pathToImage = sb.appPath + "/htroot/env/grafics/yacy.png";
        int width = 468;
        int height = 60;
        String bgcolor = "e7effc";
        String textcolor = "000000";
        String bordercolor = "5090d0";
        if (post != null) {
            bgcolor = post.get("bgcolor", bgcolor);
            textcolor = post.get("textcolor", textcolor);
            bordercolor = post.get("bordercolor", bordercolor);
            width = post.getInt("width", width);
            height = post.getInt("height", height);
        }
        String name = "";
        long links = 0L;
        long words = 0L;
        int myppm = 0;
        double myqph = 0.0;
        String type = "";
        String network = env.getConfig("network.unit.name", "unspecified").toUpperCase();
        int peers = sb.peers.sizeConnected() + 1;
        long nlinks = sb.peers.countActiveURL();
        long nwords = sb.peers.countActiveRWI();
        double nqpm = sb.peers.countActiveQPM();
        long nppm = sb.peers.countActivePPM();
        double nqph = 0.0;
        Seed seed = sb.peers.mySeed();
        if (seed != null) {
            name = seed.get("Name", "-").toUpperCase();
            links = sb.index.fulltext().collectionSize();
            words = seed.getWordCount();
            myppm = Switchboard.currentPPM();
            myqph = 60.0 * (double)sb.averageQPM();
            if (sb.peers.mySeed().isVirgin()) {
                type = "VIRGIN";
                nqph = (double)Math.round(6000.0 * nqpm) / 100.0;
            } else if (sb.peers.mySeed().isJunior()) {
                type = "JUNIOR";
                nqph = (double)Math.round(6000.0 * nqpm) / 100.0;
            } else if (sb.peers.mySeed().isSenior()) {
                type = "SENIOR";
                nlinks += links;
                nwords += words;
                nqph = (double)Math.round(6000.0 * nqpm + 100.0 * myqph) / 100.0;
                nppm += (long)myppm;
            } else if (sb.peers.mySeed().isPrincipal()) {
                type = "PRINCIPAL";
                nlinks += links;
                nwords += words;
                nqph = (double)Math.round(6000.0 * nqpm + 100.0 * myqph) / 100.0;
                nppm += (long)myppm;
            }
        }
        BannerData data = new BannerData(width, height, bgcolor, textcolor, bordercolor, name, links, words, type, myppm, network, peers, nlinks, nwords, nqph, nppm);
        if (!net.yacy.peers.graphics.Banner.logoIsLoaded()) {
            ImageIO.setUseCache(false);
            BufferedImage logo = ImageIO.read(new File(pathToImage));
            return net.yacy.peers.graphics.Banner.getBannerPicture(data, 1000L, logo);
        }
        return net.yacy.peers.graphics.Banner.getBannerPicture(data, 1000L);
    }
}

