/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;

public class pptParser
extends AbstractParser
implements Parser {
    public pptParser() {
        super("Microsoft Powerpoint Parser");
        this.SUPPORTED_EXTENSIONS.add("ppt");
        this.SUPPORTED_EXTENSIONS.add("pps");
        this.SUPPORTED_MIME_TYPES.add("application/mspowerpoint");
        this.SUPPORTED_MIME_TYPES.add("application/powerpoint");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.ms-powerpoint");
        this.SUPPORTED_MIME_TYPES.add("application/ms-powerpoint");
        this.SUPPORTED_MIME_TYPES.add("application/mspowerpnt");
        this.SUPPORTED_MIME_TYPES.add("application/vnd-mspowerpoint");
        this.SUPPORTED_MIME_TYPES.add("application/x-powerpoint");
        this.SUPPORTED_MIME_TYPES.add("application/x-m");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            String title;
            BufferedInputStream bis = new BufferedInputStream(source);
            HSLFSlideShow slideShow = new HSLFSlideShow((InputStream)bis);
            SummaryInformation summaryInfo = slideShow.getSummaryInformation();
            DocumentSummaryInformation docSummaryInfo = slideShow.getDocumentSummaryInformation();
            SlideShowExtractor pptExtractor = new SlideShowExtractor((SlideShow)slideShow);
            String contents = pptExtractor.getText().trim();
            String string = title = summaryInfo == null ? "" : summaryInfo.getTitle();
            if (title.length() == 0) {
                title = contents.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ").trim();
                if (title.length() > 80) {
                    title = title.substring(0, 80);
                }
                int l = title.length();
                while ((title = title.replaceAll("  ", " ")).length() != l) {
                    l = title.length();
                }
            }
            String author = summaryInfo == null ? "" : summaryInfo.getAuthor();
            String keywords = summaryInfo == null ? "" : summaryInfo.getKeywords();
            String subject = summaryInfo == null ? "" : summaryInfo.getSubject();
            Date lastSaveDate = summaryInfo == null ? null : summaryInfo.getLastSaveDateTime();
            String company = docSummaryInfo == null ? "" : docSummaryInfo.getCompany();
            String[] keywlist = keywords != null && !keywords.isEmpty() ? CommonPattern.COMMA.split(keywords) : null;
            ArrayList<String> descriptions = new ArrayList<String>();
            if (subject != null && !subject.isEmpty()) {
                descriptions.add(subject);
            }
            Document[] docs = new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, keywlist, pptParser.singleList(title), author, company, null, descriptions, 0.0, 0.0, contents, null, null, null, false, lastSaveDate)};
            try {
                pptExtractor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return docs;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            ConcurrentLog.logException(e);
            String errorMsg = "Unable to parse the ppt document '" + location + "':" + e.getMessage();
            AbstractParser.log.severe(errorMsg);
            throw new Parser.Failure(errorMsg, location);
        }
    }
}

